// $Id: JGNameInfo.h,v 1.4 2003/03/19 16:49:24 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGNameInfo.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGNAMEINFO_H
#define JGNAMEINFO_H

#include "jyugem/gem/gembase.h"

class JGVariable;

//
// Define an object
//
class BEE_Export JGNameInfo
{
public:
    JGNameInfo() : m_name(_TX("unknown")), m_id(0) {}
    JGNameInfo(const BCHAR * name)
            : m_name((name != NULL) ? name : _TX("unknown")), m_id(0) {}
    JGNameInfo(const string& name) : m_name(name), m_id(0) {}
    JGNameInfo(const string& name, JGid& id) : m_name(name), m_id(id) {}
    JGNameInfo(const JGNameInfo& rhs) : m_name(rhs.m_name), m_id(rhs.m_id) {}
    ~JGNameInfo() {}

    JGNameInfo& operator=(const JGNameInfo& rhs) {
            if (this == &rhs)
                return *this;
            copy(rhs);
            return *this;
        }

    string& name()           { return m_name; }
    string& getName()        { return m_name; }
    const BCHAR * charName() { return m_name.c_str(); }
    void  name(const BCHAR * nm) { m_name = nm; }
    void  name(const string& nm) { m_name = nm; }
    JGid& id()               { return m_id; }
    void  id(const JGid& id) { m_id = id; }

protected:
    void copy(const JGNameInfo& rhs) { m_name = rhs.m_name; m_id = rhs.m_id; }

protected:
    string m_name;
    JGid   m_id;
};

//
// Define an object which has variable pointer
//
class JGNameVarInfo : public JGNameInfo
{
public:
    JGNameVarInfo(const BCHAR * name = NULL) : JGNameInfo(name), m_vid(0),
                                               m_var(NULL) {}
    JGNameVarInfo(const string& name) : JGNameInfo(name), m_vid(0),
                                        m_var(NULL) {}
    JGNameVarInfo(const JGNameVarInfo& rhs)
            : JGNameInfo((const JGNameInfo&)rhs), m_vid(rhs.m_vid), m_var(rhs.m_var) {}
    ~JGNameVarInfo() {}

    JGNameVarInfo& operator=(const JGNameVarInfo& rhs) {
            if (this == &rhs)
                return *this;
            copy(rhs);
            return *this;
        }

    JGid& vid()        { return m_vid; }
    void vid(JGid& id) { m_vid = id; }
    void variable(JGVariable * var) { m_var = var; }
    JGVariable * variable() const   { return m_var; }

protected:
    void copy(const JGNameVarInfo& rhs) {
            this->JGNameInfo::copy((JGNameInfo&)rhs);
            m_vid = rhs.m_vid;
            m_var = rhs.m_var;
        }
//
protected:
    JGid       m_vid;
    JGVariable * m_var;

};

#endif  /* JGNAMEINFO_H */
