// $Id: JGTaskTrigger.h,v 1.2 2003/02/16 17:04:54 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGTaskTrigger.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGTASKTRIGGER_H
#define JGTASKTRIGGER_H


#include "jyugem/gem/gembase.h"
#include "jyugem/gem/JGTrigger.h"
#include "jyugem/gem/JGService.h"
#include "BS2MessageInfo.h"

class JGVariable;
class BS2Message;

//-----------------------------------------------------------------------------
//
// SECS Message Trigger
//
//-----------------------------------------------------------------------------
class BEE_Export JGMessageTrigger : public JGTrigger
{
public:
    JGMessageTrigger(BS2MessageInfo& msginfo);
    ~JGMessageTrigger() {
            // if (m_msg != NULL) {
            //     delete m_msg;
            // }
        }

    virtual void update() {}

    void message(BS2Message * msg) { m_msg = msg; }
    BS2Message * message()         { return m_msg; }
    int  result()  { return m_msginfo.getResult(); }
    UINT transid() { return m_msginfo.getTransactionID(); }

// member methods
protected:
    JGMessageTrigger() : JGTrigger(), m_msg(NULL) {}

// member variables
protected:
    BS2Message *   m_msg;
    BS2MessageInfo m_msginfo;
};

//
// Asynchronous method
//
class BEE_Export JGMessageRequest : public JGTriggerRequest
{
public:
    JGMessageRequest(JGMessageTrigger * trigger, JGTask * task = NULL)
            : JGTriggerRequest(trigger, task) {}
    JGMessageRequest(BS2MessageInfo& msginfo, JGTask * task = NULL)
            : JGTriggerRequest() {
            m_trigger = new JGMessageTrigger(msginfo);
            m_task = task;
        }
    virtual ~JGMessageRequest() {}

    virtual int call();

protected:
};


//-----------------------------------------------------------------------------
//
// I/O Device Trigger
//
//-----------------------------------------------------------------------------
class BEE_Export JGDeviceTrigger : public JGTrigger
{
public:
    JGDeviceTrigger(const string& name, JGVariable * var, void * arg = NULL);

    virtual void update() {}

    JGVariable * variable() { return m_variable; }

// member methods
protected:
    JGDeviceTrigger() : JGTrigger(), m_variable(NULL), m_arg(NULL) {}

// member variables
protected:
    JGVariable * m_variable;
    void * m_arg;
};

//
// Asynchronous method
//
class BEE_Export JGDeviceRequest : public JGTriggerRequest
{
public:
    JGDeviceRequest(JGDeviceTrigger * trigger, JGTask * task = NULL)
            : JGTriggerRequest(trigger, task) {}
    JGDeviceRequest(const string& name, JGVariable * var, void * arg = NULL,
                    JGTask * task = NULL) : JGTriggerRequest() {
            m_trigger = new JGDeviceTrigger(name, var, arg);
            m_task = task;
        }
    virtual ~JGDeviceRequest() {}

    virtual int call();

protected:
};

//-----------------------------------------------------------------------------
//
// Operater Trigger
//
//-----------------------------------------------------------------------------
class BEE_Export JGOperatorTrigger : public JGTrigger
{
public:
    JGOperatorTrigger(const string& ope, const string& arg1, void * arg2 = NULL);
    ~JGOperatorTrigger() {}

    virtual void update() {}

    string& arg() { return m_arg; }
    void *  ext() { return m_ext; }

// member methods
protected:
    JGOperatorTrigger() : JGTrigger(), m_arg(_TX("")), m_ext(NULL) {}

// member variables
protected:
    string m_arg;
    void * m_ext;
};

//
// Asynchronous method
//
class BEE_Export JGOperatorRequest : public JGTriggerRequest
{
public:
    JGOperatorRequest(JGOperatorTrigger * trigger, JGTask * task = NULL)
            : JGTriggerRequest(trigger, task) {}
    JGOperatorRequest(const string& ope, const string& arg, JGTask * task = NULL)
            : JGTriggerRequest() {
            m_trigger = new JGOperatorTrigger(ope, arg);
            m_task = task;
        }
    virtual ~JGOperatorRequest() {}

    virtual int call();

protected:
};


//-----------------------------------------------------------------------------
//
// Notify Trigger (Change stauts)
//
//-----------------------------------------------------------------------------
class BEE_Export JGNotifyTrigger : public JGTrigger
{
public:
    JGNotifyTrigger(const string& name) : JGTrigger(name) {}
    virtual ~JGNotifyTrigger() {}

    virtual void update() {}

// member methods
protected:
    JGNotifyTrigger() : JGTrigger() {}

// member variables
protected:
};

//
// Asynchronous method
//
class BEE_Export JGNotifyRequest : public JGTriggerRequest
{
public:
    JGNotifyRequest(JGNotifyTrigger * trigger, JGTask * task = NULL)
            : JGTriggerRequest(trigger, task) {}
    JGNotifyRequest(const string& cmd, JGTask * task = NULL)
            : JGTriggerRequest() {
            m_trigger = new JGNotifyTrigger(cmd);
            m_task = task;
        }
    virtual ~JGNotifyRequest() {}

    virtual int call();

protected:
};

//-----------------------------------------------------------------------------
//
// Host Command Trigger
//
//-----------------------------------------------------------------------------
//
// Asynchronous method
//
class BEE_Export JGRemoteRequest : public JGTriggerRequest
{
public:
    JGRemoteRequest(JGService * trigger, JGTask * task = NULL)
            : JGTriggerRequest(trigger, task) {}
    virtual ~JGRemoteRequest() {}

    virtual int call();

protected:
};



#endif  /* JGTASKTRIGGER_H  */
