// $Id: JGTriggerInfo.h,v 1.4 2003/07/27 13:27:47 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGTriggerInfo.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGTORIGGERINFO_H
#define JGTORIGGERINFO_H

#include "jyugem/gem/gembase.h"
#include "jyugem/gem/JGDefineTrigger.h"

class JGManager;
class JGVariable;
class JGTriggerInfo;
class JGObserver;

//
// Define an object to hold configure data
//
class JGTriggerSubject
{
    friend class JGTriggerInfo;

public:
    JGTriggerSubject() : m_trgid(_TX("")), m_trgName(_TX("")),
                         m_priority(0), m_period(0), m_mngr(NULL) {}
    JGTriggerSubject(const JGTriggerSubject& rhs);
    virtual ~JGTriggerSubject() {}

    JGTriggerSubject& operator=(const JGTriggerSubject& rhs);
    virtual JGTriggerInfo * factory() { return NULL; }
    virtual JGTriggerInfo * entity()  { return NULL; }
    virtual bool            isGroup() { return false; }

    JGManager * manager()           { return m_mngr; }
    void  manager(JGManager * mngr) { m_mngr = mngr; }
    const BCHAR * trgid() { return m_trgid.c_str(); }
    string& name()        { return m_trgid; }
    string& trigName()    { return m_trgName; }
    bool enabled() const  { return m_enabled; }
    void enabled(bool tf) { m_enabled = tf; }

//
private:
    void copy(const JGTriggerSubject& rhs);

//
protected:
    bool   m_enabled;
    string m_trgid;
    string m_trgName;
    int    m_priority;
    ACE_Time_Value m_period;
    JGManager *  m_mngr;

    static string _NilString;
};

typedef map<string, JGTriggerSubject *, str_less,
                    allocator<JGTriggerSubject *> > JGTriggerSubTable;
typedef JGTriggerSubTable::value_type  JGTriggerSubPair;
typedef vector<JGTriggerSubject *>     JGTriggerSubjects;
typedef list<JGTriggerSubject *>       JGTriggerSubjectList;


//
// Define an object to hold configure data
//
class JGTriggerInfo
{
public:
    JGTriggerInfo() : m_entry(false), m_var(NULL), m_curtm(0) {}
    JGTriggerInfo(const JGTriggerInfo& rhs) {
            m_curtm = rhs.m_curtm; m_var = rhs.m_var; m_entry = rhs.m_entry;
        }
    virtual ~JGTriggerInfo() {}

    JGTriggerInfo& operator=(const JGTriggerInfo& rhs) {
            if (this == &rhs)
                return *this;
            m_curtm = rhs.m_curtm; m_var = rhs.m_var; m_entry = rhs.m_entry;
            return *this;
        }
    JGVariable * variable()         { return m_var; }
    void variable(JGVariable * var) { m_var = var; }
    bool entry() const    { return m_entry; }
    void entry(bool tf)   { m_entry = tf; }

    virtual int  init();
    virtual int  sense();
    virtual int  changed() { return BEE_SUCCESS; }
    virtual int  changed(vector<JGVariable *>& vars) { return BEE_SUCCESS; }
    virtual void add(JGVariable * var) {}
    virtual void copyRelation() {}

//
protected:
    bool m_entry;
    JGVariable * m_var;
    ACE_Time_Value  m_curtm;
};

//
// Trigger Information Template Class
//
template<class T>
class JGTriggerInfoTempl : public JGTriggerInfo
{
public:
    JGTriggerInfoTempl(T * base) : JGTriggerInfo(), m_subject(base) {}

    T * subject()         { return m_subject; }
    const BCHAR * trgid() { return m_subject->trgid(); }
    string& name()        { return m_subject->name(); }

protected:
    T * m_subject;
    list<JGObserver *> m_observers;

};

typedef map<string, JGTriggerInfo *, str_less,
                    allocator<JGTriggerInfo *> > JGTriggerInfoTable;
typedef JGTriggerInfoTable::value_type  JGTriggerInfoPair;
typedef vector<JGTriggerInfo *>         JGTriggerInfos;
typedef list<JGTriggerInfo *>           JGTriggerInfoList;


#endif  /* JGTORIGGERINFO_H */
