#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    g_connector.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os
import csv
import sqlite, pdo

#
# G_CONNECTOR
#
connect_fields = ['CATEGORY','OBJSPEC','XID','CONNECT','DOMAIN','ADDRESS',
                  'ALGORITHM','ENABLED','UPD_DATE','UPD_NAME']
_insert_connect = """
insert into g_connector \
(CATEGORY,OBJSPEC,XID,CONNECT,DOMAIN,ADDRESS,ALGORITHM,ENABLED,UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s, %s, %s, %s)
"""

def ins_connect(cn, filename):
    reader = csv.DictReader(file(filename), connect_fields)

    cn.execute("delete from g_connector");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['CATEGORY']) > 0:
            cn.execute(_insert_connect, (row['CATEGORY'],
                                         row['OBJSPEC'],
                                         row['XID'],
                                         row['CONNECT'],
                                         row['DOMAIN'],
                                         row['ADDRESS'],
                                         row['ALGORITHM'],
                                         row['ENABLED'],
                                        "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def to_sqlite(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    outfile = dirname + os.sep + output + ".edb"
    cx = sqlite.connect(outfile)
    cn = cx.cursor()
    #
    ins_connect(cn, csvdir + os.sep + "connector.csv")
    #
    cx.commit()
    cx.close()

#
def to_mysql(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    dsn = "Module=MySQLdb;User=%s;Passwd=%s;DB=%s" % ("jyugem", "jyugem", output)
    db = pdo.connect(dsn)
    #
    ins_connect(db, csvdir + os.sep + "connector.csv")
    #
    db.close()

#
def usage():
    print("g_connector [-o <dbname>]");


def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "mho:v", ["help", "output="])
    except getopt.GetoptError:
        usage()
        sys.exit(2)
    output = 'gem'
    mysql = False
    verbose = False
    for o, a in opts:
        if o == "-v":
            verbose = True
        if o in ("-o", "--file"):
            output = a
        if o in ("-h", "--help"):
            usage()
            sys.exit()
        if o == "-m":
            mysql = True
    # ...

    dirname = os.getcwd()
    if not mysql:
        to_sqlite(output, dirname)
    else:
        to_mysql(output, dirname)


if __name__ == "__main__":
    main()

