/* $Id$ */

#include "user_def.h"

extern int gem_variable_add(user_variable * varinfo);

/*
 * Get %(VARIABLE NAME)s Item
 *
 * static int user_getval_%(variable_name)s(int ref_id, char ** user_str, int * buftype)
 * {
 *    *user_str = %(c_global_variable)s;
 *    *buftype = (int)USERBUF_STATIC;
 *    return 0;
 * }
 */

/*
 * Get Machine ID Item
 */
static int user_getval_machineid(int ref_id, char ** user_str, int * buftype)
{
    static char * machine_id = "MID-12345";
    *user_str = machine_id;
    *buftype = (int)USERBUF_STATIC;
    return 0;
}

/*
 * Get Root Directory Item
 */
static int user_getval_rootpath(int ref_id, char ** user_str, int * buftype)
{
    static char * dir_name = "./";
    *user_str = dir_name;
    *buftype = (int)USERBUF_STATIC;
    return 0;
}

/*
 *
 *   typedef struct user_variable
 *   {
 *       user_vid     m_vid;        // variable id.
 *       const char * m_name;       // variable/item name
 *       gvfptr       m_func;       // function pointer is to get value
 *   } user_variable;
 *
 *
 *   { %(vid)d, "%(VARIABLE_NAME)s", user_getval_%(variable_name)s },
 */
static user_variable user_var_declared[3] =
{
    { -5000, "MID", user_getval_machineid },
    { -5001, "DIR", user_getval_rootpath },
    { 0, null, null },
};



/*
 *
 * Entry variable information to gem library
 *
 */
void user_var_init()
{
    user_variable * varinfo = user_var_declared;
    while (! (varinfo->m_vid == 0 && varinfo->m_name == null &&
              varinfo->m_func == null))
    {
        int result = gem_variable_add(varinfo);
        varinfo++;
    }
}

