/* $Id: SECSMessageModel.java,v 1.3 2003/01/18 10:38:46 fukasawa Exp $ */

/**
 *  @file    SECSMessageModel.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.jsunit.gui;

import java.io.*;
import java.util.*;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import com.sun.JTreeTable.*;
import com.jyugem.secs.*;

public class SECSMessageModel extends AbstractTreeTableModel {
    SECSMessage m_message;

    // Names of the columns.
    static protected String[] clmnNames = {
        "Struct", "Name", "Type", "Value"
    };

    // Types of the columns.
    static protected Class[] clmnTypes = {
        TreeTableModel.class, String.class, String.class, String.class
    };

    // Constructor
    public SECSMessageModel(SECSMessage msg) {
        super(msg);
        m_message = msg;
    }

    //
    // The TreeModel interface
    //

    /**
     * Returns the number of children of <code>node</code>.
     */
    public int getChildCount(Object node) {
        if (node instanceof SECSMessage) {
            if (((SECSMessage)node).getUserObject() != null) {
                return 1;
            }
            return ((SECSMessage)node).getChildCount();
        } else if (node instanceof SECSList) {
            return ((SECSList)node).getChildCount();
        } else if (node instanceof SECSList) {
            SECSItem item = (SECSItem)node;
            if (item.type() != SECS.LIST) {
                return 0;
            }
            ArrayList member = (ArrayList)item.value();
            return member.size();
        }
        return 0;
    }

    /**
     * Returns the child of <code>node</code> at index <code>i</code>.
     */
    public Object getChild(Object node, int i) {
        if (node instanceof SECSMessage) {
            if (((SECSMessage)node).getUserObject() != null && i == 0) {
                return ((SECSMessage)node).getUserObject();
            }
            return ((SECSMessage)node).getChildAt(i);
        } else if (node instanceof SECSList) {
            if (((SECSList)node).getUserObject() != null && i == 0) {
                return ((SECSList)node).getUserObject();
            }
            return ((SECSList)node).getChildAt(i);
        } else if (node instanceof SECSItem) {
            SECSItem item = (SECSItem)node;
            if (item.type() != SECS.LIST) {
                return null;
            }
            ArrayList member = (ArrayList)item.value();
            return member.get(i);
        }
        return null;   //
    }

    /**
     * Returns true if the passed in object represents a leaf, false otherwise.
     */
    public boolean isLeaf(Object node) {
        if (node instanceof SECSItem) {
            return true;
        } else if (node instanceof SECSList) {
            if (((SECSList)node).getUserObject() != null) {
                return true;
            }
            return false;
        }
        return false;
    }

    //
    //  The TreeTableNode interface.
    //

    /**
     * Returns the number of columns.
     */
    public int getColumnCount() {
        return clmnNames.length;
    }

    /**
     * Returns the name for a particular column.
     */
    public String getColumnName(int column) {
        return clmnNames[column];
    }

    /**
     * Returns the class for the particular column.
     */
    public Class getColumnClass(int column) {
        return clmnTypes[column];
    }

    /**
     * Returns the value of the particular column.
     */
    public Object getValueAt(Object node, int column) {
        if (node instanceof SECSItem) {
            return null;
        } else if (node instanceof SECSList) {
            if (((SECSList)node).getUserObject() != null) {
                SECSItem item = (SECSItem)((SECSList)node).getUserObject();
                switch(column) {
                case 0:
                    return null;
                case 1:
                    return item.name();
                case 2:
                    return item.typeName();
                case 3:
                    return item.getValueString();
                }
            }
            SECSList listNode = (SECSList)node;
            switch(column) {
            case 0:
                return null;
            case 1:
                return null;
            case 2:
                return "<list>";
            case 3:
                return null;
            }
        } else if (node instanceof SECSMessage) {
            SECSMessage msg = (SECSMessage)node;
            switch(column) {
            case 0:
                return null;
            case 1:
                return null;
            case 2:
                return null;
            case 3:
                return null;
            }
        } else {
           System.out.println("getValueAt(): Unknown class");
        }
        return null;
    }

    //
    // Some convenience methods.
    //

    /**
     * Returns the path node represents.
     */
    public String getPath(Object node) {
        return "";
    }

}
