/* $Id: SECSTreeTable.java,v 1.3 2003/01/18 10:38:46 fukasawa Exp $ */

/**
 *  @file    SECSTreeTable.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package com.jyugem.jsunit.gui;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;
import javax.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.text.NumberFormat;
import com.sun.JTreeTable.*;
import com.jyugem.secs.*;

public class SECSTreeTable extends JPanel {
    protected SECSMessageModel model; // Model for the TreeTableModel
    protected JTreeTable treeTable;   // Used to represent the model
    protected JFrame frame;           // Frame containing everything
    protected int    reloadRow;
    JScrollPane scrollPane = null;

    public SECSTreeTable() {}

    public SECSTreeTable(SECSMessageModel m) {
        model = m;
        frame = createFrame();
        Container cPane = frame.getContentPane();
        JMenuBar  mb = createMenuBar();
        treeTable = createTreeTable();
        cPane.add(new JScrollPane(treeTable));

        frame.setJMenuBar(mb);
        frame.pack();
        frame.show();
    }

    public void init(JPanel mainPanel, SECSMessageModel m) {
        model = m;
        treeTable = createTreeTable();
        scrollPane = new JScrollPane(treeTable);
        mainPanel.add(scrollPane);
        scrollPane.setBounds(new Rectangle(160, 5, 460, 390));

    }

    public void fini(JPanel mainPanel) {
        // Remove the scroll pane from this window.
        if (scrollPane != null) {
            mainPanel.remove(scrollPane);
        }
    }


    /**
     * Creates and returns the instanceof JTreeTable that will be used.
     */
    protected JTreeTable createTreeTable() {
        JTreeTable treeTable = new JTreeTable(model);
        Reloader rl = new Reloader();
        treeTable.getTree().addTreeExpansionListener(rl);
        return treeTable;
    }

    /**
     * Creates the JFrame that will contain everything.
     */
    protected JFrame createFrame() {
        JFrame retFrame = new JFrame("SECS message table");
        retFrame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        return retFrame;
    }

    /**
     * Creates a menu bar.
     */
    protected JMenuBar createMenuBar() {
        JMenu fileMenu = new JMenu("File");
        JMenuItem menuItem;
        menuItem = new JMenuItem("Open");
        menuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
            }
        });
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        menuItem = new JMenuItem("Exit");
        menuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                System.exit(0);
            }
        });
        fileMenu.add(menuItem);

        // Create a menu bar
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);

        // Menu for the look and feels (lafs).
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        ButtonGroup lafGroup = new ButtonGroup();

        JMenu optionsMenu = new JMenu("Options");
        menuBar.add(optionsMenu);
        for(int i = 0; i < lafs.length; i++) {
            JRadioButtonMenuItem rb = new JRadioButtonMenuItem(lafs[i].
                                                               getName());
            optionsMenu.add(rb);
            rb.setSelected(UIManager.getLookAndFeel().getName().equals(lafs[i].getName()));
            rb.putClientProperty("UIKey", lafs[i]);
            rb.addItemListener(new ItemListener() {
                public void itemStateChanged(ItemEvent ae) {
                    JRadioButtonMenuItem rb2 = (JRadioButtonMenuItem)ae.getSource();
                    if(rb2.isSelected()) {
                        UIManager.LookAndFeelInfo info =
                             (UIManager.LookAndFeelInfo)rb2.getClientProperty("UIKey");
                        try {
                            UIManager.setLookAndFeel(info.getClassName());
                            SwingUtilities.updateComponentTreeUI(frame);
                        }
                        catch (Exception e) {
                             System.err.println("unable to set UI " + e.getMessage());
                        }
                    }
                }
            });
            lafGroup.add(rb);
        }
        return menuBar;
    }

    class Reloader implements ActionListener, TreeExpansionListener {
        public void actionPerformed(ActionEvent ae) {
            // No longer loading.
            if (reloadRow != -1) {
                generateChangeEvent(reloadRow);
            }
            reloadRow = -1;
        }

        protected void generateChangeEvent(int row) {
            if (row != -1) {
                AbstractTableModel tableModel = (AbstractTableModel)treeTable.getModel();
                tableModel.fireTableChanged(new TableModelEvent(tableModel, row, row, 1));
            }
        }

        //
        // TreeExpansionListener
        //

        /**
         * Invoked when the tree has expanded.
         */
        public void treeExpanded(TreeExpansionEvent te) {
        }

        /**
         * Invoked when the tree has collapsed.
         */
        public void treeCollapsed(TreeExpansionEvent te) {
        }
    }


    public static void main(String[] args) {
        try {
            /**
             * Creates the SECSMessageModel that will be used.
             */
            SECSMessage message = new SECSMessage("S1F14");
            SECSItem item1 = new SECSItem("MDLN", "JYUGEM");
            SECSItem item2 = new SECSItem("SOFTREV", "1.0.0");
            SECSList list1 = new SECSList();
            list1.add(item1);
            list1.add(item2);
            SECSList list = new SECSList();
            byte ack = 0;
            SECSItem item0 = new SECSItem("COMMACK", ack);
            list.add(item0);
            list.add(list1);
            message.set(list);
            SECSMessageModel model = new SECSMessageModel(message);
            SECSTreeTable treeTable = new SECSTreeTable(model);
        } catch (SecurityException se) {
            System.out.println("Could not determine home directory");
        }
    }
}
