// $Id: SECSXmlParser.h,v 1.7 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    SECSXmlParser.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef SECSXMLPARSER_H
#define SECSXMLPARSER_H

#include "b_ace.h"
#include <string>
#include <vector>
using namespace std;
#include "xercesc/util/PlatformUtils.hpp"
#include "xercesc/util/XMLString.hpp"
#include "xercesc/util/XMLUniDefs.hpp"
#include "xercesc/dom/DOMException.hpp"
#include "xercesc/parsers/XercesDOMParser.hpp"
#include "xercesc/dom/DOM.hpp"
#include "xercesc/dom/DOMNode.hpp"
#if _XERCES_VERSION >= 20200              // version-2.2.0 support namespace
using namespace XERCES_CPP_NAMESPACE;
#endif

typedef XercesDOMParser  DOMParser;

class BS2MessageType;
class BS2ItemType;
class BS2Itemtypes;

//-----------------------------------------------------------------------------
// Refer item name in list format.
//-----------------------------------------------------------------------------
struct RefItems
{
    string         m_itemName;
    vector<string> m_refers;

    RefItems() {}
    RefItems(const RefItems& rhs) {
            m_itemName = rhs.m_itemName;
            m_refers = rhs.m_refers;
        }
    RefItems& operator=(const RefItems& rhs) {
            if (this == &rhs)
                return *this;
            m_itemName = rhs.m_itemName;
            m_refers = rhs.m_refers;
            return *this;
        }
};


//-----------------------------------------------------------------------------
// XML parser class which defined SECS Message and Item.
//-----------------------------------------------------------------------------
class BEE_Export SECSXmlParser
{
public:
    SECSXmlParser(const BCHAR * xmlFile = NULL) {
            m_xmlFile = (xmlFile == NULL) ? "" : xmlFile;
        }
    ~SECSXmlParser() {}

    int parseMessage(const BCHAR * xmlFile = NULL);

    static SECSXmlParser * instance();

protected:
    int  parseElements(DOMNode * node);
    int  parseItemTypesElement(DOMNode * node);
    int  parseItemType(DOMNode * node);
    int  parseMessagesElement(DOMNode * node);
    UINT parseFormat(DOMNode * node, RefItems& listMembers);
    int  parseListName(DOMNode * node, RefItems& listMembers);
    int  parseMessage(DOMNode * node);
    int  parseBody(DOMNode * node, BS2MessageType * msgtype);
    int  parseList(DOMNode * node, BS2Itemtypes * items);
    BS2ItemType *  parseItem(DOMNode * node);
    int  init(const BCHAR * xmlFile = NULL);
    int  fini();
    int  parse();

// member variables
protected:
    string m_xmlFile;
    vector<RefItems> m_itemRefers;
};


// ---------------------------------------------------------------------------
//  This is a simple class that lets us do easy (though not terribly efficient)
//  trancoding of XMLCh data to local code page for display.
// ---------------------------------------------------------------------------
#ifndef DEFINED_STRX
#define DEFINED_STRX

class StrX
{
public :
    // -----------------------------------------------------------------------
    //  Constructors and Destructor
    // -----------------------------------------------------------------------
    StrX(const XMLCh* const toTranscode)
    {
        // Call the private transcoding method
        fLocalForm = XMLString::transcode(toTranscode);
    }

    ~StrX()
    {
        delete [] fLocalForm;
    }


    // -----------------------------------------------------------------------
    //  Getter methods
    // -----------------------------------------------------------------------
    const BCHAR* localForm() const
    {
        return fLocalForm;
    }

private :
    // -----------------------------------------------------------------------
    //  Private data members
    //
    //  fLocalForm
    //      This is the local code page form of the string.
    // -----------------------------------------------------------------------
    BCHAR*   fLocalForm;
};

inline bool operator==(const BCHAR * s, const StrX& token)
{
    return (_tcscmp(token.localForm(), s) == 0);
}

inline bool operator!=(const BCHAR * s, const StrX& token)
{
    return (_tcscmp(token.localForm(), s) != 0);
}

#endif /* DEFINED_STRX */

#endif  // SECSXMLPARSER_H
