// $Id$

//=============================================================================
/**
 *  @file    HSEventManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSEVENTMANAGER_H
#define HSEVENTMANAGER_H

#include "jyugem/gem/JGEventManager.h"

class BS2Message;
class BS2Item;

/*
 * Manage Event Class
 */
class BEE_Export HSEventManager: public JGEventManager
{
public:
    HSEventManager();
    ~HSEventManager();

    // virtual int svc(void);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);

    int setup(int tid, bool ceed, const std::vector<std::string>& ceids,
              const std::vector<std::string>& vids, const std::string& dir);
    bool   isReportFile(const string& ceid, size_t total);
    string getReportFile(const string& ceid);
    BS2Message * allEnabled(bool tf); // S2F37
    BS2Message * resetEventReport();  // S2F35
    BS2Message * resetReports();      // S2F33
    BS2Message * defineReports();     // S2F33
    BS2Message * eventReport(BS2Message * msg);       // S6F11
    BS2Message * linkEventReport();   // S2F35
    BS2Message * setupEvent(bool tf, vector<JGid>& ceids);  // S2F37

    static HSEventManager * instance();

protected:

//
private:
};

#endif
