// $Id$

//=============================================================================
/**
 *  @file    HSInitializeCmd.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSINITIALIZECMD_H
#define HSINITIALIZECMD_H

#include "jyugem/gem/JGManager.h"
#include "jyugem/bee/sequencer/sequencer.h"
using namespace jyugem::bee;

class BS2Message;
class BS2Item;

/*
 * Manage Event Class
 */
class BEE_Export HSInitializeCmd: public JGManager
{
public:
    struct InitConfig
    {
        InitConfig() : m_spool(true), m_eqconst(true), m_eqstate(false),
                       m_event(true), m_datetime(true), m_online(true) {}
        InitConfig(const InitConfig& rhs) { this->copy(rhs); }

        InitConfig& operator=(const InitConfig& rhs)
        {
            if (this != &rhs)
                this->copy(rhs);
            return *this;
        }
        void copy(const InitConfig& rhs)
        {
            m_spool = rhs.m_spool;
            m_eqconst = rhs.m_eqconst;
            m_eqstate = rhs.m_eqstate;
            m_event = rhs.m_event;
            m_datetime = rhs.m_datetime;
            m_online = rhs.m_online;
        }

        int  m_tid;
        bool m_spool;
        bool m_eqconst;
        bool m_eqstate;
        bool m_event;
        bool m_datetime;
        bool m_online;
    };

public:
    HSInitializeCmd();
    virtual ~HSInitializeCmd();

    typedef sequencer<HSInitializeCmd> CmdSequence;

    int  tid()        { return m_tid; }
    void tid(int id)  { m_tid = id; }
    void doSequence() { m_sequence = true; }
    bool online()     { return m_online.value(); }
    void online(bool tf);
    void setEcids(vector<string>& ecnames) {}
    void setSvids(vector<string>& svnames) {}
    vector<JGVariable *>& getConsts() { return m_ecvs; }
    vector<JGid>&         getSvids()  { return m_svids; }
    int next() { return this->m_cmdseq.next(); }

    virtual int init(void * argv = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int notify_svc(JGNotifyTrigger * trigger);
    virtual int close(int flag = 0);

    static HSInitializeCmd * instance();

//
private:
    CmdSequence m_cmdseq;
    ACE_Auto_Event m_sync;

    vector<JGVariable *> m_ecvs;
    vector<JGid>         m_svids;
    MUTEX_Bool m_sequence;
    MUTEX_Bool m_online;
    int m_tid;
    
    // save names of dispatch
    std::string m_s1f4_name;
    std::string m_s1f13_name;
    std::string m_s1f14_name;
    std::string m_s1f18_name;
    std::string m_s2f16_name;
    std::string m_s2f32_name;
    std::string m_s2f34_name;
    std::string m_s2f36_name;
    std::string m_s2f38_name;
    std::string m_s3f24_name;
    std::string m_s6f23_name;
};

typedef HSInitializeCmd::CmdSequence::step  CmdStep;
typedef HSInitializeCmd::CmdSequence::terminate_step  TerminateStep;


#endif
