// $Id$

//=============================================================================
/**
 *  @file    HSManager.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "HSManager.h"
#include "HSMainManager.h"
#include "HSServer.h"
#include "HSSECSDevice.h"
#include "JGTaskTrigger.h"
#include "JGStateTask.h"
#include "JGTask.h"
#include "BS2ErrorMessage.h"
#include "BS2DeclAtoms.h"

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
HSManager::HSManager()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "HSManager::HSManager");
}

//-----------------------------------------------------------------------------
HSManager::~HSManager()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "HSManager::~HSManager");
}

//-----------------------------------------------------------------------------
// Send Ack to host
//-----------------------------------------------------------------------------
int HSManager::sendAck(int secstid, int errcode)
{
    TRACE_FUNCTION(TRL_LOW, "HSManager::sendAck");

    int result = 0;
    SECSTransaction transid(0, 0, secstid);
    Transaction::iterator iter = m_trans.find(transid);
    if (iter == m_trans.end())
    {
        TRACE_ERROR((_TX("Not found tranzaction (%d)"), secstid));
        return -1;
    }
    int tid = iter->second;
    m_trans.erase(iter);

    result = HSMainManager::instance()->sendAck(this->name(), tid, errcode);

    return result;
}


//-----------------------------------------------------------------------------
// Parser of status event.
//-----------------------------------------------------------------------------
void HSManager::comm_error(JGMessageTrigger * trigger)
{
    // ACE_DEBUG((LM_DEBUG, ACE_TEXT("%s: communication error [%d/%d].\n"),
    //           this->charName(), trigger->result(), trigger->transid()));

    // Send reply message
    int errcode = 0;
    switch (trigger->result())
    {
        case BS2RET_ERROR:
            break;
        case BS2RET_ABORT:
            break;
        case BS2RET_TIMEOUT:
            break;
        case BS2RET_TIMEOUT_MESSAGE:
            break;
        default:    // BS2RET_ILLEGAL_MESSAGE
            break;
    }

    this->eraseTransaction(trigger->transid(), errcode);
}

