// $Id$

//=============================================================================
/**
 *  @file    case_expression.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================
#ifndef JYUGEM_BEE_FOR_EXPRESSION_H
#define JYUGEM_BEE_FOR_EXPRESSION_H

#include "sequencer.h"

namespace jyugem { namespace bee
{

temptate<class EXP, class T>
struct BEE_Export case_expression : public expression<EXP, T>
{
    typedef sequencer<T>       seq_type;
    typedef expression<EXP, T> expression_base;

    case_expression(vector<step *> nodes) : expression_base()
    {
        m_act = nodes;
    }
    case_expression(seq_type * sqcr, const string& cond,
                    std::vector<step *>& nodes) : expression_base(sqcr, cond)
    {
        m_act = nodes;
    }
    virtual ~case_expression() {}

    virtual int evaluate(T * context)
    {
        TRACE_FUCTION((TRL_LOW, _TX("case_expression::evaluate")));

        int offset = m_test.evaluate();
        if (offset >= 0 && offset < m_act.size())
        {
            BEEAssert(m_act[offset] != NULL);
            return m_act[offset]->evaluate(context);
        }
        else
        {
            TRACE_ERROR((_TX("over the position of case(%d/%d)"),
                offset, m_act.size()));
        }
        return 0;
    }
};


} } // *namespace*

#endif
