// $Id$

//=============================================================================
/**
 *  @file    if_expression.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================
#ifndef JYUGEM_BEE_IF_EXPRESSION_H
#define JYUGEM_BEE_IF_EXPRESSION_H

#include "sequencer.h"

namespace jyugem { namespace bee
{

temptate<class EXP, class T>
struct BEE_Export if_expression : public expression<EXP, T>
{
    typedef sequencer<T>       seq_type;
    typedef expression<EXP, T> expression_base;

    if_expression(step * tnode, step * fnode = NULL) : expression_base()
    {
        m_act.push_back(tnode);
        if (fnode != NULL)
        {
            m_act.push_back(fnode);
        }
    }
    if_expression(seq_type * sqcr, const string& cond, step * tnode,
                  step * fnode = NULL) : expression_base(sqcr, cond)
    {
        m_act.push_back(tnode);
        if (fnode != NULL)
        {
            m_act.push_back(fnode);
        }
    }
    virtual ~if_expression() {}

    virtual int evaluate(T * context)
    {
        if (m_test.evaluate())
        {
            BEEAssert(m_act[0] != NULL);
            return m_act[0]->evaluate(context);
        }
        else if (m_act.size() == 2)
        {
            return m_act[1]->evaluate(context);
        }
        return 0;
    }
};


} } // *namespace*

#endif
