// $Id: JGEquipment.h,v 1.4 2003/02/16 17:04:53 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGEquipment.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================


#ifndef JGEQUIPMENT_H
#define JGEQUIPMENT_H

#include "jyugem/gem/JGManager.h"
#include "ace/DLL.h"

// Forward declaration
class JGInfoManager;
class JGAlarmManager;
class JGEventManager;
class JGTimeModule;
class JGObjectManager;
class JGVariable;

class JGCommManager;
class JGControlManager;
class JGIODevManager;
class JGLimitManager;
class JGProcessManager;
class JGSpoolManager;
class JGTerminalManager;
class JGTraceManager;
class JGAccessManager;
class JGRCmdManager;
class JGRecipeManager;

//-----------------------------------------------------------------------------
//
// Equipment Object
//
//-----------------------------------------------------------------------------
class BEE_Export JGEquipment: public JGManager
{
    enum { DISCONNECT, OFFLINE, ONLINE };   // m_status code

public:
    JGEquipment(const string& name = _TX(""));
    ~JGEquipment();

    bool isCommunicating() const;
    bool isOnline() const;
    bool isSpooling() const;
    bool isServer() const { return m_server; }
    int  spool(BS2Message * msg);
    int  communicating();
    int  notCommunicating();
    int  online(bool tf);
    JGManager * findManager(const string& mngrName);

    virtual int svc(void);
    virtual int init(void * argv = 0);

    int  start_comm(u_long argv = 0);
    int  stop(u_long argv = 0);

    JGEventManager *   getEventManager()  { return m_event_mngr; }
    JGAlarmManager *   getAlarmManager()  { return m_alarm_mngr; }
    JGObjectManager *  getObjectManager() { return m_obj_mngr; }
    JGInfoManager *    getInfoManager()   { return m_info_mngr; }

    void setDSNName(const string& name)       { m_dsn = name; }
    void setRootDirectory(const string& name) { m_rootPath = name; }
    const string& rootDirectory() const { return m_rootPath; }

    int  getIdType();
    const string& getConf(const string& pname);
    const string& getConf(const BCHAR * pname)
    {
        string nameStr = pname;
        return this->getConf(nameStr);
    }
    JGVariable * variable(const string& vname);
    JGVariable * variable(const BCHAR * vname)
    {
        string nameStr = vname;
        return this->variable(nameStr);
    }
    JGVariable * variable(const JGid& vid);
    JGvalue&  value(const string& vname);
    JGvalue&  value(const BCHAR * vname)
    {
        string nameStr = vname;
        return this->value(nameStr);
    }
    JGvalue&  value(const JGid& vid);
    int sendEvent(JGManager * mngr, const string& evt, JGVariable * arg = NULL);
    int sendObjectEvent(JGManager * mngr, const string& evt);

    void dump() const;
//
    static JGEquipment * instance(const string& devname = _TX(""));
//
protected:
    int  act_managers(JGCommDevice * devptr);
    int  stop_managers(u_long parm = 0);
    JGCommDevice * initDevice();

    int  load(void * argv = 0);
    int  save(void * argv = 0);

protected:
    string    m_dsn;
    string    m_rootPath;
    bool      m_server;
    MUTEX_Int m_status;
    vector<JGManager *> m_managers;

    JGInfoManager *   m_info_mngr;
    JGAlarmManager *  m_alarm_mngr;
    JGEventManager *  m_event_mngr;
    JGObjectManager * m_obj_mngr;

    JGCommManager *     m_comm_mngr;
    JGControlManager *  m_control_mngr;
    JGSpoolManager *    m_spool_mngr;
    JGLimitManager *    m_limit_mngr;
    JGProcessManager *  m_process_mngr;
    JGTerminalManager * m_terminal_mngr;
    JGTraceManager *    m_trace_mngr;
    JGAccessManager *   m_access_mngr;
    JGRCmdManager *     m_rcmd_mngr;
    JGRecipeManager *   m_recipe_mngr;

    JGTimeModule *    m_systime;
};

#endif
