// $Id: JGRemoteCmd.h,v 1.3 2003/07/27 13:27:47 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGRemoteCmd.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGREMOTECMD_H
#define JGREMOTECMD_H

#include "jyugem/gem/gembase.h"


//
// Remote command & parameter (for S2F41 or S2F49)
//
struct JGRemoteCmd
{
    /*
     * Command's parameter
     */
    struct Param
    {
        Param(): m_cpname(_TX("")), m_svcname(_TX("")), m_format(ATOM_LIST),
                 m_cptype(0), m_seqnum(0), m_cpval(0) {}
        Param(const Param& rhs) { this->copy(rhs); }
        Param& operator=(const Param& rhs)
        {
            if (this != &rhs)
                this->copy(rhs);
            return *this;
        }
        void copy(const Param& rhs)
        {
            m_cpname = rhs.m_cpname;
            m_svcname = rhs.m_svcname;
            m_format = rhs.m_format;
            m_cptype = rhs.m_cptype;
            m_seqnum = rhs.m_seqnum;
            m_cpval = rhs.m_cpval;
        }

        string  m_cpname;
        string  m_svcname;   // parameter name in Equipment
        int     m_format;
        int     m_cptype;
        int     m_seqnum;
        JGvalue m_cpval;
    };

    typedef map<string, Param *, str_less> ParamMap;

    // Constructor/Destructor
    JGRemoteCmd() : m_rcmd(0), m_cmdname(_TX("")), m_svcname(_TX("")),
                    m_objspec(_TX("")), m_sfcode(0) {}
    JGRemoteCmd(const JGid& rcmd, const string& cmdname, const string& svcname,
                const string& objspec, int sfcode)
        : m_rcmd(rcmd), m_cmdname(cmdname), m_svcname(svcname),
          m_objspec(objspec), m_sfcode(sfcode) {}
    JGRemoteCmd(const JGRemoteCmd& rhs) { this->copy(rhs); }
    ~JGRemoteCmd()
    {
        for (size_t i = 0; i < m_parms.size(); i++)
        {
            delete m_parms[i];
        }
    }

    JGRemoteCmd& operator=(const JGRemoteCmd& rhs)
    {
        if (this != &rhs)
            this->copy(rhs);
        return *this;
    }
    int add(Param * param)
    {
        if (this->find(param->m_cpname) == NULL ||
            this->findBySvc(param->m_svcname) == NULL)
        {
            return -1;
        }
        m_parms.push_back(param);
        m_paramap.insert(std::make_pair(param->m_cpname, param));
        m_svcmap.insert(std::make_pair(param->m_svcname, param));
        return 0;
    }
    Param * find(const string& cpname)
    {
        ParamMap::iterator iter = m_paramap.find(cpname);
        if (iter == m_paramap.end())
            return NULL;
        return (*iter).second;
    }
    Param * findBySvc(const string& svcname)
    {
        ParamMap::iterator iter = m_svcmap.find(svcname);
        if (iter == m_svcmap.end())
            return NULL;
        return (*iter).second;
    }
    void copy(const JGRemoteCmd& rhs)
    {
        m_rcmd = rhs.m_rcmd;
        m_cmdname = rhs.m_cmdname;
        m_svcname = rhs.m_svcname;
        m_sfcode = rhs.m_sfcode;
        m_objspec = rhs.m_objspec;
        // m_parms = rhs.m_parms;                     // shallow copy
        for (size_t i = 0; i < m_parms.size(); i++)   // deep copy
        {
            m_parms.push_back(new Param(*(rhs.m_parms[i])));
        }
        m_paramap = rhs.m_paramap;
        m_svcmap = rhs.m_svcmap;
    }

    JGid   m_rcmd;
    string m_cmdname;
    string m_svcname;
    string m_objspec;
    int    m_sfcode;
    vector<Param *> m_parms;
    ParamMap m_paramap;
    ParamMap m_svcmap;
};

//
// Containers
//
typedef map<JGid, JGRemoteCmd *, id_less, allocator<JGRemoteCmd *> >
        RemoteCmdTable;
typedef RemoteCmdTable::value_type RemoteCmdPair;
typedef map<string, JGRemoteCmd *, str_less, allocator<JGRemoteCmd *> >
        RCmdMap;
typedef RCmdMap::value_type RCmdMapPair;
typedef vector<JGRemoteCmd> RemoteCmds;
typedef list<JGRemoteCmd *> RemoteCmdList;

typedef map<string, JGRemoteCmd::Param *, str_less, allocator<JGRemoteCmd::Param *> >
        RCmdParamMap;
typedef RCmdParamMap::value_type RCmdParamMapPair;

#endif  /* JGREMOTECMD_H */
