// $Id: JGScalarSub.h,v 1.2 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGScalarSub.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGSCALARSUB_H
#define JGSCALARSUB_H

#include "jyugem/gem/JGTriggerInfo.h"

class JGObserver;

//
// Scalar device access of base class
//
class JGScalarSubBase : public JGTriggerSubject
{
public:
    JGScalarSubBase(): JGTriggerSubject() {}
    JGScalarSubBase(const JGTriggerSubject& rhs)
            : JGTriggerSubject(rhs), m_relation(NULL) {}
    virtual ~JGScalarSubBase() {}

    JGScalarSubBase& operator=(const JGScalarSubBase& rhs);
    virtual JGTriggerInfo * factory();
    virtual JGTriggerInfo * entity() { return NULL; }

    JGVariable * relation()         { return m_relation; }
    void relation(JGVariable * var) { m_relation = var; }

protected:
    JGVariable * m_relation;            // Relational variable
};


//
// Scalar device access of class
//
typedef JGTriggerInfoTempl<JGScalarSubBase>  JGTrigScalar;

class JGScalarSub : public JGTrigScalar
{
public:
    JGScalarSub(JGScalarSubBase * base): JGTrigScalar(base) {}
    virtual ~JGScalarSub() {}

    virtual int init();
    virtual int changed();

    JGVariable * relation()         { return m_subject->relation(); }
    void relation(JGVariable * var) { m_subject->relation(var); }

protected:
    JGVariable * m_relation;            // Relational variable
};


#endif  /* JGSCALARSUB_H */
