#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    g_iodevie.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os
import csv
import sqlite, pdo

#
# G_IODEVICE & G_SUBSYSTEM
#
subsystem_fields = ['SUBSYS_ID','NAME','SUBSYS_TYPE','RELOC','OBJSPEC',
                    'MATERIAL_TYPE','LOCID','ENABLED']
ioevice_fields = ['LABEL','IODEV_ID','NAME','SUBSYS_ID','IODEV_TYPE','DATANUM',
                  'INTERLOCK','MAX_VAL','MIN_VAL','TIME_ENABLED','INTERVAL_TIME',
                  'RECENT_ACCESS','VALUE','DELTA_VAL','VENDOR','MODEL',
                  'REVISION','ENABLED']
sac_fields = ['LABEL','SAC_ID','SAC_NAME','IODEV_ID','IODATA_TYPE','FORMAT',
              'ADDRESS','RESET','ALGORITHM','ENABLED']

_insert_subsystem = """
insert into g_subsystem
(SUBSYS_ID,NAME,SUBSYS_TYPE,RELOC,OBJSPEC,MATERIAL_TYPE,LOCID,
ENABLED,UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s)
"""
_insert_iodevice = """
insert into g_iodevice
(IODEV_ID,NAME,SUBSYS_ID,IODEV_TYPE,DATANUM,INTERLOCK,MAX_VAL,MIN_VAL,
TIME_ENABLED,INTERVAL_TIME,RECENT_ACCESS,VALUE,DELTA_VAL,VENDOR,MODEL,REVISION,
ENABLED,UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)
"""
_insert_sac = """
insert into g_sac
(SAC_ID,SAC_NAME,IODEV_ID,IODATA_TYPE,FORMAT,ADDRESS,RESET,ALGORITHM,
ENABLED,UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)
"""

#
def ins_iodevice(cn, filename):
    reader = csv.DictReader(file(filename), ioevice_fields)

    cn.execute("delete from g_iodevice");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['IODEV_ID']) > 0:
            cn.execute(_insert_iodevice, (row['IODEV_ID'],
                                          row['NAME'],
                                          row['SUBSYS_ID'],
                                          row['IODEV_TYPE'],
                                          row['DATANUM'],
                                          row['INTERLOCK'],
                                          row['MAX_VAL'],
                                          row['MIN_VAL'],
                                          row['TIME_ENABLED'],
                                          row['INTERVAL_TIME'],
                                          row['RECENT_ACCESS'],
                                          row['VALUE'],
                                          row['DELTA_VAL'],
                                          row['VENDOR'],
                                          row['MODEL'],
                                          row['REVISION'],
                                          row['ENABLED'],
                                          "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def ins_subsystem(cn, filename):
    reader = csv.DictReader(file(filename), subsystem_fields)

    cn.execute("delete from g_subsystem");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['SUBSYS_ID']) > 0:
            cn.execute(_insert_subsystem, (row['SUBSYS_ID'],
                                           row['NAME'],
                                           row['SUBSYS_TYPE'],
                                           row['RELOC'],
                                           row['OBJSPEC'],
                                           row['MATERIAL_TYPE'],
                                           row['LOCID'],
                                           row['ENABLED'],
                                           "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def ins_sac(cn, filename):
    reader = csv.DictReader(file(filename), sac_fields)

    cn.execute("delete from g_sac");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['SAC_ID']) > 0:
            cn.execute(_insert_sac, (row['SAC_ID'],
                                     row['SAC_NAME'],
                                     row['IODEV_ID'],
                                     row['IODATA_TYPE'],
                                     row['FORMAT'],
                                     row['ADDRESS'],
                                     row['RESET'],
                                     row['ALGORITHM'],
                                     row['ENABLED'],
                                     "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def to_sqlite(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    outfile = dirname + os.sep + output + ".edb"
    cx = sqlite.connect(outfile)
    cn = cx.cursor()
    #
    ins_subsystem(cn, csvdir + os.sep + "subsystem.csv")
    ins_iodevice(cn, csvdir + os.sep + "iodevice.csv")
    ins_sac(cn, csvdir + os.sep + "sac.csv")
    #
    cx.commit()
    cx.close()

#
def to_mysql(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    dsn = "Module=MySQLdb;User=%s;Passwd=%s;DB=%s" % ("jyugem", "jyugem", output)
    db = pdo.connect(dsn)
    #
    ins_subsystem(db, csvdir + os.sep + "subsystem.csv")
    ins_iodevice(db, csvdir + os.sep + "iodevice.csv")
    ins_sac(db, csvdir + os.sep + "sac.csv")
    #
    db.close()

#
def usage():
    print("g_iodevice [-f <dbname>]");


def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "hf:v", ["help", "file="])
    except getopt.GetoptError:
        usage()
        sys.exit(2)
    output = 'gem'
    verbose = False
    for o, a in opts:
        if o == "-v":
            verbose = True
        if o in ("-f", "--file"):
            output = a
        if o in ("-h", "--help"):
            usage()
            sys.exit()
    # ...

    dirname = os.getcwd()
    if not mysql:
        to_sqlite(output, dirname)
    else:
        to_mysql(output, dirname)

if __name__ == "__main__":
    main()

