#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    make_testxml.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

"""
Copyright (C) 2004 BEE Co.,Ltd. All Rights Reserved.

"""

import sys, os, types, time, string, cStringIO
import jyugem

__author__  = "Fukasawa Mitsuo <fukasawa_mitsuo@nifty.com>"
__status__  = "beta"
__version__ = "0.0.1"
__date__    = "26 May 2004"

#---------------------------------------------------------------------------
#   Miscellaneous module data
#---------------------------------------------------------------------------
_vid_fmt = "uint4"
_ceid_fmt = "uint4"
_rptid_fmt = "uint4"
_alid_fmt = "uint4"

#
# Template of SECS Test Script
#
_tmpl_s6f11_header = """
  <secs:testcase name="VFEI_1.%(test_num)d" description="%(desc)s">
    <secs:send sf="S6F11" wait="TRUE" body="THIS">
      <secs:list>
        <secs:item name="DATAID" type="%(dataid_type)s">%(dataid)s</secs:item>
        <secs:item name="CEID" type="%(ceid_type)s">%(ceid)s</secs:item>
        <secs:list>
          <secs:list>
"""
_tmpl_s6f11_report_header = """            <secs:item name="RPTID" type="%(rpt_type)s">%(rptid)s</secs:item>
            <secs:list>
"""
_tmpl_s6f11_v_indent = """              """
_tmpl_s6f11_value = """<secs:item name="V" type="%(v_type)s">%(v)s</secs:item>  <!-- %(v_comment)s -->
"""
_tmpl_s6f11_report_tail = """            </secs:list>
"""
_tmpl_s6f11_tail = """          </secs:list>
        </secs:list>
      </secs:list>
    </secs:send>

    <secs:expect compare="MATCH">
<![CDATA[<secs:message sf="S6F12" transaction="\d+">
  <secs:item name="ACKC6" type="binary">0x00</secs:item>
</secs:message>
]]>
    </secs:expect>
  </secs:testcase>
"""

#---------------------------------------------------------------------------
#   Miscellaneous functions
#---------------------------------------------------------------------------
#
# for variable class
#
def variable_to_secs(var, nest):
    indent = "".ljust(nest * 2)
    indent += _tmpl_s6f11_v_indent
    secs = ""
    if var.substantiator == "vector":
        secs += indent + "<secs:list>\n"
        i = 0
        while i < min(var.size, 5):
            if (var.format == 0 and var.objtype != None):
                secs += objtype_to_secs(var.objtype, nest + 1)
            else:
                secs += indent + "  "
                secs += _tmpl_s6f11_value %  {
                    'v_type': jyugem.formatStr(var.format),
                    'v': valueStr(var.format, var.value, var.name, var.size),
                    'v_comment': var.name
                }
            i += 1
        secs += indent + "</secs:list>\n"
    elif var.substantiator == "object":
        secs += objtype_to_secs(var.objtype, nest)
    else:
        secs += indent
        secs += _tmpl_s6f11_value %  {
            'v_type': jyugem.formatStr(var.format),
            'v': valueStr(var.format, var.value, var.name, var.size),
            'v_comment': var.name
        }
    return secs

#
# for event class
#
def event_to_secs(evt):
    secs = _tmpl_s6f11_header %  {
        'test_num': evt.ceid, 'desc': evt.name,
        'dataid_type': "uint4", 'dataid': str(evt.ceid),
        'ceid_type': "uint4", 'ceid': str(evt.ceid)
    }
    for rptid in evt.reports:
        report = jyugem.reports[rptid]
        secs += report_to_secs(report)
    secs += _tmpl_s6f11_tail
    return secs


def report_to_secs(rpt):
    secs = _tmpl_s6f11_report_header %  {
        'rpt_type': "uint4", 'rptid': str(rpt.rptid)
    }
    for vid in rpt.vars:
        var = jyugem.variables[vid]
        if (var.clazz == 5 or var.clazz == 6):
            continue
        secs += variable_to_secs(var, 0)
    secs += _tmpl_s6f11_report_tail
    return secs


#
# for objtype class
#
def objtype_to_secs(clazz, nest):
    indent = "".ljust(nest * 2)
    indent += _tmpl_s6f11_v_indent
    secs = indent + "<secs:list>\n"
    for attr in clazz.attributes:
        secs += attribute_to_secs(attr, nest + 1)
    secs += indent + "</secs:list>\n"
    return secs

#
# for attribute class
#
def attribute_to_secs(attr, nest):
    indent = "".ljust(nest * 2)
    indent += _tmpl_s6f11_v_indent
    secs = ""
    if attr.substantiator == "vector":
        secs += indent + "<secs:list>\n"
        i = 0
        while i < min(attr.maxq, 5):
            if (attr.format == 0 and attr.objtype != None):
                secs += attribute_to_secs(attr.members[0], nest + 1)
            else:
                secs += indent + "  "
                secs += _tmpl_s6f11_value %  {
                    'v_type': jyugem.formatStr(attr.format),
                    'v': valueStr(attr.format, attr.initval, attr.name, attr.maxq),
                    'v_comment': attr.name
                }
            i += 1
        secs += indent + "</secs:list>\n"
    elif attr.substantiator == "object":
        secs += indent + "<secs:list>\n"
        for mbr_attr in attr.members:
            secs += attribute_to_secs(mbr_attr, nest + 1)
        secs += indent + "</secs:list>\n"
    else:
        secs += indent
        secs += _tmpl_s6f11_value %  {
            'v_type': jyugem.formatStr(attr.format),
            'v': valueStr(attr.format, attr.initval, attr.name, attr.maxq),
            'v_comment': attr.name
        }
    return secs

#-------------------------------------------------------------------------------
# Alarm Class
#
_tmpl_s5f1 = """
  <secs:testcase name="VFEI_5.%(test_num)d" description="%(desc)s">
    <secs:send sf="S5F1" wait="TRUE" body="THIS">
      <secs:list>
        <secs:item name="ALCD" type="binary">0x%(alcd)X</secs:item>
        <secs:item name="ALID" type="%(format)s">%(alid)d</secs:item>
        <secs:item name="ALTX" type="ascii">%(altx)s</secs:item>
      </secs:list>
    </secs:send>

    <secs:expect compare="MATCH">
<![CDATA[<secs:message sf="S5F2" wait="TRUE" transaction="\d+">
  <secs:item name="ACKC5" type="binary">0x00</secs:item>
</secs:message>
]]>
    </secs:expect>
  </secs:testcase>
"""

#
def alarm_to_secs(alarm):
    alstatus = alarm.alcd + 0x80
    secs = _tmpl_s5f1 %  {
        'test_num': alarm.alid, 'desc': alarm.name, 'alcd': alstatus,
        'format': _alid_fmt, 'alid': alarm.alid,
        'altx': alarm.altx
    }
    return secs

#
#
#
_tmpl_test_header = """<?xml version="1.0" encoding="shift_jis" ?>
<!--
"SECS Test Message for VFEI Driver"
-->

<secs:test name="VFEI_%(num)d" xmlns:secs="http://homepage2.nifty.com/SECS/"
           description="VFEI Driver %(desc)s Test">
"""

_tmpl_test_tail = """
</secs:test>
"""

#---------------------------------------------------------------------------
#   Miscellaneous functions
#---------------------------------------------------------------------------
def valueStr(format, value, item, size = 0):
    if item == "CLOCK" and format == 020:
        return time.strftime("%Y%m%d%H%M%S00", time.localtime())

    if format == 0:
        print "Illegal Item format:", item, "(", format, ")"
    elif format == 010:
        if type(value) is int:
            return "0x%02X" % (value % 256)
        else:
            return "0x00"
    elif format == 011:
        if value:
            return "TRUE"
        return "FALSE"
    elif format == 020 or format == 021:
        v = str(value)
        if size > 0:
            return v[:size]
        return v
    elif format == 030 or format == 050:
        if type(value) is int:
            return str(value)
        else:
            return str(0)
    elif format == 031 or format == 051:
        if type(value) is int:
            return str(value % 256)
        else:
            return str(0)
    elif format == 032 or format == 052:
        if type(value) is int:
            return str(value % 65536)
        else:
            return str(0)
    elif format == 034 or format == 054:
        if type(value) is int:
            return str(value % 0x100000000)
        else:
            return str(0)
    elif format == 040 or format == 044:
        if type(value) is float:
            return str(value)
        else:
            return str(0.0)
    else:
        print "Illegal Item format:", item, "(", format, ")"
    return ""


#---------------------------------------------------------------------------
#   Make SECS Event Messages (S6F11)
#---------------------------------------------------------------------------
def make_event_message(filename):
    try:
        sml = jyugem.datadef["CEID"]
    except KeyError:
        sml = "U4"
    _ceid_fmt = jyugem.formatStr(jyugem.smlToFormat(sml))
    try:
        sml = jyugem.datadef["RPTID"]
    except KeyError:
        sml = "U4"
    _rptid_fmt = jyugem.formatStr(jyugem.smlToFormat(sml))
    try:
        sml = jyugem.datadef["VID"]
    except KeyError:
        sml = "U4"
    _vid_fmt = jyugem.formatStr(jyugem.smlToFormat(sml))

    fp = open(filename, mode='w')
    #
    fp.write(_tmpl_test_header % {'num': 6, 'desc': "Events"})
    for ceid, event in jyugem.events.items():
        secsmsg = event_to_secs(event)
        fp.write(secsmsg)
    fp.write(_tmpl_test_tail)
    fp.close()
    #
    print "Finish to make secs event message file:", filename

#---------------------------------------------------------------------------
#   Make SECS Alarm Messages (S5F1)
#---------------------------------------------------------------------------
def make_alarm_message(filename):
    try:
        sml = jyugem.datadef["ALID"]
    except KeyError:
        sml = "U4"
    _alid_fmt = jyugem.formatStr(jyugem.smlToFormat(sml))

    fp = open(filename, mode='w')
    #
    fp.write(_tmpl_test_header % {'num': 5, 'desc': "Alarms"})
    for alid, alarm in jyugem.alarms.items():
        secsmsg = alarm_to_secs(alarm)
        fp.write(secsmsg)
    fp.write(_tmpl_test_tail)
    fp.close()
    #
    print "Finish to make secs alarm message file:", filename

