/* $Id$ */

/**
 *  @file    Jis.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package com.jyugem.secs;

import java.io.UnsupportedEncodingException;
import java.*;

public final class Jis extends Object {

    private byte[] value;    // *** value ***

    // Constructor
    public Jis(String s) throws UnsupportedEncodingException {
        try {
            this.value = s.getBytes("shift_jis");
        } catch (UnsupportedEncodingException e) {
            throw e;
        }
    }

    public Jis(byte[] s) {
        this.value = s;
    }

    public Jis(Jis v) {
        this.value = v.value;
    }

    public static String toString(byte[] s) throws UnsupportedEncodingException {
        String str;
        try {
            str = new String(s, "shift_jis");
        } catch (UnsupportedEncodingException e) {
            throw e;
        }
        return str;
    }

    public static Jis valueOf(String s) throws UnsupportedEncodingException {
        Jis jis;
        try {
            jis = new Jis(s);
        } catch (UnsupportedEncodingException e) {
            throw e;
        }
        return jis;
    }

    // Decodes a String into a Jis.
    public static Jis decode(String str) throws UnsupportedEncodingException {
        Jis result;
        try {
            result = Jis.valueOf(str);
        } catch (UnsupportedEncodingException e) {
            throw e;
        }
        return result;
    }

    public byte[] getBytes() {
        return value;
    }

    public String toString() {
        String str;
        try {
            str = new String(this.value, "shift_jis");
        } catch (UnsupportedEncodingException e) {
            str = "";
        }
        return str;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Jis) {
            Jis another = (Jis)obj;
            for (int i = 0; i < this.value.length; i++) {
                if (this.value[i] != another.value[i])
                    return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Jis another) {
        for (int i = 0; i < this.value.length; i++) {
            if (this.value[i] != another.value[i])
                return (this.value[i] - another.value[i]);
        }
        return 0;
    }

    public int compareTo(Object obj) {
        return compareTo((Jis)obj);
    }

}
