// $Id: JSAtom.cpp,v 1.5 2004/06/27 08:01:56 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSAtom.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "BS2Item.h"
#include "JSAtom.h"
#include "JSList.h"
#include "JSBinary.h"
#include "JSAscii.h"
#include "JSJis.h"
#include "JSUnicode.h"
#include "JSBoolean.h"
#include "JSInt1.h"
#include "JSInt2.h"
#include "JSInt4.h"
#include "JSInt8.h"
#include "JSUInt1.h"
#include "JSUInt2.h"
#include "JSUInt4.h"
#include "JSUInt8.h"
#include "JSFloat4.h"
#include "JSFloat8.h"

static JSList    _j_list;
static JSBinary  _j_binary;
static JSAscii   _j_ascii;
static JSJis     _j_jis;
static JSUnicode _j_unicode;
static JSBoolean _j_boolean;
static JSInt1    _j_int1;
static JSInt2    _j_int2;
static JSInt4    _j_int4;
static JSInt8    _j_int8;
static JSUInt1   _j_uint1;
static JSUInt2   _j_uint2;
static JSUInt4   _j_uint4;
static JSUInt8   _j_uint8;
static JSFloat4  _j_float4;
static JSFloat8  _j_float8;


// Initialize all value types
JSAtom * JSAtom::init(JNIEnv * jenv, jclass itemClass)
{
    try
    {
        _j_list.init(jenv, itemClass);
        _j_binary.init(jenv, itemClass);
        _j_ascii.init(jenv, itemClass);
        _j_jis.init(jenv, itemClass);
        _j_unicode.init(jenv, itemClass);
        _j_boolean.init(jenv, itemClass);
        _j_int1.init(jenv, itemClass);
        _j_int2.init(jenv, itemClass);
        _j_int4.init(jenv, itemClass);
        _j_int8.init(jenv, itemClass);
        _j_uint1.init(jenv, itemClass);
        _j_uint2.init(jenv, itemClass);
        _j_uint4.init(jenv, itemClass);
        _j_uint8.init(jenv, itemClass);
        _j_float4.init(jenv, itemClass);
        _j_float8.init(jenv, itemClass);
    }
    catch (runtime_error e)
    {
        throw e;
    }
    return 0;
}

// Global access
JSAtom * JSAtom::instance(int format)
{
    JSAtom * result;
    switch (format & 0x3F)   // reset array bit
    {
    case ATOM_LIST:
        result = &_j_list;
        break;
    case ATOM_BINARY:
        result = &_j_binary;
        break;
    case ATOM_ASCII:
        result = &_j_ascii;
        break;
    case ATOM_JIS:
        result = &_j_jis;
        break;
    case ATOM_UNICODE:
        result = &_j_unicode;
        break;
    case ATOM_BOOLEAN:
        result = &_j_boolean;
        break;
    case ATOM_INT1:
        result = &_j_int1;
        break;
    case ATOM_INT2:
        result = &_j_int2;
        break;
    case ATOM_INT4:
        result = &_j_int4;
        break;
    case ATOM_INT8:
        result = &_j_int8;
        break;
    case ATOM_UINT1:
        result = &_j_uint1;
        break;
    case ATOM_UINT2:
        result = &_j_uint2;
        break;
    case ATOM_UINT4:
        result = &_j_uint4;
        break;
    case ATOM_UINT8:
        result = &_j_uint8;
        break;
    case ATOM_FLOAT4:
        result = &_j_float4;
        break;
    case ATOM_FLOAT8:
        result = &_j_float8;
        break;
    default:
        ACE_ERROR((LM_ERROR, ACE_TEXT("Illegal format code(%d)"), format));
        result = NULL;
        break;
    }
    return result;
}

void JSAtom::initClass(JNIEnv * jenv, jclass itemClass)
{
    TRACE_FUNCTION(TRL_LOW, "JSAtom::initClass");
    m_jenv = jenv;
    m_itemClass = itemClass;

    m_listClass = jenv->FindClass("java/util/ArrayList");
    ASSERT_JCLASS(m_listClass, "java/util/ArrayList");

    m_listSize = jenv->GetMethodID(m_listClass, "size", "()I");
    ASSERT_METHODID(m_listSize, "size", "()I");

    m_listGet =  jenv->GetMethodID(m_listClass, "get", "(I)Ljava/lang/Object;");
    ASSERT_METHODID(m_listGet, "get", "(I)Ljava/lang/Object;");

    m_typeFld = jenv->GetFieldID(m_itemClass, "m_type", "I");
    ASSERT_METHODID(m_typeFld, "m_type", "I");
}
