// $Id: JSFloat8.cpp,v 1.5 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSFloat8.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JSFloat8.h"
#include "BS2Array.h"
#include "BS2List.h"

static const char * _className = "java/lang/Double";

void JSFloat8::init(JNIEnv * jenv, jclass itemClass)
{
    TRACE_FUNCTION(TRL_LOW, "JSFloat8::init");

    initClass(jenv, itemClass);

    m_class = m_jenv->FindClass(_className);
    ASSERT_JCLASS(m_class, _className);

    m_vget = m_jenv->GetMethodID(m_class, "doubleValue", "()D");
    ASSERT_METHODID(m_vget, "doubleValue", "()D");

    m_new = m_jenv->GetMethodID(m_class, "<init>", "(D)V");
    ASSERT_METHODID(m_new, "<init>", "(D)V");

    m_item = m_jenv->GetMethodID(itemClass, "<init>",
                                            "(Ljava/lang/String;D)V");
    ASSERT_METHODID(m_item, "<init>", "(Ljava/lang/String;D)V");

    m_array= jenv->GetMethodID(itemClass, "<init>",
                                          "(Ljava/lang/String;[D)V");
    ASSERT_METHODID(m_array, "<init>", "(Ljava/lang/String;[D)V");
}

// secs value to atom object
jobject JSFloat8::toObj(BS2Atom * atom)
{
    TRACE_FUNCTION(TRL_LOW, "JSFloat8::toObj");
    jobject obj = m_jenv->NewObject(m_class, m_new,
                                    reinterpret_cast<BS2Float8 *>(atom)->value());
    return obj;
}

// secs value to item object
jobject JSFloat8::toItemObj(BS2Atom * atom, jstring itemName)
{
    TRACE_FUNCTION(TRL_LOW, "JSFloat8::toItemObj");
    jobject obj;
    int format = atom->format();
    if (format & ATOM_ARRAY)
    {
        BS2Float8Array * arrayAtom = reinterpret_cast<BS2Float8Array *>(atom);
        int    len = arrayAtom->count();
        double * values = arrayAtom->value();

        jdoubleArray array =  m_jenv->NewDoubleArray(len);
        BEEAssert(array != NULL);
        for (int i = 0; i < len; i++)
        {
            jdouble val = *(values + i);
            m_jenv->SetDoubleArrayRegion(array, (jsize)i, 1, &val);
        }
        obj = m_jenv->NewObject(m_itemClass, m_array, itemName, array);
        m_jenv->ReleaseDoubleArrayElements(array, NULL, JNI_ABORT); // !?
    }
    else
    {
        obj = m_jenv->NewObject(m_itemClass, m_item, itemName,
                                reinterpret_cast<BS2Float8 *>(atom)->value());
    }
    return obj;
}

// jobject to secs value
BS2Atom * JSFloat8::toAtom(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSFloat8::toAtom");

    BS2Atom * atom;
    if (valObj != NULL)
    {
        jdouble doubleval = m_jenv->CallDoubleMethod(valObj, m_vget);
        atom = new BS2Float8(doubleval);
    }
    else
    {
        atom = new BS2Float8();
    }
    return atom;
}

// jobject to secs array
BS2Atom * JSFloat8::toArray(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSFloat8::toArray");

    if (valObj == NULL)
    {
        TRACE_ERROR(("Empty member object\n"));
        return NULL;
    }

    jobjectArray array = (jobjectArray)valObj;
    jsize len       = m_jenv->GetArrayLength(array);
    double * values = new double[len];
    for (int i = 0; i < len; i++)
    {
        jobject obj = m_jenv->GetObjectArrayElement(array, i);
        jdouble val = m_jenv->CallDoubleMethod(obj, m_vget);
        *(values + i) = (double)val;
    }
    BS2Float8Array * atom = new BS2Float8Array();
    atom->add(values, len);
    delete[] values;

    return atom;
}

// jobject to secs list
int JSFloat8::toList(jobject valObj, BS2List * listAtom)
{
    TRACE_FUNCTION(TRL_LOW, "JSFloat8::toList");

    jint len = m_jenv->CallIntMethod(valObj, m_listSize);
    for (int i = 0; i < len; i++)
    {
        jobject mbrObj = m_jenv->CallObjectMethod(valObj, m_listGet, i);
        jdouble val = m_jenv->CallDoubleMethod(mbrObj, m_vget);
        BS2Atom * atom = new BS2Float8(val);
        listAtom->add(*atom);
        delete atom;
    }
    return 0;
}

