{//////////////////////////////////////////////////////////////////////////////
//	^XNgCACR\R|[lg				     //
//	2000.07.10 H.Okamoto						     //
//	OXV	2003.05.17	Ver 1.15			     //
//		 TrShlApi.pas XVɔo[W̍XV		     //
//	ŏIXV	2004.02.27	Ver 1.16			     //
//		 ^XNo[ċNCxgǉ				     //
//		 ^XNo[ċNł̃Aj[VĊJ		     //
//////////////////////////////////////////////////////////////////////////////}
unit Taskbar;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Graphics, Menus, ShellApi,
  TrShlApi;

{************************************************************************}
{*	^XNgCACR\R|[lg				*}
{************************************************************************}
type
  {Forword錾}
  TIconAnimation = class;

  TTrayIcon = class(TComponent)
  private
    FIconAnimation	:TIconAnimation;	{Aj[VpXbh}
    {\[X̃[hp}
    FResIcon		:TIcon;
  protected
    FAutoPopup		:Boolean;	{True:Popup}
    FIcon		:TIcon;		{CACR}
    FLPopupMenu,
    FRPopupMenu		:TPopupMenu;	{|bvAbvj[}
    FTaskTrayIcon	:TTaskTrayIcon;

    {FTipHelp		:String;	{gC`bvqg}
    FResourceIconID	:Integer;	{ACR\[XCfbNX}
    FResourceIconList	:TStringList;	{ACR\[XXg}
    FVisible		:Boolean;	{True:\}
    FMinimized		:Boolean;	{True:ŏ̂}
    FHideOnTaskBar	:Boolean;	{True:^XNo[ɕ\Ȃ}
    FInterval		:Cardinal;	{ACR̎ύXCxg^C}
    {tbNCxg}
    OnIconChange	:TNotifyEvent;
    OnAppRestore	:TNotifyEvent;
    OnAppMinimize	:TNotifyEvent;
    {Cxg}
    FOnDblClick		:TNotifyEvent;
    FOnRDblClick	:TNotifyEvent;
    FOnMouseMove	:TMouseMoveEvent;
    FOnMouseDown,
    FOnMouseUp		:TMouseEvent;
    FOnTimer		:TNotifyEvent;	{ACRύX^C}[Cxg}
    {Ǝ̃Cxg}
    FOnMouseEnter,
    FOnMouseExit	:TNotifyEvent;
    FOnMouseClick	:TMouseEvent;
    FOnRestartTaskbar	:TNotifyEvent;	{^XNo[ċNCxg}
  public
    constructor Create(AOwner	:TComponent); override;
    destructor Destroy; override;

  protected
    procedure Loaded; override;
    
    {R[obN֐}
    procedure CallbackWndProc(var Message: TMessage);

    {Notification}
    procedure Notification(aComponent	:TComponent;
			   aOperation	:TOperation);
					override;
    {ŏCxg}
    procedure OnAppMinimizeEvent(Sender	:TObject);
    {XgACxg}
    procedure OnAppRestoreEvent(Sender	:TObject);

    {ACRύXCxg}
    procedure OnIconChangeEvent(Sender	:TObject);

    {gCɃACR\ł邩}
    function CanIconic:Boolean;

    {gCɓo^ACR̃nh𓾂}
    function GetIconHandle:HWND;

    {gCɃACRo^}
    function DoSetTrayIcon: Boolean;	{True:}
    {gCACR}
    function DoDeleteTrayIcon: Boolean;	{True:}

  public
    {^XNgC֓o^EChEnh𓾂}
    function GetTaskTrayHWND: HWND;

    {gCɃACRo^}
    function SetTrayIcon: Boolean;	{True:}
    {gCACR}
    function DeleteTrayIcon: Boolean;	{True:}

    {gCACR̕ύX}
    function ModifyIcon:Boolean;	{True:}

    {o[wv\}
    function ShowBalloonHelpSE(aHelpTitle,			{^Cg}
			       aHelpText	:String;	{bZ[W}
			       aTimeOut		:Integer;	{^CAEg(~b)}
			       aIconType	:TBalloonIconType)
						:Boolean;	{True:}

    function ShowBalloonHelp: Boolean;		{True:}

    {o[wv}
    function HideBalloonHelp: Boolean;	{True:}

  protected
    {Aj[V}
    procedure BeginIconAnimation;
    procedure EndIconAnimation;

    {ACRύX^C}[Cxg}
    procedure OnTrayIconChange;

    {vpeBIO}
    {protected}
    function GetResIcon: TIcon;
    function IconAnimation: TIconAnimation;

    {published}
    procedure SetAutoPopup(aValue	:Boolean);

    procedure SetIcon(aValue	:TIcon);

    function  GetTipHelp: String;
    procedure SetTipHelp(aValue	:String);

    procedure SetMinimized(aValue	:Boolean);

    procedure SetVisible(aValue	:Boolean);

    procedure SetIconID(aValue	:Integer);

    function  GetIconID:Integer;
    procedure SetIconIDList(aValue	:TStringList);

    procedure SetInterval(aValue	:Cardinal);

    function GetFWindow: Boolean;
    procedure SetFWindow(aValue	:Boolean);

    {NbNƃ_uNbN̔s}
    function GetChackClick: Boolean;
    procedure SetChackClick(aValue	:Boolean);

    {Shell32.dll̃o[Wo[wv\ł}
    function GetCanBalloonHelp:Boolean;
    {o[wṽ^Cg}
    function GetBlHelpTitle:String;
    procedure SetBlHelpTitle(aHelpTitle	:String);
    {o[wṽeLXg}
    function GetBalloonHelp:String;
    procedure SetBalloonHelp(aHelpText	:String);
    {gCŕ\̃^CAEg}
    function GetUTimeOut:Integer;
    procedure SetUTimeOut(aValue	:Integer);
    {o[wvŕ\ACR̎}
    function GetBalloonIconType:TBalloonIconType;
    procedure SetBalloonIconType(aValue	:TBalloonIconType);

    {c[`bvX^CNX}
    function GetToolTipStyle: TToolTipStyle;
    procedure SetToolTipStyle(aToolTipStyle: TToolTipStyle);

  protected
    property ResIcon: TIcon read GetResIcon;

  public
    {Windows2000 + IE5.0ȍ~ >>}
    property CanBalloonHelp: Boolean read GetCanBalloonHelp;
    {<< }

  published
    {vpeB}
    property AutoPopup: Boolean read FAutoPopup write SetAutoPopup default True;
    property Icon: TIcon read FIcon write SetIcon;
    property TipHelp: String read GetTipHelp write SetTipHelp;
    property Minimized: Boolean read FMinimized write SetMinimized default False;
    property Visible: Boolean read FVisible write SetVisible default True;
    property HideOnTaskBar: Boolean read FHideOnTaskBar write FHideOnTaskBar default False;
    property ResourceIconID: Integer read GetIconID write SetIconID;
    property ResourceIconList: TStringList read FResourceIconList write SetIconIDList;
    property Interval: Cardinal read FInterval write SetInterval default 0;
    property DoForegroundWindow: Boolean read GetFWindow write SetFWindow default False;
    property CheckSingleDoubleClick :Boolean read GetChackClick write SetChackClick default False;

    {Windows2000 + IE5.0ȍ~ >>}
    property BalloonHelpTitle: String read GetBlHelpTitle write SetBlHelpTitle;
    property BalloonHelpText: String read GetBalloonHelp write SetBalloonHelp;
    property BalloonHelpTimeOut: Integer read GetUTimeOut write SetUTimeOut default 5000;
    property BalloonHelpIcon: TBalloonIconType read GetBalloonIconType write SetBalloonIconType Default bitNone;
    {<< }

    {c[`bvNX}
    property ToolTipStyle: TToolTipStyle read GetToolTipStyle write SetToolTipStyle;


    {j[vpeB}
    property LButtonPopupMenu: TPopupMenu read FLPopupMenu write FLPopupMenu;
    property RButtonPopupMenu: TPopupMenu read FRPopupMenu write FRPopupMenu;
    {Cxg}
    property OnDblClick: TNotifyEvent read FOnDblClick write FOnDblClick;
    property OnRDblClick: TNotifyEvent read FOnRDblClick write FOnRDblClick;
    property OnMouseDown: TMouseEvent read FOnMouseDown write FOnMouseDown;
    property OnMouseMove: TMouseMoveEvent read FOnMouseMove write FOnMouseMove;
    property OnMouseUp: TMouseEvent read FOnMouseUp write FOnMouseUp;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseExit: TNotifyEvent read FOnMouseExit write FOnMouseExit;
    property OnMouseClick: TMouseEvent read FOnMouseClick write FOnMouseClick;
    property OnRestartTaskbar: TNotifyEvent read FOnRestartTaskbar write FOnRestartTaskbar;

    property OnIconAnimation: TNotifyEvent read FOnTimer write FOnTimer;
  end;

{************************************************************************}
{*	Aj[VpThread						*}
{************************************************************************}
  TIconAnimation = class(TThread)
  private
    Owner	:TTrayIcon;
  public
    constructor Create(AOwner	:TTrayIcon);
    destructor Destroy; override;

  protected
    procedure Execute; override;

  end;

{************************************************************************}
{*	WXg							*}
{************************************************************************}
procedure Register;

{/////////////////////////////////////////////////////////////////////////////}
implementation
{/////////////////////////////////////////////////////////////////////////////}

uses
  Forms, Consts;

constructor TTrayIcon.Create(AOwner	:TComponent);
  begin
    inherited Create(AOwner);
    {NGCg}
    FIcon := TIcon.Create;
    FIcon.OnChange := OnIconChangeEvent;
    FResourceIconList := TStringList.Create;
    FTaskTrayIcon := TTaskTrayIcon.Create;
    FTaskTrayIcon.OnMessage := CallbackWndProc;
    FIconAnimation := nil;

    if not (csDesigning in ComponentState) then begin
      {fUC}
      OnAppRestore := Application.OnRestore;
      Application.OnRestore := OnAppRestoreEvent;
      OnAppMinimize := Application.OnMinimize;
      Application.OnMinimize := OnAppMinimizeEvent;
    end;
    {vpeB̃ftHgl̐ݒ}
    FResIcon		:= nil;
    FAutoPopup 		:= True;
    FTaskTrayIcon.SetTipHelp('TipHelp');
    FVisible 		:= True;
    FResourceIconID	:= -1;
    FMinimized 		:= False;
    FHideOnTaskBar 	:= False;
    FInterval		:= 0;
  end;

destructor TTrayIcon.Destroy;
  begin
    {fUCłȂƂ}
    if not (csDesigning in ComponentState) then begin
      DoDeleteTrayIcon;
      Application.OnRestore := OnAppRestore;
      OnAppRestore := nil;
      Application.OnMinimize := OnAppMinimize;
      OnAppMinimize := nil;
    end;
    {Aj[VXbh̔j}
    if FIconAnimation <> nil then begin
      FIconAnimation.Terminate;
      if FIconAnimation.Suspended then FIconAnimation.Resume;
      FIconAnimation.Free;
    end;
    {j}
    if FResIcon   <> nil then FResIcon.Free;
    FTaskTrayIcon.Free;
    FIcon.Free;
    FResourceIconList.Free;

    inherited Destroy;
  end;

procedure TTrayIcon.Loaded;
  begin
    {fUCłȂAVisiblevpeBTruêƂ}
    if not (csDesigning in ComponentState) and CanIconic then begin
      {ACRo^}
      SetTrayIcon;
    end;
    inherited Loaded;
  end;

{R[obN֐}
procedure TTrayIcon.CallbackWndProc(var Message: TMessage);
  var
    cursorPos	:TPoint;
  begin
    if Message.Msg = WM_TaskTrayMessage then begin
      {}EXJ[\݈̌ʒu擾}
      GetCursorPos(cursorPos);

      {}
      case Message.lParam of
	WM_MOUSEMOVE:begin
	{ACR̒ʉߎ}
	  if Assigned(FOnMouseMove) then
	    FOnMouseMove(Self, [], cursorPos.X, cursorPos.Y);
	end;
	WM_LBUTTONDOWN:begin
	{{^̃_E}
	  {|bvAbvj[蓖ĂĂAAutoPopupTrue}
	  if Assigned(FLPopupMenu) and FAutoPopup then begin
            SetForegroundWindow(Application.Handle);
            Application.ProcessMessages;
            FLPopupMenu.PopupComponent := Self;
            FLPopupMenu.Popup(cursorPos.X, cursorPos.Y);
          end
          else if Assigned(FOnMouseDown) then
            FOnMouseDown(Self, mbLeft, [ssLeft], cursorPos.X, cursorPos.Y);
        end;
        WM_LBUTTONUP:begin
        {{^̃Abv}
          if Assigned(FOnMouseUp) then
            FOnMouseUp(Self, mbLeft, [ssLeft], cursorPos.X, cursorPos.Y);
        end;
        WM_LBUTTONDBLCLK:begin
        {{^̃_uNbN}
          if Assigned(FOnDblClick) then FOnDblClick(Self);
        end;
        WM_MBUTTONDOWN:begin
          {{^̃_E}
          if Assigned(FOnMouseDown) then
            FOnMouseDown(Self, mbMiddle, [ssMiddle],  cursorPos.X, cursorPos.Y);
        end;
        WM_MBUTTONUP:begin
        {{^̃Abv}
          if Assigned(FOnMouseUp) then
	    FOnMouseUp(Self, mbMiddle, [ssMiddle],  cursorPos.X, cursorPos.Y);
        end;
        WM_RBUTTONDOWN:begin
        {E{^̃_E}
          {|bvAbvj[蓖ĂĂAAutoPopupTrue}
          if Assigned(FRPopupMenu) and FAutoPopup then begin
            SetForegroundWindow(Application.Handle);
            Application.ProcessMessages;
            FRPopupMenu.PopupComponent := Self;
            FRPopupMenu.Popup(cursorPos.X, cursorPos.Y);
          end
          else if Assigned(FOnMouseDown) then
	    FOnMouseDown(Self, mbRight, [ssRight], cursorPos.X, cursorPos.Y);
        end;
        WM_RBUTTONUP:begin
        {E{^̃Abv}
          if Assigned(FOnMouseUp) then
	    FOnMouseUp(Self, mbRight, [ssRight], cursorPos.X, cursorPos.Y);
        end;
        WM_RBUTTONDBLCLK:begin
        {E{^̃_uNbN}
          if Assigned(FOnRDblClick) then FOnRDblClick(Self);
        end;
	NIN_BALLOONSHOW:begin
	{o[wv\Ƃ̃bZ[W}

	end;
	NIN_BALLOONHIDE:begin
	{o[wv\ɂȂƂ̃bZ[W}

	end;
	NIN_BALLOONTIMEOUT: begin
	{^CAEgŃo[wv\ɂȂƂɔ}

	end;
	NIN_BALLOONUSERCLICK:begin
	{[U[NbNăo[wv\ɂȂƂɔ}
	  
	end;
	{ȉƎCxg}
	WM_MOUSE_ENTER: if Assigned(FOnMouseEnter) then FOnMouseEnter(Self);
	WM_MOUSE_EXIT : if Assigned(FOnMouseExit ) then FOnMouseExit (Self);
        WM_MOUSE_CLICK:begin
          if Assigned(FOnMouseClick) then begin
            FOnMouseClick(Self, TMouseButton(Message.WParam), [], cursorPos.X, cursorPos.Y);
          end;
	end;
      end;
    end
    else begin
    {̑̃bZ[W}
      case  Message.Msg of
        WM_QUERYENDSESSION: begin
	  Message.Result := Integer(True);
	end;
	{ȉƎbZ[W}
	WM_TASKBER_RESTART:begin
	{^XNo[ċN}
	  if FIconAnimation <> nil then begin
	    {ؕs\AWin2000SP3ł̓Xbh̍ĊJɌKvɂȂ(͂)
	     Ȃ̂ŁACX^Xj߂č쐬}
	    FIconAnimation.Free;
	    FIconAnimation := nil;
	    if Visible and (FInterval > 0) then begin
	      {Aj[VĊJ}
	      BeginIconAnimation;
	    end;
	  end;
	  {Cxg}
	  if Assigned(FOnRestartTaskbar) then FOnRestartTaskbar(Self);
	end;
      end;
    end;
  end;

{Notification}
procedure TTrayIcon.Notification(aComponent	:TComponent;
				 aOperation	:TOperation);
  begin
    inherited Notification(aComponent, aOperation);
    case aOperation of
      opRemove:begin
	if aComponent = FLPopupMenu then      FLPopupMenu := nil
	else if aComponent = FLPopupMenu then FRPopupMenu := nil;
      end;
    end;
  end;

{ŏCxg}
procedure TTrayIcon.OnAppMinimizeEvent(Sender	:TObject);
  begin
    if Assigned(OnAppMinimize) then OnAppMinimize(Sender);
    if FVisible and FMinimized then begin
      {gCACRo^}
      SetTrayIcon;
    end;
    if FVisible and FHideOnTaskBar then begin
      ShowWindow(Application.Handle, SW_HIDE);
    end;
  end;

{XgACxg}
procedure TTrayIcon.OnAppRestoreEvent(Sender	:TObject);
  begin
    if Assigned(OnAppRestore) then OnAppRestore(Sender);
    if FMinimized then begin
      {gCACR}
      DoDeleteTrayIcon;
      {CtH[Oʂɏo}
      if Owner is TWinControl then
	SetForegroundWindow(TWinControl(Owner).Handle);
    end;
  end;

{ACRύXCxg}
procedure TTrayIcon.OnIconChangeEvent(Sender	:TObject);
  begin
    if not (csDesigning in ComponentState) and
       not (csLoading in ComponentState) then begin
      {gC̃ACRXV}
      ModifyIcon;
    end;
  end;

{gCɃACR\ł邩}
function TTrayIcon.CanIconic:Boolean;
  begin
    Result := FVisible;
    if Result then begin
      if FMinimized then
	Result := IsIconic(Application.Handle);
    end;
  end;

{gCɓo^ACR̃nh𓾂}
function TTrayIcon.GetIconHandle:HWND;
  {ACR\[Xǂݍ}
  procedure loadIconResource(aResName	:String);
    var
      resStream: TResourceStream;
    begin
      resStream := TResourceStream.Create(hInstance, aResName, RT_ICON);
      try
	ResIcon.LoadFromStream(resStream);
      finally
	resStream.Free;
      end;
    end;
  var
    resourceName	:String;
  begin
    Result := FIcon.Handle;
    if Result = 0 then begin
      {ACRݒ肳ĂȂƂ}
      if (ResourceIconList.Count > 0) and (FResourceIconID >= 0) then begin
	resourceName := ResourceIconList.Strings[FResourceIconID];
	(*...2002.03.09...Bitmap͎gȂ炵i΁j
	{IconŃ[h}
	Result := LoadIcon(HInstance, Pchar(resourceName));
	if Result = 0 then begin
	{IconłȂBitmap[hĂ݂...
	  Result := LoadBitmap(HInstance, Pchar(resourceName));
	end;
	...*)
	{...
	loadIconResource(ResourceIconList.Strings[FResourceIconID]);
	...}
	ResIcon.Handle := LoadIcon(HInstance, Pchar(resourceName));
	Result := ResIcon.Handle;
      end
      else begin
	Result := Application.Icon.Handle;
      end;
    end;
  end;

{gCɃACRo^}
function TTrayIcon.DoSetTrayIcon: Boolean;	{True:}
  begin
    FTaskTrayIcon.Icon := GetIconHandle;
    Result := FTaskTrayIcon.SetTrayIcon;
    if Result then begin
      {Aj[VJn}
      BeginIconAnimation;
    end;
  end;
{gCACR}
function TTrayIcon.DoDeleteTrayIcon: Boolean;	{True:}
  begin
    {Aj[VI}
    EndIconAnimation;
    {}
    {Result := FTaskTrayIcon.DeleteTrayIcon;}
    Result := FTaskTrayIcon.HideTrayIcon;
  end;

{^XNgC֓o^EChEnh𓾂}
function TTrayIcon.GetTaskTrayHWND: HWND;
  begin
    Result := FTaskTrayIcon.TrayHandle;
  end;

{gCɃACRo^}
function TTrayIcon.SetTrayIcon:Boolean;
  begin
    Result := DoSetTrayIcon;
    if Result then FVisible := True;
  end;

{gCACR}
function TTrayIcon.DeleteTrayIcon:Boolean;
  begin
    Result := DoDeleteTrayIcon;
    if Result then FVisible := False;
  end;

{gCACR̕ύX}
function TTrayIcon.ModifyIcon:Boolean;
  begin
    FTaskTrayIcon.Icon := GetIconHandle;
    if CanIconic then Result := FTaskTrayIcon.ModifyIcon
    else              Result := False;
  end;

{o[wv\}
function TTrayIcon.ShowBalloonHelpSE(aHelpTitle,		{^Cg}
				     aHelpText	:String;	{bZ[W}
				     aTimeOut	:Integer;	{^CAEg(~b)}
				     aIconType	:TBalloonIconType)
						:Boolean;	{True:}
  begin
    Result := FTaskTrayIcon.ShowBalloonHelpSE(aHelpTitle, aHelpText, aTimeOut, aIconType);
  end;
function TTrayIcon.ShowBalloonHelp: Boolean;	{True:}
  begin
    Result := FTaskTrayIcon.ShowBalloonHelp;
  end;

{o[wv}
function TTrayIcon.HideBalloonHelp: Boolean;	{True:}
  begin
    Result := FTaskTrayIcon.HideBalloonHelp;
  end;

{Aj[V}
procedure TTrayIcon.BeginIconAnimation;
  begin
    if Visible and (FInterval > 0) then begin
      {Aj[VJn}
      IconAnimation.Resume;
    end
    else begin
      if FIconAnimation <> nil then begin
	if not FIconAnimation.Suspended then FIconAnimation.Suspend;
      end;
    end;
  end;
procedure TTrayIcon.EndIconAnimation;
  begin
    if FIconAnimation <> nil then begin
      if not FIconAnimation.Suspended then FIconAnimation.Suspend;
    end;
  end;

{ACRύX^C}[Cxg}
procedure TTrayIcon.OnTrayIconChange;
  begin
    if Assigned(FOnTimer) then begin
      FOnTimer(Self);
      ModifyIcon;
    end
    else begin
      if (FResourceIconID + 1) >= FResourceIconList.Count then begin
	ResourceIconID := 0;
      end
      else begin
	ResourceIconID := FResourceIconID + 1;
      end;
    end;
  end;

{protected}
function TTrayIcon.GetResIcon: TIcon;
  begin
    if FResIcon = nil then FResIcon := TIcon.Create;
    Result := FResIcon;
  end;

function TTrayIcon.IconAnimation: TIconAnimation;
  begin
    if FIconAnimation = nil then begin
      FIconAnimation := TIconAnimation.Create(Self);
    end;
    Result := FIconAnimation;
  end;

{published}
procedure TTrayIcon.SetAutoPopup(aValue	:Boolean);
  begin
    if FAutoPopup <> aValue then FAutoPopup := aValue;
  end;

procedure TTrayIcon.SetIcon(aValue	:TIcon);
  begin
    if aValue <> nil then
      FIcon.Assign(aValue)
    else begin
      FIcon.ReleaseHandle;
      FIcon.Handle := 0;
    end;
    (*...2002.08.18
    if not (csDesigning in ComponentState) and
       not (csLoading in ComponentState) then begin
      {gC̃ACRXV}
      ModifyIcon;
    end;
    ...*)
    {ACRύXCxg}
    OnIconChangeEvent(nil);
  end;

function  TTrayIcon.GetTipHelp: String;
  begin
    Result := FTaskTrayIcon.GetTipHelp;
  end;

procedure TTrayIcon.SetTipHelp(aValue	:String);
  begin
    FTaskTrayIcon.SetTipHelp(aValue);
    if not (csDesigning in ComponentState) and
       not (csLoading in ComponentState) then begin
      ModifyIcon;
    end;
  end;

procedure TTrayIcon.SetMinimized(aValue	:Boolean);
  begin
    if FMinimized <> aValue then begin
      FMinimized := aValue;
      if not (csDesigning in ComponentState) and
         not (csLoading in ComponentState) then begin
        if CanIconic then ModifyIcon
        else 		  DoDeleteTrayIcon;
      end;
    end;
  end;

procedure TTrayIcon.SetVisible(aValue	:Boolean);
  begin
    if FVisible <> aValue then begin
      FVisible := aValue;
      {fUCłȂAR|[lg[hłȂꍇA\E\̐ؑւ}
      if not (csDesigning in ComponentState) and
         not (csLoading in ComponentState) then begin
        if CanIconic then SetTrayIcon		{\\}
	else 		  DoDeleteTrayIcon;	{\  \}
      end;
    end;
  end;

procedure TTrayIcon.SetIconID(aValue	:Integer);
  begin
    //if (FResourceIconList.Count <= aValue) or (aValue < 0) then aValue := 0;
    if (FResourceIconID <> aValue) or (aValue = 0) then begin
      FIcon.Handle := 0;
      if csLoading in ComponentState then begin
	FResourceIconID := aValue;
      end
      else begin
        if FResourceIconList.Count <= aValue then begin
          FResourceIconID := FResourceIconList.Count -1;
        end
        else if aValue < 0 then begin
          FResourceIconID := -1;
        end
        else begin
          FResourceIconID := aValue;
        end;
      end;
      if not (csDesigning in ComponentState) and
         not (csLoading in ComponentState) then begin
	if CanIconic then ModifyIcon;
      end;
    end;
  end;

function TTrayIcon.GetIconID:Integer;
  begin
    if (FResourceIconList.Count <= FResourceIconID) or
       (FResourceIconID = 0) then FResourceIconID := 0;
    Result := FResourceIconID;
  end;

procedure TTrayIcon.SetIconIDList(aValue	:TStringList);
  var
    current	:String;
  begin
    if FResourceIconList.Count = 0 then begin
      {Xg̃Rs[}
      FResourceIconList.Assign(aValue);
      if not (csDesigning in ComponentState) and
         not (csLoading in ComponentState) then begin
        {ACRXV}
        if CanIconic then ModifyIcon;
      end;
    end
    else begin
      if FResourceIconID < 0 then Exit;
      current := FResourceIconList.Strings[FResourceIconID];
      {Xg̃Rs[}
      FResourceIconList.Assign(aValue);
      {ACRID̍XV}
      SetIconID(ResourceIconID);
      if FResourceIconList.Strings[ResourceIconID] <> current then begin
        if not (csDesigning in ComponentState) and
           not (csLoading in ComponentState) then begin
          {ACRXV}
          if CanIconic then ModifyIcon;
        end;
      end;
    end;
  end;

procedure TTrayIcon.SetInterval(aValue	:Cardinal);
  begin
    if aValue <> FInterval then begin
      {ȂƂȂ50菬͕̂s}
      if (aValue < 50) and (aValue > 0) then aValue := 50;
      FInterval := aValue;
      {Aj[VJn}
      BeginIconAnimation;
    end;
  end;

function TTrayIcon.GetFWindow: Boolean;
  begin
    Result := FTaskTrayIcon.FrontToWindow;
  end;

procedure TTrayIcon.SetFWindow(aValue	:Boolean);
  begin
    FTaskTrayIcon.FrontToWindow := aValue;
  end;

{NbNƃ_uNbN̔s}
function TTrayIcon.GetChackClick: Boolean;
  begin
    Result := FTaskTrayIcon.ToolTipStyle.RequestSglDbl;
  end;
procedure TTrayIcon.SetChackClick(aValue	:Boolean);
  begin
    FTaskTrayIcon.ToolTipStyle.RequestSglDbl := aValue;
  end;

{Shell32.dll̃o[Wo[wv\ł}
function TTrayIcon.GetCanBalloonHelp:Boolean;
  begin
    Result := FTaskTrayIcon.ShellNewVersion;
  end;

{o[wṽ^Cg}
function TTrayIcon.GetBlHelpTitle:String;
  begin
    Result := FTaskTrayIcon.GetBalloonHelpTitle;
  end;
procedure TTrayIcon.SetBlHelpTitle(aHelpTitle	:String);
  begin
    FTaskTrayIcon.SetBalloonHelpTitle(aHelpTitle);
  end;

{o[wṽeLXg}
function TTrayIcon.GetBalloonHelp:String;
  begin
    Result := FTaskTrayIcon.GetBalloonHelp;
  end;
procedure TTrayIcon.SetBalloonHelp(aHelpText	:String);
  begin
    FTaskTrayIcon.SetBalloonHelp(aHelpText);
  end;

{gCŕ\̃^CAEg}
function TTrayIcon.GetUTimeOut:Integer;
  begin
    Result := FTaskTrayIcon.GetUTimeOut;
  end;

procedure TTrayIcon.SetUTimeOut(aValue	:Integer);
  begin
    FTaskTrayIcon.SetUTimeOut(aValue);
  end;

{o[wvŕ\ACR̎}
function TTrayIcon.GetBalloonIconType:TBalloonIconType;
  begin
    Result := FTaskTrayIcon.GetBalloonIconType;
  end;
procedure TTrayIcon.SetBalloonIconType(aValue	:TBalloonIconType);
  begin
    FTaskTrayIcon.SetBalloonIconType(aValue);
  end;

function TTrayIcon.GetToolTipStyle: TToolTipStyle;
  begin
    Result := FTaskTrayIcon.ToolTipStyle;
  end;

procedure TTrayIcon.SetToolTipStyle(aToolTipStyle: TToolTipStyle);
  begin
    FTaskTrayIcon.ToolTipStyle.Assign(aToolTipStyle);
  end;

{************************************************************************}
{*	Aj[VpThread						*}
{************************************************************************}
constructor TIconAnimation.Create(aOwner	:TTrayIcon);
  begin
    inherited Create(True);
    Owner := aOwner;
  end;
destructor TIconAnimation.Destroy;
  begin
    inherited Destroy;
  end;
procedure TIconAnimation.Execute;
  begin
    while not Terminated do begin
      if (Owner.Interval = 0) or
         (not Owner.Visible)  then begin
        if not Suspended then Suspend;
      end;

      if Owner.Visible then begin
        {ACRύX}
	Owner.OnTrayIconChange;
        {ҋ@}
	Sleep(Owner.Interval);
      end;
    end;
  end;

{************************************************************************}
{*	WXg							*}
{************************************************************************}
procedure Register;
  begin
    RegisterComponents('Samples', [TTrayIcon]);
  end;

end.


