{//////////////////////////////////////////////////////////////////////////////
//	^XNgCACR\֘Ajbg				     //
//	2002.04.15 H.Okamoto						     //
//	ŏIXV	2004.02.27					     //
//////////////////////////////////////////////////////////////////////////////}
unit TrShlApi;

{/////////////////////////////////////////////////////////////////////////////}
interface
{/////////////////////////////////////////////////////////////////////////////}

uses
  Windows, Messages, Classes {$IFNDEF NO_USE_CUSTOM_TOOLTIP}, Graphics{$ENDIF};

{************************************************************************}
{* 	萔`							*}
{************************************************************************}
const
  WM_TaskTrayMessage	= WM_User + 200;
  NotifyIconErrMessage    = '^XNgCɃACRo^ł܂B';
  NotifyIconModErrMessage = '^XNgC̃ACRύXł܂B';

  {^XNgCNXpbZ[W}
  WM_MOUSE_ENTER	= WM_User + 210;	{}EXgC̃ACRɓƂ̃bZ[W}
  WM_MOUSE_EXIT		= WM_User + 211;	{@@@V@@@̃ACRoƂ̃bZ[W}
  WM_MOUSE_CLICK	= WM_User + 212;	{@@@V@@@̃ACRŃ}EXNbNƂ̃bZ[W}
  WM_TASKBER_RESTART	= WM_User + 220;	{^XNo[ċNbZ[W}

  TRAY_ICON_WINDOW_CLASS_NAME	= 'TaskTrayHandle';

  {Windows XP Ή ^XNgCɃACR\ȂƂƂ̃G[}
  {`̎ʎqG[ɂȂRgĂ}
  //ERROR_TIMEOUT   = 1460;

{************************************************************************}
{* 	e`							*}
{************************************************************************}
type
  {^XNgCACRnh̃bZ[WCxgnh}
  TOnMessage	= procedure (var Message: TMessage) of object;

{*****************************************************************************
	Shell32.dll Ver5.0 ȍ~p(Windows 2000 + IE5.0 ȍ~)
******************************************************************************}
const
  NIM_SETFOCUS		= $0004;
  NIM_SETVERSION	= $0008;

  {TNotifyIconData.uFlags ǉ萔}
  {$EXTERNALSYM NIF_STATE}
  NIF_STATE		= $00000008;
  {$EXTERNALSYM NIF_INFO}
  NIF_INFO		= $00000010;

  {TNotifyIconData.dwState}
  NIS_HIDDEN 		= $00000001;
  NIS_SHAREDICON	= $00000002;

  {TNotifyIconData.uTimeoutOrVersion}
  {^XNgCACRɊւ铮o[W:
   ʏ͂OWin95ォ̃bZ[WƓł}
  NOTIFYICON_VERSION	= $00000001;

  {TNotifyIconData.dwInfoFlags Konstanten}
  {o[wvɕ\ACR̎}
  NIIF_NONE		= $00000000;	{ACRȂ}
  NIIF_INFO		= $00000001;	{}
  NIIF_WARNING		= $00000002;	{x}
  NIIF_ERROR		= $00000003;	{G[}

  {o[֘AbZ[W Shell32.dll ̃o[W 6.0ȍ~H}
  {(1):^XNgCACRɊւ铮o[W1̂Ƃp炵
   (2):Shell32.dll ̃o[W6(Windows XP)ȍ~炵}
  NIN_SELECT		= WM_USER + 0;		{(1)}
  NINF_KEY		= $1;
  NIN_KEYSELECT		= NIN_SELECT or NINF_KEY;	{(1)=WM_USER + 1}
  NIN_BALLOONSHOW	= WM_USER + 2;		{(2):o[wv\Ƃ̃bZ[W}
  NIN_BALLOONHIDE	= WM_USER + 3;		{(2):o[wv\ɂȂƂ̃bZ[W}
  NIN_BALLOONTIMEOUT	= WM_USER + 4;		{(2):^CAEgŃo[wv\ɂȂƂɔ}
  NIN_BALLOONUSERCLICK	= WM_USER + 5;		{(2):[U[NbNăo[wv\ɂȂƂɔ}

type
  {^XNgCɃACR\邽߂̍\ Ver 5 ȍ~}
  PNewNotifyIconData = ^TNewNotifyIconData;
  _NEWNOTIFYICONDATA	= packed record
    cbSize		:DWORD;
    Wnd			:HWND;
    uID			:UINT;
    uFlags		:UINT;
    uCallbackMessage	:UINT;
    hIcon		:HICON;
    szTip		:array [0..127] of AnsiChar;
    {ǉ}
    dwState		:DWORD;
    dwStateMask		:DWORD;
    szInfo		:array [0..255] of AnsiChar;
    uTimeout		:UINT;
    szInfoTitle		:array [0.. 63] of AnsiChar;
    dwInfoFlags		:DWORD;
  end;
  TNewNotifyIconData = _NEWNOTIFYICONDATA;

  {DLL̃o[W𓾂\}
  TDllVersionInfo	= packed record
    cbSize		:DWORD;
    dwMajorVersion	:DWORD;
    dwMinorVersion	:DWORD;
    dwBuildNumber	:DWORD;
    dwPlatformID	:DWORD;
  end;

{************************************************************************}
{* 	JX^c[`bvNX					*}
{************************************************************************}
{$IFNDEF NO_USE_CUSTOM_TOOLTIP}
const
  MOUSE_BUTTON_LEFT	= 1;
  MOUSE_BUTTON_RIGHT	= 2;
  MOUSE_BUTTON_MIDDLE	= 3;

type
  {}EX̏}
  TTrayIconMouseState	= (timsLDown, timsRDown, timsMDown, timsEnter);
  TTrayIconMouseStates	= set of TTrayIconMouseState;

  TCustomToolTipStyle	=class(TPersistent)
  protected
    FOwnerHWnd,				{^XNgCACRnh}
    FHTooltip		:HWND;		{c[`bvEChEnh}

    FIconRect		:TRect;		{^XNgC̃ACR̗̈}
    {FExitMouse		:Boolean;	{True:}EXJ[\ACROɂ}
    FThread		:TThread;	{}EXIn/Out𔻒肷邽߂̃Xbh}
    FMouseStates	:TTrayIconMouseStates;	{}EXJ[\̏}
    FWaitClick		:Boolean;
    {vpeB}
    FRequestSglDbl	:Boolean;	{True:VONbNƃ_uNbN𔻒肷}
    FUseDefault		:Boolean;	{True:ftHg̃qg\s}
    FHintFont		:TFont;
    //FDelayTimeAutoPop	:Integer;	{x}
    //FDelayTimeInitial	:Integer;
    //FDelayTimeReshow	:Integer;
    FBackGrdColor	:TColor;	{wiF}
    //FMaxTipWidth	:Integer;	{TipWiondowő啝}
    //FMargin		:TRect;		{㉺E}[W}
  public
    constructor Create;
    destructor Destroy; override;

  protected
    {<< vpeBIO >>}
    {I[i[̐ݒ}
    procedure SetOwner(aOwnerHWND	:HWND);

    {w}EXԂł邩}
    function GetMouseState(aTrayIconMouseState: TTrayIconMouseState): Boolean;
    {ҋ@̃}EX{^}
    function GetWaitClickButton: TTrayIconMouseState;

    {x
    function GetDelayTime(aIndex: Integer): Integer;
    procedure SetDelayTime(aIndex: Integer; aValue: Integer);}
    {eLXgEwiF}
    function GetColor(aIndex: Integer): TColor;
    procedure SetColor(aIndex: Integer; aColor: TColor);
    {eLXgTCY
    function GetTextSize: Integer;
    procedure SetTextSize(aValue: Integer);}
    {tHg
    function GetFont: TFont;
    procedure SetFont(aFont: TFont);}
    {TipWindowő啝
    function GetMaxTipWidth: Integer;
    procedure SetMaxTipWidth(aValue: Integer);}
    {㉺E}[W
    function GetMargin(aIndex: Integer): Integer;
    procedure SetMargin(aIndex: Integer; aValue: Integer);}

  protected
    {bZ[W}
    procedure WndProc(var Message: TMessage);

    {c[`bṽnh𓾂}
    {vׂẴACR͓c[`bvLĂ炵}
    function GetTooltipHandle: HWND;

    {}EXACRɓ̏}
    procedure OnMouseEnter;
    {}EXACROɏȍ}
    procedure OnMouseExit;

    {}EXNbN}
    procedure OnMouseClick(aMouseButton: TTrayIconMouseState);

    {^XNgCACR̃bZ[W}
    procedure TrayIconWndProc(var Message: TMessage);

    {gCACR͈͂𖳌}
    procedure DisableTrayIconRect;

  public
    {f[^̕}
    procedure Assign(aSource: TPersistent); override;

  protected
    {}EXCxg}
    procedure DoMouseEnter;
    procedure DoMouseExit;
    procedure DoMouseClick(aMouseButton: TTrayIconMouseState);
    procedure DoMouseDblClick(aMouseButton: TTrayIconMouseState);

    {c[`bvύX}
    procedure SetCustomToolTip;
    {Wɖ߂}
    procedure SetDefaultToolTip;

  protected
    property MouseEnter: Boolean index timsEnter read GetMouseState;
    property RequestSglDbl: Boolean read FRequestSglDbl write FRequestSglDbl;

    property UseDefault: Boolean read FUseDefault write FUseDefault;
    {x
    property DelayTimeAutoPopup: Integer index 1 read GetDelayTime write SetDelayTime default 5000;
    property DelayTimeInitial  : Integer index 2 read GetDelayTime write SetDelayTime default 500;
    property DelayTimeReshow   : Integer index 3 read GetDelayTime write SetDelayTime default 100;}
    {wiF}
    property BackGroundColor: TColor index 1 read GetColor write SetColor;
    {eLXgFƃTCY}
    property TextColor: TColor index 2 read GetColor write SetColor;
    {property TextSize: Integer read GetTextSize write SetTextSize default 9;}

    {tHgCX^X
    property HintFont: TFont read GetFont write SetFont;}

    {ő啝...ʂȂ݂ł
    property MaxTipWidth: Integer read GetMaxTipWidth write SetMaxTipWidth default 400;}
    {㉺E}[W
    property MarginTop   : Integer index 1 read GetMargin write SetMargin default 0;
    property MarginLeft  : Integer index 2 read GetMargin write SetMargin default 0;
    property MarginRight : Integer index 3 read GetMargin write SetMargin default 0;
    property MarginBottom: Integer index 4 read GetMargin write SetMargin default 0;}
  end;

  TToolTipStyle	=class(TCustomToolTipStyle)
  public
    property RequestSglDbl;

  published
    property UseDefault;
    {x...ʂȂ݂ł
    property DelayTimeAutoPopup default 5000;
    property DelayTimeInitial default 500;
    property DelayTimeReshow default 100;}
    {wiF}
    property BackGroundColor;
    {eLXgFƃTCY}
    property TextColor;
    {...ʂȂ݂ł
    property TextSize default 9;
    property HintFont;}
    {ő啝...ʂȂ݂ł
    property MaxTipWidth default 400;}
    {㉺E}[W...ʂȂ݂ł
    property MarginTop;
    property MarginLeft;
    property MarginRight;
    property MarginBottom;}
  end;

{vpeB:xԂɂ
DelayTimeAutoPopup
  gCACRɊOڂlp`̓Ń|C^~ĂƂ
  c[`bvqgEChE\Ă鎞

DelayTimeInitial
  gCACRɊOڂlp`̓Ń|C^~Ăc[`bv
  qgEChE\܂ł̎

DelayTimeReshow
  |C^ʂ̃gCACRɈړĂ玟̃c[`bvqgEChE
  \܂ł̎
}
{$ENDIF}

{************************************************************************}
{* 	^XNgCACR\pNX				*}
{************************************************************************}
type
  {o[`bvwṽACR^Cv}
  TBalloonIconType	= (bitNone, bitInfo, bitWarning, bitError);
  {^XNgCACR̃ACR}
  TOnTrayIconFlag	= (otifRegisted, otifShowing);
  TOnTrayIconFlags	= set of TOnTrayIconFlag;

  TTaskTrayIcon	=class
  private
    {FShellNew		:Boolean;		{True:Shell32.dll Ver5.0ȍ~}
    FShell32Ver		:Integer;		{Shell32.dll̃o[W}
    FUpdateCount	:Integer;
  protected
    FTrayHandle		:HWnd;			{^XNgCp Handle}
    FIconData		:TNewNotifyIconData;	{gCACRf[^}
   {FOnTaskTray		:Boolean;		{True:^XNgCɕ\}
    FOnTrayIconFlag	:TOnTrayIconFlags;	{^XNgCւ̃ACR\}
    FEnabledHide	:Boolean;		{True: ACR\͉Bɂ
						 ShellNewVersion = True ̂Ƃ̂ݗL}
    FOnMessage		:TOnMessage;		{bZ[W}

    {$IFNDEF NO_USE_CUSTOM_TOOLTIP}
    FToolTipStyle	:TToolTipStyle;		{c[`bvωNX}
    {$ENDIF}
  public
    FrontToWindow	:Boolean;

  public
    constructor Create;
    destructor Destroy; override;

    {vpeB}
    procedure Assign(aDest	:TTaskTrayIcon);

  protected
    {^XNgCpWindowProcedure}
    procedure TrayWndProc(var Message: TMessage);

    {^XNgCo^pnh̎擾}
    function GetTrayHandle:HWnd;

    {}EXACRɓ̏}
    procedure DoMouseEnter;
    {}EXACROɏȍ}
    procedure DoMouseExit;

    {^XNgCɃACRo^Ă邩}
    function GetIconRegisted: Boolean;
    procedure SetIconRegisted(aValue: Boolean);
    {^XNgCɃACR\Ă邩}
    function GetOnTaskTray: Boolean;
    procedure SetOnTaskTray(aValue: Boolean);

  public
    {vpeBIO}
    {gCɓo^ACR̃nh}
    function GetIconHandle:HICON;
    procedure SetIconHandle(aIconHandle	:HICON);

    {gCŕ\eLXg}
    function GetTipHelp:String;
    procedure SetTipHelp(aTipHelp	:String);

    {<<<<< Windows2000 + IE5.0ȍ~ >>>>>}
    {Shell32.dll̃o[W 5.0ȍ~}
    function GetShellNewVersion: Boolean;

    {o[wṽ^Cg}
    function GetBalloonHelpTitle:String;
    procedure SetBalloonHelpTitle(aHelpTitle	:String);

    {o[wṽeLXg}
    function GetBalloonHelp:String;
    procedure SetBalloonHelp(aHelpText	:String);

    {gCŕ\o[wṽ^CAEg}
    function GetUTimeOut:Integer;
    procedure SetUTimeOut(aValue	:Integer);

    {o[wvŕ\ACR̎}
    function GetBalloonIconType:TBalloonIconType;
    procedure SetBalloonIconType(aValue	:TBalloonIconType);
    {<<<<< ܂ >>>>>}

  public
    {̍XVJn}
    procedure BeginUpdate;
    {̍XVI}
    procedure EndUpdate;
    {̍XV}
    procedure FinishUpdate;

    {XV}
    function Updating: Boolean;	{True:XV}

    {gCɃACRo^}
    function SetTrayIcon:Boolean;

    {gCACR}
    function HideTrayIcon:Boolean;
    function DeleteTrayIcon:Boolean;

    {gCACR̕ύX}
    function ModifyIcon:Boolean;

    {o[wv\}
    function ShowBalloonHelpSE(aHelpTitle,			{^Cg}
    			       aHelpText	:String;	{bZ[W}
                               aTimeOut		:Integer;	{^CAEg(~b)}
                               aIconType	:TBalloonIconType)
                             			:Boolean;	{True:}

    function ShowBalloonHelp: Boolean;	{True:}

    {o[wv}
    function HideBalloonHelp: Boolean;	{True:}

    {ACRɃJ[\邩}
    {$IFNDEF NO_USE_CUSTOM_TOOLTIP}
    function IsCursorInnerRect(aX, aY: Integer): Boolean;
    {$ENDIF}

  public
    {vpeB}
    property Icon:HICON read GetIconHandle write SetIconHandle;
    property IconRegisted: Boolean read GetIconRegisted write SetIconRegisted;	{True: ^XNgCɃACRo^ς}
    property OnTaskTray: Boolean read GetOnTaskTray write SetOnTaskTray;	{True: ^XNgCɃACR\}
    property Shell32Version: Integer read FShell32Ver;
    property ShellNewVersion: Boolean read GetShellNewVersion;			{True: Shell32.dll̃o[W 5.0 ȍ~}
    {$IFNDEF NO_USE_CUSTOM_TOOLTIP}
    property ToolTipStyle: TToolTipStyle read FToolTipStyle;
    {$ENDIF}
    property TrayHandle: HWnd read GetTrayHandle;
    {Cxg}
    property OnMessage:TOnMessage read FOnMessage write FOnMessage;
  end;

{************************************************************************}
{*	TaskTrayIconClasspMessageHandler				*}
{************************************************************************}
type
  TTrayIconWinProcList	= class(TList)
  protected
    uTaskbarRestart	:UINT;
  public
    {NGCg}
    constructor Create;
    {j}
    destructor Destroy; override;

  protected
    {NXWindowsɓo^}
    procedure RegisterClass;
    {NXWindows폜}
    procedure UnRegisterClass;

    {bZ[W}
    function MessageDeliver(aHWND	:HWND;
    			    var Message	:TMessage)
                          		:Boolean;	{True:}

  public
    {NXǉ}
    procedure AddClass(aTaskTrayIcon	:TTaskTrayIcon);
    {NX폜}
    procedure DeleteClass(aTaskTrayIcon	:TTaskTrayIcon);

  end;

{************************************************************************}
{* 	֐`							*}
{************************************************************************}
{Shell32.dll̃o[W𓾂}
function GetShellDllVersion:Longint;

{/////////////////////////////////////////////////////////////////////////////}
implementation
{/////////////////////////////////////////////////////////////////////////////}

uses
  SysUtils, CommCtrl, ShellApi;

{************************************************************************}
{* 	[JCX^X						*}
{************************************************************************}
var
  {$IFNDEF NO_USE_CUSTOM_TOOLTIP}
  {ToolTipClass		:TCustomToolTipStyle;}
  {$ENDIF}
  TrayIconWinProcList	:TTrayIconWinProcList;

{************************************************************************}
{* 	[J萔`						*}
{************************************************************************}
(*...CommCtrl.pas jbgɒ`ς...
const
  TOOLTIPS_CLASS	= 'tooltips_class32';
  TTS_NOPREFIX		= 2;

  {c[`bv萔}
  TTM_SETTIPBKCOLOR	= WM_USER + 19; // wiF̐ݒ
  TTM_SETTIPTEXTCOLOR	= WM_USER + 20; // eLXgF̐ݒ
  TTM_GETDELAYTIME	= WM_USER + 21; // xԂ̎擾
  TTM_GETTIPBKCOLOR	= WM_USER + 22; // wiF̎擾
  TTM_GETTIPTEXTCOLOR	= WM_USER + 23; // eLXgF̎擾
  TTM_SETMAXTIPWIDTH	= WM_USER + 24; // `bvEBhE̍ő啝̐ݒ
  TTM_GETMAXTIPWIDTH	= WM_USER + 25; // `bvEBhE̍ő啝̎擾
  TTM_SETMARGIN		= WM_USER + 26; // }[W̐ݒ
  TTM_GETMARGIN		= WM_USER + 27; // }[W̎擾
  TTM_POP		= WM_USER + 28; // 
  TTM_UPDATE		= WM_USER + 29; // ĕ`  // Tooltip constants
  TTM_SETTITLEA		= WM_USER + 32;

  {x(DelayTime) ̎擾ݒp}
  TTDT_AUTOMATIC	= 0;
  TTDT_RESHOW		= 1;
  TTDT_AUTOPOP		= 2;
  TTDT_INITIAL		= 3;
*)

{************************************************************************}
{* 	TaskTrayWindowProc						*}
{************************************************************************}
function TaskTrayProc(hWnd	:HWND;
		      aMsg	:Longword;
		      wParam	:Longint;
		      lParam	:Longint)
				:Longint; stdcall;
  var
    msg		:TMessage;
    defProc	:Boolean;
  begin
    Result := 0;
    defProc := True;
    if TrayIconWinProcList <> nil then begin
      msg.Msg := aMsg;
      msg.WParam := wParam;
      msg.LParam := lParam;
      if TrayIconWinProcList.MessageDeliver(hWnd, msg) then begin
        Result := msg.Result;
        defProc := False;
      end;
    end;
    {W\bh}
    if defProc then begin
      Result := DefWindowProc(hWnd, aMsg, wParam, lParam);
    end;
  end;

{************************************************************************}
{*	Mouse Enter/Reave CxgpThread				*}
{************************************************************************}
{$IFNDEF NO_USE_CUSTOM_TOOLTIP}
type
  TMouseEventMaker = class(TThread)
  private
    Owner	:TCustomToolTipStyle;
  public
    constructor Create(AOwner	:TCustomToolTipStyle);
    destructor Destroy; override;

  protected
    procedure Execute; override;
    procedure OnMouseExit;
  end;

constructor TMouseEventMaker.Create(aOwner	:TCustomToolTipStyle);
  begin
    inherited Create(True);
    Owner := aOwner;
  end;
destructor TMouseEventMaker.Destroy;
  begin
    inherited Destroy;
  end;
procedure TMouseEventMaker.Execute;
  begin
    while not Terminated do begin
      if (not Owner.MouseEnter) and (not Suspended) then Suspend;
      {ҋ@}
      Sleep(100);
      {}EXO}
      Synchronize(OnMouseExit);
    end;
  end;

procedure TMouseEventMaker.OnMouseExit;
  begin
    {}EX̃ACROs}
    Owner.OnMouseExit;
  end;
{$ENDIF}

{************************************************************************}
{* 	[J֐							*}
{************************************************************************}
CONST
  {^XNgC̃ACR̃TCY}
  TASKTRAY_ICONSIZE	= {16}32;	{ŉB邱Ƃ̂Ŕ{̃TCYŗlq}
  {Ȕ͈͒萔}
  DISABLE_RECT	:TRect=(Left:0; Top:0; Right:0; Bottom:0);

{͈͂𖳌:^XNgC̃ACR(0.0)܂ޔ͈͂ɂȂȂƂO}
procedure DisableRect(var aRect :TRect);
  begin
    {FillChar(aRect, SizeOf(TRect), #$0);}
    aRect := DISABLE_RECT;
  end;

{`͈͂XV}
procedure UpdateRect(var aRect :TRect; aPos: TPoint);
  begin
    {...2003.05.17
    if (aRect.Left = 0) and (aRect.Top = 0) and
       (aRect.Right = 0) and (aRect.Bottom = 0) then begin
    ...}
    if (aRect.Left  = DISABLE_RECT.Left)  and (aRect.Top = DISABLE_RECT.Top) and
       (aRect.Right = DISABLE_RECT.Right) and (aRect.Bottom = DISABLE_RECT.Bottom) then begin
      aRect.TopLeft     := aPos;
      aRect.BottomRight := aPos;
    end
    else begin
      {E͈͂̍XV}
      if aRect.Left > aPos.x then aRect.Left := aPos.x
      else if aRect.Right < aPos.x then aRect.Right := aPos.x;
      {㉺͈͂̍XV}
      if aRect.Top > aPos.y then aRect.Top := aPos.y
      else if aRect.Bottom < aPos.y then aRect.Bottom := aPos.y;
    end;
  end;

{_͈͓ł邩}
function IsInnerRect(aRect :TRect; aPos: TPoint): Boolean;
  begin
    Result := (aRect.Left <= aPos.x) and (aRect.Right  >= aPos.x) and
              (aRect.Top  <= aPos.Y) and (aRect.Bottom >= aPos.y);
  end;

{TrayIconWinProcListɓo^}
procedure AddTrayIconWinProcList(aClass	:TTaskTrayIcon);
  begin
    if TrayIconWinProcList = nil then begin
      TrayIconWinProcList := TTrayIconWinProcList.Create;
    end;
    TrayIconWinProcList.AddClass(aClass);
  end;
{TrayIconWinProcList폜}
procedure DelTrayIconWinProcList(aClass	:TTaskTrayIcon);
  begin
    if TrayIconWinProcList <> nil then begin
      TrayIconWinProcList.DeleteClass(aClass);
      if TrayIconWinProcList.Count = 0 then begin
	TrayIconWinProcList.Free;
	TrayIconWinProcList := nil;
      end;
    end;
  end;

{$IFNDEF NO_USE_CUSTOM_TOOLTIP}
{************************************************************************}
{* 	JX^c[`bvNX					*}
{************************************************************************}
constructor TCustomToolTipStyle.Create;
  begin
    inherited Create;
    {NGCg}
    FHintFont		:= TFont.Create;
    {}
    FOwnerHWnd		:= 0;
    FHTooltip		:= GetTooltipHandle;
    FRequestSglDbl	:= True;
    FUseDefault 	:= True;
    {FExitMouse		:= True;}
    FThread		:= nil;
    FMouseStates	:= [];
    DisableTrayIconRect;
    {x
    FDelayTimeAutoPop	:= 5000;
    FDelayTimeInitial	:= 500;
    FDelayTimeReshow	:= 100;}
    {wiF
    FBackGrdColor	:= GetSysColor(COLOR_INFOBK);}
    {eLXgF
    FHintFont.Color	:= GetSysColor(COLOR_INFOTEXT);}
    {ő啝
    FMaxTipWidth	:= 400;}
    {㉺E}[W
    FillChar(FMargin, SizeOf(TRect), #$0);}

    {ToolTipClass	:= Self;}
  end;

destructor TCustomToolTipStyle.Destroy;
  begin
    if FThread <> nil then begin
      if not FThread.Suspended then begin
        FThread.Terminate;
        FThread.WaitFor;
      end;
      FThread.Free;
    end;
    {ftHgݒɖ߂}
    SetDefaultToolTip;
    {j}
    FHintFont.Free;
    inherited Destroy;
  end;

{<< vpeBIO >>}
{I[i[̐ݒ}
procedure TCustomToolTipStyle.SetOwner(aOwnerHWND	:HWND);
  begin
    FOwnerHWnd	:= aOwnerHWND;
  end;

{w}EXԂł邩}
function TCustomToolTipStyle.GetMouseState(aTrayIconMouseState: TTrayIconMouseState): Boolean;
  begin
    Result := aTrayIconMouseState in FMouseStates;
  end;

{ҋ@̃}EX{^}
function TCustomToolTipStyle.GetWaitClickButton: TTrayIconMouseState;
  begin
    if 	    timsLDown in FMouseStates then Result := timsLDown
    else if timsRDown in FMouseStates then Result := timsRDown
    else 				   Result := timsMDown;
  end;

{x
function TCustomToolTipStyle.GetDelayTime(aIndex: Integer): Integer;
  begin
    case aIndex of
      1	:  Result := FDelayTimeAutoPop;
      2	:  Result := FDelayTimeInitial;
      3	:  Result := FDelayTimeReshow;
      else Result := -1;
    end;
  end;
procedure TCustomToolTipStyle.SetDelayTime(aIndex: Integer; aValue: Integer);
  begin
    if aValue < -1 then aValue := -1;
    case aIndex of
      1	:  FDelayTimeAutoPop := aValue;
      2	:  FDelayTimeInitial := aValue;
      3	:  FDelayTimeReshow  := aValue;
    end;
  end;}

{F}
function TCustomToolTipStyle.GetColor(aIndex: Integer): TColor;
  begin
    case aIndex of
      1	:  Result := FBackGrdColor;
      2	:  Result := FHintFont.Color;
      else Result := clBlack;
    end;
  end;
procedure TCustomToolTipStyle.SetColor(aIndex: Integer; aColor: TColor);
  begin
    case aIndex of
      1	:  FBackGrdColor := aColor;
      2	:  FHintFont.Color := aColor;
    end;
  end;

{eLXgTCY
function TCustomToolTipStyle.GetTextSize: Integer;
  begin
    Result := FHintFont.Size;
  end;
procedure TCustomToolTipStyle.SetTextSize(aValue: Integer);
  begin
    FHintFont.Size := aValue;
  end;}

{tHg
function TCustomToolTipStyle.GetFont: TFont;
  begin
    Result := FHintFont;
  end;
procedure TCustomToolTipStyle.SetFont(aFont: TFont);
  begin
    FHintFont.Assign(aFont);
  end;}

{TipWindowő啝
function TCustomToolTipStyle.GetMaxTipWidth: Integer;
  begin
    Result := FMaxTipWidth;
  end;
procedure TCustomToolTipStyle.SetMaxTipWidth(aValue: Integer);
  begin
    if aValue < -1 then aValue := -1;
    FMaxTipWidth := aValue;
  end;}

{㉺E}[W
function TCustomToolTipStyle.GetMargin(aIndex: Integer): Integer;
  begin
    case aIndex of
      1	:  Result := FMargin.Top;
      2	:  Result := FMargin.Left;
      3	:  Result := FMargin.Right;
      4	:  Result := FMargin.Bottom;
      else Result := 0;
    end;
  end;
procedure TCustomToolTipStyle.SetMargin(aIndex: Integer; aValue: Integer);
  begin
    if aValue < -1 then aValue := -1;
    case aIndex of
      1	:  FMargin.Top	  := aValue;
      2	:  FMargin.Left	  := aValue;
      3	:  FMargin.Right  := aValue;
      4	:  FMargin.Bottom := aValue;
    end;
  end;}

{bZ[W}
procedure TCustomToolTipStyle.WndProc(var Message: TMessage);
  {...
  var
    phdr: PNMHdr;
  begin
    case Message.Msg of
      WM_NOTIFY:begin
        phdr := Pointer(Message.LParam);
        case phdr^.code of
          TTN_POP :if Assigned(FOnHide) then FOnHide(AMsg,phdr^);
          TTN_SHOW:if Assigned(FOnShow) then FOnShow(AMsg,phdr^);
        end;
      end;
    end;
  end;
  ...}
  begin

  end;
  
{c[`bṽnh𓾂}
{vׂẴACR͓c[`bvLĂ炵}
function TCustomToolTipStyle.GetTooltipHandle: HWND;
  var
    toolTopWnd,
    hTaskBar		:HWND;
    pidTaskBar,
    pidToolTopWnd	:DWORD;
  begin
    {TaskBar Handle ̎擾}
    hTaskBar := FindWindowEx(0, 0, 'Shell_TrayWnd', nil);
    {TaskBar  Process ID 擾}
    GetWindowThreadProcessId(hTaskBar, @pidTaskBar);
    {Tooltip Window ̌}
    toolTopWnd := FindWindowEx(0, 0, TOOLTIPS_CLASS, nil);

    while toolTopWnd <> 0 do begin
      {Tooltip  Process ID 擾}
      GetWindowThreadProcessId(toolTopWnd, @pidToolTopWnd);
      {^XNo[ƃc[`bv Process ID rāAvĂ^XNo[̃c[`bvƂ}
      if pidTaskBar = pidToolTopWnd then begin
	{c[`bṽEChEX^C𒲍}
	if (GetWindowLong(toolTopWnd, GWL_STYLE) and TTS_NOPREFIX) = 0 then begin
	  Break;
	end;
      end;
      {ēx Tooltip Window ̌}
      toolTopWnd := FindWindowEx(0, toolTopWnd, TOOLTIPS_CLASS, nil);
    end;
    {}
    Result := toolTopWnd;
  end;

{}EXCxg}
procedure TCustomToolTipStyle.OnMouseEnter;
  var
    cursorPos	:TPoint;
  begin
    {}EXJ[\̈ʒu擾}
    GetCursorPos(cursorPos);
    {͈͍XV}
    UpdateRect(FIconRect, cursorPos);
    {2003.05.17...^XNo[̈ʒuύXɂȂƂp}
    if (Abs(FIconRect.Right - FIconRect.Left) > TASKTRAY_ICONSIZE) or
       (Abs(FIconRect.Bottom - FIconRect.Top) > TASKTRAY_ICONSIZE) then begin
      {ACR̈悪ACRTCY𒴂Ă܂ƂA^XNo[ړ肵ȁH}
      {̈斳}
      DisableTrayIconRect;
      {ēx͈͍XV}
      UpdateRect(FIconRect, cursorPos);
    end;
    {}EXINCxg}
    if not MouseEnter then DoMouseEnter;
  end;

procedure TCustomToolTipStyle.OnMouseExit;
  var
    cursorPos	:TPoint;
  begin
    if MouseEnter then begin
      {}EXJ[\̈ʒu擾}
      GetCursorPos(cursorPos);
      {ACR̈ɂ邩}
      if not IsInnerRect(FIconRect, cursorPos) then DoMouseExit;
    end;
  end;

const
  TIMER_ID	= 7;

{}EXNbN}
procedure TCustomToolTipStyle.OnMouseClick(aMouseButton: TTrayIconMouseState);
  begin
    if FRequestSglDbl then begin
      if (not FWaitClick) and
         (SetTimer(FOwnerHWnd, TIMER_ID, GetDoubleClickTime, @TaskTrayProc) <> 0) then begin
        FWaitClick := True;
      end;
    end
    else begin
      DoMouseClick(aMouseButton);
      Exclude(FMouseStates, aMouseButton);
    end;
  end;

{^XNgCACR̃bZ[W}
procedure TCustomToolTipStyle.TrayIconWndProc(var Message: TMessage);
  begin
    if Message.Msg = WM_TaskTrayMessage then begin
      case Message.lParam of
        {}EXC}
        WM_MOUSEMOVE	:OnMouseEnter;
        {NbNҋ@}
        WM_LBUTTONDOWN	:if Message.WParam >= 0 then Include(FMouseStates, timsLDown);
        WM_RBUTTONDOWN	:if Message.WParam >= 0 then Include(FMouseStates, timsRDown);
        WM_MBUTTONDOWN	:if Message.WParam >= 0 then Include(FMouseStates, timsMDown);
        {NbN}
        WM_LBUTTONUP	:OnMouseClick(timsLDown);
        WM_RBUTTONUP	:OnMouseClick(timsRDown);
        WM_MBUTTONUP	:OnMouseClick(timsMDown);
        {_uNbN}
        WM_LBUTTONDBLCLK:DoMouseDblClick(timsLDown);
        WM_RBUTTONDBLCLK:DoMouseDblClick(timsRDown);
        WM_MBUTTONDBLCLK:DoMouseDblClick(timsMDown);
      end;
    end
    else if Message.Msg = WM_TIMER then begin
      KillTimer(FOwnerHWnd, TIMER_ID);
      if FWaitClick then DoMouseClick(GetWaitClickButton);
    end;
  end;

{gCACR͈͂𖳌}
procedure TCustomToolTipStyle.DisableTrayIconRect;
  begin
    DisableRect(FIconRect);
  end;

{f[^̕}
procedure TCustomToolTipStyle.Assign(aSource: TPersistent);
  begin
    inherited Assign(aSource);
    if aSource is TCustomToolTipStyle then begin
      FUseDefault	:= TCustomToolTipStyle(aSource).FUseDefault;	{True:ftHg̃qg\s}
      FBackGrdColor	:= TCustomToolTipStyle(aSource).FBackGrdColor;
    end;
  end;

procedure TCustomToolTipStyle.DoMouseEnter;
  begin
    {tOI}
    Include(FMouseStates, timsEnter);
    {c[`bvwvύX}
    if not FUseDefault then SetCustomToolTip;
    {NGCg}
    if FThread = nil then FThread := TMouseEventMaker.Create(Self);
    {XbhJn}
    if FThread.Suspended then FThread.Resume;
    {I[i[ɒʒm}
    if FOwnerHWnd <> 0 then
      SendMessage(FOwnerHWnd, WM_TaskTrayMessage, 0, WM_MOUSE_ENTER);
  end;

procedure TCustomToolTipStyle.DoMouseExit;
  begin
    {tOIt}
    Exclude(FMouseStates, timsEnter);
    {c[`bvwv߂}
    if not FUseDefault then SetDefaultToolTip;
    {^XNgCACR͈͉
    DisableTrayIconRect;}
    {I[i[ɒʒm}
    if FOwnerHWnd <> 0 then
      SendMessage(FOwnerHWnd, WM_TaskTrayMessage, 0, WM_MOUSE_EXIT);
  end;

{}EXNbN}
procedure TCustomToolTipStyle.DoMouseClick(aMouseButton: TTrayIconMouseState);
  begin
    if (aMouseButton in FMouseStates) and (FOwnerHWnd <> 0) then begin
      SendMessage(FOwnerHWnd, WM_TaskTrayMessage, Ord(aMouseButton), WM_MOUSE_CLICK);
    end;
    {tOIt}
    FWaitClick := False;
    Exclude(FMouseStates, aMouseButton);
  end;

{}EX_uNbN}
procedure TCustomToolTipStyle.DoMouseDblClick(aMouseButton: TTrayIconMouseState);
  begin
    {tOIt}
    FWaitClick := False;
    Exclude(FMouseStates, aMouseButton);
    {}EX_Exgs}
    case aMouseButton of
      timsLDown:
        PostMessage(FOwnerHWnd, WM_TaskTrayMessage, -1, WM_LBUTTONDOWN);
      timsRDown:
        PostMessage(FOwnerHWnd, WM_TaskTrayMessage, -1, WM_RBUTTONDOWN);
      timsMDown:
        PostMessage(FOwnerHWnd, WM_TaskTrayMessage, -1, WM_MBUTTONDOWN);
    end;
  end;

{c[`bvύX}
procedure TCustomToolTipStyle.SetCustomToolTip;
  begin
    if FHTooltip = 0 then Exit;
    {tHgݒ
    SendMessage(FHTooltip, WM_SETFONT, FHintFont.Handle, 1);}
    {x
    SendMessage(FHTooltip, TTM_SETDELAYTIME, TTDT_AUTOPOP, FDelayTimeAutoPop);
    SendMessage(FHTooltip, TTM_SETDELAYTIME, TTDT_INITIAL, FDelayTimeInitial);
    SendMessage(FHTooltip, TTM_SETDELAYTIME, TTDT_RESHOW , FDelayTimeReshow);}
    {wiF}
    SendMessage(FHTooltip, TTM_SETTIPBKCOLOR, FBackGrdColor, 0);
    {eLXgF}
    SendMessage(FHTooltip, TTM_SETTIPTEXTCOLOR, FHintFont.Color, 0);
    {ő啝
    SendMessage(FHTooltip, TTM_SETMAXTIPWIDTH, 0, FMaxTipWidth);}
    {㉺E}[W  
    SendMessage(FHTooltip, TTM_SETMARGIN, 0, LParam(@(FMargin)));}
  end;

procedure TCustomToolTipStyle.SetDefaultToolTip;
  begin
    if FHTooltip = 0 then Exit;
    {}
    SendMessage(FHTooltip, TTM_POP, 0, 0);
    {<< ftHgݒɖ߂ >>}
    {tHg̐ݒ
    SendMessage(FHTooltip, WM_SETFONT, 0, 1);}
    {x
    SendMessage(FHTooltip, TTM_SETDELAYTIME, TTDT_AUTOMATIC, 0);}
    {wiF}
    SendMessage(FHTooltip, TTM_SETTIPBKCOLOR, GetSysColor(COLOR_INFOBK), 0);
    {eLXgF}
    SendMessage(FHTooltip, TTM_SETTIPTEXTCOLOR, GetSysColor(COLOR_INFOTEXT), 0);
    {ő啝
    SendMessage(FHTooltip, TTM_SETMAXTIPWIDTH, 0, -1);}
    {㉺E}[W
    FillChar(tipRect, SizeOf(TRect), #$0);
    SendMessage(FHTooltip, TTM_SETMARGIN, 0, LParam(@(tipRect)));}
  end;
{$ENDIF}

{************************************************************************}
{* 	e`							*}
{************************************************************************}
type
  {ENotifyIconErrorO̒`}
  ENotifyIconError = class(Exception);

{************************************************************************}
{* 	^XNgCACR\pNX				*}
{************************************************************************}
constructor TTaskTrayIcon.Create;
  begin
    inherited Create;
    {o^}
    AddTrayIconWinProcList(Self);
    {NGCg}
    {$IFNDEF NO_USE_CUSTOM_TOOLTIP}
    FToolTipStyle := TToolTipStyle.Create;
    {$ENDIF}
    {Shell32.dll̃o[W`FbN
    FShellNew := GetShellDllVersion >= MakeLong(0, 5);}
    FShell32Ver := GetShellDllVersion;

    {\̏}
    FillChar(FIconData, SizeOf(TNewNotifyIconData), #0);
    {vpeB}
    FUpdateCount	:= 0;
    FTrayHandle		:= 0;
    {FOnTaskTray	:= False;}
    FOnTrayIconFlag	:= [];
    FEnabledHide	:= True;
    FOnMessage		:= nil;
    FrontToWindow	:= False;
  end;

destructor TTaskTrayIcon.Destroy;
  begin
    {j}
    {$IFNDEF NO_USE_CUSTOM_TOOLTIP}
    if FToolTipStyle <> nil then FToolTipStyle.Free;
    {$ENDIF}
    {gCACR폜}
    DeleteTrayIcon;
    if FTrayHandle <> 0 then DestroyWindow(FTrayHandle);
    {}
    DelTrayIconWinProcList(Self);
    inherited Destroy;
  end;

{vpeB}
procedure TTaskTrayIcon.Assign(aDest	:TTaskTrayIcon);

  begin
    FIconData := aDest.FIconData;
    ModifyIcon;
  end;

{^XNgCpWindowProcedure}
procedure TTaskTrayIcon.TrayWndProc(var Message: TMessage);
  begin
    if (Message.Msg = TrayIconWinProcList.uTaskbarRestart) then begin
      {^XNgCACRւ̍ĕ\}
      if IconRegisted then begin
        if OnTaskTray then begin
          {xo^ԂɍXVAēo^s}
	  IconRegisted := False;
	  SetTrayIcon;
        end
        else begin
          {o^ԂɍXV}
          IconRegisted := False;
        end;
      end;
      {^XNo[ċNbZ[W̔s}
      Message.Msg := WM_TASKBER_RESTART;
      FOnMessage(Message);
      Message.Msg := TrayIconWinProcList.uTaskbarRestart;
    end;
    {c[`bvύXNXւ̒ʒm}
    {$IFNDEF NO_USE_CUSTOM_TOOLTIP}
    FToolTipStyle.TrayIconWndProc(Message);
    {$ENDIF}
    {W}
    if Assigned(FOnMessage) then begin
      FOnMessage(Message);
    end
    else begin
      with Message do
	Result := DefWindowProc(TrayHandle, Msg, WParam, LParam);
    end;
  end;

{^XNgCo^pnh̎擾}
function TTaskTrayIcon.GetTrayHandle:HWnd;
  begin
    if FTrayHandle = 0 then begin
      {EChE쐬}
      FTrayHandle := CreateWindowEx(WS_EX_TOOLWINDOW, TRAY_ICON_WINDOW_CLASS_NAME,
				    '', WS_POPUP, 0, 0, 0, 0, 0, 0, hInstance, nil);
      {c[`bvNX̍쐬}
      {$IFNDEF NO_USE_CUSTOM_TOOLTIP}
      FToolTipStyle.SetOwner(FTrayHandle);
      {$ENDIF}
    end;
    Result := FTrayHandle;
  end;

{}EXACRɓ̏}
procedure TTaskTrayIcon.DoMouseEnter;
  begin
    {Mouse Enter Event}
    if FTrayHandle <> 0 then begin
      SendMessage(FTrayHandle, WM_TaskTrayMessage, 0, WM_MOUSE_ENTER);
    end;
  end;

{}EXACROɏȍ}
procedure TTaskTrayIcon.DoMouseExit;
  begin
    {Mouse Exit Event}
    if FTrayHandle <> 0 then begin
      SendMessage(FTrayHandle, WM_TaskTrayMessage, 0, WM_MOUSE_EXIT);
    end;
  end;

{^XNgCɃACRo^Ă邩}
function TTaskTrayIcon.GetIconRegisted: Boolean;
  begin
    Result := otifRegisted in FOnTrayIconFlag;
  end;
procedure TTaskTrayIcon.SetIconRegisted(aValue: Boolean);
  begin
    {IȃtȌ݂̂̂ߌ݂̒lƂ̔rȂ}
    //if GetIconRegisted <> aValue then begin
    if aValue then begin
      Include(FOnTrayIconFlag, otifRegisted);	{o^}
      Include(FOnTrayIconFlag, otifShowing);	{\}
    end
    else begin
      Exclude(FOnTrayIconFlag, otifRegisted);	{o^}
      Exclude(FOnTrayIconFlag, otifShowing);	{\}
    end;
  end;
{^XNgCɃACR\Ă邩}
function TTaskTrayIcon.GetOnTaskTray: Boolean;
  begin
    Result := otifShowing in FOnTrayIconFlag;
  end;
procedure TTaskTrayIcon.SetOnTaskTray(aValue: Boolean);
  begin
    if aValue then begin
      Include(FOnTrayIconFlag, otifShowing);
    end
    else begin
      Exclude(FOnTrayIconFlag, otifShowing);
    end;
  end;

{gCɓo^ACR̃nh𓾂}
function TTaskTrayIcon.GetIconHandle:HICON;
  begin
    Result := FIconData.hIcon;
  end;
procedure TTaskTrayIcon.SetIconHandle(aIconHandle	:HICON);
  begin
    FIconData.hIcon := aIconHandle;
  end;

{gCŕ\eLXg}
function TTaskTrayIcon.GetTipHelp:String;
  begin
    Result := FIconData.szTip;
  end;

procedure TTaskTrayIcon.SetTipHelp(aTipHelp	:String);
  begin
    if aTipHelp = '' then begin
      FIconData.szTip[0] := #0;
    end
    else begin
      {s܂ޏꍇXy[XŒu}
      if not GetShellNewVersion then
        StringReplace(aTipHelp, #$D#$A, ' ', [rfReplaceAll]);
      {`bvwv̍XV}
      if ShellNewVersion then StrPLCopy(PChar(@FIconData.szTip), PChar(aTipHelp), 127)
      else                    StrPLCopy(PChar(@FIconData.szTip), PChar(aTipHelp),  63);
    end;
  end;

{Shell32.dll̃o[W 5.0ȍ~}
function TTaskTrayIcon.GetShellNewVersion: Boolean;
  begin
    Result := FShell32Ver >= MakeLong(0, 5);
  end;

{o[wṽ^Cg}
function TTaskTrayIcon.GetBalloonHelpTitle:String;
  begin
    Result := FIconData.szInfoTitle;
  end;
procedure TTaskTrayIcon.SetBalloonHelpTitle(aHelpTitle	:String);
  begin
    if aHelpTitle = '' then begin
      FIconData.szInfoTitle[0] := #0;
    end
    else begin
      StrPLCopy(PChar(@FIconData.szInfoTitle), PChar(aHelpTitle), 63);
    end;
  end;

{o[wṽeLXg}
function TTaskTrayIcon.GetBalloonHelp:String;
  begin
    Result := FIconData.szInfo;
  end;

procedure TTaskTrayIcon.SetBalloonHelp(aHelpText	:String);
  begin
    if aHelpText = '' then begin
      FIconData.szInfo[0] := #0;
    end
    else begin
      StrPLCopy(PChar(@FIconData.szInfo), PChar(aHelpText), 255);
    end;
  end;

{gCŕ\̃^CAEg}
function TTaskTrayIcon.GetUTimeOut:Integer;
  begin
    Result := FIconData.uTimeout;
  end;

procedure TTaskTrayIcon.SetUTimeOut(aValue	:Integer);
  begin
    FIconData.uTimeout := aValue;
  end;

{o[wvŕ\ACR̎}
function TTaskTrayIcon.GetBalloonIconType:TBalloonIconType;
  begin
    Result := TBalloonIconType(FIconData.dwInfoFlags);
  end;
procedure TTaskTrayIcon.SetBalloonIconType(aValue	:TBalloonIconType);
  begin
    case aValue of
      bitInfo   :FIconData.dwInfoFlags := NIIF_INFO;
      bitWarning:FIconData.dwInfoFlags := NIIF_WARNING;
      bitError  :FIconData.dwInfoFlags := NIIF_ERROR;
      else       FIconData.dwInfoFlags := NIIF_NONE;
    end;
  end;

{̍XVJn}
procedure TTaskTrayIcon.BeginUpdate;
  begin
    Inc(FUpdateCount);
  end;
{̍XVI}
procedure TTaskTrayIcon.EndUpdate;
  begin
    if FUpdateCount > 0 then Dec(FUpdateCount);
  end;
{̍XV}
procedure TTaskTrayIcon.FinishUpdate;
  begin
    FUpdateCount := 0;
  end;

{XV}
function TTaskTrayIcon.Updating: Boolean;	{True:XV}
  begin
    Result := FUpdateCount > 0;
  end;

{gCɃACRo^}
function TTaskTrayIcon.SetTrayIcon:Boolean;
  {o^G[̃gC}
  procedure retrySet(var aRetryCount	:Integer);
    begin
      if GetLastError = ERROR_TIMEOUT then begin
        {2bҋ@}
	Sleep(2000);
	IconRegisted := True;
	if Shell_NotifyIcon(NIM_MODIFY, PNotifyIconDataA(@FIconData)) then begin
        {ŏ̓o^ɐĂ̂Ƃ}
	  IconRegisted := True;
	  {$IFNDEF NO_USE_CUSTOM_TOOLTIP}
	  {^XNgC̃ACR͈͂𖳌}
	  ToolTipStyle.DisableTrayIconRect;
	  {$ENDIF}
	end
        else begin
	{ēx`W}
	  IconRegisted := False;
          if FrontToWindow then SetForegroundWindow(FTrayHandle);
	  if Shell_NotifyIcon(NIM_ADD, PNotifyIconDataA(@FIconData)) then begin
	    IconRegisted := True;
	    {$IFNDEF NO_USE_CUSTOM_TOOLTIP}
	    {^XNgC̃ACR͈͂𖳌}
	    ToolTipStyle.DisableTrayIconRect;
	    {$ENDIF}
	  end
	  else if aRetryCount = 0 then begin
            raise ENotifyIconError.Create(NotifyIconModErrMessage);
          end
          else begin
            Dec(aRetryCount);
          end;
        end;
      end
      else begin
      {TimeOutȊÕG[}
        raise ENotifyIconError.Create(NotifyIconErrMessage);
      end;
    end;
  (*...
  {Vo[W}
  procedure setNewVersionMessage;
    var
      msgInfo	:TNewNotifyIconData;
    begin
      {FillChar(msgInfo, SizeOf(TNewNotifyIconData), #1);}
      msgInfo.uTimeout := NOTIFYICON_VERSION;
      if Shell_NotifyIcon(NIM_SETVERSION, @msgInfo) then begin
        {Windows XP ȍ~̂݁H}
        MessageBox(TrayHandle, 'xxx', 'OK', 0);
      end;
    end;
  ...*)
  var
    retryCount	:Integer;
  begin
    if not OnTaskTray then begin
    {ACRo^ or \}
      with FIconData do begin
	if ShellNewVersion then begin
	{Shell32.dll ̃o[W 5 ȍ~}
	  cbSize := SizeOf(TNewNotifyIconData);
	  dwState := NIS_SHAREDICON;
	  dwStateMask := 0;
	  dwInfoFlags := 0;
	end
	else begin
	{Shell32.dll ̃o[W 5 ȑO}
	  cbSize := SizeOf(TNotifyIconData);
	end;
	uID := 1;
	Wnd := TrayHandle;
	uCallbackMessage := WM_TaskTrayMessage;
        uFlags := NIF_MESSAGE or NIF_ICON or NIF_TIP;
      end;
      {Vo[Wpɐݒ
      if ShellNewVersion then setNewVersionMessage;}
      {gCɃACRo^}
      Result := FIconData.hIcon > 0;
      if Result then begin
        if FrontToWindow then SetForegroundWindow(FTrayHandle);
        if IconRegisted then begin
        {ACR͓o^ς}
        {^XNgC̃ACR̔\}
	  FIconData.dwState := 0;
	  FIconData.uFlags := FIconData.uFlags or NIF_STATE;
	  FIconData.dwStateMask := NIS_HIDDEN or NIS_SHAREDICON;
	  if Shell_NotifyIcon(NIM_MODIFY, PNotifyIconDataA(@FIconData)) then begin
            OnTaskTray := True;
          end;
        end
        else begin
        {^XNgCւ̓o^}
          if Shell_NotifyIcon(NIM_ADD, PNotifyIconDataA(@FIconData)) then begin
            IconRegisted := True;
	    OnTaskTray := True;
            {$IFNDEF NO_USE_CUSTOM_TOOLTIP}
            {^XNgC̃ACR͈͂𖳌}
            ToolTipStyle.DisableTrayIconRect;
            {$ENDIF}
          end
          else begin
            {gC}
            retryCount := 5;
            while (not OnTaskTray) and (retryCount >= 0) do retrySet(retryCount);
          end;
        end;
      end;
    end;
    Result := OnTaskTray;
  end;

{gCACR}
function TTaskTrayIcon.HideTrayIcon:Boolean;
  begin
    if ShellNewVersion and FEnabledHide then begin
      if IconRegisted and OnTaskTray then begin
	{ACR\}
	FIconData.uFlags := NIF_STATE;
	FIconData.dwState := NIS_HIDDEN;
	FIconData.dwStateMask := NIS_HIDDEN or NIS_SHAREDICON;
	Result := Shell_NotifyIcon(NIM_MODIFY, PNotifyIconDataA(@FIconData));
	FIconData.dwState := 0;
	{tOύX}
	OnTaskTray := False;
      end
      else begin
	Result := True;
      end;
    end
    else begin
      Result := DeleteTrayIcon;
    end;
  end;
function TTaskTrayIcon.DeleteTrayIcon:Boolean;
  begin
    if IconRegisted then begin
      {ACRo^}
      Result := Shell_NotifyIcon(NIM_DELETE, PNotifyIconDataA(@FIconData));
      {tOύX}
      IconRegisted := False;
    end
    else begin
      Result := True;
    end;
  end;

{gCACR̕ύX}
function TTaskTrayIcon.ModifyIcon:Boolean;
  begin
    Result := False;
    if Updating then Exit;
    
    if OnTaskTray then begin
      {łɕ\ς}
      if FIconData.hIcon > 0 then begin
      {ACRnh擾ł}
        if FrontToWindow then SetForegroundWindow(FTrayHandle);
	{\XV}
	if IconRegisted and not OnTaskTray then begin
	  FIconData.uFlags := NIF_STATE;
	  FIconData.dwStateMask := NIS_HIDDEN or NIS_SHAREDICON;
	end;
	if not Shell_NotifyIcon(NIM_MODIFY, PNotifyIconDataA(@FIconData)) then begin
          {raise ENotifyIconError.Create(NotifyIconModErrMessage);}
          {XVɎsƂgCACRĂ܂Ăꍇz肵
           ǉsBÓASetTrayIcon \bhŔ̂
           RgĂ...2002.09.18}
      	  if GetLastError <> ERROR_TIMEOUT then begin
          {^CAEg̃G[ȊO̓gCɃACRȂ̂Ɣ}
            try
              {tO}
	      IconRegisted := False;
              {VKɓo^}
              SetTrayIcon;
            except
            end;
          end;
        end;
	{^[}
	Result := OnTaskTray;
      end;
    end
    else begin
      {ACR̐VKo^}
      Result := SetTrayIcon;
    end;
  end;

{o[wv\}
function TTaskTrayIcon.ShowBalloonHelpSE(aHelpTitle,			{^Cg}
                          	         aHelpText	:String;	{bZ[W}
                          	         aTimeOut	:Integer;	{^CAEg(~b)}
                                         aIconType	:TBalloonIconType)
                                       			:Boolean;	{True:}
  begin
    if ShellNewVersion then begin
      SetBalloonHelpTitle(aHelpTitle);
      SetBalloonHelp(aHelpText);
      SetUTimeOut(aTimeOut);
      SetBalloonIconType(aIconType);

      HideBalloonHelp;
      Result := ShowBalloonHelp;
    end
    else begin
      Result := False;
    end;
  end;

function TTaskTrayIcon.ShowBalloonHelp: Boolean;	{True:}
  begin
    if ShellNewVersion and OnTaskTray then begin
      {tOύX}
      FIconData.uFlags := NIF_INFO;
      try
        {\}
        {HideBalloonHelp;}
        Result := ModifyIcon;
      finally
        {tO}
        FIconData.uFlags := NIF_MESSAGE or NIF_ICON or NIF_TIP;
      end;
    end
    else begin
      Result := False;
    end;
  end;

{o[wv}
function TTaskTrayIcon.HideBalloonHelp: Boolean;	{True:}
  var
    tempInfo	:String;
  begin
    if ShellNewVersion and OnTaskTray then begin
      {tOύX}
      FIconData.uFlags := NIF_INFO;
      try
	tempInfo := GetBalloonHelp;
	SetBalloonHelp('');
	{\XV}
	Result := ModifyIcon;
	{eLXg}
	SetBalloonHelp(tempInfo);
      finally
	{tO}
	FIconData.uFlags := NIF_MESSAGE or NIF_ICON or NIF_TIP;
      end;
    end
    else begin
      Result := False;
    end;
  end;

{ACRɃJ[\邩}
{$IFNDEF NO_USE_CUSTOM_TOOLTIP}
function TTaskTrayIcon.IsCursorInnerRect(aX, aY: Integer): Boolean;
  begin
    Result := OnTaskTray;
    if Result then begin
      Result := IsInnerRect(FToolTipStyle.FIconRect, Point(aX, aY));
    end;
  end;
{$ENDIF}

{************************************************************************}
{*	TaskTrayIconClasspMessageHandler				*}
{************************************************************************}
{NGCg}
constructor TTrayIconWinProcList.Create;
  begin
    inherited Create;
    {WindowNX̓o^}
    RegisterClass;
    {GNXv[̍ċNŃ^XNgC̃ACRĕ\邽߂̂
     gbvx̃EChEɃu[hLXgB
     IE4.0ȍ~Ȃʒm̂낤H WinNT IE3.02 Opera6.03 
     uTaskbarRestart <> 0 ɂȂ܂}
    uTaskbarRestart := RegisterWindowMessage('TaskbarCreated');
  end;

{j}
destructor TTrayIconWinProcList.Destroy;
  begin
    {WindowNX̉}
    UnRegisterClass;
    inherited Destroy;
  end;

{NXWindowsɓo^}
procedure TTrayIconWinProcList.RegisterClass;
  var
    wndClass	:TWndClass;
  begin
    {EChENXo^}
    wndClass.style := 0{CS_HREDRAW or CS_VREDRAW};
    wndClass.lpfnWndProc := @TaskTrayProc;
    wndClass.cbClsExtra := 0;
    wndClass.cbWndExtra := 0;
    wndClass.hInstance := hInstance;
    wndClass.hIcon := LoadIcon(hInstance, 'MAINICON');
    wndClass.hCursor := LoadCursor(0, idc_Arrow);
    wndClass.hbrBackground := Color_Window + 1;
    wndClass.lpszMenuName := nil{MAKEINTRESOURCE(1)};
    wndClass.lpszClassName := TRAY_ICON_WINDOW_CLASS_NAME;
    {o^}
    Windows.RegisterClass(wndClass);
  end;

{NXWindows폜}
procedure TTrayIconWinProcList.UnRegisterClass;
  begin
    {NXo^̉}
    Windows.UnRegisterClass(TRAY_ICON_WINDOW_CLASS_NAME, hInstance);
  end;

{bZ[W}
function TTrayIconWinProcList.MessageDeliver(aHWND		:HWND;
                                             var Message	:TMessage)
                          					:Boolean;	{True:}
  var
    idx	:Integer;
  begin
    for idx := 0 to Count - 1 do begin
      if (TObject(Items[idx]) is TTaskTrayIcon) and
         (TTaskTrayIcon(Items[idx]).FTrayHandle = aHWND) then begin
        {bZ[WM}
        TTaskTrayIcon(Items[idx]).TrayWndProc(Message);
        {}
        Result := True;
        Exit;
      end;
    end;
    Result := False;
  end;

{NXǉ}
procedure TTrayIconWinProcList.AddClass(aTaskTrayIcon	:TTaskTrayIcon);
  begin
    {o^}
    TrayIconWinProcList.Add(aTaskTrayIcon);
  end;

{NX폜}
procedure TTrayIconWinProcList.DeleteClass(aTaskTrayIcon	:TTaskTrayIcon);
  var
    dataIdx	:Integer;
  begin
    {o^ς݂̃CX^X̃CfbNX𓾂}
    dataIdx := IndexOf(aTaskTrayIcon);
    {ȂƂ̓XLbv}
    if dataIdx < -1 then Exit;
    {CfbNXŃXg폜}
    Delete(dataIdx);
  end;

{************************************************************************}
{* 	֐`							*}
{************************************************************************}
{t@C̃vpeBo[W𓾂}
function GetFileVersion: Integer;
  const
    coTRANSLATION	= '\\VarFileInfo\\Translation';
    coSTR_FILE_INFO	= '\\StringFileInfo\\';
  var
    fileVarsionInfoSize	:Integer;
    dummy		:DWORD;
    versionInfoSize	:DWORD;
    pFileVarsionInfo,
    translation,
    infoPointer		:Pointer;
    filenmae, varValue	:String;
    major, minor	:WORD;
  begin
    Result := 0;
    
    {VXetH_𓾂}
    GetMem(infoPointer, MAX_PATH);
    GetSystemDirectory(infoPointer, MAX_PATH);
    filenmae := PChar(infoPointer) + '\' + shell32;
    FreeMem(infoPointer);
    infoPointer := nil;

    {o[WTCY𓾂}
    fileVarsionInfoSize := GetFileVersionInfoSize(PChar(filenmae), dummy);

    if fileVarsionInfoSize > 0 then begin
      {o[Wpm}
      GetMem(pFileVarsionInfo, fileVarsionInfoSize);

      try
        {o[W񃊃\[X擾}
        GetFileVersionInfo(PChar(filenmae), 0, fileVarsionInfoSize, pFileVarsionInfo);

        {ϊe[uւ̃|C^擾}
        VerQueryValue(pFileVarsionInfo, coTRANSLATION, translation, versionInfoSize);

        {o[WNGXg}
        varValue := coSTR_FILE_INFO +
                    IntToHex(LoWord(LongInt(translation^)), 4) +
                    IntToHex(HiWord(LongInt(translation^)), 4) + '\\';

        {t@Co[W}
        if VerQueryValue(pFileVarsionInfo, PChar(varValue + 'FileVersion'),
                         infoPointer, versionInfoSize) then begin
          varValue := String(PChar(infoPointer));
          try
            {o[W9.xx܂ł͑vi΁j}
            major := StrToInt(varValue[1]);
            minor := StrToInt(Copy(varValue, 3, 2));
            Result := MakeLong(minor, major);
          except
            {Ô}
          end;
        end;
      finally
        FreeMem(pFileVarsionInfo, fileVarsionInfoSize);
      end;{try...}

    end;
  end;

{Shell32.dll̃o[W𓾂}
function GetShellDllVersion:Longint;
  var
    hinstDll		:HMODULE;
    dllVersionInfo	:TDllVersionInfo;
    dllGetVerProc	:function (var aDllVersionInfo	:TDllVersionInfo)
							:HRESULT; stdcall;
    hHRESULT		:HRESULT;
  begin
    Result := GetFileVersion;
    {hinstDll := LoadLibrary(Shell32);}
    hinstDll := SafeLoadLibrary(Shell32);	{2002.09.03ύX}

    if hinstDll < 32 then begin
      {G[}
    end
    else begin
      try
	{o[WԂ֐̃[h}
	@dllGetVerProc := GetProcAddress(hinstDll, 'DllGetVersion');

	if Assigned(dllGetVerProc) then begin
	{o[W5ȍ~Ȃ瑶݂}
	  {}
	  FillChar(dllVersionInfo, SizeOf(TDllVersionInfo), #0);
	  dllVersionInfo.cbSize := SizeOf(TDllVersionInfo);
	  {o[W擾}
	  hHRESULT := dllGetVerProc(dllVersionInfo);
	  if SUCCEEDED(hHRESULT) then begin
	    {Result := MakeLong(dllVersionInfo.dwMajorVersion,
			       dllVersionInfo.dwMinorVersion);}
	    Result := MakeLong(dllVersionInfo.dwMinorVersion,
			       dllVersionInfo.dwMajorVersion);
	  end;
	end
        else begin
        {t@C̃vpeBo[W𓾂}
          Result := GetFileVersion;
        end;
      finally
	{}
	FreeLibrary(hinstDll);
      end;
    end;
  end;

{/////////////////////////////////////////////////////////////////////////////}
initialization
{/////////////////////////////////////////////////////////////////////////////}
  TrayIconWinProcList	:= nil;
  {$IFNDEF NO_USE_CUSTOM_TOOLTIP}
  {ToolTipClass		:= nil;}
  {$ENDIF}

end.
