// tH_[_CAO
// http://forum.nifty.com/fdelphi/samples/01038.html

unit untBrowseFolder;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
Dialogs;

type
  TBrowseFolder = class(TComponent)
  private
    { Private 錾 }
    FDir, FTitle,FIniDir: String;
  protected
    { Protected 錾 }
  public
    { Public 錾 }
    Constructor Create(AOwner: TComponent); override;
    Function Execute: Boolean;
    Property DirName: String Read FDir;
  published
    { Published 錾 }
    Property Title: String Read FTitle Write FTitle;
    Property IniDir: String Read FIniDir Write FIniDir;
  end;

procedure Register;

implementation

Uses ShlObj;

Var BF1 :TBrowseFolder; // tB[hQƗp̕ϐ

procedure Register;
begin
  RegisterComponents('Dialogs', [TBrowseFolder]);
end;

Constructor TBrowseFolder.Create(AOwner: TComponent);
begin
  inherited create(AOwner);
  BF1:= Self; // ꂪ݂I
end;

function BrowseCallbackProc(hwnd: HWND; uMsg: UINT; lParam, lpData:
                                        LPARAM): Integer; stdcall;
 {SHBrowseForFolder ̃R[obN֐}
var
  Path : PChar;
begin
  Result:= 0;
  Path := Pchar(BF1.FIniDir);
  if ((uMsg=BFFM_INITIALIZED) and (Path <> nil)) then
    SendMessage(hwnd, BFFM_SETSELECTION, 1,LongInt(Path));
end;

Function TBrowseFolder.Execute;
{́A点̍X؂̂}
var
  BI: TBrowseInfo;
  IDList: PItemIDList;
  Dir: Array [0..Max_Path] Of Char;
begin
  FDir := '';
  Result := False;
  FillChar(BI, SizeOf(BI), 0);
  BI.hwndOwner := TWinControl(Owner).Handle;
  BI.lpfn := TFNBFFCallBack(@BrowseCallbackProc); //R[obN֐̃AhX
  BI.lpszTitle := PChar(FTitle);
  BI.pidlRoot := nil;
  BI.ulFlags := BIF_RETURNONLYFSDIRS + BIF_STATUSTEXT;
  IDList := SHBrowseForFolder(BI);
  If IDList <> nil Then
  Begin
    SHGetPathFromIDList(IDList, Dir);
    FDir := String(Dir);
    Result := True;
  End;
end;

end.
