unit untDoeSUB;

interface




uses
  SysUtils, 
  StrUtils, 
  Classes, 
  Types,
  Forms, 
  Controls, 
  HogeTextView, 
  StrSub,
  untGlobal;














const
  ATTRIB_BOLD = 1;
  ATTRIB_LINK = 2;

  ATTRIB_ANCHOR_NAME = 0;
  ATTRIB_ANCHOR_HREF = 1;

  DD_OFFSET_LEFT = 32;
  LI_OFFSET_LEFT = 16;

type
  (*-------------------------------------------------------*)
  THogeMemoryStream = class(TMemoryStream)
  public
    procedure WriteString(const str: string);
    procedure WriteChar(c: Char);
    function ReadString: string;
    property Memory;
  end;
















































  (*-------------------------------------------------------*)
  TDatItemType = (ditNORMAL, ditNAME, ditDATE, ditMAIL, ditMSG);
  (*-------------------------------------------------------*)
  TDatOut = class(TObject)


  public
    constructor Create;
    destructor Destroy; override;
    procedure WriteHTML(str: PChar; size: integer); overload; virtual;
    procedure WriteHTML(str: String); overload; virtual;
    procedure WriteText(str: PChar; size: integer); overload; virtual; abstract;
    procedure WriteText(str: String); overload; virtual;
    procedure WriteChar(c: Char); virtual;
    procedure WriteItem(str: PChar; size: integer;
                        itemType: TDatItemType); virtual; abstract;
    procedure WriteAnchor(const Name: string;
                          const HRef: string;
                          str: PChar; size: integer); virtual; abstract;


    procedure Flush; virtual;

  end;
  (*-------------------------------------------------------*)
  TConvDatOut = class(TDatOut)







  protected
    str: PChar;
    index: integer;
    size: integer;

    procedure EndOfTag;
    function GetTagName: string;
    function GetAttribPair(var name, value: string): Boolean;

    function GetRange(var ANK: string): string;
    procedure SkipSpaces;
    function GetURL: string;
    function DoRange(const prefix: string): boolean;
    function ProcRedirect: boolean; virtual;
    function ProcTag: boolean; virtual;
    function ProcURL: boolean; virtual;
    function ProcEntity: boolean; virtual;






    procedure ProcHTML; virtual;
    procedure ProcName; virtual;
  public
    procedure WriteItem(str: PChar; size: integer; itemType: TDatItemType); override;



  end;
  (*-------------------------------------------------------*)


  (*-------------------------------------------------------*)

  TDat2View = class(TConvDatOut)
  protected
    FBrowser: THogeTextView;
    re_entrant: integer;
    canceled: boolean;
    FAttribute: THogeAttribute;
    FBold: THogeAttribute;
    FStream: THogeMemoryStream;
    flushCount: integer;
    FOffsetLeft: integer;
    FBiteSpaces: boolean;
    FUser: integer;
    FHref: string;
    function ProcTag: boolean; override;
    function ProcEntity: boolean; override;
    procedure BeginAnchor; virtual;
    procedure EndAnchor; virtual;
  public
    constructor Create(browser: THogeTextView);
    destructor Destroy; override;
    procedure WriteText(str: PChar; size: integer); override;
    procedure WriteAnchor(const Name: string;
                          const HRef: string;
                          str: PChar; size: integer); override;
    procedure WriteChar(c: Char); override;
    procedure WriteUNICODE(str: PChar; size: integer);
    function WriteUnicode2(s: string): boolean;
    procedure WriteBR;
    procedure SetBold(boldP: boolean);
    procedure Flush; override;
    procedure Cancel;
  end;

  TSimpleDat2View = class(TDat2View)
  protected
    procedure ProcHTML; override;
    procedure BeginAnchor; override;
    procedure EndAnchor; override;
  public
    procedure Flush; override;
  end;

  function TVMouseProc(Sender: THogeTextView; Shift: TShiftState;
                     X, Y: Integer): string;

implementation

procedure THogeMemoryStream.WriteString(const str: string);
begin
  WriteBuffer(str[1], length(str));
end;

procedure THogeMemoryStream.WriteChar(c:Char);
begin
  WriteBuffer(c, 1);
end;

function THogeMemoryStream.ReadString: string;
var
  savePos: integer;
  count: integer;
  s: string;
begin
  count := Size;
  if count <= 0 then
  begin
    s := '';
  end
  else begin
    savePos := Position;
    Position := 0;
    SetLength(s, count);
    ReadBuffer(s[1], count);
    Position := savePos;
  end;
  result := s;
end;

(*=======================================================*)

(*=======================================================*)
constructor TDatOut.Create;
begin
  inherited;
end;

destructor TDatOut.Destroy;
begin
  inherited;
end;

procedure TDatOut.WriteHTML(str: PChar; size: integer);
begin
  WriteItem(str, size, ditNORMAL);
end;

procedure TDatOut.WriteHTML(str: String);
begin
  WriteHTML(PChar(str), length(str));
end;

procedure TDatOut.WriteText(str: String);
begin
  WriteText(PChar(str), length(str));
end;

procedure TDatOut.WriteChar(c: Char);
begin
  WriteText(@c, 1);
end;

procedure TDatOut.Flush;
begin
end;

(*=======================================================*)
procedure TConvDatOut.EndOfTag;
var
  quote: boolean;
begin
  quote := false;
  while index < size do
  begin
    if (str + index)^ = '"' then
      quote := not quote
    else if (not quote) and ((str + index)^ = '>') then
    begin
      Inc(index);
      exit;
    end;
    Inc(index);
  end;
end;

(* ^O擾() *)
function TConvDatOut.GetTagName: string;
var
  i: integer;
  tag: string;
begin
  for i := index to size - 1 do
  begin
    case (str + i)^ of
    '>', ' ', #1..#$1F, '=':
      begin
        index := i;
        result := LowerCase(tag);
        exit;
      end;
    else tag := tag + (str + i)^;
    end;
  end;
  result := LowerCase(tag);
  index := size;
end;

function TConvDatOut.GetAttribPair(var name, value: string): Boolean;
var
  i: integer;
label GOTVALUE;
begin
  while (index < size -1) and ((str + index)^ <> '>') do
  begin
    SkipSpaces;
    if (index < size -1) then
    begin
      name := GetTagName;
      SkipSpaces;
      if (index < size -1) and ((str + index)^ = '=') then
      begin
        Inc(index);
        SkipSpaces;
        value := '';
        if (index < size -1) and ((str + index)^ = '"') then
        begin
          for i := index + 1 to size -1 do
          begin
            case (str + i)^ of
            '>': begin index := i; goto GOTVALUE;; end;
            '"': begin index := i + 1; goto GOTVALUE; end;
            else value := value + (str + i)^;
            end;
          end;
          index := size -1;
        end
        else
          value := GetTagName;
        GOTVALUE:
          result := True;
          exit;
      end;
    end;
  end;
  result := False;
end;


procedure TConvDatOut.SkipSpaces;
var
  i: integer;
begin
  for i := index to size -1 do
  begin
    case (str + i)^ of
    #0..#$20:;
    else
      begin
        index := i;
        exit;
      end;
    end;
  end;
end;

function TConvDatOut.GetURL: string;
begin
  while index < size do
  begin
    case (str + index)^ of
    #$21, #$23..#$3B, #$3D, #$3F..#$7E: result := result + (str + index)^;
    else break;
    end;
    Inc(index);
  end;
end;


function TConvDatOut.GetRange(var ANK: string): string;
var
  s: string;
begin
  ANK := '';
  while index < size do
  begin
    case (str + index)^ of
    '0'..'9':
      begin
        s := s + (str + index)^;
        ANK := ANK + (str + index)^;
      end;
    '-':
      begin
        if length(s) <= 0 then
          break;
        s := s + (str + index)^;
        ANK := ANK + (str + index)^;
      end;
    #$81:
      begin
        if (index + 1 < size) and
           (((str + index+1)^ = #$7c) or
            ((str + index+1)^ = #$5d))  then
        begin (* | *)
          if length(s) <= 0 then
            break;
          s := s + #$81 + (str + index+1)^; //'|';
          ANK := ANK + '-';
          inc(index);
        end
        else
          break;
      end;
    #$82:
      begin
        if (index + 1 < size) and ((str + index+1)^ in [#$4f..#$58]) then
        begin   (* Sp *)
          inc(index);
          s := s + #$82 + (str + index)^;
          ANK := ANK + Chr(Ord((str + index)^) - $1f);
        end
        else
          break;
      end;
    else break;
    end;
    Inc(index);
  end;
  result := s;
end;

function TConvDatOut.ProcTag: boolean;
begin
  result := False;
end;

function TConvDatOut.ProcEntity: boolean;
begin
  result := False;
end;

function TConvDatOut.DoRange(const prefix: string): boolean;
var
  s, ANK: string;
  len: integer;
  c: Char;
begin
  len := length(prefix);
  Inc(index, len);
  s := GetRange(ANK);
  if 0 < length(s) then
  begin
    s := AnsiReplaceStr(prefix + s, '&gt;', '>');
    WriteAnchor('', '#' + ANK, PChar(s), length(s));
    ProcTag;
    while (index + 2 < size) and ((str + index)^ in [',', '=']) do
    begin
      c := (str + index)^;
      inc(index);
      s := GetRange(ANK);
      if length(s) <= 0 then
      begin
        dec(index);
        break;
      end;
      WriteChar(c);
      WriteAnchor('', '#' + ANK, PChar(s), length(s));
    end;
    result := true;
  end else
  begin
    Dec(index, len);
    result := false;
  end;
end;

function TConvDatOut.ProcRedirect: boolean;
begin
  (* &gt;[&gt;]digit[,digit|-digit] *)
  result := false;
  if (str + index)^ = '&' then
  begin
    if StartWithP('&gt;&gt;', str + index, size - index) then
      result := DoRange('&gt;&gt;')
    else if StartWithP('&gt;', str + index, size - index) then
      result := DoRange('&gt;');
  end
  else if StartWithP('', str + index, size - index) then
    result := DoRange('')
  else if StartWithP('', str + index, size - index) then
    result := DoRange('');
end;

function TConvDatOut.ProcURL: boolean;
var
  s: string;
begin
  (* http://xxx or ttp://xxx *)
  result := true;
  if (str + index)^ = 'h' then
  begin
    if StartWithP('http://', str + index, size - index) then
    begin
      s := GetURL;
      WriteAnchor('', s, PChar(s), length(s));
    end
    else if StartWithP('htp://', str + index, size - index) then
    begin
      s := GetURL;
      WriteAnchor('', 'ht' + Copy(s, 2, high(integer)), PChar(s), length(s));
    end
    else
      result := false;
  end
  else if StartWithP('ttp://', str + index, size - index) then
  begin
    s := GetURL;
    WriteAnchor('', 'h' + s, PChar(s), length(s));
  end
  else
    result := false;
end;


procedure TConvDatOut.ProcHTML;
begin
  while (index < size) do
  begin
    if not (((str + index)^ = '<') and ProcTag) and
       not (((str + index)^ in ['h','t']) and ProcURL) and
       not (((str + index)^ in ['&', #$81]) and ProcRedirect) and
       not (((str + index)^ = '&') and ProcEntity) then
    begin
      case (str + index)^ of
      #0..#$1F:;
      else
        WriteChar((str + index)^);
      end;
      Inc(index);
    end;
  end;
end;

procedure TConvDatOut.ProcName;
begin
  if isAllNumber(str, index, index + size) then
    DoRange('')
  else
    ProcHTML;
end;

procedure TConvDatOut.WriteItem(str: PChar; size: integer; itemType: TDatItemType);
begin
  Self.str   := str;
  Self.index := 0;
  Self.size  := size;
  if itemType = ditNAME then
    ProcName
  else
    ProcHTML;
end;

(*=======================================================*)

(* =========================================================== *)
function ZoomToPoint(zoom: integer): Integer;
begin
  result := -9;
  case zoom of
  0: result := -9;
  1: result := -10;
  2: result := -12;
  3: result := -16;
  4: result := -24;
  end;
end;

function ZoomToExternalLeading(zoom: integer): Integer;
begin
  result := 1;
  case zoom of
  0: result := 1;
  1: result := 2;
  2: result := 2;
  3: result := 3;
  4: result := 4;
  end;
end;

function FindAnchorName(item: THogeTVItem; var startPos, size: integer): boolean;
var
  i: integer;
begin
  if startPos <= 0 then
    i := 1
  else begin
    i := startPos + size;
    size := 0;
  end;
  startPos := 0;
  result := True;
  for i := i to length(item.FAttrib) do
  begin
    if (Ord(item.FAttrib[i]) and (htvVMASK or htvATTMASK))
       = (htvHIDDEN or ATTRIB_ANCHOR_NAME) then
    begin
      if startPos <= 0 then
        startPos := i
    end
    else if 0 < startPos then
    begin
      size := i - startPos;
      exit;
    end;
  end;
  result := false;
end;


(* =========================================================== *)

constructor TDat2View.Create(browser: THogeTextView);
begin
  inherited Create;
  FBrowser := browser;
  canceled := false;
  re_entrant := 0;
  FAttribute := 0;
  FBold := 0;
  FStream := THogeMemoryStream.Create;
  FStream.Size := 4096;
  flushCount := 0;
  FOffsetLeft := 0;
  FBiteSpaces := False;
  FUser := 0;
end;

destructor TDat2View.Destroy;
begin
  FStream.Free;
  inherited;
end;

procedure TDat2View.BeginAnchor;
begin
end;

procedure TDat2View.EndAnchor;
begin
end;

function TDat2View.ProcTag: boolean;
  procedure SetFont;
  var
    name, value: string;
  begin
    while GetAttribPair(name, value) do
    begin
      if (name = 'face') and (0 < length(value)) then
      begin
        FBrowser.SetFont(value, 12);
        break;
      end;
    end;
  end;

  procedure SetAttrib;
  var
    name, value: string;
    att: integer;
  begin
    while GetAttribPair(name, value) do
    begin
      if (name = 'i') and (0 < length(value)) then
      begin
        att := (Str2Int(value) * 2) mod 32;
        if att <> FAttribute then
        begin
          Flush;
          FAttribute := att;
        end;
        break;
      end;
    end;
  end;

var
  tag: string;
begin
  if (str + index)^ = '<' then
  begin
    Inc(index);
    tag := GetTagName;
    if (tag = 'br') or (tag = 'hr') or (tag = '/p') or (tag = '/li') or
       (tag = 'ul') then
      WriteBR
    else if (tag = 'dd') then
    begin
      WriteBR;
      FOffsetLeft := DD_OFFSET_LEFT;
    end
    else if (tag = '/dd') then
    begin
      FOffsetLeft := 0;
    end
    else if (tag = 'b') then
      SetBold(True)
    else if (tag = '/b') then
      SetBold(False)
    else if (tag = 'font') then
      SetFont
    else if (tag = 'sa') then
      SetAttrib
    else if (tag = 'a') then
      BeginAnchor
    else if (tag = '/a') then
      EndAnchor;
    EndOfTag;
    result := True;
  end
  else
    result := false;
end;

(* (str + index)^ = '&' *)
function TDat2View.ProcEntity: boolean;
var
  i, len, val: integer;

  procedure OutCode;
  begin
    Inc(i, len);
    if 255 < val then
    begin
      if val <> 3642 then
        WriteUNICODE(PChar(@val), 2);
    end
    else if Chr(val) in LeadBytes then
    begin
      FStream.WriteBuffer((str + index)^, i - index)
    end
    else
      FStream.WriteBuffer(PChar(@val)^, 1);
    index := i;
    if (str + index)^ = ';' then
      Inc(index);
  end;

var
  s, sEnd: string;
begin
  result := true;
  i := index + 1;
  if (str + i)^ = '#' then
  begin
    val := 0;
    Inc(i);
    if (str + i)^ in ['X','x'] then
    begin
      Inc(i);
      if GetHex(str + i, size - i, val, len) then
      begin
        OutCode;
        exit;
      end;
    end
    else begin
      if GetDecimal(str + i, size - i, val, len) then
      begin
        OutCode;
        exit;
      end;
    end;
  end
  else begin
    while i < size do
    begin
      case (str + i)^ of
//    'A'..'Z','a'..'z':
      'A'..'Z','a'..'z','1'..'9':
        begin
          s := s + (str + i)^;
          if s = 'amp' then  (* ÂO ; ŏIȂ̂ *)
          begin
            WriteChar('&');
            index := i + 1;
            if (index < size) and ((str + index)^ = ';') then
              Inc(index);
            exit;
          end;
        end;
      else
        begin
//          SetLength(s, i - index - 1);
//          Move((str + index + 1)^, s[1], i - index - 1);
          if (str + i)^ = ';' then
          begin
            sEnd := (str + i)^;
            Inc(i);
          end;
          if (s = 'gt') then
            WriteChar('>')
          else if (s = 'lt') then
            WriteChar('<')
          else if (s = 'quot') then
            WriteChar('"')
          else if (s = 'nbsp') or (s = 'ensp') or (s = 'thinsp') then
            WriteChar(' ')
          else if (s = 'copy') then
            WriteUNICODE(#$A9#$00, 2)
          else if (s = 'hearts') then
            WriteUNICODE(#$65#$26, 2)
          else if(WriteUnicode2(s)=false) then			// 2009.03.10
            WriteText('&' + s + sEnd);
          index := i;
          exit;
        end;
      end;
      Inc(i);
    end;
  end;
  result := false;
end;


procedure TDat2View.WriteText(str: PChar; size: integer);
begin
  FStream.WriteBuffer(str^, size);
  FBiteSpaces := False;
end;

procedure TDat2View.WriteAnchor(const Name: string;
                                const Href: string;
                                str: PChar; size: integer);
var
  user: integer;
begin
  Flush;
  if 0 < length(Href) then
    user := htvUSER
  else
    user := 0;

  FBrowser.nAppend(str, size, FBold or ATTRIB_LINK or user);
  FBrowser.Append(Name, ATTRIB_ANCHOR_NAME or htvHIDDEN);
  FBrowser.Append(Href, ATTRIB_ANCHOR_HREF or htvHIDDEN);

  FBiteSpaces := False;
end;

procedure TDat2View.WriteBR;
  procedure TrimRight;
  var
    i: integer;
    p: PChar;
  begin
    p := FStream.Memory;
    for i := FStream.Position -1 downto 0 do
    begin
      if (p+i)^ <> ' ' then
      begin
        FStream.Position := i + 1;
        exit;
      end;
    end;
    FStream.Position := 0;
  end;

begin
  TrimRight;
  Flush;
  FBrowser.Append(#10);
  FBiteSpaces := True;
end;

procedure TDat2View.SetBold(boldP: boolean);
begin
  Flush;
  if boldP then
    FBold := 1
  else
    FBold := 0;
end;

procedure TDat2View.WriteChar(c: Char);
begin
  if FBiteSpaces and (c = ' ') then
    exit;
  FBiteSpaces := False;
  if ' ' <= c then
    FStream.WriteChar(c);
end;
//
//
//
procedure TDat2View.WriteUNICODE(str: PChar; size: integer);
begin
  Flush;
  FBrowser.nAppend(str, size, FBold or FAttribute or htvUNICODE);
end;
//
//
//
function TDat2View.WriteUnicode2(s: string): boolean;
begin
	Result:=true;
	if gConfig.Doe_AaReplace = True then
	begin
			 if (s = 'nbsp') then WriteUNICODE(#$A0#$00, 2)		// &nbsp;	A000	
		else if (s = 'apos') then WriteUNICODE(#$27, 1)			// &apos;	39				// x27-39
		else if (s = 'iexcl') then WriteUNICODE(#$A1#$00, 2)	// &iexcl;	A100	
		else if (s = 'cent') then WriteUNICODE(#$A2#$00, 2)		// &cent;	A200	
		else if (s = 'pound') then WriteUNICODE(#$A3#$00, 2)	// &pound;	A300	
		else if (s = 'curren') then WriteUNICODE(#$A4#$00, 2)	// &curren;	A400	
		else if (s = 'yen') then WriteUNICODE(#$A5#$00, 2)		// &yen;	A500	
		else if (s = 'brvbar') then WriteUNICODE(#$A6#$00, 2)	// &brvbar;	A600	
		else if (s = 'sect') then WriteUNICODE(#$A7#$00, 2)		// &sect;	A700	
		else if (s = 'uml') then WriteUNICODE(#$A8#$00, 2)		// &uml;	A800	
//		else if (s = 'copy') then WriteUNICODE(#$A9#$00, 2)		// &copy;	A900	
		else if (s = 'ordf') then WriteUNICODE(#$AA#$00, 2)		// &ordf;	AA00	
		else if (s = 'laquo') then WriteUNICODE(#$AB#$00, 2)	// &laquo;	AB00	
		else if (s = 'not') then WriteUNICODE(#$AC#$00, 2)		// &not;	AC00	
		else if (s = 'shy') then WriteUNICODE(#$AD#$00, 2)		// &shy;	AD00	
		else if (s = 'reg') then WriteUNICODE(#$AE#$00, 2)		// &reg;	AE00	
		else if (s = 'macr') then WriteUNICODE(#$AF#$00, 2)		// &macr;	AF00	
		else if (s = 'deg') then WriteUNICODE(#$B0#$00, 2)		// &deg;	B000	
		else if (s = 'plusmn') then WriteUNICODE(#$B1#$00, 2)	// &plusmn;	B100	
		else if (s = 'sup2') then WriteUNICODE(#$B2#$00, 2)		// &sup2;	B200	
		else if (s = 'sup3') then WriteUNICODE(#$B3#$00, 2)		// &sup3;	B300	
		else if (s = 'acute') then WriteUNICODE(#$B4#$00, 2)	// &acute;	B400	
		else if (s = 'micro') then WriteUNICODE(#$B5#$00, 2)	// &micro;	B500	
		else if (s = 'para') then WriteUNICODE(#$B6#$00, 2)		// &para;	B600	
		else if (s = 'middot') then WriteUNICODE(#$B7#$00, 2)	// &middot;	B700	
		else if (s = 'cedil') then WriteUNICODE(#$B8#$00, 2)	// &cedil;	B800	
		else if (s = 'sup1') then WriteUNICODE(#$B9#$00, 2)		// &sup1;	B900	
		else if (s = 'ordm') then WriteUNICODE(#$BA#$00, 2)		// &ordm;	BA00	
		else if (s = 'raquo') then WriteUNICODE(#$BB#$00, 2)	// &raquo;	BB00	
		else if (s = 'frac14') then WriteUNICODE(#$BC#$00, 2)	// &frac14;	BC00	
		else if (s = 'frac12') then WriteUNICODE(#$BD#$00, 2)	// &frac12;	BD00	
		else if (s = 'frac34') then WriteUNICODE(#$BE#$00, 2)	// &frac34;	BE00	
		else if (s = 'iquest') then WriteUNICODE(#$BF#$00, 2)	// &iquest;	BF00	
		else if (s = 'Agrave') then WriteUNICODE(#$C0#$00, 2)	// &Agrave;	C000	
		else if (s = 'Aacute') then WriteUNICODE(#$C1#$00, 2)	// &Aacute;	C100	
		else if (s = 'Acirc') then WriteUNICODE(#$C2#$00, 2)	// &Acirc;	C200	
		else if (s = 'Atilde') then WriteUNICODE(#$C3#$00, 2)	// &Atilde;	C300	
		else if (s = 'Auml') then WriteUNICODE(#$C4#$00, 2)		// &Auml;	C400	
		else if (s = 'Aring') then WriteUNICODE(#$C5#$00, 2)	// &Aring;	C500	
		else if (s = 'AElig') then WriteUNICODE(#$C6#$00, 2)	// &AElig;	C600	
		else if (s = 'Ccedil') then WriteUNICODE(#$C7#$00, 2)	// &Ccedil;	C700	
		else if (s = 'Egrave') then WriteUNICODE(#$C8#$00, 2)	// &Egrave;	C800	
		else if (s = 'Eacute') then WriteUNICODE(#$C9#$00, 2)	// &Eacute;	C900	
		else if (s = 'Ecirc') then WriteUNICODE(#$CA#$00, 2)	// &Ecirc;	CA00	
		else if (s = 'Euml') then WriteUNICODE(#$CB#$00, 2)		// &Euml;	CB00	
		else if (s = 'Igrave') then WriteUNICODE(#$CC#$00, 2)	// &Igrave;	CC00	
		else if (s = 'Iacute') then WriteUNICODE(#$CD#$00, 2)	// &Iacute;	CD00	
		else if (s = 'Icirc') then WriteUNICODE(#$CE#$00, 2)	// &Icirc;	CE00	
		else if (s = 'Iuml') then WriteUNICODE(#$CF#$00, 2)		// &Iuml;	CF00	
		else if (s = 'ETH') then WriteUNICODE(#$D0#$00, 2)		// &ETH;	D000	
		else if (s = 'Ntilde') then WriteUNICODE(#$D1#$00, 2)	// &Ntilde;	D100	
		else if (s = 'Ograve') then WriteUNICODE(#$D2#$00, 2)	// &Ograve;	D200	
		else if (s = 'Oacute') then WriteUNICODE(#$D3#$00, 2)	// &Oacute;	D300	
		else if (s = 'Ocirc') then WriteUNICODE(#$D4#$00, 2)	// &Ocirc;	D400	
		else if (s = 'Otilde') then WriteUNICODE(#$D5#$00, 2)	// &Otilde;	D500	
		else if (s = 'Ouml') then WriteUNICODE(#$D6#$00, 2)		// &Ouml;	D600	
		else if (s = 'times') then WriteUNICODE(#$D7#$00, 2)	// &times;	D700	
		else if (s = 'Oslash') then WriteUNICODE(#$D8#$00, 2)	// &Oslash;	D800	
		else if (s = 'Ugrave') then WriteUNICODE(#$D9#$00, 2)	// &Ugrave;	D900	
		else if (s = 'Uacute') then WriteUNICODE(#$DA#$00, 2)	// &Uacute;	DA00	
		else if (s = 'Ucirc') then WriteUNICODE(#$DB#$00, 2)	// &Ucirc;	DB00	
		else if (s = 'Uuml') then WriteUNICODE(#$DC#$00, 2)		// &Uuml;	DC00	
		else if (s = 'Yacute') then WriteUNICODE(#$DD#$00, 2)	// &Yacute;	DD00	
		else if (s = 'THORN') then WriteUNICODE(#$DE#$00, 2)	// &THORN;	DE00	
		else if (s = 'szlig') then WriteUNICODE(#$DF#$00, 2)	// &szlig;	DF00	
		else if (s = 'agrave') then WriteUNICODE(#$E0#$00, 2)	// &agrave;	E000	
		else if (s = 'aacute') then WriteUNICODE(#$E1#$00, 2)	// &aacute;	E100	
		else if (s = 'acirc') then WriteUNICODE(#$E2#$00, 2)	// &acirc;	E200	
		else if (s = 'atilde') then WriteUNICODE(#$E3#$00, 2)	// &atilde;	E300	
		else if (s = 'auml') then WriteUNICODE(#$E4#$00, 2)		// &auml;	E400	
		else if (s = 'aring') then WriteUNICODE(#$E5#$00, 2)	// &aring;	E500	
		else if (s = 'aelig') then WriteUNICODE(#$E6#$00, 2)	// &aelig;	E600	
		else if (s = 'ccedil') then WriteUNICODE(#$E7#$00, 2)	// &ccedil;	E700	
		else if (s = 'egrave') then WriteUNICODE(#$E8#$00, 2)	// &egrave;	E800	
		else if (s = 'eacute') then WriteUNICODE(#$E9#$00, 2)	// &eacute;	E900	
		else if (s = 'ecirc') then WriteUNICODE(#$EA#$00, 2)	// &ecirc;	EA00	
		else if (s = 'euml') then WriteUNICODE(#$EB#$00, 2)		// &euml;	EB00	
		else if (s = 'igrave') then WriteUNICODE(#$EC#$00, 2)	// &igrave;	EC00	
		else if (s = 'iacute') then WriteUNICODE(#$ED#$00, 2)	// &iacute;	ED00	
		else if (s = 'icirc') then WriteUNICODE(#$EE#$00, 2)	// &icirc;	EE00	
		else if (s = 'iuml') then WriteUNICODE(#$EF#$00, 2)		// &iuml;	EF00	
		else if (s = 'eth') then WriteUNICODE(#$F0#$00, 2)		// &eth;	F000	
		else if (s = 'ntilde') then WriteUNICODE(#$F1#$00, 2)	// &ntilde;	F100	
		else if (s = 'ograve') then WriteUNICODE(#$F2#$00, 2)	// &ograve;	F200	
		else if (s = 'oacute') then WriteUNICODE(#$F3#$00, 2)	// &oacute;	F300	
		else if (s = 'ocirc') then WriteUNICODE(#$F4#$00, 2)	// &ocirc;	F400	
		else if (s = 'otilde') then WriteUNICODE(#$F5#$00, 2)	// &otilde;	F500	
		else if (s = 'ouml') then WriteUNICODE(#$F6#$00, 2)		// &ouml;	F600	
		else if (s = 'divide') then WriteUNICODE(#$F7#$00, 2)	// &divide;	F700	
		else if (s = 'oslash') then WriteUNICODE(#$F8#$00, 2)	// &oslash;	F800	
		else if (s = 'ugrave') then WriteUNICODE(#$F9#$00, 2)	// &ugrave;	F900	
		else if (s = 'uacute') then WriteUNICODE(#$FA#$00, 2)	// &uacute;	FA00	
		else if (s = 'ucirc') then WriteUNICODE(#$FB#$00, 2)	// &ucirc;	FB00	
		else if (s = 'uuml') then WriteUNICODE(#$FC#$00, 2)		// &uuml;	FC00	
		else if (s = 'yacute') then WriteUNICODE(#$FD#$00, 2)	// &yacute;	FD00	
		else if (s = 'thorn') then WriteUNICODE(#$FE#$00, 2)	// &thorn;	FE00	
		else if (s = 'yuml') then WriteUNICODE(#$FF#$00, 2)		// &yuml;	FF00	

		else if (s = 'OElig') then WriteUNICODE(#$52#$01, 2)	// &OElig;
		else if (s = 'oelig') then WriteUNICODE(#$53#$01, 2)	// &oelig;
		else if (s = 'Scaron') then WriteUNICODE(#$60#$01, 2)	// &Scaron;
		else if (s = 'scaron') then WriteUNICODE(#$61#$01, 2)	// &scaron;
		else if (s = 'Yuml') then WriteUNICODE(#$78#$01, 2)		// &Yuml;
		else if (s = 'fnof') then WriteUNICODE(#$92#$01, 2)		// &fnof;
		else if (s = 'circ') then WriteUNICODE(#$C6#$02, 2)		// &circ;
		else if (s = 'Tilde') then WriteUNICODE(#$3C#$22, 2)	// &Tilde;
		else if (s = 'tilde') then WriteUNICODE(#$DC#$02, 2)	// &tilde;

		else if (s = 'Alpha') then WriteUNICODE(#$91#$03, 2)	// &Alpha;	9103	
		else if (s = 'Beta') then WriteUNICODE(#$92#$03, 2)		// &Beta;	9203	
		else if (s = 'Gamma') then WriteUNICODE(#$93#$03, 2)	// &Gamma;	9303	
		else if (s = 'Delta') then WriteUNICODE(#$94#$03, 2)	// &Delta;	9403	
		else if (s = 'Epsilon') then WriteUNICODE(#$95#$03, 2)	// &Epsilon;	9503	
		else if (s = 'Zeta') then WriteUNICODE(#$96#$03, 2)		// &Zeta;	9603	
		else if (s = 'Eta') then WriteUNICODE(#$97#$03, 2)		// &Eta;	9703	
		else if (s = 'Theta') then WriteUNICODE(#$98#$03, 2)	// &Theta;	9803	
		else if (s = 'Iota') then WriteUNICODE(#$99#$03, 2)		// &Iota;	9903	
		else if (s = 'Kappa') then WriteUNICODE(#$9A#$03, 2)	// &Kappa;	9A03	
		else if (s = 'Lambda') then WriteUNICODE(#$9B#$03, 2)	// &Lambda;	9B03	
		else if (s = 'Mu') then WriteUNICODE(#$9C#$03, 2)		// &Mu;	9C03	
		else if (s = 'Nu') then WriteUNICODE(#$9D#$03, 2)		// &Nu;	9D03	
		else if (s = 'Xi') then WriteUNICODE(#$9E#$03, 2)		// &Xi;	9E03	
		else if (s = 'Omicron') then WriteUNICODE(#$9F#$03, 2)	// &Omicron;	9F03	
		else if (s = 'Pi') then WriteUNICODE(#$A0#$03, 2)		// &Pi;	A003	
		else if (s = 'Pho') then WriteUNICODE(#$A1#$03, 2)		// &Pho;	A103	
		else if (s = 'Sigma') then WriteUNICODE(#$A3#$03, 2)	// &Sigma;	A303	
		else if (s = 'Tau') then WriteUNICODE(#$A4#$03, 2)		// &Tau;	A403	
		else if (s = 'Upsilon') then WriteUNICODE(#$A5#$03, 2)	// &Upsilon;	A503	
		else if (s = 'Phi') then WriteUNICODE(#$A6#$03, 2)		// &Phi;	A603	
		else if (s = 'Chi') then WriteUNICODE(#$A7#$03, 2)		// &Chi;	A703	
		else if (s = 'Psi') then WriteUNICODE(#$A8#$03, 2)		// &Psi;	A803	
		else if (s = 'Omega') then WriteUNICODE(#$A9#$03, 2)	// &Omega;	A903	
		else if (s = 'thetasym') then WriteUNICODE(#$D1#$03, 2)	//	&thetasym; 
		else if (s = 'upsih') then WriteUNICODE(#$D2#$03, 2)	//	&upsih; 
		else if (s = 'piv') then WriteUNICODE(#$D6#$03, 2)		//	&piv; 
		else if (s = 'alpha') then WriteUNICODE(#$B1#$03, 2)	// &alpha;	B103	
		else if (s = 'beta') then WriteUNICODE(#$B2#$03, 2)		// &beta;	B203	
		else if (s = 'gamma') then WriteUNICODE(#$B3#$03, 2)	// &gamma;	B303	
		else if (s = 'delta') then WriteUNICODE(#$B4#$03, 2)	// &delta;	B403	
		else if (s = 'epsilon') then WriteUNICODE(#$B5#$03, 2)	// &epsilon;	B503	
		else if (s = 'zeta') then WriteUNICODE(#$B6#$03, 2)		// &zeta;	B603	
		else if (s = 'eta') then WriteUNICODE(#$B7#$03, 2)		// &eta;	B703	
		else if (s = 'theta') then WriteUNICODE(#$B8#$03, 2)	// &theta;	B803	
		else if (s = 'iota') then WriteUNICODE(#$B9#$03, 2)		// &iota;	B903	
		else if (s = 'kappa') then WriteUNICODE(#$BA#$03, 2)	// &kappa;	BA03	
		else if (s = 'lambda') then WriteUNICODE(#$BB#$03, 2)	// &lambda;	BB03	
		else if (s = 'mu') then WriteUNICODE(#$BC#$03, 2)		// &mu;	BC03	
		else if (s = 'nu') then WriteUNICODE(#$BD#$03, 2)		// &nu;	BD03	
		else if (s = 'xi') then WriteUNICODE(#$BE#$03, 2)		// &xi;	BE03	
		else if (s = 'omicron') then WriteUNICODE(#$BF#$03, 2)	// &omicron;	BF03	
		else if (s = 'pi') then WriteUNICODE(#$C0#$03, 2)		// &pi;	C003	
		else if (s = 'rho') then WriteUNICODE(#$C1#$03, 2)		// &rho;	C103	
		else if (s = 'sigmaf') then WriteUNICODE(#$C2#$03, 2)	// &sigmaf;	C203	
		else if (s = 'sigma') then WriteUNICODE(#$C3#$03, 2)	// &sigma;	C303	
		else if (s = 'tau') then WriteUNICODE(#$C4#$03, 2)		// &tau;	C403	
		else if (s = 'upsilon') then WriteUNICODE(#$C5#$03, 2)	// &upsilon;	C503	
		else if (s = 'phi') then WriteUNICODE(#$C6#$03, 2)		// &phi;	C603	
		else if (s = 'chi') then WriteUNICODE(#$C7#$03, 2)		// &chi;	C703	
		else if (s = 'psi') then WriteUNICODE(#$C8#$03, 2)		// &psi;	C803	
		else if (s = 'omega') then WriteUNICODE(#$C9#$03, 2)	// &omega;	C903	
		else if (s = 'ndash') then WriteUNICODE(#$13#$20, 2)	// &ndash;	1320	
		else if (s = 'mdash') then WriteUNICODE(#$14#$20, 2)	// &mdash;	1420	
		else if (s = 'lsquo') then WriteUNICODE(#$18#$20, 2)	// &lsquo;	1820	
		else if (s = 'rsquo') then WriteUNICODE(#$19#$20, 2)	// &rsquo;	1920	
		else if (s = 'sbquo') then WriteUNICODE(#$1A#$20, 2)	// &sbquo;	1A20	
		else if (s = 'ldquo') then WriteUNICODE(#$1C#$20, 2)	// &ldquo;	1C20	
		else if (s = 'rdquo') then WriteUNICODE(#$1D#$20, 2)	// &rdquo;	1D20	
		else if (s = 'bdquo') then WriteUNICODE(#$1E#$20, 2)	// &bdquo;	1E20	
		else if (s = 'dagger') then WriteUNICODE(#$20#$20, 2)	// &dagger;	2020	
		else if (s = 'Dagger') then WriteUNICODE(#$21#$20, 2)	// &Dagger;	2120	
		else if (s = 'bull') then WriteUNICODE(#$22#$20, 2)		// &bull;	2220	
		else if (s = 'hellip') then WriteUNICODE(#$26#$20, 2)	// &hellip;	2620	
		else if (s = 'permil') then WriteUNICODE(#$30#$20, 2)	// &permil;	3020	
		else if (s = 'prime') then WriteUNICODE(#$32#$20, 2)	// &prime;	3220	
		else if (s = 'Prime') then WriteUNICODE(#$33#$20, 2)	// &Prime;	3320	
		else if (s = 'lsaquo') then WriteUNICODE(#$39#$20, 2)	// &lsaquo;	3920	
		else if (s = 'rsaquo') then WriteUNICODE(#$3A#$20, 2)	// &rsaquo;	3A20	
		else if (s = 'oline') then WriteUNICODE(#$3E#$20, 2)	// &oline;	3E20	
		else if (s = 'frasl') then WriteUNICODE(#$44#$20, 2)	// &frasl;	4420	
		else if (s = 'euro') then WriteUNICODE(#$AC#$20, 2)		// &euro;	AC20	
		else if (s = 'weierp') then WriteUNICODE(#$18#$21, 2)	// &weierp;	1821	
		else if (s = 'image') then WriteUNICODE(#$11#$21, 2)	// &image;	1121	
		else if (s = 'real') then WriteUNICODE(#$1C#$21, 2)		// &real;	1C21	
		else if (s = 'trade') then WriteUNICODE(#$22#$21, 2)	// &trade;	2221	
		else if (s = 'alefsym') then WriteUNICODE(#$35#$21, 2)	// &alefsym;	3521	
		else if (s = 'larr') then WriteUNICODE(#$90#$21, 2)		// &larr;	9021	
		else if (s = 'rarr') then WriteUNICODE(#$92#$21, 2)		// &rarr;	9221	
		else if (s = 'darr') then WriteUNICODE(#$93#$21, 2)		// &darr;	9321	
		else if (s = 'harr') then WriteUNICODE(#$94#$21, 2)		// &harr;	9421	
		else if (s = 'crarr') then WriteUNICODE(#$B5#$21, 2)	// &crarr;	B521	
		else if (s = 'lArr') then WriteUNICODE(#$D0#$21, 2)		// &lArr;	D021	
		else if (s = 'uArr') then WriteUNICODE(#$D1#$21, 2)		// &uArr;	D121	
		else if (s = 'rArr') then WriteUNICODE(#$D2#$21, 2)		// &rArr;	D221	
		else if (s = 'dArr') then WriteUNICODE(#$D3#$21, 2)		// &dArr;	D321	
		else if (s = 'hArr') then WriteUNICODE(#$D4#$21, 2)		// &hArr;	D421	
		else if (s = 'loz') then WriteUNICODE(#$CA#$25, 2)		// &loz;	CA25	
		else if (s = 'spades') then WriteUNICODE(#$60#$26, 2)	// &spades;	6026	
		else if (s = 'clubs') then WriteUNICODE(#$63#$26, 2)	// &clubs;	6326	
//		else if (s = 'hearts') then WriteUNICODE(#$65#$26, 2)	// &hearts;	6526	
		else if (s = 'diams') then WriteUNICODE(#$66#$26, 2)	// &diams;	6626	
		else if (s = 'forall') then WriteUNICODE(#$00#$22, 2)	// &forall;	0022	
		else if (s = 'part') then WriteUNICODE(#$02#$22, 2)		// &part;	0222	
		else if (s = 'exist') then WriteUNICODE(#$03#$22, 2)	// &exist;	0322	
		else if (s = 'empty') then WriteUNICODE(#$05#$22, 2)	// &empty;	0522	
		else if (s = 'nabla') then WriteUNICODE(#$07#$22, 2)	// &nabla;	0722	
		else if (s = 'isin') then WriteUNICODE(#$08#$22, 2)		// &isin;	0822	
		else if (s = 'notin') then WriteUNICODE(#$09#$22, 2)	// &notin;	0922	
		else if (s = 'ni') then WriteUNICODE(#$0B#$22, 2)		// &ni;	0B22	
		else if (s = 'prod') then WriteUNICODE(#$0F#$22, 2)		// &prod;	0F22	
		else if (s = 'sum') then WriteUNICODE(#$11#$22, 2)		// &sum;	1122	
		else if (s = 'minus') then WriteUNICODE(#$12#$22, 2)	// &minus;	1222	
		else if (s = 'lowast') then WriteUNICODE(#$17#$22, 2)	// &lowast;	1722	
		else if (s = 'radic') then WriteUNICODE(#$1A#$22, 2)	// &radic;	1A22	
		else if (s = 'prop') then WriteUNICODE(#$1D#$22, 2)		// &prop;	1D22	
		else if (s = 'infin') then WriteUNICODE(#$1E#$22, 2)	// &infin;	1E22	
		else if (s = 'ang') then WriteUNICODE(#$20#$22, 2)		// &ang;	2022	
		else if (s = 'and') then WriteUNICODE(#$27#$22, 2)		// &and;	2722	
		else if (s = 'or') then WriteUNICODE(#$28#$22, 2)		// &or;	2822	
		else if (s = 'cap') then WriteUNICODE(#$29#$22, 2)		// &cap;	2922	
		else if (s = 'cup') then WriteUNICODE(#$2A#$22, 2)		// &cup;	2A22	
		else if (s = 'int') then WriteUNICODE(#$2B#$22, 2)		// &int;	2B22	
		else if (s = 'there4') then WriteUNICODE(#$34#$22, 2)	// &there4;	3422	
		else if (s = 'sim') then WriteUNICODE(#$3C#$22, 2)		// &sim;	3C22	
		else if (s = 'cong') then WriteUNICODE(#$45#$22, 2)		// &cong;	4522	
		else if (s = 'asymp') then WriteUNICODE(#$48#$22, 2)	// &asymp;	4822	
		else if (s = 'ne') then WriteUNICODE(#$60#$22, 2)		// &ne;	6022	
		else if (s = 'equiv') then WriteUNICODE(#$61#$22, 2)	// &equiv;	6122	
		else if (s = 'le') then WriteUNICODE(#$64#$22, 2)		// &le;	6422	
		else if (s = 'ge') then WriteUNICODE(#$65#$22, 2)		// &ge;	6522	
		else if (s = 'sub') then WriteUNICODE(#$82#$22, 2)		// &sub;	8222	
		else if (s = 'sup') then WriteUNICODE(#$83#$22, 2)		// &sup;	8322	
		else if (s = 'nsub') then WriteUNICODE(#$84#$22, 2)		// &nsub;	8422	
		else if (s = 'sube') then WriteUNICODE(#$86#$22, 2)		// &sube;	8622	
		else if (s = 'supe') then WriteUNICODE(#$87#$22, 2)		// &supe;	8722	
		else if (s = 'oplus') then WriteUNICODE(#$95#$22, 2)	// &oplus;	9522	
		else if (s = 'otimes') then WriteUNICODE(#$97#$22, 2)	// &otimes;	9722	
		else if (s = 'perp') then WriteUNICODE(#$A5#$22, 2)		// &perp;	A522	

		else if (s = 'emsp') then WriteUNICODE(#$03#$20, 2)		// &emsp;
		else if (s = 'zwnj') then WriteUNICODE(#$0C#$20, 2)		// &zwnj;
		else if (s = 'zwj') then WriteUNICODE(#$0D#$20, 2)		// &zwj;
		else if (s = 'lrm') then WriteUNICODE(#$0E#$20, 2)		// &lrm;
		else if (s = 'rlm') then WriteUNICODE(#$0F#$20, 2)		// &rlm;
		else if (s = 'uarr') then WriteUNICODE(#$91#$21, 2)		// &uarr;
		else if (s = 'Uarr') then WriteUNICODE(#$9F#$21, 2)		// &Uarr;
		else if (s = 'sdot') then WriteUNICODE(#$C5#$22, 2)		// &sdot;
		else if (s = 'lceil') then WriteUNICODE(#$08#$23, 2)	// &lceil;
		else if (s = 'rceil') then WriteUNICODE(#$09#$23, 2)	// &rceil;
		else if (s = 'lfloor') then WriteUNICODE(#$0A#$23, 2)	// &lfloor;
		else if (s = 'rfloor') then WriteUNICODE(#$0B#$23, 2)	// &rfloor;
	//	else if (s = 'Lang') then WriteUNICODE(#$EA#$27, 2)		// &Lang;
		else if (s = 'lang') then WriteUNICODE(#$29#$23, 2)		// &lang;	#$E8#$27
	//	else if (s = 'Rang') then WriteUNICODE(#$EB#$27, 2)		// &Rang;
		else if (s = 'rang') then WriteUNICODE(#$2A#$23, 2)		// &rang;	#$E9#$27
		else Result:=false;
	end
	else
		Result:=false;
end;
//
//
//
procedure TDat2View.Flush;
begin
  FBrowser.Strings[FBrowser.Strings.Count -1].OffsetLeft := FOffsetLeft;
  if FStream.Position <= 0 then
    exit;
  if FUser <> 0 then
    FBrowser.nAppend(FStream.Memory, FStream.Position, FBold or FUser)
  else
    FBrowser.nAppend(FStream.Memory, FStream.Position, FBold or FAttribute);
  FStream.Position := 0;
  Inc(flushCount);
  if (flushCount mod 256) = 0 then
  begin
    Inc(re_entrant);
    Application.ProcessMessages;
    Dec(re_entrant);
  end;
end;

procedure TDat2View.Cancel;
begin
  canceled := true;
end;

(* =========================================================== *)

(*=======================================================*)

procedure TSimpleDat2View.BeginAnchor;
var
  name, value: string;
begin
  Flush;
  FHref := '';
  while GetAttribPair(name, value) do
  begin
    if name = 'href' then
    begin
      FHref := value;
      break;
    end;
  end;
  FUser := htvUSER or ATTRIB_LINK;
end;

procedure TSimpleDat2View.EndAnchor;
begin
  Flush;

  //WriteAnchor('', FHref, PChar(FHref), length(FHref));
  FBrowser.Append(FHref, ATTRIB_ANCHOR_HREF or htvHIDDEN);
  FUser := 0;
end;

procedure TSimpleDat2View.ProcHTML;
begin
  while (index < size) do
  begin
    if not (((str + index)^ = '<') and ProcTag) and
       not (((str + index)^ = '&') and ProcEntity) then
    begin
      case (str + index)^ of
      #0..#$1F:;
      else
        WriteChar((str + index)^);
      end;
      Inc(index);
    end;
  end;
end;

procedure TSimpleDat2View.Flush;
begin
  FBrowser.Invalidate;
  inherited;
end;

function TVMouseProc(Sender: THogeTextView; Shift: TShiftState;
                     X, Y: Integer): string;
var
  point: TPoint;
  view: THogeTextView;
  item: THogeTVItem;
  index: integer;
  newCursor: TCursor;
begin
  result := '';
  view := THogeTextView(Sender);
  point := view.ClientToPhysicalCharPos(X, Y);
  newCursor := crDefault;
  if 0 <= point.X then
  begin
    newCursor := crIBeam;
    item := view.Strings[point.Y];
    index := point.X +1;
    with THogeTextView(Sender) do
    begin
      if InSelection(point.X, point.Y) then
      begin
        if Cursor <> crDefault then
          Cursor := crDefault;
        exit;
      end;
    end;
    result := item.GetEmbed(index);
    if 0 < length(result) then
      newCursor := crHandPoint;
  end;
  with THogeTextView(Sender) do
    if Cursor <> newCursor then
      Cursor := newCursor;
end;

end.
