unit untTopicBrowserDoe;

interface

uses
  Classes, ComCtrls, Controls, HogeTextView, Dialogs, SyncObjs,
  Messages,
  untTopic, SysUtils, untGlobal, Forms, untHintWindow, untMainForm,
  untTool, ExtCtrls, windows,
  untTopicBrowser, untBmRegExp,
  untDoeSUB, Graphics, Menus,StrUtils,untRegExpr;

type

  TTopicBrowserDoe = class(TTopicBrowser)
  protected
    FStatusText  : string;
    FOutputTimer : TTimer;
    FPrevPos: TPoint;
    FReplaceMode : integer;
    FBrowser : THogeTextView;
    FReceivedIndex : integer;
    FGoScroll      : Boolean;
    FRestoredPos   : Boolean;
    FPopupMenu     : TPopupMenu;
    NGWords: TStringList;
    FIDSearchMode  : Boolean;
    FID_forSearch  : string;
    FParent        : TObject;
    FBitmap    : TGraphic;
    FMouseMoveCount : integer;

    procedure OutputTime(sender : TObject);
    procedure SetNGWords;
    function  DatToHtml(body: string): string;
    function  DatToHtml2(body: string; ref: string): string;
    function  DatToHtml3(body: string): string;
    function  ReplaceString(MatchStr: string): string;
    procedure BrowserInitialize();
    procedure OnBrowserMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure OnBrowserMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure OnBrowserKeyDown(Sender: TObject; var Key: Word;Shift: TShiftState);
    procedure BrowserStatusTextChange(Sender: TObject; const Text: AnsiString);
//  procedure RestoreScrollPosition; override;
    function  DeleteTag(strbody: string): string;

  public
    procedure JumpMessage(const msgno: integer); override;
    procedure Topic_MessageReceived(sender: TObject); override;
    procedure SaveScrollPosition; override;
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy;    override;
    procedure   RestoreScrollPosition; override;
    procedure   OpenTopic(Topic: TTopic);  override;
    procedure   CloseTopic; override;
    procedure   Reload;   override;
    procedure   ChangeViewLimit(NewLimit: integer); override;
    procedure   SearchText(const str: string; mode: boolean); override;
    procedure   SetFont(fname: string; fsize: integer); override;
//  procedure   SetHTMLColor(mes: integer; nam: integer; lnk: integer; bg: integer); override;
    procedure   SetHTMLColor(mes: integer; nam: integer; namelink: integer; lnk: integer; bg: integer); override;
    procedure   IDSearch(id: string); override;
    procedure   SetWallpaper(g: TGraphic); override;
    procedure   IDSearchPopUp(id: string); override;

    procedure   OnMouseEnter(var msg: TMessage); message WM_MOUSEHOVER;   // 2008.04.29ǉ
    procedure   OnMouseLeave(var msg: TMessage); message WM_MOUSELEAVE;   // 2008.04.29ǉ
//  procedure   OnMouseLeave;    // 2008.04.29ǉ
    procedure SelectAll(); override;

   end;

implementation

{ TTopicBrowserDoe }

constructor TTopicBrowserDoe.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  FPopupMenu := TPopupMenu.Create(self);

  FBrowser := THogeTextView.Create(self);
  FBrowser.Parent := self;
  FBrowser.Align := alClient;
  FBrowser.LeftMargin := 15;
  FBrowser.TopMargin := 15;
  FBrowser.RightMargin := 20;
  FBrowser.ExternalLeading := 1;
  FBrowser.VerticalCaretMargin := 1;
  FBrowser.PopupMenu := FPopupMenu;

//FBrowser.TextAttrib[0].style := [fsBold];
//FBrowser.TextAttrib[0].color := RGB($22, $8B, $22);
  FBrowser.TextAttrib[1].style := [fsBold];
  FBrowser.TextAttrib[1].color := RGB($22, $8B, $22);
  FBrowser.TextAttrib[2].color := clBlue;
  FBrowser.TextAttrib[2].style := [fsUnderline];
  FBrowser.TextAttrib[3].color := clBlue;
  FBrowser.TextAttrib[3].style := [fsBold, fsUnderline];

  FBrowser.TextAttrib[4].color := RGB($22,$8B,$22);
  FBrowser.TextAttrib[5].color := RGB($22,$8B,$22);
  FBrowser.TextAttrib[5].style := [fsBold];


  FBrowser.OnMouseMove := OnBrowserMouseMove;
  FBrowser.OnMouseDown := OnBrowserMouseDown;
  FBrowser.OnKeyDown   := OnBrowserKeyDown;
  FBrowser.Invalidate;

  //wirbg}bv\
  if FileExists(AppPath('wallpaper.bmp')) then
  begin
    FBitmap := TBitmap.Create;
    FBitmap.LoadFromFile(AppPath('wallpaper.bmp'));
    FBrowser.Wallpaper := FBitmap;
  end;

  FBrowser.Visible := true;

  FOutputTimer := TTimer.Create(self);
  FOutputTimer.Enabled  := false;
  FOutputTimer.Interval := 1;
  FOutputTimer.OnTimer  := OutputTime;

  //IDo[h
  FIDSearchMode := false;

  //c[`bvxŏ߂̃JE^
  FMouseMoveCount := 0;

  NGWords := TStringList.Create;
//gEvent:= TSimpleEvent.Create;
  gEvent.ResetEvent();
end;

destructor TTopicBrowserDoe.Destroy;
begin

  NGWords.Free;
//gEvent.Free;

  inherited;

end;
//
//
//
procedure TTopicBrowserDoe.OpenTopic(Topic: TTopic);
begin
  BrowserInitialize();

  //X擾邽тngword.txtǂݍݒ
  SetNGWords();

  inherited OpenTopic(Topic);

end;
//
//
//
procedure TTopicBrowserDoe.CloseTopic;
begin

  inherited;

  FOutputTimer.Enabled := false;
  FBrowser.Clear;
  BrowserInitialize();

//Application.ProcessMessages;		// 2008.08.16
  FBrowser.Invalidate;		// 2008.08.16
//FBrowser.Update;
end;
//
//
//
procedure TTopicBrowserDoe.Reload;
begin
  inherited;

end;
//
// XN[ʒuۑ
//
procedure TTopicBrowserDoe.SaveScrollPosition;
//var
//pL: TPoint;
//pP: TPoint;
begin
  inherited;

//Topic.ScrollPosition := FBrowser.LogicalCaret.Y;
  if Assigned(Topic) and Assigned(FBrowser) then
  begin
    if MainForm.TopicDeleted=false then
    begin
      Topic.ScrollPosition         := FBrowser.LogicalTopLine;  // 2008.06.20
      Topic.PhysicalScrollPosition := FBrowser.TopLine;  		// 2008.07.04
    end else
    begin
      Topic.ScrollPosition         := 0;
      Topic.PhysicalScrollPosition := -1;
    end;
  end;

// Topic.PhysicalScrollPosition := FBrowser.LogicalCaret.Y;
//	FBrowser.Caret;
//	FBrowser.ScreenCaret;
//	FBrowser.LogicalCaret;

{	// L -> P
	pL.X:=0;
	pL.Y:=FBrowser.LogicalTopLine;
    pP := FBrowser.LogicalToPhysical(pL);

	pP.X:=0;
	pP.Y:=FBrowser.TopLine;
	pL:=FBrowser.PhysicalToLogical(pP);
}
end;
//
// bZ[WM
//
procedure TTopicBrowserDoe.Topic_MessageReceived(sender: TObject);
begin
  if FLoading = false then
    FOutputTimer.Enabled := true;

end;
//
//ngword.txt ̓e NGWords ɋL
//
procedure TTopicBrowserDoe.SetNGWords();
begin
  //NGWords := TStringList.Create;
  NGWords.Clear;
  NGWords.LoadFromFile(Apppath('ngword.txt'));
end;
//---------------------------------------------------------
// bZ[W̕\
//---------------------------------------------------------
procedure TTopicBrowserDoe.OutputTime(sender: TObject);
var
  outputhtml  : string;
  output      : string;
  strBody     : string;
  I           : integer;
  msg         : TTopicMessage;
  dest        : TSimpleDat2View;
  msgs        : TList;
  str2chName: String;
  str2chMailName: string;
  str2chID: String;
  str2chMail: String;
  str2chBody: String;
  str2chReferer: String;
  k: integer;
  intInStr: integer;
  ansistr: string;
  intIDSearchCount : integer;
  regEx: TRegExpr;
label
  Finish;
begin
  FOutputTimer.Enabled := false;
	if Topic.MessageList.Count=0 then exit;
//	FBrowser.ExternalLeading:=0;		Doe̍s default=1
//	FBrowser.VisibleLines:=0;			// Ls
	FBrowser.BeginUpdate();

  try
	gEvent.ResetEvent();

  //^C}~
  FOutputTimer.Enabled := false;
  FLoading := true;
  FDownloading:= true;

  //IDo`pɊo
  FParent := sender;

  //IDo
  intIDSearchCount := 0;

  dest := TSimpleDat2View.Create(FBrowser);

  msgs := Topic.MessageList;

  I := FReceivedIndex;

  while I <= msgs.Count - 1 do
  begin
    //msg = P̃X
    msg := TTopicMessage(msgs[I]);
    FReceivedIndex := I + 1;
    Inc(I);

    str2chName := msg.PostName;
    str2chID := msg.RestStr;
    str2chBody := msg.Body;
    str2chMail := msg.PostEmail;
    str2chMailName := '';
    str2chReferer := Topic.BrowserUrl + IntToStr(msg.Index);
    //BẽN𒣂
    str2chID := DatToHtml2(str2chID,str2chReferer);

    //ځ`񂵂X̔f
    regEx := TRegExpr.Create;
    regEx.Expression := '<K88_ABONE>';
    if regEx.Exec(str2chMail) then
    begin
      str2chName := 'ځ[';
      str2chID := 'ځ[';
      str2chBody := '';
      str2chMail := APP_NAME;
    end;
    regEx.Free;

    //NG[hɊY邩̔f
    intInStr := 0;
    for k:=0 to NGWords.Count-1 do
    begin
     //DeleteTagŃ^Ô<B>ŋ܂gbv΍
     ansistr := DeleteTag(str2chName);
     intInStr := intInstr + Pos(NGWords.Strings[k],ansistr);
     ansistr := str2chID;
     intInStr := intInstr + Pos(NGWords.Strings[k],ansistr);
     ansistr := str2chBody;
     intInStr := intInstr + Pos(NGWords.Strings[k],ansistr);
     ansistr := str2chMail;
     intInStr := intInstr + Pos(NGWords.Strings[k],ansistr);
     if intInstr > 0 then Break;
    end;

    if (intInStr) > 0 then
    begin
     str2chName := '<FONT COLOR=BLUE>NGځ[</FONT>';
     //tID͂̂܂܎c
     //str2chID := 'ځ[';
     str2chBody := '';
     //NG[hځ[̂Ƃ[Katju88ƕ\
     str2chMail := APP_NAME;
    end;

    //Vǂ̔f
    if msg.IsNewMessage = false then
      outputhtml := gConfig.ResHtml
    else
      outputhtml := gConfig.NewResHtml;

      //Oƃ[ 2005/03/17
    if str2chMail <> '' then
    begin
      if not gConfig.DispMailAddress then
        str2chMailName := '<B><A HREF="mailto:' + str2chMail+ '">' +
                  str2chName +
                  '</A></B>'
      else
      str2chMailName := '<B><A HREF="mailto:' + str2chMail+ '">' +
                  str2chName +
                  '</A></B>'+ ' [' + str2chMail+ ']';
    end
    else
     str2chMailName := '<B>' + str2chName + '</B>';

    //WXL݂̂ɑΉɂ ̂
    {
    outputhtml := StringReplace(outputhtml, '&MAILNAME', '<B>' + mailname + '</B>', [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '&NUMBER',   '<a href="menu://at/' + IntToStr(msg.Index) + '">' + IntToStr(msg.Index) + '</a>', [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '&DATE',     msg.RestStr, [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '&PLAINNUMBER',IntToStr(msg.Index), [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '&MAIL', msg.Postemail, [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '&NAME', '<B>' + msg.PostName + '</B>', [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '&THREADURL', Topic.BrowserUrl, [rfReplaceAll]);
    }

	// I[owbh͑傫vIł͂Ȃ
//  outputhtml := StringReplace(outputhtml, '<MAILNAME/>', '<B>' + str2chMailName + '</B>', [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '<MAILNAME/>', str2chMailName, [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '<NUMBER/>',   '<a href="menu://at/' + IntToStr(msg.Index) + '">' + IntToStr(msg.Index) + '</a>', [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '<DATE/>',     str2chID, [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '<PLAINNUMBER/>',IntToStr(msg.Index), [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '<MAIL/>', str2chMail, [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '<NAME/>', '<B>' + str2chName + '</B>', [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '<THREADURL/>', Topic.BrowserUrl, [rfReplaceAll]);
    outputHtml := StringReplace(outputHtml, '<SKINPATH/>',gConfig.SkinPath, [rfReplaceAll]);

    strBody := DatToHtml(str2chBody);
    outputHtml := StringReplace(outputhtml, '<MESSAGE/>',  strBody, [rfReplaceAll]);

// AA
//if gConfig.Doe_AaReplace = True then
//  outputHtml := ReplaceAA(outputHtml);

    //IDNɂ
    outputHtml := DatToHtml3(outputHtml);
    output := outputhtml + #13#10;

    //IDo[h
    if (FIDSearchMode) then
    begin
      if AnsiContainsText(msg.RestStr,FID_forSearch) then
      begin
          Inc(intIDSearchCount);
          dest.WriteHTML(output);
      end;
    end
    else
    //IDo[hł͂ȂƂʂɏo
        dest.WriteHTML(output);


    // XN[ VƂ
//  if FRestoredPos = false then          // XN[ʒu̕܂sĂȂ
//    if msg.IsNewMessage = true then     // VbZ[W
//      RestoreScrollPosition;

    msg.IsNewMessage := false;

    //if I = msgs.Count - 1 then Application.ProcessMessages;	// 2008.07.03
  end;

  //IDo[h
  if (FIDSearchMode) then
  begin
      //<BR>Ȃƕ\Ȃ
      dest.WriteHTML('<BR><BR></dt><BR>');
      dest.WriteHTML('IDo@@' + FID_forSearch + ' o ' + IntToStr(intIDSearchCount) + '<BR><BR>'#13#10);
  end;

  FLoading := false;
  dest.Free;

Finish:
//	FBrowser.EndUpdate();

  if FReceivedIndex >= msgs.Count then       // ݂̕\sXgs(ȍ~)Ȃ
    RestoreScrollPosition;                   // XN[

  FIDSearchMode := false;

  FBrowser.EndUpdate();

  except
    on e: Exception do
    begin
      ShowMessage(e.Message);
    end;
  end;

	gEvent.SetEvent();
end;
{ --------------------------------------------------------
  ֐: DatToHtml
  pr  : >>1 ̕ϊ
    : body - Ώۂ̕
  ߂l: Ȃ
  l  : ϊ̕
  ------------------------------------------------------}
function TTopicBrowserDoe.DatToHtml(body: string): string;
var
  awk: TAwkStr;
begin
  body := EraseATag(body);
  awk := TAwkStr.Create(nil);
  awk.OnReplaceString := ReplaceString;

  // XԍɃN\
  FReplaceMode := 1;
  awk.RegExp := '(&gt;|)+[0-9O-X]+([-|[][0-9O-X]+)?';
  awk.GSub('', body);

  // URLɃN\
  FReplaceMode := 2;
  awk.RegExp := 'h*ttp://[a-zA-Z_/%@\-~\.0-9&=%\?#;:\,\+]+';
  awk.GSub('', body);

  awk.Free;

  result := body;

end;
//
// BE̎dlɍ킹ăN𒣂
//
function TTopicBrowserDoe.DatToHtml2(body: string; ref: string): string;
var
  match: boolean;
  regEx: TRegExpr;
  strDate: String;
  strLink: String;
  strID: String;
  strMark: String;
begin
  regEx := TRegExpr.Create;


  //tƎԂ̐`FbN

  regEx.Expression := '.+ [0-9\:]+ ';
  match := regEx.Exec(body);
  if (match = false) then
  begin
     result := body;
     regEx.Free;
     exit;
  end;
  strDate := regEx.Match[0];

  //be.2ch.net/be́ADatJavaScriptߍ܂ꂽ
  //P[XBEIDT
  regEx.Expression := '/test/[a-zA-Z\.\?=]+[0-9]+';
  match := regEx.Exec(body);

  if (match) then strLink := regEx.Match[0];

  if (match = false) then
  begin
    //JavaScriptȂP[X
    regEx.Expression := '[ <]BE:([0-9]+)';
    match := regEx.Exec(body);

    if (match = false) then
    begin
     result := body;
     regEx.Free;
     exit;
    end;

    strLink := '/test/p.php?i=' + regEx.Match[1];
  end;

  strLink := strLink + '&u=d:' + ref;

  //ID̐`FbN
  regEx.Expression := 'ID:[a-zA-Z0-9\.?\+\/]+';

  match := regEx.Exec(body);

  if (match) then strID := regEx.Match[0];

  if (match = false) then
  begin
     regEx.Expression := ' (.+) BE:';
     match := regEx.Exec(body);
     if (match = false) then
     begin
       result := body;
       regEx.Free;
       exit;
     end;
     strID := regEx.Match[1];
  end;

  //JavaScriptP[X
  regEx.Expression := '>(.+)</a>';
  match := regEx.Exec(body);

  if (match) then strMark := regEx.Match[1];

  if (match = false) then
  begin
    //JavaScriptȂP[X
    regEx.Expression := ' BE:[0-9]+-(.+)';
    match := regEx.Exec(body);

    if (match) then
    //N̕IEƂ킹邽߂ɐ擪?
    strMark := '?' + regEx.Match[1]
    else
    //BEVdl̒ Level\
    begin
     regEx.Expression := '<BE:[0-9]+:([0-9]+)>';
     regEx.Exec(body);
     //match := regEx.Exec(body);
     strMark := 'Lv.' + regEx.Match[1];
    end;
  end;

  regEx.Free;

  if (strLink <> '') then
  begin
    //`𐮂
     body := strDate + strID + ' <a href="http://be.2ch.net' + strLink + '" target="_blank">' + strMark + '</a>';
  end;

  result := body;
end;
//
//
//
function TTopicBrowserDoe.DatToHtml3(body: string): string;
var
  match: boolean;
  regEx: TRegExpr;
  strID: String;
  strIDFix: String;
begin

  //IDɃN𒣂

  regEx := TRegExpr.Create;

  regEx.Expression := 'ID:([a-zA-Z0-9\.?\+\/]+)';
  match := regEx.Exec(body);
  if (match = false) then
  begin
     result := body;
     regEx.Free;
     exit;
  end;

  strID := regEx.Match[0];
  strIDFix := '<a href="menu://id/' + strID + '">ID</a>:' + regEx.Match[1];
  body := StringReplace(body, strID, strIDFix, [rfReplaceAll]);

  regEx.Free;
  result := body;


end;
//
//
//
function TTopicBrowserDoe.ReplaceString(MatchStr : string) : string;
var
  strNum, check: string;
  i: integer;
  isNum: char;

begin
  case FReplaceMode of
    1:
    begin
      check := ZenkakuToHankaku(MatchStr);
      for i := Length(check)  downto 1 do
      begin
        isNum := check[i];
        if (isNum in ['0'..'9']) or (isNum = '-') then
        begin
          strNum := isNum + strNum;
        end;
      end;

      result := '<A HREF="jump://goto/' + strNum + '">' + MatchStr + '</A>';
    end;
    2:
    begin
      check := Matchstr;
      if Copy(check, 1, 1) <> 'h' then
      begin
        check := 'h' + check;
      end;

      if Pos('#', check) <> 0 then
      begin
        result := '<a href="' + AnsiReplaceText(check, '#', '[%23]') + '">' + MatchStr + '</a>'
      end else
      begin
        result := '<a href="' + check + '">' + MatchStr + '</a>';
      end;

    end;
  end;

end;


procedure TTopicBrowserDoe.BrowserInitialize;
begin

  FOutputTimer.Enabled := false;

  FReceivedIndex  := 0;
  //FLogLoadedCount := 0;
  FRestoredPos := false;

  //NtHgݒ
  FBrowser.SetFont(gConfig.Doe_FontName, gConfig.Doe_FontSize);
  //zFݒ
//SetHTMLColor(gConfig.Doe_TextColor,gConfig.Doe_NameColor,gConfig.Doe_LinkColor,gConfig.Doe_BGColor);
  SetHTMLColor(gConfig.Doe_TextColor,gConfig.Doe_NameColor,gConfig.Doe_NameLinkColor,gConfig.Doe_LinkColor,gConfig.Doe_BGColor);

end;
//
//
//
procedure TTopicBrowserDoe.OnBrowserMouseMove(Sender: TObject; Shift: TShiftState;
                                      X, Y: Integer);
var
  st: String;
begin

  FPrevPos.X := X;
  FPrevPos.Y := Y;
  st := TVMouseProc(THogeTextView(Sender), Shift, X, Y);

  Inc(FMouseMoveCount);
  //c[`bvx
  if FMouseMoveCount > 50 then
  begin
     FMouseMoveCount := 0;
     FStatusText := '';
     ToolTip.UnVisible;
  end;

//if st = '' then exit;
// 2008.04.29
if st = '' then
begin
  FStatusText:='';
  exit;
end;


  if st <> FStatusText then
  begin
    FStatusText := st;
    if FStatusText = '' then exit;

    //}EXI[o[IDoȂ
    if Copy(FStatusText, 1, 10) = 'menu://id/' then exit;

    BrowserStatusTextChange(Sender, FStatusText);
  end
  else if length(st) <= 0 then
    ToolTip.UnVisible;
end;
//
//
//
procedure TTopicBrowserDoe.OnBrowserMouseDown(Sender: TObject; Button: TMouseButton;
                                      Shift: TShiftState; X, Y: Integer);
var
  s      : string;
begin
  case Button of
  mbLeft:
    begin
      if (FStatusText = '') then exit;
      s := Sender.ClassName;
      OnBrowserMouseMove(Sender, Shift, X, Y);
      RaiseNavigateUrlEvent(FStatusText);
      THogeTextView(Sender).Selecting := False;
    end;
  mbRight:
    begin
      if gConfig.Doe_RightClick = True then		// 2008.06.10
      begin
        s := FBrowser.Selection;
        inherited DoePopUp(s);
      end;
    end;
  end;
end;

procedure TTopicBrowserDoe.OnBrowserKeyDown(Sender: TObject; var Key: Word;
                                    Shift: TShiftState);
var
  view: THogeTextView;
  item: THogeTVItem;
  point: TPoint;
  index: integer;
  strref: string;

//s: SHORT;
begin
	if Key=$E5 then				// IME ON̎̏
	begin
		if GetKeyState(VK_SPACE) < 0 then Key:=VK_SPACE
		else
		if GetKeyState($50) < 0 then Key:=$50				// VK_P==$50
		else
		if GetKeyState(VK_RETURN) < 0 then Key:=VK_RETURN
	end;

  view := THogeTextView(Sender);
  //PopupHint.UnVisible;
  case Key of
  VK_SPACE:
    begin
      view.Selecting := False;
      if ssShift in Shift then
        view.PageUp
      else
        view.PageDown;
    end;
  VK_RETURN, Ord('P'), Ord('p'):
    begin
      point := view.Caret;
      item :=view.Strings[point.Y];
      index := point.X + 1;
      strref := item.GetEmbed(index);
      case Key of
      VK_RETURN: ;
        //BrowserBeforeNavigate(Sender, ref, Cancel);
      Ord('P'), Ord('p'): 
        BrowserStatusTextChange(Sender, strref);
      end;
      Key := 0;
    end;
  end;
end;

procedure TTopicBrowserDoe.BrowserStatusTextChange(Sender: TObject;
                                           const Text: AnsiString);
begin
  inherited ChangePopup(Text);
end;
//
// XN[ʒu
//
procedure TTopicBrowserDoe.RestoreScrollPosition;
var
  point: TPoint;
begin
  inherited;

  if FRestoredPos = true then exit;    // XN[ʒuXgAς݂
  if Topic = Nil then exit;

  try
  MainForm.FExecute:=True;
  FRestoredPos := true;
  point.X := 0;

  if Topic.PhysicalScrollPosition <> -1 then
  begin
    point.Y := Topic.PhysicalScrollPosition;
//  FBrowser.SetPhysicalCaret(0,0);
    FBrowser.SetTop(FBrowser.PhysicalToLogical(point).Y+1);

//  FBrowser.SetLogicalCaret(0,Topic.PhysicalScrollPosition);
//  FBrowser.SetTop(Topic.ScrollPosition+1);

  end else
  begin
//  point.Y := Topic.ScrollPosition;
//  FBrowser.SetPhysicalCaret(0,0);
    FBrowser.SetTop(Topic.ScrollPosition+1);
  end;

//	if Topic = Nil then
//	begin
//		point.Y:=0;
//	end
//	else
//	begin
//	  point.Y := Topic.ScrollPosition;
//	end;

//	  FBrowser.SetPhysicalCaret(0, Topic.ScrollPosition);  // 2008.06.20
//	  FBrowser.SetLogicalCaret(0, Topic.ScrollPosition);   // 2008.06.20
//	  FBrowser.SetTop(Topic.ScrollPosition+1);
//	FBrowser.SetTop(FBrowser.PhysicalToLogical(point).Y+1);

  MainForm.FExecute:=False;

  except
    on e: Exception do
    begin
      ShowMessage(e.Message);
    end;
  end;

end;

procedure TTopicBrowserDoe.JumpMessage(const msgNo: integer);
var
  i: integer;
  item: THogeTVItem;
  point: TPoint;
  intJumpLine: Integer;
  strHit: string;
  regEx: TRegExpr;

begin
  inherited;

  //XAJ[ւ̃Wv
  regEx := TRegExpr.Create;

  FBrowser.Selecting := False;
  intJumpLine := -1;
  strHit := intToStr(msgNo) + 'menu://at/' + intToStr(msgNo) + ' ';
  regEx.Expression := strHit;

  //uEȔ݂T[`AWv݂
  for i := 0 to FBrowser.Strings.Count -1 do
  begin
    item := FBrowser.Strings[i];
    if regEx.Exec(item.FText) then
        intJumpLine := i;
  end;

  regEx.Free;

  //݂Ȃ΃X[
  if intJumpLine = -1 then exit;

  point.X := 0;
  point.Y := intJumpLine;
  FBrowser.SetTop(FBrowser.PhysicalToLogical(point).Y);
  FBrowser.SetPhysicalCaret(0, intJumpLine + FBrowser.VerticalCaretMargin);

end;

procedure TTopicBrowserDoe.ChangeViewLimit(NewLimit: integer);
begin
  inherited;

end;

//
procedure TTopicBrowserDoe.SearchText(const str: string; mode: boolean);
//var
//ret : boolean;
begin

  //ɂ킹
  if mode then
    FBrowser.SearchForward(str)
  else
    FBrowser.SearchBackward(str);
end;

procedure TTopicBrowserDoe.SetFont(fname: string; fsize: integer);
begin
//  FBrowser.Font.Pitch := fpFixed;	
//  FBrowser.SetFont(fname,fsize);

    FBrowser.SetFontEx(fname,fsize,fpFixed);
//  FBrowser.SetFontEx(fname,fsize,fpDefault);
//  FBrowser.SetFontEx(fname,fsize,fpVariable);
end;
//
// F̐ݒ
//
procedure TTopicBrowserDoe.SetHTMLColor(mes: integer; nam: integer; namelink: integer; lnk: integer; bg: integer);
begin
   // message
   FBrowser.TextAttrib[0].color := mes;			// bZ[WF
   // name
   FBrowser.TextAttrib[1].color := nam;
   FBrowser.TextAttrib[3].color := namelink;	// N̖O
   // HTTP link
   FBrowser.TextAttrib[2].color := lnk;			// N̐F
   FBrowser.Color := bg;

  FBrowser.VScrollLines := gConfig.Doe_ScrollLine;
  FBrowser.TopMargin    := gConfig.Doe_TopMargin;
  FBrowser.LeftMargin   := gConfig.Doe_LeftMargin;
  FBrowser.RightMargin  := gConfig.Doe_RightMargin;
  FBrowser.ExternalLeading := gConfig.Doe_ExternalLeading;

//FBrowser.Font.Pitch := fpFixed;	
//FBrowser.Font.Pitch := fpDefault;	
//FBrowser.Font.Pitch := fpVariable;

end;
//
//^O߂̊֐
//
function TTopicBrowserDoe.DeleteTag(strbody: string): string;
var
  intPos   : Integer;
  strRest   : string;
  strResult : string;
begin

  strRest := strbody;

  while true do
  begin
    intPos := Pos('<', strRest);
    if intPos < 1 then break;
    strResult := strResult + Copy(strRest, 1, intPos - 1);
    strRest := CopyAfter(strRest, intPos + 1);

    intPos := Pos('>', strRest);
    if intPos < 1 then break;
    strRest := CopyAfter(strRest, intPos + 1);
  end;

  strResult := strResult + strRest;
  result := StringReplace(strResult, '</', '', [rfReplaceAll]);
end;

//IDo 2005/04/14
procedure TTopicBrowserDoe.IDSearch(id: string);
begin
   FBrowser.Clear;
   FIDSearchMode := true;
   FID_forSearch := id;
   FReceivedIndex := 0;
   //`
   OutputTime(FParent);

end;

//IDo|bvAbv
procedure TTopicBrowserDoe.IDSearchPopUp(id: string);
var
  strId: string;
begin

  strId := id;
  //`FbN
  if not (Copy(strId,1,10) = 'menu://id/') then
     strId := 'menu://id/' + strId;

   BrowserStatusTextChange(FParent, strId);

end;


//wirbg}bv
procedure  TTopicBrowserDoe.SetWallpaper(g: TGraphic);
begin
   FBitmap := g;
end;
//
//
//
procedure TTopicBrowserDoe.OnMouseEnter(var msg: TMessage);
begin
  try
   //
  except
  end;
end;
//
//
//
procedure TTopicBrowserDoe.OnMouseLeave(var msg: TMessage);
//procedure TTopicBrowserDoe.OnMouseLeave;
begin
  try
    ToolTip.UnVisible;
  except
  end;
end;
//
// ׂđI
//
procedure TTopicBrowserDoe.SelectAll();
begin
  FBrowser.BeginningOfBuffer;
  FBrowser.SetMarkCommand;
  FBrowser.EndOfBuffer;
  FBrowser.Selecting := True;
end;

end.
