unit untConfig;
// INIt@C֌W

interface

uses
  Graphics,
  untHttp,
  IdCookie;

const
  APP_USERAGENT    = 'Monazilla/1.00 Katju88';
  APP_2chUA        = 'katju88';
  DIR_LOG          = 'log\';
  FILE_BOARDALIAS  = 'board.alias';
  FILE_OPTIONINI   = 'katju88.ini';
  FILE_COOKIEINI   = 'Cookie.ini';

  //dat֌W
  K88_IDX_EXT     =  '.i';
  K88_DAT_EXT     =  '.d';
  KATJU_IDX_EXT   =  '.idx';
  KATJU_DAT_EXT   =  '.dat';

type
  TBrowserType = (ubIE = 0 , ubDoe = 1);

  TConfig = class
  private
    FOptionIniPath : string;
    procedure SetProxy(Http: TAsyncHttp; ProxyString: string);
  public
    AlwaysNewTab: Boolean;
//  AutoFocus: boolean;
    AutoMouseWheel: boolean;
    AutoSort: boolean;
    BoardListViewWidth: Integer;
    BoardListNoColor: Boolean;
    BoardListOneCategory: Boolean;
    BoardListUrl: string;
    BrowserType: TBrowserType;
    CoolBarBandBreak: string;
    CoolBarBandId: string;
    CoolBarBandWidth: string;
    DefaultSage: Boolean;
    HeaderHtml: string;
    IsOffLineMode: Boolean;
    MainFormHeight: Integer;
    MainFormLeft: Integer;
    MainFormStyleSub1: Boolean;
    MainFormStyleSub2: Boolean;
    MainFormStyleSub3: Boolean;
    MainFormStyleType3: Boolean;
    MainFormTop: Integer;
    MainFormWidth: Integer;
    MainFormWindowState: Integer;
    MultiLineTab: Boolean;
    NewResHtml: string;
    NewMarkHtml: string;
    SkinPath: string;

    LogPath: string;
    LogFolderPath: string;
    LogFolder: string;

    Password: string;
    ReadProxy: string;
    ReadProxyUse: Boolean;
    ResHtml: string;
    TopicListViewColumnFontSize: Integer;
    TopicListViewColumnOrders: string;
    TopicListViewColumnPadding: Integer;
    TopicListViewColumnWidths: string;
    TopicListViewGridLines: boolean;
    TopicListViewWidth  : Integer;
    TopicListViewHeight : Integer;
    UserAgent: string;
    ViewLimit: Integer;
    WriteProxyUse : Boolean;
    WriteProxy    : String;
    DispMailAddress: boolean;

    // ֘A
    UserId: string;
    SessionID: string;
    SavePassword: boolean;
    AutoLogin: boolean;

    //݂̃NbL[ݒ
    WriteCookie: string;
    WriteCookie2: string;
    WriteCookie3: string;
    Cookies: TIdCookies;

    // OuEUݒ
    BrowserPath: string;
    InsertURL: string;
    UseDefaultBrowser: Boolean;

    //݃tH[֘A
    KoteHan: string;
    KoteMail: string;
    MailListFile: string;
    NameListFile: string;
    WriteFormWidth  : Integer;
    WriteFormHeight : Integer;
    WriteFormLeft   : Integer;
    WriteFormTop    : Integer;
    OutTime         : boolean;

    // XꗗF֘A
    TopicListColorUse: Boolean;
    TopicListFavoriteColor: TColor;
    TopicListNewMesColor: TColor;
    TopicListNewTopicColor: TColor;
    TopicListNoNewMesColor: TColor;
    TopicListNotGotColor: TColor;

    TopicListOddColorUse: Boolean;
    TopicListOddColor   : TColor;

    // BE
    BELogin: boolean;
    BEMDMD: string;
    BEDMDM: string;

    //IC/ItCݒ
    Offline: boolean;
 
    //ڑҋ@b
    CONNECT_TIMEOUT: integer;

    //摜vr[@\
    PicturePreview: boolean;

    //v
    ToukeiInfo_Board_Load: integer;
    ToukeiInfo_Thread_Load: integer;
    ToukeiInfo_Thread_Make: integer;
    ToukeiInfo_Write: integer;
    ToukeiInfo_Write_AutoCancel: integer;
    ToukeiInfo_TotalTime: double;
    ToukeiInfo_LogStart: TDateTime;
    ToukeiInfo_AppStartToday: TDateTime;
    ToukeiInfo_AppExeCount: integer;

    //DoeR|̐ݒ
    Use_DoeComponent: boolean;
    Doe_FontName: string;
    Doe_FontSize: integer;
    Doe_TextColor: TColor;
    Doe_BGColor: TColor;
    Doe_NameColor: TColor;
    Doe_NameLinkColor: TColor;
    Doe_LinkColor: TColor;
	Doe_AaReplace: boolean;
    Doe_RightClick: boolean;

    Doe_ScrollLine  : integer;
    Doe_LeftMargin  : integer;
    Doe_RightMargin : integer;
    Doe_TopMargin   : integer;
    Doe_ExternalLeading : integer;

    DoLogClear: boolean;
    LogLimitSize: integer;
    DoLogSave: boolean;

    BackupIdx: boolean;
    BackupIdxNum: integer;
    ViewThreadTitle: boolean;
    Kakikomi: boolean;
    AdjustWindow: boolean;
    AdjustWindowRange: integer;
    Mailto: boolean;
    Update: boolean;
    ReadCheck: boolean;
    CleanFolder: boolean;


    // Font
    BoardListFontName: string;
    BoardListFontSize: integer;
    BoardListFontCharset: integer;
    BoardListFontColor: TColor;
    BoardListFontStyle: integer;
    TopicListFontName: string;
    TopicListFontSize: integer;
    TopicListFontCharset: integer;
    TopicListFontColor: TColor;
    TopicListFontStyle: integer;

    constructor Create(IniPath : string);
    procedure ReadOption;
    procedure WriteOption;
    procedure InitWriteProxy(Http : TAsyncHttp);
    procedure InitReadProxy (Http : TAsyncHttp);
    procedure ParseProxy(ProxyString: string; out ProxyHost : string; out ProxyPort : Integer);
    function GetUnixTime_Now: Integer;
  end;

implementation

uses
  IniFiles, SysUtils, Forms,
  untCrypt, untTool, DateUtils;

const
  FILE_HEADERHTML    = 'Header.html';
  FILE_RESHTML       = 'Res.html';
  FILE_NEWRESHTML    = 'NewRes.html';
  FILE_NEWMARKHTML   = 'NewMark.html';
  FILE_NAMELIST      = 'namelist.txt';
  FILE_MAILLIST      = 'maillist.txt';
  SEC_MAIN           = 'Main';
  SEC_PROXY          = 'Proxy';
  SEC_MAINFORM       = 'MainForm';
  SEC_BOARDLISTBOX   = 'BoardListBox';
  SEC_TOPICLISTVIEW  = 'TopicListView';
  SEC_COOLBAR        = 'CoolBar';
  SEC_KATJU88        = 'katju88';
  SEC_LOGIN          = 'Login';
  SEC_WRITEFORM      = 'WriteForm';
  SEC_BROWSER        = 'Browser';
  SEC_ETC            = 'etc';
  KEY_SKIN           = 'Skin';
  KEY_LOGDIR         = 'LogDir';
  KEY_AUTOSORT       = 'AutoSort';
  KEY_USERAGENT      = 'UserAgent';
  KEY_BOARDLISTURL   = 'BoardListUrl';
  KEY_WRITEPROXYUSE  = 'WriteProxyUse';
  KEY_WRITEPROXY     = 'WriteProxy';
  KEY_READPROXYUSE   = 'ReadProxyUse';
  KEY_READPROXY      = 'ReadProxy';
  KEY_WINDOWSTATE    = 'WindowState';
  KEY_WIDTH          = 'Width';
  KEY_HEIGHT         = 'Height';
  KEY_TOP            = 'Top';
  KEY_LEFT           = 'Left';
  KEY_OUTTIME        = 'OutTime';
  KEY_STYLETYPE3     = 'StyleType3';
  KEY_STYLESUB1      = 'StyleSub1';
  KEY_STYLESUB2      = 'StyleSub2';
  KEY_STYLESUB3      = 'StyleSub3';
  KEY_VIEWLIMIT      = 'ViewLimit';
  KEY_COLUMNWIDTHS   = 'ColumnWidths';
  KEY_COLUMNORDERS   = 'ColumnOrders';
  KEY_COLUMNPADDING  = 'ColumnPadding';
  KEY_COLUMNFONTSIZE = 'ColumnFontSize';
  KEY_DEFAULTSAGE    = 'DefaultSage';
  KEY_BANDID         = 'BandId';
  KEY_BANDWIDTH      = 'BandWidth';
  KEY_BANDBREAK      = 'BandBreak';
  KEY_BROWSERTYPE    = 'BrowserType';
  KEY_ALWAYSNEWTAB   = 'AlwaysNewTab';
  KEY_MULTILINETAB   = 'MultiLineTab';
  KEY_AUTOLOGIN      = 'AutoLogin';
  KEY_USERID         = 'UserId';
  KEY_PASSWORD       = 'Password';
  KEY_SAVEPASSWORD   = 'SavePassword';
  KEY_GRIDLINES      = 'GridLines';
  KEY_NAMELIST       = 'NameListFile';
  KEY_MAILLIST       = 'MailListFile';
  KEY_NoColor        = 'NoColor';
  KEY_ONECATEGORY    = 'OneCategory';
  KEY_KOTEHAN        = 'KoteHan';
  KEY_KOTEMAIL       = 'KoteMail';
  KEY_USEDEFBROWSER  = 'UseDefBrowser';
  KEY_BROWSERPATH    = 'BrowserPath';
  KEY_INSERTURL      = 'InsertUrl';
//KEY_AUTOFOCUS      = 'AutoFocus';
  KEY_AUTOMOUSEWHEEL = 'AutoMouseWheel';
  KEY_USECOLOR       = 'UseColor';
  KEY_CLNOTGOT       = 'NotGotColor';
  KEY_CLFAVORITE     = 'FavoriteColor';
  KEY_CLNEWMES       = 'NewMessageColor';
  KEY_CLNONEWMES     = 'NoNewMessageColor';
  KEY_CLNEWTOPIC     = 'NewTopicColor';

  KEY_ODD_COLORUSE   = 'OddColorUse';
  KEY_ODD_COLOR      = 'OddColor';

  //NbL[֘A
  KEY_WRITECOOKIE = 'WriteCookie';
  KEY_WRITECOOKIE2 = 'WriteCookie2';
  KEY_WRITECOOKIE3 = 'WriteCookie3';

  KEY_DISPMAILADDRESS   = 'DispMailAddress';
  KEY_LOGLIMITSIZE      = 'LogLimitSize';
  KEY_DOLOGCLEAR        = 'DoLogClear';
  KEY_DOLOGSAVE         = 'DoLogSave';
  KEY_ONLINEOFFLINE     =  'Offline';
  KEY_CONNECTIONTIMEOUT = 'ConnectionTimeout';
  KEY_PICTUREPREVIEW    = 'PicturePreview';

  KEY_BACKUPIDX         = 'BackupIdx';          //
  KEY_BACKUPIDXNUM      = 'BackupIdxNum';       //
  KEY_VIEWTHREADTITLE   = 'ViewThreadTitle';
  KEY_KAKIKOMI          = 'Kakikomi';
  KEY_ADJUSTWINDOW      = 'AdjustWindow';
  KEY_ADJUSTWINDOWRANGE = 'AdjustWindowRange';
  KEY_MAILTO            = 'Mailto';
  KEY_UPDATE            = 'Update';
  KEY_READCHECK         = 'ReadCheck';
  KEY_CLEANFOLDER       = 'CleanFolder';

  //v֌W
  KEY_TOUKEIINFO_BOARD_LOAD   = 'ToukeiInfo_BoardLoad';
  KEY_TOUKEIINFO_THREAD_LOAD  = 'ToukeiInfo_ThreadLoad';
  KEY_TOUKEIINFO_THREAD_MAKE  = 'ToukeiInfo_ThreadMake';
  KEY_TOUKEIINFO_WRITE        = 'ToukeiInfo_Write';
  KEY_TOUKEIINFO_WRITE_AUTOCANCEL = 'ToukeiInfo_WriteAutoCancel';
  KEY_TOUKEIINFO_TOTALTIME    = 'ToukeiInfo_TotalTime';
  KEY_TOUKEIINFO_LOGSTART     = 'ToukeiInfo_LogStart';
  KEY_TOUKEIINFO_APPEXECOUNT  = 'ToukeiInfo_AppExeCount';

  KEY_USE_DOECOMPONENT = 'Use_DoeComponent';
  KEY_DOE_FONTNAME  = 'Doe_FontName';
  KEY_DOE_FONTSIZE  = 'Doe_FontSize';
  KEY_DOE_TEXTCOLOR = 'Doe_TextColor';
  KEY_DOE_BGCOLOR   = 'Doe_BGColor';
  KEY_DOE_NAMECOLOR = 'Doe_NameColor';
  KEY_DOE_NAMELINKCOLOR = 'Doe_NameLinkColor';
  KEY_DOE_LINKCOLOR = 'Doe_LinkColor';
  KEY_DOE_AAREPLACE = 'Doe_AaReplace';
  KEY_DOE_RIGHTCLICK= 'Doe_RightClick';

  KEY_DOE_SCROLLLINE  = 'Doe_ScrollLine';
  KEY_DOE_LEFTMARGIN  = 'Doe_LeftMargin';
  KEY_DOE_RIGHTMARGIN = 'Doe_RightMargin';
  KEY_DOE_TOPMARGIN   = 'Doe_TopMargin';
  KEY_DOE_EXTERNALLEADING = 'Doe_ExternalLeading';

  KEY_BOARDLISTFONTNAME     = 'BoardListFontName';
  KEY_BOARDLISTFONTSIZE     = 'BoardListFontSize';
  KEY_BOARDLISTFONTCHARSET  = 'BoardListFontCharset';
  KEY_BOARDLISTFONTCOLOR    = 'BoardListFontColor';
  KEY_BOARDLISTFONTSTYLE    = 'BoardListFontStyle';
  KEY_TOPICLISTFONTNAME     = 'TopicListFontName';
  KEY_TOPICLISTFONTSIZE     = 'TopicListFontSize';
  KEY_TOPICLISTFONTCHARSET  = 'TopicListFontCharset';
  KEY_TOPICLISTFONTCOLOR    = 'TopicListFontColor';
  KEY_TOPICLISTFONTSTYLE    = 'TopicListFontStyle';

  //BEOC֌W
  KEY_BELOGIN   =  'BELogin';
  KEY_MDMD      =  'MDMD';
  KEY_DMDM      =  'DMDM';

{ TConfig }

//  \bh

constructor TConfig.Create(IniPath: string);
begin
  FOptionIniPath := IniPath;
end;

procedure TConfig.ReadOption;
var
  OptionIni : TIniFile;
  strPath   : string;
begin

  OptionIni      := TIniFile.Create(FOptionIniPath);

  // Main
  ViewLimit     := OptionIni.ReadInteger(SEC_MAIN, KEY_VIEWLIMIT, 50);
  //{[h擾URL
  BoardListUrl  := OptionIni.ReadString(SEC_MAIN, KEY_BOARDLISTURL, 'http://menu.2ch.net/bbsmenu.html');
  DefaultSage   := OptionIni.ReadBool(SEC_MAIN, KEY_DEFAULTSAGE, false);
  BrowserType   := TBrowserType(OptionIni.ReadInteger(SEC_MAIn, KEY_BROWSERTYPE, 0));
  UserAgent     := OptionIni.ReadString(SEC_MAIN, KEY_USERAGENT, APP_USERAGENT);
  AlwaysNewTab  := OptionIni.ReadBool(SEC_MAIN, KEY_ALWAYSNEWTAB, false);
  MultiLineTab  := OptionIni.ReadBool(SEC_MAIN, KEY_MULTILINETAB, false);
//AutoFocus     := OptionIni.ReadBool(SEC_MAIN, KEY_AUTOFOCUS, false);
  AutoMouseWheel:= OptionIni.ReadBool(SEC_MAIN, KEY_AUTOMOUSEWHEEL, true);

  //ڑҋ@bVinit@CŎ
  //ftHg10000~b10b
  CONNECT_TIMEOUT := OptionIni.ReadInteger(SEC_MAIN, KEY_CONNECTIONTIMEOUT,10000);

  //摜vr[
  PicturePreview := OptionIni.ReadBool(SEC_MAIN, KEY_PICTUREPREVIEW,true);

  //v
  ToukeiInfo_Board_Load := OptionIni.ReadInteger(SEC_MAIN, KEY_TOUKEIINFO_BOARD_LOAD,0);
  ToukeiInfo_Thread_Load := OptionIni.ReadInteger(SEC_MAIN, KEY_TOUKEIINFO_THREAD_LOAD,0);
  ToukeiInfo_Thread_Make := OptionIni.ReadInteger(SEC_MAIN, KEY_TOUKEIINFO_THREAD_MAKE,0);
  ToukeiInfo_Write := OptionIni.ReadInteger(SEC_MAIN, KEY_TOUKEIINFO_WRITE,0);
  ToukeiInfo_Write_AutoCancel := OptionIni.ReadInteger(SEC_MAIN, KEY_TOUKEIINFO_WRITE_AUTOCANCEL,0);
  ToukeiInfo_TotalTime := OptionIni.ReadFloat(SEC_MAIN, KEY_TOUKEIINFO_TOTALTIME,0);
  ToukeiInfo_LogStart := OptionIni.ReadDateTime(SEC_MAIN, KEY_TOUKEIINFO_LOGSTART,Now);
  ToukeiInfo_AppStartToday := Now;
  ToukeiInfo_AppExeCount := OptionIni.ReadInteger(SEC_MAIN, KEY_TOUKEIINFO_APPEXECOUNT,0) + 1;

  //DoeR|[lg
  Use_DoeComponent := OptionIni.ReadBool(SEC_MAIN, KEY_USE_DOECOMPONENT, true);
  Doe_FontName := OptionIni.ReadString(SEC_MAIN, KEY_DOE_FONTNAME,'lr oSVbN');
  Doe_FontSize := OptionIni.ReadInteger(SEC_MAIN, KEY_DOE_FONTSIZE,10);

  DispMailAddress := OptionIni.ReadBool(SEC_MAIN, KEY_DISPMAILADDRESS, true);
  DoLogClear := OptionIni.ReadBool(SEC_MAIN, KEY_DOLOGCLEAR, false);
  LogLimitSize := OptionIni.ReadInteger(SEC_MAIN, KEY_LOGLIMITSIZE, 20);
  DoLogSave := OptionIni.ReadBool(SEC_MAIN, KEY_DOLOGSAVE, true);

  //IC/ItCݒ
  Offline := OptionIni.ReadBool(SEC_MAIN, KEY_ONLINEOFFLINE, false);

  // Proxy
  WriteProxyUse := OptionIni.ReadBool(  SEC_PROXY, KEY_WRITEPROXYUSE, false);
  WriteProxy    := OptionIni.ReadString(SEC_PROXY, KEY_WRITEPROXY,    '');
  ReadProxyUse  := OptionIni.ReadBool(  SEC_PROXY, KEY_READPROXYUSE,  false);
  ReadProxy     := OptionIni.ReadString(SEC_PROXY, KEY_READPROXY,     '');

  // MainForm Layout
  MainFormWindowState := OptionIni.ReadInteger(SEC_MAINFORM, KEY_WINDOWSTATE, Integer(wsNormal));
  MainFormWidth       := OptionIni.ReadInteger(SEC_MAINFORM, KEY_WIDTH,  600);
  MainFormHeight      := OptionIni.ReadInteger(SEC_MAINFORM, KEY_HEIGHT, 500);
  MainFormLeft        := OptionIni.ReadInteger(SEC_MAINFORM, KEY_LEFT,   10);
  MainFormTop         := OptionIni.ReadInteger(SEC_MAINFORM, KEY_TOP,    10);
  MainFormStyleType3  := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLETYPE3, false);
  MainFormStyleSub1   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB1,  false);
  MainFormStyleSub2   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB2,  false);
  MainFormStyleSub3   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB3,  false);
  BoardListViewWidth  := OptionIni.ReadInteger(SEC_BOARDLISTBOX,  KEY_WIDTH,  120);
  BoardListNoColor    := OptionIni.ReadBool(SEC_BOARDLISTBOX, KEY_NoColor, true);
  BoardListOneCategory:= OptionIni.ReadBool(SEC_BOARDLISTBOX, KEY_ONECATEGORY, False);
  TopicListViewWidth  := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_WIDTH,  300);
  TopicListViewHeight := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_HEIGHT, 100);
  TopicListViewColumnOrders := OptionIni.ReadString(SEC_TOPICLISTVIEW, KEY_COLUMNORDERS, '0,1,2,3,4,5,6,8,7,9,10,');
  TopicListViewColumnWidths := OptionIni.ReadString(SEC_TOPICLISTVIEW, KEY_COLUMNWIDTHS, '0,0,47,389,40,40,33,130,130,50,30,');
  TopicListViewColumnPadding := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_COLUMNPADDING, 2);
  TopicListViewColumnFontSize := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_COLUMNFONTSIZE, 9);
  TopicListViewGridLines      := OptionIni.ReadBool   (SEC_TOPICLISTVIEW, KEY_GRIDLINES, false);
  CoolBarBandId             := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDID, '');
  CoolBarBandWidth          := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDWIDTH, '');
  CoolBarBandBreak          := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDBREAK, '');

  // OuEUݒ
  UseDefaultBrowser := OptionIni.ReadBool  (SEC_BROWSER, KEY_USEDEFBROWSER, False);
  BrowserPath       := OptionIni.ReadString(SEC_BROWSER, KEY_BROWSERPATH,   '');
  InsertURL         := OptionIni.ReadString(SEC_BROWSER, KEY_INSERTURL,     '');

  // etc
  LogPath := OptionIni.ReadString(SEC_ETC, KEY_LOGDIR, '');
  if LogPath = '' then
  begin
    LogFolderPath := AppPath('');
    LogFolder  := DIR_LOG;
  end else
  begin
    LogFolderPath := ExtractFileDir(LogPath)+'\';
    LogFolder  := ExtractFileName(LogPath)+'\';
  end;

  SkinPath := OptionIni.ReadString(SEC_ETC, KEY_SKIN, '');
//SkinPath := OptionIni.ReadString(SEC_ETC, KEY_SKIN, ExtractFilePath(Application.ExeName) );  // 2008.06.26
  AutoSort := OptionIni.ReadBool(SEC_ETC, KEY_AUTOSORT, False);

  // wb_pHTML
  if SkinPath = '' then
  strPath := AppPath(FILE_HEADERHTML)
  else
//strPath := SkinPath +'\'+ FILE_HEADERHTML;
  strPath := IncludeTrailingPathDelimiter(SkinPath) + FILE_HEADERHTML;

  if FileExists(strPath) then
    HeaderHtml := GetFile(strPath)
  else
  if FileExists(ChangeFileExt(strPath, '.htm')) then
    HeaderHtml := GetFile(ChangeFileExt(strPath, '.htm'))
  else
    HeaderHtml := '<html lang="ja"><body><font face="lr oSVbN"><dl>';

  // X\pHTML
  if SkinPath = '' then
  strPath := AppPath(FILE_RESHTML)
  else
//strPath := SkinPath +'\'+ FILE_RESHTML;
  strPath := IncludeTrailingPathDelimiter(SkinPath) + FILE_RESHTML;

  if FileExists(strPath) then
  begin
    ResHtml := GetFile(strPath);
  end else if FileExists(ChangeFileExt(strPath, '.htm')) then
  begin
    ResHtml := GetFile(ChangeFileExt(strPath, '.htm'));
  end else
  begin
    ResHtml := '<dt><NUMBER/> OF<font color="forestgreen"><MAILNAME/></font> eF<DATE/></dt><dd><MESSAGE/><br></dd><br><br>';
  end;

  // VX\pHTML
  if SkinPath = '' then
    strPath := AppPath(FILE_NEWRESHTML)
  else
//  strPath := SkinPath +'\'+ FILE_NEWRESHTML;
    strPath := IncludeTrailingPathDelimiter(SkinPath) + FILE_NEWRESHTML;

  if FileExists(strPath) then
  begin
    NewResHtml := GetFile(strPath);
  end else if FileExists(ChangeFileExt(strPath, '.htm')) then
  begin
    NewResHtml := GetFile(ChangeFileExt(strPath, '.htm'));
  end else
  begin
    NewResHtml := '<dt><b><NUMBER/></b> OF<font color="forestgreen"><MAILNAME/></font> eF<DATE/></dt><dd><MESSAGE/><br></dd><br><br>';
  end;

  // NewMarkHtml\
  if SkinPath = '' then
  strPath := AppPath(FILE_NEWMARKHTML)
  else
//strPath := SkinPath +'\'+ FILE_NEWMARKHTML;
  strPath := IncludeTrailingPathDelimiter(SkinPath) + FILE_NEWMARKHTML;

  if FileExists(strPath) then
  begin
    NewMarkHtml := GetFile(strPath);
  end else if FileExists(ChangeFileExt(strPath, '.htm')) then
  begin
    NewMarkHtml := GetFile(ChangeFileExt(strPath, '.htm'));
  end else
  begin
    NewMarkHtml := '';
  end;

  // Dolib֘A
  AutoLogin    := OptionIni.ReadBool  (SEC_LOGIN, KEY_AUTOLOGIN,    false);
  UserId       := Decrypt(OptionIni.ReadString(SEC_LOGIN, KEY_USERID,  ''));
  Password     := Decrypt(OptionIni.ReadString(SEC_LOGIN, KEY_PASSWORD,''));
  SavePassword := OptionIni.ReadBool  (SEC_LOGIN, KEY_SAVEPASSWORD, false);

  BELogin     := OptionIni.ReadBool(SEC_LOGIN, KEY_BELOGIN, false);
  BEMDMD      := OptionIni.ReadString(SEC_LOGIN, KEY_MDMD, '');
  BEDMDM      := OptionIni.ReadString(SEC_LOGIN, KEY_DMDM, '');

  // ݊֘A
  NameListFile    := OptionIni.ReadString(SEC_WRITEFORM, KEY_NAMELIST, FILE_NAMELIST);
  MailListFile    := OptionIni.ReadString(SEC_WRITEFORM, KEY_MAILLIST, FILE_MAILLIST);
  WriteFormWidth  := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_WIDTH,  450);
  WriteFormHeight := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_HEIGHT, 370);
  WriteFormLeft   := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_LEFT,   385);
  WriteFormTop    := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_TOP,    180);
  OutTime         := OptionIni.ReadBool(SEC_WRITEFORM, KEY_OUTTIME,False);
  KoteHan         := OptionIni.ReadString (SEC_WRITEFORM, KEY_KOTEHAN,  '');
  KoteMail        := OptionIni.ReadString (SEC_WRITEFORM, KEY_KOTEMAIL, '');

  // XꗗF֘A
  TopicListColorUse      := OptionIni.ReadBool   (SEC_TOPICLISTVIEW, KEY_USECOLOR,   True);
  TopicListNotGotColor   := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNOTGOT,   clBlack);
  TopicListFavoriteColor := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLFAVORITE, clBlack);
  TopicListNewMesColor   := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNEWMES,   16711680);
  TopicListNoNewMesColor := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNONEWMES, clBlack);
  TopicListNewTopicColor := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNEWTOPIC, 4227327);

  TopicListOddColorUse   := OptionIni.ReadBool   (SEC_TOPICLISTVIEW, KEY_ODD_COLORUSE, True);
  TopicListOddColor      := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_ODD_COLOR, 15201022);

  // DoezF֘A
  Doe_TextColor := OptionIni.ReadInteger(SEC_MAIN, KEY_DOE_TEXTCOLOR, clBlack);
  Doe_BGColor := OptionIni.ReadInteger(SEC_MAIN, KEY_DOE_BGCOLOR, clWhite);
  Doe_NameColor := OptionIni.ReadInteger(SEC_MAIN, KEY_DOE_NAMECOLOR, clGreen);
  Doe_NameLinkColor := OptionIni.ReadInteger(SEC_MAIN, KEY_DOE_NAMELINKCOLOR, clBlue);
  Doe_LinkColor := OptionIni.ReadInteger(SEC_MAIN, KEY_DOE_LINKCOLOR, clBlue);

  Doe_AaReplace := OptionIni.ReadBool(SEC_MAIN, KEY_DOE_AAREPLACE, True);		// 2009.03.09
  Doe_RightClick:= OptionIni.ReadBool(SEC_MAIN, KEY_DOE_RIGHTCLICK, True);		// 2008.06.10

  Doe_ScrollLine  := OptionIni.ReadInteger(SEC_MAIN, KEY_DOE_SCROLLLINE,  3);
  Doe_LeftMargin  := OptionIni.ReadInteger(SEC_MAIN, KEY_DOE_LEFTMARGIN, 15);
  Doe_RightMargin := OptionIni.ReadInteger(SEC_MAIN, KEY_DOE_RIGHTMARGIN,20);
  Doe_TopMargin   := OptionIni.ReadInteger(SEC_MAIN, KEY_DOE_TOPMARGIN,  15);
  Doe_ExternalLeading := OptionIni.ReadInteger(SEC_MAIN, KEY_DOE_EXTERNALLEADING, 1);

  // xxxxxxxx.idxobNAbv 2008.05.12
  BackupIdx    := OptionIni.ReadBool(SEC_MAIN, KEY_BACKUPIDX, False);
  BackupIdxNum := OptionIni.ReadInteger(SEC_MAIN, KEY_BACKUPIDXNUM, 10);
  ViewThreadTitle := OptionIni.ReadBool(SEC_MAIN, KEY_VIEWTHREADTITLE, True);
  Kakikomi := OptionIni.ReadBool(SEC_MAIN, KEY_KAKIKOMI, False);
  AdjustWindow      := OptionIni.ReadBool(SEC_MAIN, KEY_ADJUSTWINDOW, True);
  AdjustWindowRange := OptionIni.ReadInteger(SEC_MAIN, KEY_ADJUSTWINDOWRANGE, 8);
  Mailto := OptionIni.ReadBool(SEC_MAIN, KEY_MAILTO, False);
  //20130512 XV͂Ȃ悤ɂ
  //Update := OptionIni.ReadBool(SEC_MAIN, KEY_UPDATE, TRUE);
  Update := false;
  ReadCheck := OptionIni.ReadBool(SEC_MAIN, KEY_READCHECK, FALSE);
  CleanFolder := OptionIni.ReadBool(SEC_MAIN, KEY_CLEANFOLDER, FALSE);

  BoardListFontName     := OptionIni.ReadString(SEC_BOARDLISTBOX, KEY_BOARDLISTFONTNAME,'lr oSVbN');
  BoardListFontSize     := OptionIni.ReadInteger(SEC_BOARDLISTBOX, KEY_BOARDLISTFONTSIZE,9);
//BoardListFontCharset  := OptionIni.ReadInteger(SEC_BOARDLISTBOX, KEY_BOARDLISTFONTCHARSET,TFontCharSet(SHIFTJIS_CHARSET));
  BoardListFontCharset  := OptionIni.ReadInteger(SEC_BOARDLISTBOX, KEY_BOARDLISTFONTCHARSET,128);
  BoardListFontColor    := OptionIni.ReadInteger(SEC_BOARDLISTBOX, KEY_BOARDLISTFONTCOLOR,clBlack);
  BoardListFontStyle    := OptionIni.ReadInteger(SEC_BOARDLISTBOX, KEY_BOARDLISTFONTSTYLE,0);

  TopicListFontName    := OptionIni.ReadString(SEC_TOPICLISTVIEW, KEY_TOPICLISTFONTNAME,'lr oSVbN');
  TopicListFontSize    := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_TOPICLISTFONTSIZE,9);
  TopicListFontCharset := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_TOPICLISTFONTCHARSET,128);
  TopicListFontColor   := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_TOPICLISTFONTCOLOR,clBlack);
  TopicListFontStyle   := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_TOPICLISTFONTSTYLE,0);

  //݃NbL[
  WriteCookie := OptionIni.ReadString(SEC_ETC, KEY_WRITECOOKIE, '');
  WriteCookie2 := OptionIni.ReadString(SEC_ETC, KEY_WRITECOOKIE2, '');
  WriteCookie3 := OptionIni.ReadString(SEC_ETC, KEY_WRITECOOKIE3, '');

  Cookies := nil;

  OptionIni.Free;
end;

procedure TConfig.WriteOption;
var
  OptionIni : TIniFile;
begin
  OptionIni := TIniFile.Create(FOptionIniPath);

  // Main
  OptionIni.WriteString(SEC_MAIN, KEY_BOARDLISTURL, BoardListUrl);
  OptionIni.WriteInteger(SEC_MAIN, KEY_VIEWLIMIT, ViewLimit);
  OptionIni.WriteBool(SEC_MAIN, KEY_DEFAULTSAGE, DefaultSage);
  OptionIni.WriteInteger(SEC_MAIn, KEY_BROWSERTYPE, Integer(BrowserType));
  OptionIni.WriteBool(SEC_MAIN, KEY_ALWAYSNEWTAB, AlwaysNewTab);
  OptionIni.WriteBool(SEC_MAIN, KEY_MULTILINETAB, MultiLineTab);
//OptionIni.WriteBool(SEC_MAIN, KEY_AUTOFOCUS, AutoFocus);
  OptionIni.WriteBool(SEC_MAIN, KEY_AUTOMOUSEWHEEL, AutoMouseWheel);

  OptionIni.WriteBool(SEC_MAIN, KEY_DISPMAILADDRESS, DispMailAddress);
  OptionIni.WriteInteger(SEC_MAIN, KEY_LOGLIMITSIZE, LogLimitSize);
  OptionIni.WriteBool(SEC_MAIN, KEY_DOLOGCLEAR, DoLogClear);
  OptionIni.WriteBool(SEC_MAIN, KEY_DOLOGSAVE, DoLogSave);

  //IC/ItCݒ
  OptionIni.WriteBool(SEC_MAIN,KEY_ONLINEOFFLINE,Offline);

  //ڑҋ@b
  OptionIni.WriteInteger(SEC_MAIN, KEY_CONNECTIONTIMEOUT,CONNECT_TIMEOUT);
  //摜vr[@\
  OptionIni.WriteBool(SEC_MAIN,KEY_PICTUREPREVIEW,PicturePreview);

  //v
  OptionIni.WriteInteger(SEC_MAIN,KEY_TOUKEIINFO_BOARD_LOAD,ToukeiInfo_Board_Load);
  OptionIni.WriteInteger(SEC_MAIN,KEY_TOUKEIINFO_THREAD_LOAD,ToukeiInfo_Thread_Load);
  OptionIni.WriteInteger(SEC_MAIN,KEY_TOUKEIINFO_THREAD_MAKE,ToukeiInfo_Thread_Make);
  OptionIni.WriteInteger(SEC_MAIN, KEY_TOUKEIINFO_WRITE,ToukeiInfo_Write);
  OptionIni.WriteInteger(SEC_MAIN,KEY_TOUKEIINFO_WRITE_AUTOCANCEL,ToukeiInfo_Write_AutoCancel);
  OptionIni.WriteFloat(SEC_MAIN, KEY_TOUKEIINFO_TOTALTIME,ToukeiInfo_TotalTime);
  OptionIni.WriteDateTime(SEC_MAIN,KEY_TOUKEIINFO_LOGSTART,ToukeiInfo_LogStart);
  OptionIni.WriteInteger(SEC_MAIN,KEY_TOUKEIINFO_APPEXECOUNT,ToukeiInfo_AppExeCount);

  //IC/ItCݒ
  OptionIni.WriteBool(SEC_MAIN,KEY_USE_DOECOMPONENT,Use_DoeComponent);
  OptionIni.WriteString(SEC_MAIN,KEY_DOE_FONTNAME,Doe_FontName);
  OptionIni.WriteInteger(SEC_MAIN,KEY_DOE_FONTSIZE,Doe_FontSize);

  // Proxy
  OptionIni.WriteBool(  SEC_PROXY, KEY_WRITEPROXYUSE, WriteProxyUse);
  OptionIni.WriteString(SEC_PROXY, KEY_WRITEPROXY,    WriteProxy);
  OptionIni.WriteBool(  SEC_PROXY, KEY_READPROXYUSE,  ReadProxyUse);
  OptionIni.WriteString(SEC_PROXY, KEY_READPROXY,     ReadProxy);

  // MainForm Layout
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_WINDOWSTATE, MainFormWindowState);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_WIDTH,       MainFormWidth);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_HEIGHT,      MainFormHeight);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_LEFT,        MainFormLeft);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_TOP,         MainFormTop);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLETYPE3, MainFormStyleType3);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB1,  MainFormStyleSub1);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB2,  MainFormStyleSub2);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB3,  MainFormStyleSub3);
  OptionIni.WriteInteger(SEC_BOARDLISTBOX,  KEY_WIDTH,   BoardListViewWidth);
  OptionIni.WriteBool(SEC_BOARDLISTBOX, KEY_NOCOLOR,     BoardListNoColor);
  OptionIni.WriteBool(SEC_BOARDLISTBOX, KEY_ONECATEGORY, BoardListOneCategory);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_WIDTH,        TopicListViewWidth);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_HEIGHT,       TopicListViewHeight);
  OptionIni.WriteString (SEC_TOPICLISTVIEW, KEY_COLUMNWIDTHS, TopicListViewColumnWidths);
  OptionIni.WriteString (SEC_TOPICLISTVIEW, KEY_COLUMNORDERS, TopicListViewColumnOrders);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_COLUMNPADDING, TopicListViewColumnPadding);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_COLUMNFONTSIZE, TopicListViewColumnFontSize);
  OptionIni.WriteBool   (SEC_TOPICLISTVIEW, KEY_GRIDLINES, TopicListViewGridLines);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDID, CoolBarBandId);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDWIDTH, CoolBarBandWidth);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDBREAK, CoolBarBandBreak);

  // OuEUݒ
  OptionIni.WriteBool  (SEC_BROWSER, KEY_USEDEFBROWSER, UseDefaultBrowser);
  OptionIni.WriteString(SEC_BROWSER, KEY_BROWSERPATH,   BrowserPath);
  OptionIni.WriteString(SEC_BROWSER, KEY_INSERTURL,     InsertURL);

  // Dolib֘A
  OptionIni.WriteBool  (SEC_LOGIN, KEY_AUTOLOGIN,    AutoLogin);
  OptionIni.WriteString(SEC_LOGIN, KEY_USERID,       Crypt(UserId));
  OptionIni.WriteBool  (SEC_LOGIN, KEY_SAVEPASSWORD, SavePassword);

  OptionIni.WriteBool(SEC_LOGIN, KEY_BELOGIN, BELogin);

  //BEOC̃[ƃR[hޏ̒ǉ
  OptionIni.WriteString(SEC_LOGIN, KEY_DMDM, BEDMDM);
  OptionIni.WriteString(SEC_LOGIN, KEY_MDMD, BEMDMD);

  if SavePassword then
    OptionIni.WriteString(SEC_LOGIN, KEY_PASSWORD,   Crypt(Password))
  else
    OptionIni.DeleteKey(SEC_LOGIN, KEY_PASSWORD);

  // ݊֘A
  OptionIni.WriteString(SEC_WRITEFORM, KEY_NAMELIST, NameListFile);
  OptionIni.WriteString(SEC_WRITEFORM, KEY_MAILLIST, MailListFile);
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_WIDTH,  WriteFormWidth);
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_HEIGHT, WriteFormHeight);
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_LEFT,   WriteFormLeft);
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_TOP,    WriteFormTop);
//OptionIni.WriteInteger(SEC_WRITEFORM, KEY_OUTTIME,            );
  OptionIni.WriteString (SEC_WRITEFORM, KEY_KOTEHAN,  KoteHan);
  OptionIni.WriteString (SEC_WRITEFORM, KEY_KOTEMAIL, KoteMail);

  // XꗗF֘A
  OptionIni.WriteBool   (SEC_TOPICLISTVIEW, KEY_USECOLOR,   TopicListColorUse);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNOTGOT,   TopicListNotGotColor);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLFAVORITE, TopicListFavoriteColor);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNEWMES,   TopicListNewMesColor);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNONEWMES, TopicListNoNewMesColor);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNEWTOPIC, TopicListNewTopicColor);


  OptionIni.WriteBool(SEC_TOPICLISTVIEW, KEY_ODD_COLORUSE, TopicListOddColorUse);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_ODD_COLOR, TopicListOddColor);

  // DoezF֘A
  OptionIni.WriteInteger(SEC_MAIN, KEY_DOE_TEXTCOLOR, Doe_TextColor);
  OptionIni.WriteInteger(SEC_MAIN, KEY_DOE_BGCOLOR, Doe_BGColor);
  OptionIni.WriteInteger(SEC_MAIN, KEY_DOE_NAMECOLOR, Doe_NameColor);
  OptionIni.WriteInteger(SEC_MAIN, KEY_DOE_NAMELINKCOLOR, Doe_NameLinkColor);
  OptionIni.WriteInteger(SEC_MAIN, KEY_DOE_LINKCOLOR, Doe_LinkColor);

  OptionIni.WriteBool(SEC_MAIN, KEY_DOE_AAREPLACE, Doe_AaReplace);
  OptionIni.WriteBool(SEC_MAIN, KEY_DOE_RIGHTCLICK, Doe_RightClick);

  OptionIni.WriteInteger(SEC_MAIN, KEY_DOE_SCROLLLINE, Doe_ScrollLine);
  OptionIni.WriteInteger(SEC_MAIN, KEY_DOE_LEFTMARGIN, Doe_LeftMargin);
  OptionIni.WriteInteger(SEC_MAIN, KEY_DOE_RIGHTMARGIN,Doe_RightMargin);
  OptionIni.WriteInteger(SEC_MAIN, KEY_DOE_TOPMARGIN,  Doe_TopMargin);
  OptionIni.WriteInteger(SEC_MAIN, KEY_DOE_EXTERNALLEADING, Doe_ExternalLeading);

  // etc
  OptionIni.WriteString(SEC_ETC, KEY_LOGDIR, LogPath);

  OptionIni.WriteString(SEC_ETC, KEY_SKIN, SkinPath);
  OptionIni.WriteBool(SEC_ETC, KEY_AUTOSORT, AutoSort);

  // xxxxxxxx.idxobNAbv 2008.05.12
  OptionIni.WriteBool(SEC_MAIN, KEY_BACKUPIDX, BackupIdx);
  OptionIni.WriteInteger(SEC_MAIN, KEY_BACKUPIDXNUM, BackupIdxNum);
  OptionIni.WriteBool(SEC_MAIN, KEY_VIEWTHREADTITLE, ViewThreadTitle);
  OptionIni.WriteBool(SEC_MAIN, KEY_KAKIKOMI, Kakikomi);
  OptionIni.WriteBool(SEC_MAIN, KEY_ADJUSTWINDOW, AdjustWindow);
  OptionIni.WriteInteger(SEC_MAIN, KEY_ADJUSTWINDOWRANGE, AdjustWindowRange);
  OptionIni.WriteBool(SEC_MAIN, KEY_MAILTO, Mailto);
  OptionIni.WriteBool(SEC_MAIN, KEY_UPDATE, Update);
  OptionIni.WriteBool(SEC_MAIN, KEY_READCHECK, ReadCheck);
  OptionIni.WriteBool(SEC_MAIN, KEY_CLEANFOLDER, CleanFolder);

  OptionIni.WriteString(SEC_BOARDLISTBOX, KEY_BOARDLISTFONTNAME,BoardListFontName);
  OptionIni.WriteInteger(SEC_BOARDLISTBOX, KEY_BOARDLISTFONTSIZE,BoardListFontSize);
  OptionIni.WriteInteger(SEC_BOARDLISTBOX, KEY_BOARDLISTFONTCHARSET,BoardListFontCharset);
  OptionIni.WriteInteger(SEC_BOARDLISTBOX, KEY_BOARDLISTFONTCOLOR,BoardListFontColor);
  OptionIni.WriteInteger(SEC_BOARDLISTBOX, KEY_BOARDLISTFONTSTYLE,BoardListFontStyle);

  OptionIni.WriteString(SEC_TOPICLISTVIEW, KEY_TOPICLISTFONTNAME,TopicListFontName);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_TOPICLISTFONTSIZE,TopicListFontSize);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_TOPICLISTFONTCHARSET,TopicListFontCharset);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_TOPICLISTFONTCOLOR,TopicListFontColor);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_TOPICLISTFONTSTYLE,TopicListFontStyle);

  //݃NbL[
  OptionIni.WriteString(SEC_ETC, KEY_WRITECOOKIE, WriteCookie);
  OptionIni.WriteString(SEC_ETC, KEY_WRITECOOKIE2, WriteCookie2);
  OptionIni.WriteString(SEC_ETC, KEY_WRITECOOKIE3, WriteCookie3);
  
  OptionIni.Free;
end;

procedure TConfig.SetProxy(Http: TAsyncHttp; ProxyString : string);
var
  host : string;
  port : integer;
begin
  ParseProxy(ReadProxy, host, port);
  Http.ProxyHost := host;
  Http.ProxyPort := port;
end;

procedure TConfig.InitReadProxy(Http: TAsyncHttp);
begin
  if ReadProxyUse then
    SetProxy(Http, ReadProxy);
end;

procedure TConfig.InitWriteProxy(Http: TAsyncHttp);
begin
  if WriteProxyUse then
    SetProxy(Http, WriteProxy);
end;

procedure TConfig.ParseProxy(ProxyString: string; out ProxyHost: string;
  out ProxyPort: Integer);
var
  proxyitem : TStringArray;
begin

  SetLength(proxyitem, 0);
  if ProxyString <> '' then
  begin
    proxyitem := Split(ProxyString, ':');
    if length(proxyitem) >= 2 then
      proxyport := StrToIntNeo(proxyitem[1])
    else
      proxyport := 8080;
    proxyhost := proxyitem[0];
  end;

end;

function TConfig.GetUnixTime_Now: Integer;
var
  intTime: Integer;
begin

  //20140309 UnixԂ̌vZ

  //Unixԁ1970N11 00:00:00̌oߕb
  //86400P̕b 60*60*24
  //32400GMTƓ{Ԃ̍AXԕ̕b 60*60*9

  //2ch͌ݎԈȍ~Ȁ݂֎~ĂāÂƂ
  //uuEU𗧂グȂĂ݂ĂṽG[ɂȂ
  //ݎzĂ͂Ȃ

  intTime := Trunc( (Now - EncodeDate(1970, 1, 1) ) * 86400) - 32400;
  //5bĖmɉߋ̎ɂĂ
  intTime := intTime -5;

  result := intTime;
end;

end.
