unit untLogSweeperForm;

interface

uses
  Controls, Forms, Classes, StdCtrls,
  untLogSweeper, untBoardList;

type
  TLogSweeperForm = class(TForm)
    LimitEdit: TEdit;
    ExecuteButton: TButton;
    CancelButton: TButton;
    Label1: TLabel;
    NoEraseMarkTopicCheckBox: TCheckBox;
    procedure ExecuteButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
    FCanceled: boolean;
    FLogSweeper: TLogSweeper;
    procedure LogComplete(Sender: TObject);
  public
    { Public 錾 }
    BoardList: TBoardList;
  end;

var
  LogSweeperForm: TLogSweeperForm;

implementation

{$R *.dfm}

uses
  SysUtils, Dialogs, 
  untGlobal;

procedure TLogSweeperForm.ExecuteButtonClick(Sender: TObject);
begin
  try
    StrToInt(LimitEdit.Text);
  except
    ShowMessage('͂Ă');
    exit;
  end;
  ExecuteButton.Enabled := false;

  FCanceled := false;
  FLogSweeper := TLogSweeper.Create;
  FLogSweeper.FreeOnTerminate := true;
  FLogSweeper.OnTerminate := LogComplete;
  FLogSweeper.LogLimitSize := StrToInt(LimitEdit.Text);
  FLogSweeper.BoardList := BoardList; 
  FLogSweeper.Resume;
end;

procedure TLogSweeperForm.CancelButtonClick(Sender: TObject);
begin
  if Assigned(FLogSweeper) then
  begin
    FLogSweeper.Terminate;
  end;

  FCanceled := true;

  ExecuteButton.Enabled := true;
  Close;
end;

procedure TLogSweeperForm.FormCreate(Sender: TObject);
begin
  LimitEdit.Text := IntToStr(gConfig.LogLimitSize);
end;

procedure TLogSweeperForm.LogComplete(Sender: TObject);
begin
  ExecuteButton.Enabled := true;
  if not FCanceled then
  begin
    ShowMessage('I܂');
  end;
end;

end.
