unit untLoginForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TLoginForm = class(TForm)
    UserIdEdit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    PasswordEdit: TEdit;
    SavePasswordCheckBox: TCheckBox;
    LoginButton: TButton;
    CloseButton: TButton;
    AutoLoginCheckBox: TCheckBox;
    LogoutButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure LoginButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure SavePasswordCheckBoxClick(Sender: TObject);
    procedure LogoutButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  LoginForm: TLoginForm;

implementation

uses
  untGlobal;

{$R *.dfm}

procedure TLoginForm.FormCreate(Sender: TObject);
begin
  UserIdEdit.Text              := gConfig.UserId;
  PasswordEdit.Text            := gConfig.Password;
  SavePasswordCheckBox.Checked := gConfig.SavePassword;
  AutoLoginCheckBox.Checked    := gConfig.AutoLogin;

  SavePasswordCheckBoxClick(self);
end;

procedure TLoginForm.LoginButtonClick(Sender: TObject);
var
  blRet: boolean;

begin
  gConfig.UserId       := UserIdEdit.Text;
  gConfig.Password     := PasswordEdit.Text;
  gConfig.SavePassword := SavePasswordCheckBox.Checked;
  gConfig.AutoLogin    := AutoLoginCheckBox.Checked and SavePasswordCheckBox.Checked;

  blRet := gDolibLogin.Login;

  if (blRet) then
  begin
	if SavePasswordCheckBox.Checked=false then
      gConfig.Password:='';

    close;
  end;
end;

procedure TLoginForm.CloseButtonClick(Sender: TObject);
begin
  if SavePasswordCheckBox.Checked=true then
  begin
    gConfig.Password     := PasswordEdit.Text;
  end else
  begin
    gConfig.Password     := '';
  end;

  gConfig.UserId       := UserIdEdit.Text;
  gConfig.SavePassword := SavePasswordCheckBox.Checked;
  gConfig.AutoLogin    := AutoLoginCheckBox.Checked and SavePasswordCheckBox.Checked;

  Close;
end;

procedure TLoginForm.LogoutButtonClick(Sender: TObject);
begin
  gConfig.SessionID := '';
  close;
end;

procedure TLoginForm.SavePasswordCheckBoxClick(Sender: TObject);
begin
//AutoLoginCheckBox.Enabled := SavePasswordCheckBox.Checked;

	if SavePasswordCheckBox.Checked=false then
    begin
      AutoLoginCheckBox.Checked:=false;
      AutoLoginCheckBox.Enabled:=false;
    end else
    begin
      AutoLoginCheckBox.Enabled:=true;
    end;
end;


end.
