unit untMainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes,
  Controls, Forms, Dialogs, ComCtrls, StdCtrls, ToolWin,
  Menus, Contnrs, Taskbar, ActnList, ExtCtrls, ImgList,Math,
  IdBaseComponent, IdComponent, untDoeSearchForm,
  untBoard, untBoardList, untTopicBrowser, untWriteForm, untTool,
  untGlobal, untTopic, untBoardCategory, untTopicListView, untBoardListView,
  AppEvnts;

type
  TMainForm = class(TForm)
    AddressToolBar : TToolBar;
    GoToToolButton : TToolButton;
    ToolBarImageList: TImageList;
    TopicListViewImageList: TImageList;
    Splitter1: TSplitter;
    RightPanel: TPanel;
    Splitter2: TSplitter;
    BrowserPanel: TPanel;
    TopicToolBar: TToolBar;
    DownloadTopicToolButton: TToolButton;
    ToolButton8: TToolButton;
    ToolButton12: TToolButton;
    TopicWriteToolButton: TToolButton;
    FavoriteToolButton: TToolButton;
    TrashToolButton: TToolButton;
    CloseTabToolButton: TToolButton;
    TopicListViewPopupMenu: TPopupMenu;
    OpenNewTabMenuItem: TMenuItem;
    BoardNameLabel: TLabel;
    TopicNameLabel: TLabel;
    TopicPagePopupMenu: TPopupMenu;
    CloseMenuItem: TMenuItem;
    CloseAllMenuItem: TMenuItem;
    CloseWithoutMenuItem: TMenuItem;
    CopyUrlMenuItem: TMenuItem;
    CopyTitleUrlMenuItem: TMenuItem;
    OpenByBrowserMenuItem: TMenuItem;
    N01: TMenuItem;
    N7: TMenuItem;
    AutoReloadMenuItem: TMenuItem;
    TopicTabControl: TTabControl;
    ToolPopupMenu: TPopupMenu;
    OptionMenuItem: TMenuItem;
    N5: TMenuItem;
    UpdateBoardListMenuItem: TMenuItem;
    N9: TMenuItem;
    ViewLimitPopupMenu: TPopupMenu;
    ViewLimit50MenuItem: TMenuItem;
    ViewLimit100MenuItem: TMenuItem;
    ViewLimit250MenuItem: TMenuItem;
    ViewLimit500MenuItem: TMenuItem;
    ViewLimit1000MenuItem: TMenuItem;
    ViewLimitNothingMenuItem: TMenuItem;
    CoolBar: TCoolBar;
    MainToolBar: TToolBar;
    SearchToolButton: TToolButton;
    PatrolToolButton: TToolButton;
    MakeTopicToolButton: TToolButton;
    StyleToolButton: TToolButton;
    StyleSub1ToolButton: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    UrlEdit: TEdit;
    BoardButtonToolBar: TToolBar;
    BoardButton: TToolButton;
    AddressBarPopupMenu: TPopupMenu;
    AddressBarOpenBrowser: TMenuItem;
    AddressBarCopyURL: TMenuItem;
    ToolButton4: TToolButton;
    ToolButton3: TToolButton;
    StyleSub2ToolButton: TToolButton;
    StyleSub3ToolButton: TToolButton;
    MainStatusBar: TStatusBar;
    RepaintTabTimer: TTimer;
    RepaintListViewTimer: TTimer;
    BoardListViewPopupMenu: TPopupMenu;
    RegisterBoardButtonMenuItem: TMenuItem;
    N3: TMenuItem;
    CopyBoardUrlMenuButton: TMenuItem;
    OpenBoardByBrowserMenuItem: TMenuItem;
    LeftPanel: TPanel;
    ArticlePopupMenu: TPopupMenu;
    N2: TMenuItem;
    LoginMenuItem: TMenuItem;
    N4: TMenuItem;
    SetPriorityMenuItem: TMenuItem;
    InputMemoMenuItem: TMenuItem;
    CopyUrlTopicList: TMenuItem;
    CopyTitleUrlTopicList: TMenuItem;
    OpenByBrowserTopicList: TMenuItem;
    N11: TMenuItem;
    CreateOfflineFolder: TMenuItem;
    RemoveOfflineFolder: TMenuItem;
    TrashMenuItem: TMenuItem;
    ResAtMenuItem: TMenuItem;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    BoardButtonPopupMenu: TPopupMenu;
    BoardDeleteMenuItem: TMenuItem;
    ActionList1: TActionList;
    ReceiveActiveTabAction: TAction;
    CloseActiveTabAction: TAction;
    TabForwardAction: TAction;
    TabBeforeAction: TAction;
    ChangeLimitAllActiveTab: TAction;
    ChangeStyle1Action: TAction;
    ChangeStyle2Action: TAction;
    ChangeStyle3Action: TAction;
    FavoritePopupMenu: TPopupMenu;
    SetPriorityPlus3ItemMenu: TMenuItem;
    SetPriorityPlus2ItemMenu: TMenuItem;
    SetPriorityPlus1ItemMenu: TMenuItem;
    SetPriorityZeroItemMenu: TMenuItem;
    SetPriorityMinus1ItemMenu: TMenuItem;
    SetPriorityMinus2ItemMenu: TMenuItem;
    SetPriorityMinus3ItemMenu: TMenuItem;
    BoardButtonToolBarPopupMenu: TPopupMenu;
    EditBoardButtonMenuItem: TMenuItem;
    N6: TMenuItem;
    N13: TMenuItem;
    N14: TMenuItem;
    OpenAllCategoryAction: TAction;
    CloseAllCategoryAction: TAction;
    LogSweeperAction: TAction;
    GoTrayAction: TAction;
    TopicTabImageList: TImageList;
    TrayIcon: TTrayIcon;
    LogSaveModeToolButton: TToolButton;
    TopPanel: TPanel;
    Animate1: TAnimate;
    AboneMenuItem: TMenuItem;
    TopicListView: TTopicListView;
    BoardListView: TBoardListView;
    NG1: TMenuItem;
    OnlineToolButton: TToolButton;
    OpenKatju88SiteDMenuItem: TMenuItem;
    BELoginMenuItem: TMenuItem;
    Image1: TImage;
    ThreadAboneMenuItem: TMenuItem;
    NG2: TMenuItem;
    N8: TMenuItem;
    ToukeiInfoMenuItem: TMenuItem;
    AboneCancelMenuItem: TMenuItem;
    DoePopupMenu: TPopupMenu;
    DoePopupMenuCopy: TMenuItem;
    IDSearchPopupMenu: TPopupMenu;
    IDSearchPopupMenuItem: TMenuItem;
    DoeSearchToolButton: TToolButton;
    N10: TMenuItem;
    IDSearchPopupBMenuItem: TMenuItem;
    DownloadAllTopicToolButton: TToolButton;
    ViewLimitChange: TToolButton;
    ToolButton2: TToolButton;
    StopTopicToolButton: TToolButton;
    N12: TMenuItem;
    RegisterOtherBoardButton: TMenuItem;
    ReGetMenuItem: TMenuItem;
    ToolButton1: TToolButton;
    N15: TMenuItem;
    N16: TMenuItem;
    Katju88WikiMenuItem: TMenuItem;
    N17: TMenuItem;
    N2ch1: TMenuItem;
    N18: TMenuItem;
    N19: TMenuItem;
    Wiki1: TMenuItem;
    AnimatePanel: TPanel;
    ApplicationEvents1: TApplicationEvents;
    AroundMenuItem: TMenuItem;
    N20: TMenuItem;
    TestMenu: TMenuItem;
    SearchStr: TAction;
    SearchDoe: TAction;
    DoePopupMenuCut: TMenuItem;
    DoePopupMenuPaste: TMenuItem;
    DoePopupMenuSelectAll: TMenuItem;
    DoePopupMenuPrint: TMenuItem;
    N21: TMenuItem;
    DoePopupMenuBack: TMenuItem;
    DoePopupMenuOver: TMenuItem;
    Open2chSearchMenuItem: TMenuItem;
    DoeTextSizeMenuItem: TMenuItem;
    N22: TMenuItem;
    DoeTextSize16MenuItem: TMenuItem;
    DoeTextSize15MenuItem: TMenuItem;
    DoeTextSize14MenuItem: TMenuItem;
    DoeTextSize13MenuItem: TMenuItem;
    DoeTextSize12MenuItem: TMenuItem;
    DoeTextSize11MenuItem: TMenuItem;
    DoeTextSize10MenuItem: TMenuItem;
    DoeTextSize09MenuItem: TMenuItem;
    DoeTextSize08MenuItem: TMenuItem;
    SearchDoeNext: TAction;
    SearchDoePrev: TAction;
    AddressBarCopyThreadTitle: TMenuItem;
    N1: TMenuItem;
    DoePopupMenuSearchNext: TMenuItem;
    DoePopupMenuSearchPrev: TMenuItem;
    CoolPanel: TPanel;
    LogSaveToolButton: TToolButton;
    P2LoginMenuItem: TMenuItem;
    OpenKatju88_27MenuItem: TMenuItem;
    procedure OnlineToolButtonClick(Sender: TObject);
    procedure TopicWriteToolButtonClick(Sender: TObject);
    procedure NG1Click(Sender: TObject);
    procedure StyleChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BoardListViewClick(Sender: TObject);
    procedure OpenNewTabMenuItemClick(Sender: TObject);
    procedure TopicTabControlChange(Sender: TObject);
    procedure TopicTabControlDrawTab(Control: TCustomTabControl;
      TabIndex: Integer; const Rect: TRect; Active: Boolean);
    procedure CloseTabToolButtonClick(Sender: TObject);
    procedure TopicTabControlMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FavoriteToolButtonClick(Sender: TObject);
    procedure PatrolToolButtonClick(Sender: TObject);
    procedure BoardNameLabelClick(Sender: TObject);
    procedure AutoReloadMenuItemClick(Sender: TObject);
    procedure SearchToolButtonClick(Sender: TObject);
    procedure StopToolButtonClick(Sender: TObject);
    procedure MakeTopicToolButtonClick(Sender: TObject);
    procedure TopicTabControlResize(Sender: TObject);
    procedure OptionMenuItemClick(Sender: TObject);
    procedure TrashToolButtonClick(Sender: TObject);
    procedure ViewLimitChangeClick(Sender: TObject);
    procedure UpdateBoardListMenuItemClick(Sender: TObject);
    procedure UrlEditKeyDown(Sender: TObject;
                             var Key: Word;
                             Shift: TShiftState);
    procedure CopyUrlMenuItemClick(Sender: TObject);
    procedure CopyTitleUrlMenuItemClick(Sender: TObject);
    procedure OpenByBrowserMenuItemClick(Sender: TObject);
    procedure RepaintTabTimerTimer(Sender: TObject);
    procedure RepaintListViewTimerTimer(Sender: TObject);
    procedure DownloadAllTopicToolButtonClick(Sender: TObject);
    procedure RegisterBoardButtonMenuItemClick(Sender: TObject);
    procedure CopyBoardUrlMenuButtonClick(Sender: TObject);
    procedure OpenBoardByBrowserMenuItemClick(Sender: TObject);
    procedure TopicTabControlMouseUp(Sender: TObject;
                                     Button: TMouseButton;
                                     Shift: TShiftState;
                                     X, Y: Integer);
    procedure LoginMenuItemClick(Sender: TObject);
    procedure ResAtMenuItemClick(Sender: TObject);
    procedure BoardDeleteMenuItemClick(Sender: TObject);
    procedure BoardButtonToolBarMouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure CloseActiveTabActionExecute(Sender: TObject);
    procedure TabBeforeActionExecute(Sender: TObject);
    procedure TabForwardActionExecute(Sender: TObject);
    procedure ChangeLimitAllActiveTabExecute(Sender: TObject);
    procedure ChangeStyle2ActionExecute(Sender: TObject);
    procedure ChangeStyle1ActionExecute(Sender: TObject);
    procedure ChangeStyle3ActionExecute(Sender: TObject);
    procedure CreateOfflineFolderClick(Sender: TObject);
    procedure FavoritePopupMenuPopup(Sender: TObject);
    procedure FavoriteMenuItemClick(Sender: TObject);
    procedure RemoveOfflineFolderClick(Sender: TObject);
    procedure TopicTabControlDragOver(Sender, Source: TObject;
                                      X, Y: Integer;
                                      State: TDragState;
                                      var Accept: Boolean);
    procedure TopicTabControlDragDrop(Sender, Source: TObject;
                                      X, Y: Integer);
    procedure BoardListViewDragOver(Sender, Source: TObject;
                                    X, Y: Integer;
                                    State: TDragState; var Accept: Boolean);
    procedure BoardListViewDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure SetPriorityMenuItemClick(Sender: TObject);
    procedure SetSelectedTopicPriority(Priority: Integer);
    procedure TopicListViewPopupMenuPopup(Sender: TObject);
    procedure TopicPagePopupMenuPopup(Sender: TObject);
    procedure SetPriorityPlusItemMenuClick(Sender: TObject);
    procedure EditBoardButtonMenuItemClick(Sender: TObject);
    procedure OpenAllCategoryActionExecute(Sender: TObject);
    procedure CloseAllCategoryActionExecute(Sender: TObject);
    procedure InputMemoMenuItemClick(Sender: TObject);
    procedure LogSweeperActionExecute(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure GoTrayActionExecute(Sender: TObject);
    procedure TrayIconMouseClick(Sender: TObject;
                                 Button: TMouseButton;
                                 Shift: TShiftState;
                                 X, Y: Integer);
    procedure BoardListViewKeyDown(Sender: TObject;
                                   var Key: Word;
                                   Shift: TShiftState);
    procedure CopyTitleUrlTopicListClick(Sender: TObject);
    procedure CopyUrlTopicListClick(Sender: TObject);
    procedure IETextSizeMenuItemClick(Sender: TObject);
    procedure Open2chGuideMenuItemClick(Sender: TObject);
    procedure Open2chMenuItemClick(Sender: TObject);
    procedure OpenByBrowserTopicListClick(Sender: TObject);
    procedure OpenKatju88SiteAMenuItemClick(Sender: TObject);
    procedure OpenKatju88SiteBMenuItemClick(Sender: TObject);
    procedure OpenKatju88SiteCMenuItemClick(Sender: TObject);
    procedure TrashMenuItemClick(Sender: TObject);
    procedure GoToToolButtonClick(Sender: TObject);
    procedure UrlEditChange(Sender: TObject);
    procedure AddressToolBarResize(Sender: TObject);
    procedure AddressBarOpenBrowserClick(Sender: TObject);
    procedure AddressBarCopyURLClick(Sender: TObject);
    procedure BoardButtonMouseDown(Sender: TObject;
                                   Button: TMouseButton;
                                   Shift: TShiftState;
                                   X, Y: Integer);
    procedure BoardButtonClick(Sender: TObject);
    procedure ReceiveActiveTabActionExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure LogSaveModeToolButtonClick(Sender: TObject);
    procedure SaveTopicToolButtonClick(Sender: TObject);
    procedure AboneMenuItemClick(Sender: TObject);
    procedure OpenBoard(Board: TBoard);
    procedure TopicListViewKeyDown(Sender: TObject;
                                   var Key: Word;
                                   Shift: TShiftState);
    procedure TopicListViewMouseUp(Sender: TObject;
                                   Button: TMouseButton;
                                   Shift: TShiftState;
                                   X, Y: Integer);
    procedure BoardListViewMouseDown(Sender: TObject; Button: TMouseButton;
                                     Shift: TShiftState; X, Y: Integer);
    procedure AppMinimized(Sender: TObject);
    procedure AppRestored(Sender: TObject);
    procedure OpenKatju88SiteDMenuItemClick(Sender: TObject);
    procedure BELoginMenuItemClick(Sender: TObject);
    procedure ThreadAboneItemClick(Sender: TObject);
    procedure NG2Click(Sender: TObject);
    procedure ToukeiInfoMenuItemClick(Sender: TObject);
    procedure AboneCancelMenuItemClick(Sender: TObject);
    procedure DoePopupMenuCopyClick(Sender: TObject);
    procedure DoePopUp(const statusText: string);
    procedure IDSearchPopupMenuItemClick(Sender: TObject);
    procedure DoeSearchToolButtonClick(Sender: TObject);
    procedure IDSearchPopupBMenuItemClick(Sender: TObject);
    procedure StopTopicToolButtonClick(Sender: TObject);
    procedure RegisterOtherBoardButtonClick(Sender: TObject);
    procedure ReGetMenuItemClick(Sender: TObject);
    procedure Katju88WikiMenuItemClick(Sender: TObject);
    procedure Wiki1Click(Sender: TObject);
    procedure N2ch1Click(Sender: TObject);
    procedure N18Click(Sender: TObject);
    procedure N19Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure ApplicationEvents1Message(var Msg: tagMSG;
      var Handled: Boolean);
    procedure AroundMenuItemClick(Sender: TObject);
    procedure TestMenuClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure DoePopupMenuCutClick(Sender: TObject);
    procedure DoePopupMenuPasteClick(Sender: TObject);
    procedure DoePopupMenuSelectAllClick(Sender: TObject);
    procedure DoePopupMenuPrintClick(Sender: TObject);
    procedure DoePopupMenuBackClick(Sender: TObject);
    procedure DoePopupMenuOverClick(Sender: TObject);
    procedure Open2chSearchMenuItemClick(Sender: TObject);
    procedure DoeTextSizeMenuItemClick(Sender: TObject);
    procedure SearchDoeNextExecute(Sender: TObject);
    procedure SearchDoePrevExecute(Sender: TObject);
    procedure AddressBarCopyThreadTitleClick(Sender: TObject);
    procedure DoePopupMenuSearchNextClick(Sender: TObject);
    procedure DoePopupMenuSearchPrevClick(Sender: TObject);
    procedure CoolBarChange(Sender: TObject);
    procedure CoolBarResize(Sender: TObject);
    procedure LogSaveToolButtonClick(Sender: TObject);
    procedure ApplicationEvents1Activate(Sender: TObject);
    procedure ApplicationEvents1Deactivate(Sender: TObject);
    procedure OpenKatju88_27MenuItemClick(Sender: TObject);
  private
    FActive: boolean;
    FSelectButton: string;
    FSelectMessageNo: integer;
    FOldtab: TTopicBrowser;
    FWriteForm: TWriteForm;
    FSelectedBoard: TBoard;
    FBrowserList:         TObjectList;
    FBoardButtonMenuList: TObjectList;
    FBoardButtonList: TStringList;
//  FMouseControl: TControl;
    FImageList: TImageList;
    FBoardList: TBoardList;
    clipText: string;
    ID_forSearch: string;
//  FDoeSearchForm: TDoeSearchForm;

    procedure CoolBarRestore;
    procedure CloseTab(const Index: integer);
    procedure ChangeTab();
    procedure OpenUrl(Sender: TObject; Url: string);
    procedure RefreshBoardListView;
    procedure TopicBrowser_NavigateUrl(Sender: TObject; URL: string);
    procedure TopicBrowser_ChangeDownloadState(Sender: TObject);
    procedure TopicBrowser_Complete(Sender: TObject);
    procedure OpenBrowser(URL: string);
    procedure CreateBoardButton();
    procedure SaveBoardButton;
    procedure FormIdle(Sender: TObject; var Done: Boolean);
    procedure OpenSelectedTopic;
    procedure BoardListViewSetVisible(const Visible, IsNormalMode: boolean);
    procedure TopicListViewSetVisible(const Visible, IsNormalMode: boolean);
    procedure BrowserPanelSetVisible(const Visible, IsNormalMode: boolean);
    procedure Spliter2SetVisible(const Visible, IsNormalMode: boolean);
    procedure ChangeTopicListViewColumnPadding;
    procedure ReloadOpenedTopic;
//  procedure RemoveTopicListViewItem(Topic: TTopic);
    procedure OpenTab(topic: TTopic; newtab: Boolean; StartNo: integer = 0);
    function GetActiveTab: TTopicBrowser;
    function CreateTopicBrowser: TTopicBrowser;
    function GetTabIndexAtPoint(Point: TPoint): Integer;
    function GetTabAtPoint(Point: TPoint): TTopicBrowser;
    procedure ChangeCaption;
//  procedure SearchString;         // 2008.04.29
	procedure DoeSearch();			// 2008.05.02
	procedure AdjustWindow(var Msg : TWMWindowPosChanging); message WM_WINDOWPOSCHANGING;	// 2008.06.05


  public
    { Public 錾 }
    DoeSearched: Boolean;
    FExecute: Boolean;
    FOpenning: Boolean;		// 2008.08.19
//  Around: boolean;         // 񒆃tO
    TopicDeleted: boolean;   // O폜
//  TopicAllClosed: boolean; // Topicׂĕ
    OpenTopicNumber: integer;// JĂTopic

    procedure OpenSearchTab(const str: string; mode: boolean);
    procedure Board_Error(Sender: TObject);
    procedure Board_StatusChange(Sender: TObject);
    procedure Board_Complete(Sender: TObject);
    procedure TopicBrowser_TrashComplete(Sender: TObject);

    procedure SetColumnOrderArray();			// 2008.04.29
    function GetInit(): Boolean;
    procedure SetInit(flag: Boolean);
//	procedure SaveScrollPosition;		// 2009.07.16
  end;
var
  MainForm: TMainForm;
  Init: boolean;

implementation

uses
  untRegExpr, IdHTTP, Commctrl, Graphics,
  ShellAPI, Clipbrd, StrUtils, mmsystem, ShDocVw_TLB,
  untConfig, untLogSweeper, untLogSweeperForm,
  untSearchForm, untUpdateBoardForm, untLoginForm,
  unt2chUrlParser,
  untCreateOfflineFolder, untHintWindow, untOptionForm,
  untEditBoardButttonForm, untImageListTool, untOnlineBoard,
  untAllSubscribedTopics, untFavoriteBoard,  untLostBoard,
  untTaskManager, SyncObjs,
  untTopicBrowserIE,
  untTopicBrowserDoe,
  untBELoginForm,
  untUpdate,
  untToukeiInfoForm;

{$R *.dfm}


procedure TMainForm.Board_Error(Sender: TObject);
begin
  MainStatusBar.SimpleText := (Sender as TBoard).StatusText;
end;

procedure TMainForm.Board_StatusChange(Sender: TObject);
var
  errmes: string;
begin
  errmes := (Sender as TOnlineBoard).StatusText;

  MainStatusBar.SimpleText := errmes;

end;

procedure TMainForm.Board_Complete(Sender: TObject);
var
  errmes: string;

begin
  errmes := '';

  if Sender is TOnlineBoard then
  begin
    errmes := (Sender as TOnlineBoard).StatusText;
    MainStatusBar.SimpleText := errmes;
  end;
  if Animate1.FileName <> '' then
  begin
    Animate1.Active := false;
  end;

end;

//procedure TMainForm.RemoveTopicListViewItem(Topic: TTopic);
//begin
//  if not Assigned(Topic) then
//  begin
//    exit;
//  end;
//
//  if FSelectedBoard is TFavoriteBoard then
//  begin
//    (FSelectedBoard as TFavoriteBoard).RemoveTopic(Topic);
//    // \XV
//    TopicListView.RemoveTopic(Topic);
//    TopicListView.TopicListRefresh;
//  end;
//  TopicListView.DoubleBuffered := true;
//  TopicListView.Repaint;
//  TopicListView.DoubleBuffered := false;
//end;

procedure TMainForm.TopicListViewKeyDown(Sender: TObject;
                                         var Key: Word;
                                         Shift: TShiftState);
begin
  if Key = VK_RETURN then
  begin
    OpenSelectedTopic;
  end;
end;
//
//
//
procedure TMainForm.TopicListViewMouseUp(Sender: TObject;
                                         Button: TMouseButton;
                                         Shift: TShiftState;
                                         X, Y: Integer);
begin
  // gsbNACeIꂽ
  if Button = mbLeft then
  begin
    OpenSelectedTopic;
  end;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TMainForm.OpenBoard(Board: TBoard);
var
  i, j: integer;
  category: TBoardCategory;
  activeTab: TTopicBrowser;			// 2009.07.17

begin
  if not Assigned(Board) then
  begin
    exit;
  end;

  if Animate1.FileName <> '' then
  begin
    Animate1.Active := true;
  end;


// ActiveTab̃XN[ʒuۑ	2009.07.17
  activeTab:=GetActiveTab;
  if Assigned(activeTab) and Assigned(activeTab.Topic) then
  begin
    activeTab.SaveScrollPosition;
    activeTab.Topic.SaveIdx;
  end;

//TopicAllClosed:=false;
//Inc(OpenTopicNumber);
  //^XNɗ\
  gTaskManager.RequestBoard(TopicListView, Board, reqbOpenBoard);
  FSelectedBoard := Board;

  //LvVύX
  ChangeCaption();

  // {[hXg{bNX̃JeSĂJ
  for i := 0 to FBoardList.Categorys.Count - 1 do
  begin
    category := TBoardCategory(FBoardList.Categorys[i]);
    for j := 0 to category.Boards.Count - 1 do
    begin
      if category.Boards[j] = FSelectedBoard then
      begin
        if category.Opened = false then
        begin
          if gConfig.BoardListOneCategory then
          begin
            CloseAllCategoryActionExecute(nil);
          end;
          BoardListView.OpenCategory(category);
        end;
        break;
      end;
    end;
  end;
  // {[hXg{bNX̑IύX
  BoardListView.OpenBoard(FSelectedBoard);
  if FSelectedBoard is TOnlineBoard then
  begin
    UrlEdit.Text := (FSelectedBoard as TOnlineBoard).BoardUrl;
  end;

end;

procedure TMainForm.BoardListViewKeyDown(Sender: TObject;
                                         var Key: Word;
                                         Shift: TShiftState);
begin
  case Key of
    VK_RETURN:
      BoardListViewClick(Sender);
    VK_MULTIPLY:
      OpenAllCategoryActionExecute(Sender);
    VK_SUBTRACT:
      CloseAllCategoryActionExecute(Sender);
  end;
end;

procedure TMainForm.BoardButtonToolBarMouseUp(Sender: TObject;
                                              Button: TMouseButton;
                                              Shift: TShiftState;
                                              X, Y: Integer);
begin
  if Button = mbLeft then
  begin
    BoardButtonClick(sender);
  end else if Button = mbRight then
  begin
    if Sender is TToolButton then
    begin
      FSelectButton := TToolButton(Sender).Caption;
      BoardButtonPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
    end else if Sender is TToolBar then
    begin
      BoardButtonToolBarPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
    end;
  end;

  if sender is TToolButton then
  begin
    TToolButton(sender).Down := false;
  end;
end;

procedure TMainForm.BoardButtonMouseDown(Sender: TObject;
                                         Button: TMouseButton;
                                         Shift: TShiftState;
                                         X, Y: Integer);
begin
  if sender is TToolButton then
  begin
    TToolButton(sender).Down := true;
  end;
end;

procedure TMainForm.BoardButtonClick(Sender: TObject);
var
  i, j: integer;
  caption: string;
  category: TBoardCategory;

begin
  if sender is TMenuItem then
  begin
    caption := TMenuItem(Sender).Caption
  end else if sender is TToolButton then
  begin
    caption := TToolButton(sender).Caption;
  end;

  for i := 0 to FBoardList.Categorys.Count - 1 do
  begin
    category := TBoardCategory(FBoardList.Categorys[i]);
    for j := 0 to category.Boards.Count - 1 do
    begin
      if TBoard(category.Boards[j]).DisplayName = caption then
      begin
        OpenBoard(TBoard(category.Boards[j]));
        exit;
      end;
    end;
  end;
end;

procedure TMainForm.CreateOfflineFolderClick(Sender: TObject);
var
  createForm: TCreateOfflineFolderForm;
  cancel: boolean;
  folderName, folderPath: string;
  board: TStringList;

begin
  createForm := TCreateOfflineFolderForm.Create(self);
  createForm.ShowModal;
  cancel     := createForm.Cancel;
  folderName := createForm.FolderName;
  createForm.Release;
  createForm.Free;

  if cancel then
  begin
    exit;
  end;

  folderPath := AppPath(folderName + '.idx');

  if AnsiCompareStr(folderName, '') = 0 then
  begin
    exit;
  end;

  if FileExists(folderPath) then
  begin
    ShowMessage('ɓ̑qɂ܂');
    exit;
  end;

  if LastDelimiter('\/:,;*"<>|', folderName) > 0 then
  begin
    ShowMessage('\/:,;*"<>| ͎̕g܂');
    exit;
  end;

  // {[ht@C̍쐬
  board := TStringList.Create;
  board.SaveToFile(folderpath);
  board.Free;
  FBoardList.MyFolder.AddBoard(folderPath, '}CtH_', folderName);

  RefreshBoardListView;
end;
//
// {^ɓo^
//
procedure TMainForm.RegisterBoardButtonMenuItemClick(Sender: TObject);
var
  index: Integer;
  item: TBoardListViewItem;
  boardname: string;

begin
  item := BoardListView.SelectedItem;

  if not Assigned(item) then
  begin
    exit;
  end;

  if Assigned(item.Board) then
  begin
    boardname := TBoard(item.Board).DisplayName
  end else
  begin
    boardname := '' + item.Category.CategoryName;
  end;

  // o^ĂȂΓo^
  index := FBoardButtonList.IndexOf(boardname);
  if index = -1 then
  begin
    FBoardButtonList.Add(boardname);
  end else
  begin
    FBoardButtonList.Delete(index);
  end;

  CreateBoardButton;
  SaveBoardButton;
end;
//
// {^̃JX^}CY
//
procedure TMainForm.BoardDeleteMenuItemClick(Sender: TObject);
var
  itemind : integer;
begin

  // o^Ă΍폜
  itemind := FBoardButtonList.IndexOf(FSelectButton);
  if itemind > -1 then
  begin
    FBoardButtonList.Delete(itemind);
  end;

  CreateBoardButton;
  SaveBoardButton;
end;
//
// {^\z
//
{
//  IWi
procedure TMainForm.CreateBoardButton;
var
  i, j: integer;
  button: TToolButton;
  newMenu: TPopupMenu;
  newMenuItem: TMenuItem;
  categoryMenu: TMenuItem;
  category: TBoardCategory;
begin

  FBoardButtonMenuList.Clear;

  // remove
  for i := 0 to BoardButtonToolBar.ButtonCount - 1 do
  begin
    button := BoardButtonToolBar.Buttons[0];
    BoardButtonToolBar.RemoveControl(button);
    button.Free;
  end;

//
  for i := FBoardButtonList.Count - 1 downto 0 do
  begin
    button := TToolButton.Create(BoardButtonToolBar);
    button.AutoSize  := true;
    button.Parent    := BoardButtonToolBar;
    button.Caption   := FBoardButtonList[i];
    button.Style     := tbsButton;
    button.OnMouseUp := BoardButtonToolBarMouseUp;

    newMenu := TPopupMenu.Create(BoardButtonToolBar);
    newMenu.AutoHotkeys := maManual;
    button.DropdownMenu := newMenu;
    FBoardButtonMenuList.Add(newMenu);

    if Copy(FBoardButtonList[i], 1, 2) = '' then
    begin
      category := nil;
      for j := 0 to  FBoardList.Categorys.Count - 1 do
      begin
        category := TBoardCategory(FBoardList.Categorys[j]);
        if CopyAfter(FBoardButtonList[i], 3) = category.CategoryName then
          break;
        category := nil;
      end;

      if category <> nil then
        for J := 0 to category.Boards.Count - 1 do
        begin
          newMenuItem := TMenuItem.Create(newMenu);
          newMenuItem.Caption := TBoard(category.Boards[J]).DisplayName;
          newMenuItem.AutoHotkeys := maManual;
          newMenuItem.OnClick := BoardButtonClick;
          newMenu.Items.Add(newMenuItem);
          FBoardButtonMenuList.Add(newMenuItem);
        end;
    end else
    begin
      button.OnMouseDown := BoardButtonMouseDown;
    end;
  end;

  // Q˂
  button := TToolButton.Create(BoardButtonToolBar);
  button.AutoSize := true;
  button.Parent   := BoardButtonToolBar;
  button.Caption  := 'Q˂';

  newMenu := TPopupMenu.Create(BoardButtonToolBar);
  newMenu.AutoHotkeys := maManual;
  button.DropdownMenu := newMenu;
  FBoardButtonMenuList.Add(newMenu);

  for i := 0 to  FBoardList.Categorys.Count - 1 do
  begin
    category := TBoardCategory(FBoardList.Categorys[i]);
    categoryMenu := TMenuItem.Create(newMenu);
    categoryMenu.Caption := category.CategoryName;
    newmenu.Items.Add(categoryMenu);
    FBoardButtonMenuList.Add(categoryMenu);

    for j := 0 to category.Boards.Count - 1 do
    begin
      newMenuItem := TMenuItem.Create(categoryMenu);
      newMenuItem.Caption := TBoard(category.Boards[J]).DisplayName;
      newMenuItem.OnClick := BoardButtonClick;
      categoryMenu.Add(newMenuItem);
      FBoardButtonMenuList.Add(newMenuItem);
    end;
  end;
end;
}
//
// New Version
//
procedure TMainForm.CreateBoardButton;
var
  i, j: integer;
  button: TToolButton;
  newMenu: TPopupMenu;
  newMenuItem: TMenuItem;
  categoryMenu: TMenuItem;
  category: TBoardCategory;

  mWrap: boolean;
  mCount: integer;
  mButtonPos:TPoint;
  mLineHeight: integer;
  mTopPanelHeight: integer;
  mCoolBarHeight: integer;
  mBoardButtonToolBarHeight: integer;

begin
//TopPanel.AutoSize := True;
//BoardButtonToolBar.Height := 0;
  CoolBar.AutoSize := True;
  AnimatePanel.AutoSize := True;

//BoardButtonToolBar.RowCount	// s
  mLineHeight:= Ceil(BoardButtonToolBar.Height/BoardButtonToolBar.RowCount);  // 1s̍
  mTopPanelHeight := TopPanel.Height - mLineHeight*(BoardButtonToolBar.RowCount-1);
  mCoolBarHeight  := CoolBar.Height  - mLineHeight*(BoardButtonToolBar.RowCount-1);
  mBoardButtonToolBarHeight := mLineHeight;

  FBoardButtonMenuList.Clear;  // FBoardButtonMenuList: TObjectList;

  // {^폜
  for i := 0 to BoardButtonToolBar.ButtonCount - 1 do
  begin
    button := BoardButtonToolBar.Buttons[0];
    BoardButtonToolBar.RemoveControl(button);
    button.Free;
  end;

  mCount:=0;
  mWrap:=false;
  mButtonPos.x:=0;
  mButtonPos.y:=0;

  // Q˂
  button := TToolButton.Create(BoardButtonToolBar);
  button.AutoSize := true;
  button.Parent   := BoardButtonToolBar;
  button.Caption  := 'Q˂';

//button.Style    := tbsTextButton;
//button.AutoSize := false;
  button.Wrap := false;
  button.Left := mButtonPos.x;
  button.Top := mButtonPos.y;

  newMenu := TPopupMenu.Create(BoardButtonToolBar);
  newMenu.AutoHotkeys := maManual;
  button.DropdownMenu := newMenu;
  FBoardButtonMenuList.Add(newMenu);

// hbv_Ej[ɃJeSXgo^
  for i := 0 to  FBoardList.Categorys.Count - 1 do
  begin
    category := TBoardCategory(FBoardList.Categorys[i]);
    categoryMenu := TMenuItem.Create(newMenu);
    categoryMenu.Caption := category.CategoryName;
    newmenu.Items.Add(categoryMenu);
    FBoardButtonMenuList.Add(categoryMenu);

    for j := 0 to category.Boards.Count - 1 do
    begin
      newMenuItem := TMenuItem.Create(categoryMenu);
      newMenuItem.Caption := TBoard(category.Boards[J]).DisplayName;
      newMenuItem.OnClick := BoardButtonClick;
      categoryMenu.Add(newMenuItem);
      FBoardButtonMenuList.Add(newMenuItem);
    end;
  end;

  BoardButtonToolBar.Height := button.Height;
  mButtonPos.x:=button.Left+button.Width;
  Inc(mCount);

//for i := FBoardButtonList.Count - 1 downto 0 do
  for i := 0 to FBoardButtonList.Count-1 do
  begin
    button := TToolButton.Create(BoardButtonToolBar);
    button.AutoSize  := true;
    button.Caption   := FBoardButtonList[i];
    button.Style     := tbsButton;
    button.OnMouseUp := BoardButtonToolBarMouseUp;

    button.Wrap := false;
    button.Left := mButtonPos.x;
    button.Top := mButtonPos.y;

    if mButtonPos.x+button.Width+4 > BoardButtonToolBar.Width then
    begin
      BoardButtonToolBar.Buttons[mCount-1].Wrap := true;  // true:s
      mWrap:=true;
    end;

    button.Parent := BoardButtonToolBar;
    if mWrap = true then
    begin
      // ssAeȂ̂ŁATCY̌vZs
//      begin
        mTopPanelHeight :=mTopPanelHeight + button.Height;
        mCoolBarHeight := mCoolBarHeight + button.Height;
        mBoardButtonToolBarHeight := mBoardButtonToolBarHeight+ button.Height;
//      end;
      mWrap := false;
    end;
    mButtonPos.x := button.Left+button.Width;
    mButtonPos.y := button.Top;
    Inc(mCount);

    newMenu := TPopupMenu.Create(BoardButtonToolBar);
    newMenu.AutoHotkeys := maManual;
    button.DropdownMenu := newMenu;
    FBoardButtonMenuList.Add(newMenu);

    if Copy(FBoardButtonList[i], 1, 2) = '' then
    begin
      category := nil;
      for j := 0 to  FBoardList.Categorys.Count - 1 do
      begin
        category := TBoardCategory(FBoardList.Categorys[j]);
        if CopyAfter(FBoardButtonList[i], 3) = category.CategoryName then
          break;
        category := nil;
      end;

      if category <> nil then
        for J := 0 to category.Boards.Count - 1 do
        begin
          newMenuItem := TMenuItem.Create(newMenu);
          newMenuItem.Caption := TBoard(category.Boards[J]).DisplayName;
          newMenuItem.AutoHotkeys := maManual;
          newMenuItem.OnClick := BoardButtonClick;
          newMenu.Items.Add(newMenuItem);
          FBoardButtonMenuList.Add(newMenuItem);
        end;
    end else
    begin
      button.OnMouseDown := BoardButtonMouseDown;
    end;
  end;

  TopPanel.Height           := mTopPanelHeight;
  CoolBar.Height            := mCoolBarHeight;
  BoardButtonToolBar.Height := mBoardButtonToolBarHeight;

end;






{ --------------------------------------------------------
  pr  : ^uύXꂽ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.ChangeTab;
var
  activeTab: TTopicBrowser;
  i: integer;
  board: TOnlineBoard;

begin
  activeTab := GetActiveTab();
  if activeTab = nil then
  begin
    exit;
  end;

  FOldtab := activeTab;

  if (activeTab.Topic <> nil) and (OpenTopicNumber>0) then
  begin
    board := (ActiveTab.Topic.OnlineBoard as TOnlineBoard);

    BoardNameLabel.Caption   := '[' + board.DisplayName + ']';
    TopicNameLabel.Left      := BoardNameLabel.Left + BoardNameLabel.Width + 5;

//	activeTab.Topic.Title := StringReplace(activeTab.Topic.Title, '&gt;', '>', [rfReplaceAll]);
//	activeTab.Topic.Title := StringReplace(activeTab.Topic.Title, '&lt;', '<', [rfReplaceAll]);
//	activeTab.Topic.Title := StringReplace(activeTab.Topic.Title, '&amp;', '&', [rfReplaceAll]);
//	activeTab.Topic.Title := StringReplace(activeTab.Topic.Title, '&quot;', '"', [rfReplaceAll]);
    activeTab.Topic.Title := ReTitle(activeTab.Topic.Title);

    activeTab.Caption        := activeTab.Topic.Title;

//  TopicNameLabel.Caption   := activeTab.Topic.Title;
    TopicNameLabel.Caption   := activeTab.Topic.Title + Format(' (%d)',[activeTab.Topic.MessageCount]);

    MainStatusBar.SimpleText := activeTab.Topic.StatusText;

    if tsFavorite in ActiveTab.Topic.Status then
    begin
      FavoriteToolButton.ImageIndex := 18;
    end else
    begin
      FavoriteToolButton.ImageIndex := 19;
    end;

    AutoReloadMenuItem.Checked := ActiveTab.AutoReload;
    UrlEdit.Text := ActiveTab.Topic.BrowserUrl;
  end else
  begin
    BoardNameLabel.Caption := '';
    TopicNameLabel.Caption := '';
    //MainStatusBar.SimpleText := '';
  end;

  ChangeCaption();  // 2008.05.19

  activeTab.Visible := true;	// 2008.07.02

  for i := 0 to FBrowserList.Count - 1 do
  begin
    if FBrowserList[i] <> ActiveTab then
    begin
      TTopicBrowser(FBrowserList[I]).Visible := false;
    end;
  end;

  // ^uĕ`
  RepaintTabTimer.Enabled := true;
end;
//
//
//
procedure TMainForm.FormCreate(Sender: TObject);
var
//items: TStringArray;
  textSize: integer;
  activeTab: TTopicBrowser;
//pColumArray: PInteger;
  Style: TFontStyles;

begin
  gEvent:=Nil;
  gExecute:=false;			// 2009.01.26
  Init:=False;
  DoeSearched:=False;		// WindowI[ṽtO
  FExecute:=False; 			// s̃tO(rp)
//Around:=False;			// 񒆃tO
  TopicDeleted:=false;		// 
//TopicAllClosed:=true;		// 
  OpenTopicNumber:=0;

  AnimatePanel.Align:=alRight;
  AnimatePanel.BevelInner:=bvNone;
  AnimatePanel.BevelOuter:=bvNone;
  AnimatePanel.Caption:='';
//CoolBar.Align:=alClient;
  CoolPanel.Align:=alClient;
  CoolBar.Align:=alTop;

//TopPanel.Height:=2+
//CoolBar.Bands[0].Height+2+
//CoolBar.Bands[1].Height+2+
//CoolBar.Bands[2].Height+2;

//TopPanel.AutoSize := false;
  CoolBar.AutoSize := True;
  BoardButtonToolBar.ShowCaptions := true;
  BoardButtonToolBar.Indent := 0;
  BoardButtonToolBar.AutoSize := false;
  BoardButtonToolBar.Wrapable := false;  // sȂ

  // 
  TimeBeginPeriod(1);

  FBrowserList         := TObjectList.Create;
  FBoardButtonMenuList := TObjectList.Create;

  FBoardButtonList := TStringList.Create;

  Application.OnIdle := FormIdle;

  if FileExists(AppPath('anime.avi')) then
  begin
    Animate1.FileName := AppPath('anime.avi');
  end;

  // Style
  if gConfig.MainFormStyleType3 then
  begin
    StyleToolButton.ImageIndex := 3
  end else
  begin
    StyleToolButton.ImageIndex := 7;
  end;

  if gConfig.DoLogSave then
  begin
    LogSaveModeToolButton.Down := true;
    //SaveTopicToolButton.Visible := false;

    LogSaveToolButton.Visible := false;			// 2008.08.17
//  TopicToolBar.Left := TopicToolBar.Left - LogSaveToolButton.Width;
  end else
  begin
    LogSaveModeToolButton.Down := false;
    //SaveTopicToolButton.Visible := true;

    LogSaveToolButton.Visible := true;			// 2008.08.17
    if OpenTopicNumber > 0 then
      LogSaveToolButton.Enabled := true
    else
      LogSaveToolButton.Enabled := false;

    TopicToolBar.Left := TopicToolBar.Left - LogSaveToolButton.Width;
//  TopicToolBar.Width := TopicToolBar.Width + LogSaveToolButton.Width;
  end;

  //X擾̃c[{^
  if gConfig.Use_DoeComponent then
     ViewLimitChange.Visible := false
  else
     DoeSearchToolButton.Visible := false;

  //IC/ItCݒ
  if gConfig.Offline then
  begin
     OnlineToolButton.Down := False;
  end else
  begin
     OnlineToolButton.Down := True;
  end;

  FavoriteToolButton.ImageIndex := 19;		// 2008.08.16

  //eyecon.bmp݂ΉʉEɉ摜o
  if FileExists(AppPath('eyecon.bmp')) then
  begin
    Image1.Picture.LoadFromFile(AppPath('eyecon.bmp'));
  end else
  begin
    //摜\ȂƂɕ\̈ς
//    Image1.Width := 0;
    Image1.Visible := False;
    CoolBar.Width := Animate1.Left -1;
  end;

  StyleSub1ToolButton.Down := gConfig.MainFormStyleSub1;
  StyleSub2ToolButton.Down := gConfig.MainFormStyleSub2;
  StyleSub3ToolButton.Down := gConfig.MainFormStyleSub3;
  // ݒ蔽f
  StyleChange(nil);

  TopicTabControl.MultiLine := gConfig.MultiLineTab;

  TopicListView.Font.Size := gConfig.TopicListViewColumnFontSize;
  TopicListView.GridLines := gConfig.TopicListViewGridLines;

  // J̕тƕݒ肷
  SetColumnOrderArray();

  // {[hXgXV
  FBoardList := TBoardList.Create;
  FBoardList.Init;
  RefreshBoardListView;

  // uEUЂƂJĂ
  activeTab := CreateTopicBrowser();
  activeTab.Visible := true;

  // ݃tH[
  FWriteForm := TWriteForm.CreateForm(Application, self);

// {^̍쐬
  if FileExists(AppPath('favboard.idx')) then
  begin
    FBoardButtonList.LoadFromFile(AppPath('favboard.idx'));
  end;
//CreateBoardButton();

  ChangeTopicListViewColumnPadding;

  //qɂJ
{
    for i := 0 to 10 do
    begin
      TopicListView.Columns.FindItemID(StrToIntNeo(items[i])).Index := i;
    end;
  OpenBoard(FBoardList.MyFolder.FavoriteBoard);
}


  // CɓJ
  if Assigned(FBoardList.MyFolder.FavoriteBoard) then
  begin
    OpenBoard(FBoardList.MyFolder.FavoriteBoard)
  end;

  // R}hCURLnꂽJ
  if ParamCount > 0 then
  begin
    OpenUrl(self, ParamStr(1));
  end;

  Application.OnMinimize := AppMinimized;
  Application.OnRestore  := AppRestored;

// Form size
  CoolBarRestore;
  self.Height := gConfig.MainFormHeight;
  self.Width  := gConfig.MainFormWidth;
  self.Top    := gConfig.MainFormTop;
  self.Left   := gConfig.MainFormLeft;
  self.Show;
  self.WindowState := TWindowState(gConfig.MainFormWindowState);
  self.Repaint;

  TopicToolBar.Width:=CloseTabToolButton.Left+CloseTabToolButton.Width+1;
  TopicToolBar.Left:=BrowserPanel.Width-TopicToolBar.Width;

// {^̍쐬
  CreateBoardButton();

  if activeTab is TTopicBrowserIE then
  begin
    DoeTextSizeMenuItem.Enabled:=False;
    // IETCYɃ`FbN
    textSize := (activeTab as TTopicBrowserIE).GetTextSize;
    case textSize of
      0:
        ToolPopupMenu.Items[0][4].Checked := true;
      1:
        ToolPopupMenu.Items[0][3].Checked := true;
      2:
        ToolPopupMenu.Items[0][2].Checked := true;
      3:
        ToolPopupMenu.Items[0][1].Checked := true;
      4:
        ToolPopupMenu.Items[0][0].Checked := true;
    end;
  end else
  if activeTab is TTopicBrowserDoe then
  begin
    //IETextSizeMenuItem.Enabled:=False;
    //IETextSizeGiantMenuItem.Enabled:=False;
    ToolPopupMenu.Items[0].Enabled:=False;

    // IETCYɃ`FbN
    textSize := gConfig.Doe_FontSize;
    case textSize of
       8:
        DoeTextSize08MenuItem.Checked := true;
       9:
        DoeTextSize09MenuItem.Checked := true;
      10:
        DoeTextSize10MenuItem.Checked := true;
      11:
        DoeTextSize11MenuItem.Checked := true;
      12:
        DoeTextSize12MenuItem.Checked := true;
      13:
        DoeTextSize13MenuItem.Checked := true;
      14:
        DoeTextSize14MenuItem.Checked := true;
      15:
        DoeTextSize15MenuItem.Checked := true;
      16:
        DoeTextSize16MenuItem.Checked := true;
    end;
  end;
//
//
//
  Style := [];
  BoardListView.Font.Name    := gConfig.BoardListFontName;
  BoardListView.Font.Size    := gConfig.BoardListFontSize;
  BoardListView.Font.Charset := gConfig.BoardListFontCharset;
  BoardListView.Font.Color   := gConfig.BoardListFontColor;
  if gConfig.BoardListFontStyle and 1 <> 0 then
    Include(Style,fsBold);
  if gConfig.BoardListFontStyle and 2 <> 0 then
    Include(Style,fsItalic);
  if gConfig.BoardListFontStyle and 4 <> 0 then
    Include(Style,fsUnderline);
  if gConfig.BoardListFontStyle and 8 <> 0 then
    Include(Style,fsStrikeOut);
  BoardListView.Font.Style := Style;

  Style := [];
  TopicListView.Font.Name    := gConfig.TopicListFontName;
  TopicListView.Font.Size    := gConfig.TopicListFontSize;
  TopicListView.Font.Charset := gConfig.TopicListFontCharset;
  TopicListView.Font.Color   := gConfig.TopicListFontColor;
  if gConfig.TopicListFontStyle and 1 <> 0 then
    Include(Style,fsBold);
  if gConfig.TopicListFontStyle and 2 <> 0 then
    Include(Style,fsItalic);
  if gConfig.TopicListFontStyle and 4 <> 0 then
    Include(Style,fsUnderline);
  if gConfig.TopicListFontStyle and 8 <> 0 then
    Include(Style,fsStrikeOut);
  TopicListView.Font.Style := Style;

end;
//
//
//
procedure TMainForm.FormShow(Sender: TObject);
begin
//
end;
//
//
//
procedure TMainForm.FormActivate(Sender: TObject);
var
  mUpdateDlg:TUpdateDlg;
begin
//FActive := true;

  if Init = False then
  begin
    if gConfig.Update=True then
    begin
      mUpdateDlg:=TUpdateDlg.Create(self);
  //  mUpdateDlg.Show();
      mUpdateDlg.CheckUpdate;
      mUpdateDlg.Free;
    end;

//  Animate1.Active := false;
    Init := True;
  end;
end;
//
//
//
procedure TMainForm.AppMinimized(Sender: TObject);
var
  i: Integer;

begin
  // http://www.asahi-net.or.jp/~HA3T-NKMR/tips003.htm
  // ̃R[h
  for i := 0 to Screen.FormCount -1 do
  begin
    if Screen.Forms[i] <> Application.MainForm then
    begin
      with Screen.Forms[i] do
      begin
        Tag     :=  LongInt(Visible);
        Visible := False;
      end;
    end;
  end;
end;

procedure TMainForm.AppRestored(Sender: TObject);
var
  i: Integer;

begin
  // http://www.asahi-net.or.jp/~HA3T-NKMR/tips003.htm
  // ̃R[h
  for i := 0 to Screen.FormCount -1 do
  begin
    if Screen.Forms[i] <> Application.MainForm then
    begin
      with Screen.Forms[i] do
      begin
        Visible := Boolean(Tag);
      end;
    end;
  end;
end;
//
// I
//
procedure TMainForm.FormDestroy(Sender: TObject);
    function DleteDir(Dir:string): Boolean;
    var
      Rec     : TSearchRec; {t@C}
    begin
      Result := false;

      if  (FindFirst(Dir + '\*.*', faAnyFile, Rec) = 0) then
      begin
        repeat
          if ((Rec.Name <> '.') and (Rec.Name <> '..')) then
          begin
              if ((Rec.Attr and faDirectory) > 0) then
              begin
                DleteDir(Dir + '\' + Rec.Name);
              end;

              if Rec.Attr > 0 then
              begin
                Result := RemoveDir(Dir + '\' + Rec.Name);
              end;
          end;
        until (FindNext(Rec) <> 0);
      end;
      FindClose(Rec);
    end;
var
  i: Integer;
  column: TListColumn;
  band: TCoolBand;
  pColumArray: PInteger;
  iCount: Integer;
  ID: Integer;
  IdWidth: Array[0..15] of Integer;
begin

  // JĂ^u鏈
  if OpenTopicNumber>0 then
  begin
    for i:=0 to TopicTabControl.Tabs.Count-1 do
    begin
      CloseTab(0);
    end;
  end;

  // Style
  gConfig.MainFormStyleType3 := (StyleToolButton.ImageIndex = 3);
  gConfig.MainFormStyleSub1  := StyleSub1ToolButton.Down;
  gConfig.MainFormStyleSub2  := StyleSub2ToolButton.Down;
  gConfig.MainFormStyleSub3  := StyleSub3ToolButton.Down;

  if LeftPanel.Visible then
  begin
    gConfig.BoardListViewWidth := LeftPanel.Width;
  end;
  if (StyleToolButton.ImageIndex = 7) then
  begin
    if BrowserPanel.Visible then
    begin
      gConfig.TopicListViewHeight := TopicListView.Height;
    end;
  end else
  begin
    if BrowserPanel.Visible then
    begin
      gConfig.TopicListViewWidth := TopicListView.Width;
    end;
  end;

  // Form size
  if self.WindowState = wsMinimized then
  begin
    gConfig.MainFormWindowState := Integer(wsNormal)
  end else
  begin
    gConfig.MainFormWindowState := Integer(self.WindowState);
  end;

  if self.WindowState = wsNormal then
  begin
    gConfig.MainFormHeight := self.Height;
    gConfig.MainFormWidth  := self.Width;
    gConfig.MainFormTop    := self.Top;
    gConfig.MainFormLeft   := self.Left;
  end;



  gConfig.BoardListFontName    := BoardListView.Font.Name;
  gConfig.BoardListFontSize    := BoardListView.Font.Size;
  gConfig.BoardListFontCharset := BoardListView.Font.Charset;
  gConfig.BoardListFontColor   := BoardListView.Font.Color;
  gConfig.BoardListFontStyle:=0;
  if fsBold in BoardListView.Font.Style then
     gConfig.BoardListFontStyle:=gConfig.BoardListFontStyle+1;
  if fsItalic in BoardListView.Font.Style then
     gConfig.BoardListFontStyle:=gConfig.BoardListFontStyle+2;
  if fsUnderline in BoardListView.Font.Style then
     gConfig.BoardListFontStyle:=gConfig.BoardListFontStyle+4;
  if fsStrikeOut in BoardListView.Font.Style then
     gConfig.BoardListFontStyle:=gConfig.BoardListFontStyle+8;

  gConfig.TopicListFontName    := TopicListView.Font.Name;
  gConfig.TopicListFontSize    := TopicListView.Font.Size;
  gConfig.TopicListFontCharset := TopicListView.Font.Charset;
  gConfig.TopicListFontColor   := TopicListView.Font.Color;
  gConfig.TopicListFontStyle:=0;
  if fsBold in TopicListView.Font.Style then
     gConfig.TopicListFontStyle:=gConfig.TopicListFontStyle+1;
  if fsItalic in TopicListView.Font.Style then
     gConfig.TopicListFontStyle:=gConfig.TopicListFontStyle+2;
  if fsUnderline in TopicListView.Font.Style then
     gConfig.TopicListFontStyle:=gConfig.TopicListFontStyle+4;
  if fsStrikeOut in TopicListView.Font.Style then
     gConfig.TopicListFontStyle:=gConfig.TopicListFontStyle+8;

//
// TopicListView̗тۑ
//
  // TopicListView column order
  gConfig.TopicListViewColumnOrders := '';
  iCount:=TopicListView.Columns.Count;
  GetMem(pColumArray,SizeOf(PInteger)*iCount);
  ListView_GetColumnOrderArray(TopicListView.Handle,iCount,pColumArray);
//for i := 0 to iCount - 1 do
//begin
//  gConfig.TopicListViewColumnOrders :=
//  gConfig.TopicListViewColumnOrders + IntToStr(PIntegerArray(pColumArray)[i]) + ',';
//end;
  // LƁAvfԂ1ȂĂ܂B
  for i := 0 to iCount - 1 do
  begin
    if i <> 0 then
      gConfig.TopicListViewColumnOrders := gConfig.TopicListViewColumnOrders + ',';
    gConfig.TopicListViewColumnOrders :=
    gConfig.TopicListViewColumnOrders + IntToStr(PIntegerArray(pColumArray)[i]);
  end;

  FreeMem(pColumArray);
//
//
//
  // TopicListView column width
  gConfig.TopicListViewColumnWidths := '';
  for i := 0 to TopicListView.Columns.Count - 1 do
  begin
    column := TopicListView.Columns[i];
    ID:=column.ID;
    IdWidth[ID]:=column.Width
  end;

  for i := 0 to TopicListView.Columns.Count - 1 do
//begin
//  gConfig.TopicListViewColumnWidths :=
//  gConfig.TopicListViewColumnWidths + IntToStr(IdWidth[i]) + ',';
//end;
  begin
    if i <> 0 then
      gConfig.TopicListViewColumnWidths := gConfig.TopicListViewColumnWidths + ',';
    gConfig.TopicListViewColumnWidths :=
    gConfig.TopicListViewColumnWidths + IntToStr(IdWidth[i]);
  end;
//
//
//
  gConfig.CoolBarBandId    := '';
  gConfig.CoolBarBandWidth := '';
  gConfig.CoolBarBandBreak := '';
//for i := 0 to CoolBar.Bands.Count -1 do
//begin
//  band := CoolBar.Bands[i];
//  gConfig.CoolBarBandId    := gConfig.CoolBarBandId    + IntToStr(band.ID) + ', ' ;
//  gConfig.CoolBarBandWidth := gConfig.CoolBarBandWidth + IntToStr(band.Width) + ', ';
//  if band.Break = true then
//  begin
//    gConfig.CoolBarBandBreak := gConfig.CoolBarBandBreak + 'TRUE, '
//  end else
//  begin
//    gConfig.CoolBarBandBreak := gConfig.CoolBarBandBreak + 'FALSE, ';
//  end;
//end;

  for i := 0 to CoolBar.Bands.Count -1 do
  begin
    band := CoolBar.Bands[i];
    if i <> 0 then
    begin
      gConfig.CoolBarBandId    := gConfig.CoolBarBandId    + ',';
      gConfig.CoolBarBandWidth := gConfig.CoolBarBandWidth + ',';
      gConfig.CoolBarBandBreak := gConfig.CoolBarBandBreak + ',';
    end;

    gConfig.CoolBarBandId    := gConfig.CoolBarBandId    + IntToStr(band.ID);
    gConfig.CoolBarBandWidth := gConfig.CoolBarBandWidth + IntToStr(band.Width);
    if band.Break = true then
    begin
      gConfig.CoolBarBandBreak := gConfig.CoolBarBandBreak + 'TRUE'
    end else
    begin
      gConfig.CoolBarBandBreak := gConfig.CoolBarBandBreak + 'FALSE';
    end;
  end;


//  log̋tH_폜
  if(gConfig.CleanFolder=TRUE) then
    DleteDir(DIR_LOG);

  // OwnedtH[ɂĂ̂ŉȂĂ悢
  //FWriteForm.Free;

  //20130721 ŃG[\̂Ńgbv
  try
    FImageList.Free;
    FBoardButtonMenuList.Free;
    FBoardButtonList.Free;
    FBrowserList.Free;
    FBoardList.Free; //܂BBSɏŖ肪N邱Ƃ
  except on e:Exception do
      ;
  end;


  if gEvent<>nil then
    gEvent.Free;

  //ғԂ̌vZ
  gConfig.ToukeiInfo_TotalTime := gConfig.ToukeiInfo_TotalTime + (Now - gConfig.ToukeiInfo_AppStartToday);

  TimeEndPeriod(1);
end;
//
// \X^CύX
//
procedure TMainForm.StyleChange(Sender: TObject);
var
  IsNormalMode: Boolean;

begin
	// XP Styleƃ{^͎Ő؂ւȂ
    if (Sender = StyleSub1ToolButton) then
	begin
		if gConfig.MainFormStyleSub1 = True then
		begin
			StyleSub1ToolButton.Down := False;
			gConfig.MainFormStyleSub1:= False;
		end
		else
		begin
			StyleSub1ToolButton.Down := True;
			gConfig.MainFormStyleSub1:= True;
		end
	end
	else
    if (Sender = StyleSub2ToolButton) then
	begin
		if gConfig.MainFormStyleSub2 = True then
		begin
			StyleSub2ToolButton.Down := False;
			gConfig.MainFormStyleSub2:= False;
		end
		else
		begin
			StyleSub2ToolButton.Down := True;
			gConfig.MainFormStyleSub2:= True;
		end
	end
	else
    if (Sender = StyleSub3ToolButton) then
	begin
		if gConfig.MainFormStyleSub3 = True then
		begin
			StyleSub3ToolButton.Down := False;
			gConfig.MainFormStyleSub3:= False;
		end
		else
		begin
			StyleSub3ToolButton.Down := True;
			gConfig.MainFormStyleSub3:= True;
		end
	end;


  IsNormalMode := (StyleToolButton.ImageIndex = 7);

  // yCX^C̕ύX
  if Sender = StyleToolButton then
  begin
    if IsNormalMode then
    begin
      StyleToolButton.Hint := 'cRʍ\ɕύX';
      StyleToolButton.ImageIndex     := 3;
      StyleSub1ToolButton.ImageIndex := 4;
      StyleSub2ToolButton.ImageIndex := 5;
      StyleSub3ToolButton.ImageIndex := 6;
      gConfig.MainFormStyleType3 := True;
    end else
    begin
      StyleToolButton.Hint := 'ʏʍ\ɕύX';
      StyleToolButton.ImageIndex     := 7;
      StyleSub1ToolButton.ImageIndex := 8;
      StyleSub2ToolButton.ImageIndex := 9;
      StyleSub3ToolButton.ImageIndex := 10;
      gConfig.MainFormStyleType3 := False;
    end;
    IsNormalMode := (StyleToolButton.ImageIndex = 7);
  end;

// [2][3]̓gOɂȂĂ
  if StyleSub2ToolButton.Down and StyleSub3ToolButton.Down then
  begin
    if (Sender = StyleSub2ToolButton) then
    begin
      StyleSub3ToolButton.Down := false;
      gConfig.MainFormStyleSub3:= False;			
    end else
    begin
      StyleSub2ToolButton.Down := false;
      gConfig.MainFormStyleSub2:= False;			
    end;
  end;

// [1]
  if StyleSub1ToolButton.Down then
  begin
    BoardListViewSetVisible(False, IsNormalMode);
  end else
  begin
    BoardListViewSetVisible(True, IsNormalMode);
  end;

// [2][3]̓gO
  if not StyleSub2ToolButton.Down and not StyleSub3ToolButton.Down then
  begin
    TopicListViewSetVisible(True, IsNormalMode);
    Spliter2SetVisible(True, IsNormalMode);
    BrowserPanelSetVisible(True, IsNormalMode);
  end else
  if StyleSub2ToolButton.Down then
  begin
    TopicListViewSetVisible(True, IsNormalMode);
    Spliter2SetVisible(False, IsNormalMode);
    BrowserPanelSetVisible(False, IsNormalMode);
  end else
  begin
    TopicListViewSetVisible(False, IsNormalMode);
    Spliter2SetVisible(False, IsNormalMode);
    BrowserPanelSetVisible(True, IsNormalMode); 
  end; 
end;
//
// ^u`
//
procedure TMainForm.TopicTabControlDrawTab(Control: TCustomTabControl;
                                           TabIndex: Integer;
                                           const Rect: TRect;
                                           Active: Boolean);
var
  browser: TTopicBrowser;
  X: Integer;
  drawRect: TRect;

begin
  if (TabIndex >= 0) and (TabIndex < TopicTabControl.Tabs.Count) then
  begin
    browser := TTopicBrowser(FBrowserList[TabIndex]);

    // 
    Control.Canvas.FillRect(Rect);

    // ACR̕`
    if (browser.ImageIndex > -1) and
       (browser.ImageIndex < TopicTabControl.Images.Count) then
    begin
      TopicTabControl.Images.Draw(Control.Canvas,
                                  Rect.Left + 3,
                                  Rect.Top + 3,
                                  browser.ImageIndex);
      X := Rect.Left + 20;
    end else
    begin
      X := Rect.Left + 5;
    end;

    if not Active then
    begin
      Control.Canvas.Font.Color := clBtnShadow
    end else
    begin
      Control.Canvas.Font.Color := clWindowText;
    end;
    drawRect.Top    := Rect.Top + 2;
    drawRect.Left   := X;
    drawRect.Bottom := Rect.Bottom - 1;
    drawRect.Right  := Rect.Right  - 1;
    Control.Canvas.TextRect(drawRect, X, Rect.Top + 5, browser.Caption);
  end;
end;
//------------------------------------------------------------------
//	
// {[hXgClick
//
//------------------------------------------------------------------
procedure TMainForm.BoardListViewClick(Sender: TObject);
var
  i: integer;
  item: TBoardListViewItem;
  categoryName: string;
  doOpen: boolean;

begin
  item := BoardListView.SelectedItem;

  if not Assigned(item) then
  begin
    exit;
  end;

  if Assigned(item.Board) then
  begin
    OpenBoard(item.Board)
  end else
  begin
    if gConfig.BoardListOneCategory then
    begin
      doOpen := not Item.Category.Opened;
      categoryName := Item.Category.CategoryName;
      CloseAllCategoryActionExecute(Sender);
      for i := 0 to BoardListView.Items.Count - 1 do
      begin
        if BoardListView.GetItem(i).Category.CategoryName = CategoryName then
        begin
          item := BoardListView.GetItem(i);
          break;
        end;
      end;
      if doOpen then
      begin
        BoardListView.OpenCategory(item.Category);
      end;
    end else if item.Category.Opened then
    begin
      BoardListView.CloseCategory(item.Category);
    end else
    begin
      BoardListView.OpenCategory(item.Category);
    end;
  end;
end;
//
// ^uύX
//
procedure TMainForm.TopicTabControlChange(Sender: TObject);
begin
  ChangeTab();
end;
//------------------------------------------------------------------
//
// ^u_uNbNꂽ
//
//------------------------------------------------------------------
procedure TMainForm.TopicTabControlMouseDown(Sender: TObject;
                                             Button: TMouseButton;
                                             Shift: TShiftState;
                                             X, Y: Integer);
begin
  if (Button = mbLeft) and (ssDouble in Shift) then
  begin
    ReloadOpenedTopic;
  end else if Button = mbLeft then
  begin
    TopicTabControl.BeginDrag(false, 20);
  end;
end;

procedure TMainForm.TopicTabControlMouseUp(Sender: TObject;
                                           Button: TMouseButton;
                                           Shift: TShiftState;
                                           X, Y: Integer);
begin
  if Button = mbMiddle then
  begin
    CloseTabToolButtonClick(nil);
  end;
end;

// xNbN
procedure TMainForm.BoardNameLabelClick(Sender: TObject);
var
  activeTab: TTopicBrowser;

begin
  activeTab := GetActiveTab();
  if Assigned(activeTab) and Assigned(activeTab.Topic) then
  begin
    OpenBoard(activeTab.Topic.OnlineBoard as TBoard);
  end;
end;

procedure TMainForm.UrlEditKeyDown(Sender: TObject;
                                   var Key: Word;
                                   Shift: TShiftState);
begin
  if Key = $0d then
  begin
    OpenUrl(Sender, UrlEdit.Text);
  end;
end;

//  j[Cxg 

// ݒEBhEJ
procedure TMainForm.OptionMenuItemClick(Sender: TObject);
var
  optionForm: TOptionForm;
  oldPadding, oldFontSize: integer;

begin
  oldPadding  := gConfig.TopicListViewColumnPadding;
  oldFontSize := gConfig.TopicListViewColumnFontSize;

  optionForm := TOptionForm.Create(self);
  optionForm.ShowModal;
  optionForm.Free;

  if oldPadding <> gConfig.TopicListViewColumnPadding then
  begin
    ChangeTopicListViewColumnPadding;
  end;
  if oldFontSize <> gConfig.TopicListViewColumnFontSize then
  begin
    TopicListView.Font.Size := gConfig.TopicListViewColumnFontSize;
  end;

  //Xꗗ̃Obh
  TopicListView.GridLines := gConfig.TopicListViewGridLines;
  //tHgݒ
  if (gConfig.Use_DoeComponent) then
  begin
    GetActiveTab.SetFont(gConfig.Doe_FontName,gConfig.Doe_FontSize);
//  GetActiveTab.SetHTMLColor(gConfig.Doe_TextColor,gConfig.Doe_NameColor,gConfig.Doe_LinkColor,gConfig.Doe_BGColor);
    GetActiveTab.SetHTMLColor(gConfig.Doe_TextColor,gConfig.Doe_NameColor,gConfig.Doe_NameLinkColor,gConfig.Doe_LinkColor,gConfig.Doe_BGColor);
  end;

end;

// {[hXg̍XV
procedure TMainForm.UpdateBoardListMenuItemClick(Sender: TObject);
var
  updateBoardForm: TUpdateBoardListForm;

begin

  updateBoardForm := TUpdateBoardListForm.Create(self);
  updateBoardForm.BoardList := FBoardList;
  updateBoardForm.ShowModal;
  updateBoardForm.Free;

  TopicListView.ForceToOpenBoard := true;
  RefreshBoardListView;
end;

// OC
procedure TMainForm.LoginMenuItemClick(Sender: TObject);
var
  loginForm: TLoginForm;

begin
  loginForm := TLoginForm.Create(self);
  loginForm.ShowModal;
  loginForm.Release;
  loginForm.Free;
end;

// open topic with newtab
procedure TMainForm.OpenNewTabMenuItemClick(Sender: TObject);
var
  topic: TTopic;
  isNewTab: Boolean;

begin
  topic := TopicListView.SelectedTopic;
  if Assigned(topic) then
  begin
    isNewTab := not gConfig.AlwaysNewTab;
    OpenTab(topic, IsNewTab);
  end;
end;



// I[g[h
procedure TMainForm.AutoReloadMenuItemClick(Sender: TObject);
var
  activeTab: TTopicBrowser;

begin
  AutoReloadMenuItem.Checked := not AutoReloadMenuItem.Checked;

  activeTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);
  if Assigned(activeTab) and Assigned(activeTab.Topic) then
  begin
    activeTab.AutoReload := AutoReloadMenuItem.Checked;
  end;
end;

procedure TMainForm.ViewLimitChangeClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  limit: integer;

begin
  activeTab := GetActiveTab();
  if not Assigned(activeTab) then
  begin
    exit;
  end;

  if Sender = ViewLimit50MenuItem then
  begin
    limit := 50;
  end
  else if Sender = ViewLimit100MenuItem then
  begin
    limit := 100;
  end
  else if Sender = ViewLimit250MenuItem then
  begin
    limit := 250;
  end
  else if Sender = ViewLimit500MenuItem then
  begin
    limit := 500;
  end
  else if Sender = ViewLimit1000MenuItem then
  begin
    limit := 1000;
  end
  else
  begin
    limit := 0;
  end;
  activeTab.ChangeViewLimit(limit);
  ChangeTab;
end;

//  c[j[Cxg 
// 
// Jn
procedure TMainForm.PatrolToolButtonClick(Sender: TObject);
var
  b: TFavoriteBoard;

begin
  b := FBoardList.MyFolder.FavoriteBoard;
  if FSelectedBoard <> b then
  begin
    OpenBoard(b);
  end;
  b.OnStateChange := TopicBrowser_ChangeDownloadState;
  b.OnComplete := TopicBrowser_ChangeDownloadState;
  b.Patrol(self);
  RepaintListViewTimer.Enabled := true;
end;
//
// 
//
procedure TMainForm.AroundMenuItemClick(Sender: TObject);
var
  b: TFavoriteBoard;

begin
  b := FSelectedBoard as TFavoriteBoard;
//if FSelectedBoard <> b then
//begin
//  OpenBoard(b);
//end;

  b.OnStateChange := TopicBrowser_ChangeDownloadState;
  b.OnComplete := TopicBrowser_ChangeDownloadState;
  b.Patrol(self);
  RepaintListViewTimer.Enabled := true;
end;



procedure TMainForm.OpenSearchTab(const str: string; mode: boolean);
begin

end;
//
// 
//
procedure TMainForm.SearchToolButtonClick(Sender: TObject);
var
  i: Integer;
  searchText: string;
  activeTab: TTopicBrowser;
begin
  SearchForm.ShowModal;
  searchText := SearchForm.SearchEdit.Text;
  if SearchForm.SearchSelect = srFromTopic then
  begin
    // Xbh̓e猟
    activeTab := GetActiveTab();
    if activeTab <> nil then
    begin
      activeTab.SearchText(searchText,true);
    end;
  end
  else if SearchForm.SearchSelect = srFromTopicList then
  begin
    // Xbhꗗ猟
    TopicListView.Search(searchText);
  end
  else if SearchForm.SearchSelect = srFromBoardList then
  begin
    // ꗗ猟
    for i := 0 to BoardListView.Items.Count - 1 do
      if AnsiContainsText(BoardListView.Items[i].Caption, SearchText) then
      begin
        BoardListView.Items[i].Selected := true;
        //BoardListBox.ItemIndex := i;
        BoardListViewClick(BoardListView);
        break;
      end;
  end;
end;
//
// gsbN
//
procedure TMainForm.TopicWriteToolButtonClick(Sender: TObject);
var
  activeTab: TTopicBrowser;

begin
  activeTab := GetActiveTab();
  if Assigned(activeTab) and Assigned(activeTab.Topic) then
  begin
    // [hpuEUݒ
    FWriteForm.TopicBrowser := activeTab;
    FWriteForm.SetTopic(ActiveTab.Topic);
  end;
end;
//
// ɃX
//
procedure TMainForm.ResAtMenuItemClick(Sender: TObject);
var
  activeTab: TTopicBrowser;

begin
  activeTab := GetActiveTab();
  if Assigned(activeTab) and Assigned(activeTab.Topic) then
  begin
    FWriteForm.TopicBrowser := activeTab;
    FWriteForm.SetTopic(activeTab.Topic, FSelectMessageNo);
  end;
end;

// ځ`
procedure TMainForm.AboneMenuItemClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  tp: TTopic;

begin
  activeTab := GetActiveTab();
  tp := activeTab.Topic;
  if Assigned(activeTab) and Assigned(tp) then
  begin
    tp.AboneNumber := FSelectMessageNo;
    gTaskManager.Request(tp, activeTab, reqtAbone);
    gTaskManager.Request(tp, activeTab, reqtOpen);
  end;
end;
//
// O̍폜	ANeBuX̃O폜
//
procedure TMainForm.TrashToolButtonClick(Sender: TObject);
var
  activeTab: TTopicBrowser;

begin
  activeTab := GetActiveTab();

  if Assigned(activeTab) and Assigned(activeTab.Topic) then
  begin
    TopicDeleted:=true;
    gTaskManager.Request(activeTab.Topic, activeTab, reqtTrash);

//  if activeTab.Topic.ScrollPosition  <> 0 then
//    activeTab.Topic.ScrollPosition  := 0;
//  if activeTab.Topic.PhysicalScrollPosition <> -1 then
//    activeTab.Topic.PhysicalScrollPosition :=-1;

  end;
end;
//
// ^XN̏I
//
procedure TMainForm.TopicBrowser_TrashComplete(Sender: TObject);
var
  activeTab: TTopicBrowser;
  tp: TTopic;

begin
  activeTab := GetActiveTab();
  if Assigned(activeTab) then
  begin
    // CloseTopicActiveTab.TopicnilɂȂ̂ŕۑ
    tp := activeTab.Topic;

//  RemoveTopicListViewItem(activeTab.Topic);

    TopicListView.TopicListRefresh;

//  TopicListView.DoubleBuffered := true;
//  TopicListView.Repaint;
//  TopicListView.DoubleBuffered := false;
    CloseTabToolButtonClick(self);
    tp.EraseIdx;

  end;
end;
//
// ^u
//
procedure TMainForm.CloseTabToolButtonClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  i, index: integer;
  found: boolean;
  pt: TPoint;

begin
  activeTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);

  if Sender = CloseMenuItem then					// 
  begin
    index := GetTabIndexAtPoint(TopicPagePopupMenu.PopupPoint);
    CloseTab(index);
  end else if Sender = CloseAllMenuItem then		// ׂĕ
  begin
    // Sĕ
    for i := 0 to TopicTabControl.Tabs.Count - 1 do
    begin
      CloseTab(0);
    end;
  end else if Sender = CloseWithoutMenuItem then	// ̃^uȊOׂĕ
  begin
    // ANeBuȃ^uȊO
    found := false;
    for i := 0 to TopicTabControl.Tabs.Count - 1 do
      if not found then
      begin
        if FBrowserList[0] <> activeTab then
        begin
          CloseTab(0)
        end else
        begin
          found := true
        end;
      end else
      begin
        CloseTab(1);
      end;
  end else if Sender = nil then
  begin
    // {^NbN^u
    GetCursorPos(pt);
    index := GetTabIndexAtPoint(pt);
    CloseTab(index);
  end else
  begin
    // ANeBuȃ^u
    CloseTab(TopicTabControl.TabIndex);
  end;
end;

// SẴgsbN_E[h
procedure TMainForm.DownloadAllTopicToolButtonClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  i: Integer;

begin
  for i := 0 to FBrowserList.Count - 1 do
  begin
    activeTab := TTopicBrowser(FBrowserList[i]);
    activeTab.Reload;
    Application.ProcessMessages;
  end;

  RepaintTabTimer.Enabled := true;
end;

// Cɓɒǉ
procedure TMainForm.FavoriteToolButtonClick(Sender: TObject);
var
  activeTab: TTopicBrowser;

begin
  activeTab := GetActiveTab();
  if not Assigned(activeTab) or not Assigned(activeTab.Topic) then
  begin
    exit;
  end;

  if not (tsFavorite in activeTab.Topic.Status) then
  begin
    Include(activeTab.Topic.Status, tsFavorite);
    FBoardList.MyFolder.FavoriteBoard.AppendTopic(activeTab.Topic);
  end else
  begin
    // Cɓ肩폜
    Exclude(activeTab.Topic.Status, tsFavorite);
    FBoardList.MyFolder.FavoriteBoard.RemoveTopic(activeTab.Topic);
    if FSelectedBoard is TFavoriteBoard then
    begin
      TopicListView.RemoveTopic(activeTab.Topic);
    end;
  end;

  activeTab.Topic.SaveIdx;
  TopicBrowser_ChangeDownloadState(self);
  if FSelectedBoard is TFavoriteBoard then
  begin
// Cɓǂݒ
    OpenBoard(FBoardList.MyFolder.FavoriteBoard);
  end;
end;

// _E[h~
procedure TMainForm.StopToolButtonClick(Sender: TObject);
begin
  gTaskManager.Cancel;
end;

// VKX
procedure TMainForm.MakeTopicToolButtonClick(Sender: TObject);
begin

  //ItCł͕\Ȃ悤ɂ
  if (FSelectedBoard = nil) or (gConfig.Offline) then exit;

  if FSelectedBoard is TOnlineBoard then
  begin
     FWRiteForm.SetBoard((FSelectedBoard as TOnlineBoard));
  end;

end;

// URL̃Rs[
procedure TMainForm.CopyUrlMenuItemClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);
  if ActiveTab <> nil then
    if ActiveTab.Topic <> nil then
      Clipboard.AsText := ActiveTab.Topic.BrowserUrl;

end;

// ^CgURL̃Rs[
procedure TMainForm.CopyTitleUrlMenuItemClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);
  if ActiveTab <> nil then
    if ActiveTab.Topic <> nil then
      Clipboard.AsText := ActiveTab.Topic.Title + #13#10 +
                          ActiveTab.Topic.BrowserUrl;

end;

// uEUŊJ
procedure TMainForm.OpenByBrowserMenuItemClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);
  if ActiveTab <> nil then
  begin
    if ActiveTab.Topic <> nil then
    begin
      OpenBrowser(ActiveTab.Topic.BrowserUrl);
    end;
  end;
end;

procedure TMainForm.CopyBoardUrlMenuButtonClick(Sender: TObject);
var
  item: TBoardListViewItem;

begin
  item := BoardListView.SelectedItem;
  if not Assigned(item) then
  begin
    exit;
  end;

  if Assigned(item.Board) and (item.Board is TOnlineBoard) then
  begin
    Clipboard.AsText := (item.Board as TOnlineBoard).BoardUrl;
  end;
end;

procedure TMainForm.OpenBoardByBrowserMenuItemClick(Sender: TObject);
var
  item: TBoardListViewItem;

begin
  item := BoardListView.SelectedItem;
  if not Assigned(item) then
  begin
    exit;
  end;

  if Assigned(item.Board) and (item.Board is TOnlineBoard) then
  begin
    OpenBrowser((item.Board as TOnlineBoard).BoardUrl);
  end;
end;
//
// ^u
//
procedure TMainForm.CloseTab(const Index: integer);
var
  b: TTopicBrowser;
  select, closedTabIndex: integer;

begin
  if (index >= 0) and (index < FBrowserList.Count) and (OpenTopicNumber >0) then
  begin
    b := TTopicBrowser(FBrowserList[index]);
    // ݃tH[ւ̎QƂNA
    if b = FWriteForm.TopicBrowser then
    begin
      FWriteForm.TopicBrowser := nil;
    end;

    // 2008.07.11 O폜łȂȂAXN[ʒuۑ
    if TopicDeleted=false then    // uO폜vł͂Ȃꍇ
    begin
      b.SaveScrollPosition;  // 2008.06.20
      b.Topic.SaveIdx;       // 2008.06.20
    end;

    if TopicTabControl.Tabs.Count = 1 then
    begin
      gTaskManager.Request(b.Topic, b, reqtClose);
//    TopicAllClosed:=true;		// 2008.07.11
      OpenTopicNumber:=0;
      LogSaveToolButton.Enabled := false;
//    BoardNameLabel.Caption:='';	// 2008.08.08
//    TopicNameLabel.Caption:='';	// 2008.08.08
//    ShowMessage('AAAAA');
    end else
    begin
      closedTabIndex := TopicTabControl.TabIndex;

//    b.SaveScrollPosition;
//    b.Topic.SaveIdx;
      Exclude(b.Topic.Status, tsOpened);

      TopicTabControl.Tabs.Delete(index);
      TopicTabControl.RemoveControl(b);
      FBrowserList.Remove(b);
      Dec(OpenTopicNumber);
      if OpenTopicNumber=0 then
      begin
//      FavoriteToolButton.Enabled := false;
        LogSaveToolButton.Enabled := false;
      end;

      if closedTabIndex = index then
      begin
        if index > 1 then
        begin
          select := index - 1
        end else
        begin
          select := 0;
        end;
        TopicTabControl.TabIndex := select;
      end;
    end;

    FOldtab := nil;
    ChangeTab;
//  if OpenTopicNumber =0 then
//  begin
//    b := TTopicBrowser(FBrowserList[index]);
//    b.Invalidate;
//    b.Update;
//    Application.ProcessMessages;		// 2008.08.16
//  end;
  end;
end;
//
// XbhJ
//
procedure TMainForm.OpenTab(Topic: TTopic; newTab: Boolean; StartNo: integer = 0);
var
  openNewTab: Boolean;
  activeTab, browser: TTopicBrowser;
  i, foundIndex: Integer;
  strNGWordFile: String;
  FileStream : TFileStream;
  Mode: Word;

  procedure Change(const idx: integer);
  begin
    TopicTabControl.TabIndex := idx;
    Application.ProcessMessages;
  end;

begin
// TopicAllClosed:=false; // 2008.07.11

   //ngword.txt݂̑̃`FbN ȂΎ
   strNGWordFile := Apppath('ngword.txt');
  if FileExists(strNGWordFile) = false then
   begin
    Mode := fmCreate or fmShareDenyWrite;
    FileStream := TFileStream.Create(strNGWordFile, Mode);		// ̈Ӗs
    FileStream.Free;
  end;

  // ɃXbh\ς݂Ȃ炻ANeBuɂ
  foundIndex := -1;
  activeTab := nil;
  for i := 0 to TopicTabControl.Tabs.Count - 1 do
  begin
    browser := TTopicBrowser(FBrowserList[i]);
    if browser.Topic = Topic then
    begin
	  activeTab := browser;
      foundIndex := i;
		break;
    end;
  end;

  if foundIndex > -1 then
  begin
    // [hJn
    Change(foundIndex);
    if StartNo > 0 then
    begin
      activeTab.StartNo := StartNo;
    end;

  //activeTab.SaveScrollPosition;		// 2008.08.19		ŕۑ悤ɂ
    activeTab.SaveScrollPosition;		// 2009.07.17
    gTaskManager.Request(Topic, activeTab, reqtReload);
  end else
  begin
    if (TTopicBrowser(FBrowserList[0]).Topic <> nil) and newTab then
    begin
      openNewTab := true;
    end else
    begin
      openNewTab := false;

	  activeTab := GetActiveTab;
      if activeTab.AutoReload then
      begin
        openNewTab := true;
      end;
    end;

    if Animate1.FileName <> '' then
    begin
      Animate1.Active := true;
    end;

    if openNewTab then
    begin
      // VJ
  	  activeTab := CreateTopicBrowser;
      Change(FBrowserList.Count - 1);
      // ŕ\ȂƃXN[Ȃ
      activeTab.Visible := true;
    end else
    begin
      // ANeBuȃ^uŊJ
      if not Assigned(activeTab) then
      begin
        exit;
      end;
      Change(TopicTabControl.TabIndex);
    end;
    if StartNo > 0 then
    begin
      activeTab.StartNo := StartNo;
    end else
    begin
      activeTab.RangeNoList.Clear;
    end;

    activeTab.SaveScrollPosition;  						// 2009.07.17
    gTaskManager.Request(Topic, activeTab, reqtOpen);
  end;

  if OpenTopicNumber=0 then				// 2008.08.17
  begin
//  FavoriteToolButton.Enabled := true;
    LogSaveToolButton.Enabled := true;
  end;

//Inc(OpenTopicNumber);
//	OpenTopicNumber:=TopicTabControl.Count;
	OpenTopicNumber:=TopicTabControl.Tabs.Count;

end;
//
//
//
function TMainForm.GetActiveTab: TTopicBrowser;
var
  index : integer;
begin

  index := TopicTabControl.TabIndex;
  if (index >= 0) and (index < FBrowserList.Count) then
  begin
    result := TTopicBrowser(FBrowserList[index])
  end else
  begin
    result := nil;
  end;
end;
//
//
//
procedure TMainForm.TopicTabControlResize(Sender: TObject);
var
  i: Integer;

begin
  if FBrowserList <> nil then
  begin
    for i := 0 to FBrowserList.Count - 1 do
    begin
      with TTopicBrowser(FBrowserList[i]) do
      begin
        Left   := 3;
        Top    := TopicTabControl.TabHeight * TopicTabControl.RowCount + 5;
        Width  := TopicTabControl.Width - 6;
        Height := TopicTabControl.Height - Top - 3;
      end;
    end;
  end;
  //ʏ㕔̉摜̈ʒu
  Image1.Left := CoolBar.Width + 1;

end;
//
// URLJ
//
procedure TMainForm.OpenUrl(Sender: TObject; Url: string);
var
  parser: T2chUrlParser;
  topic: TTopic;
  board: TOnlineBoard;
  msgNo: integer;
  isNewTab: Boolean;

  javascriptURL: string;
  activeTab: TTopicBrowser;
  i,t: integer;

  strID: string;
  regEx: TRegExpr;
  msg: TTopicMessage;
begin
  // 2008.07.13
  if (AnsiStartsStr('mailto:', URL)=true) and (gConfig.Mailto=true) then
  begin
    exit;
  end;

  //XԍNbN
  if AnsiStartsStr('menu://at/', URL) then
  begin
    msgNo := StrToIntNeo(CopyAfter(URL, 11));
    FSelectMessageNo := msgNo;

    //ځ`ς݂ǂ̔f
    regEx := TRegExpr.Create;
    regEx.Expression := '<K88_ABONE>';

    //X擾
    msg := FOldTab.Topic.MessageList[msgNo - 1];

    //ftHg
    AboneMenuItem.Visible := true;
    AboneCancelMenuItem.Visible := false;

    if msg.PostEmail <> '' then
    begin
      if regEx.Exec(msg.PostEmail) then
      begin
        //ځ`ς݂̏ꍇ
        AboneMenuItem.Visible := false;
        AboneCancelMenuItem.Visible := true;
      end;
    end;
    regEx.Free;

    ArticlePopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
    exit;
  end;

//BeNNbN JavaScript
  if AnsiStartsStr('javascript:w=window.open(''http://be.2ch.net/test/p.php?i=',URL) then
  begin
    activeTab := GetActiveTab;

    i := Length('javascript:w=window.open(''') +1;
    t := pos('''+document.URL);if(w)w.focus();void(0);', URL) -i;

    javascriptURL := copy(URL, i, t) + activeTab.Topic.BrowserUrl;

    // uEUŊJ
    OpenBrowser(javascriptURL);
    exit;
  end;

  if AnsiStartsStr('http://be.2ch.net',URL) then
  begin
    // uEUŊJ
    OpenBrowser(URL);
    exit;
  end;


  //IDNbN
  if AnsiStartsStr('menu://id/', URL) then
  begin
    strID := CopyAfter(URL, 11);
    //L
    ID_ForSearch := strID;
    IDSearchPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);

    exit;
  end;


  parser := T2chUrlParser.Create;
  try
    parser.Parse(URL);
    if not parser.Is2chUrl then
    begin
      // uEUŊJ
      OpenBrowser(Url);
      exit;
    end;

    board := FBoardList.GetBoard(parser.Server, parser.BoardName);

    if parser.TopicId <> '' then
    begin
      topic := board.GetTopic(parser.TopicId);

      { ͒
      if topic.NoIndex = true then
      begin
        OpenBoard(Board);
      end;}

      if Sender is TEdit then
      begin
        isNewTab := (GetAsyncKeyState(VK_SHIFT) < 0) xor gConfig.AlwaysNewTab;
      end else
      begin // if Sender is TTopicBrowser
        IsNewTab := true;
      end;
      if parser.StartNo > 0 then
      begin
        OpenTab(topic, IsNewTab, parser.StartNo);
      end else
      begin
        OpenTab(topic, IsNewTab);
      end;
    end else
    begin
      OpenBoard(board);
    end;
  finally
    parser.Free;
  end;
end;

function TMainForm.CreateTopicBrowser: TTopicBrowser;
begin

  if (gConfig.Use_DoeComponent) then
  begin
     gEvent := TSimpleEvent.Create;
     result := TTopicBrowserDoe.Create(self);
  end else
  begin
     result := TTopicBrowserIE.Create(self);
  end;
  result.OnChangeDownloadState := TopicBrowser_ChangeDownloadState;
  result.OnComplete := TopicBrowser_Complete;
  result.Visible := false;
  result.Parent  := TopicTabControl;
  result.OnNavigateUrl := TopicBrowser_NavigateUrl;
  FBrowserList.Add(result);
  TopicTabControl.Tabs.Add('');
end;

// {[hꗗ̍č\z
procedure TMainForm.RefreshBoardListView;
var
  i: integer;
  menuItem: TMenuItem;

begin

  BoardListView.Reload(FBoardList);

  FavoritePopupMenu.Items.Clear;

try
  for i := 1 to FBoardList.MyFolder.Boards.Count - 1 do
  begin
    if (TBoard(FBoardList.MyFolder.Boards[i]) is TAllSubscribedTopics) then
    begin
      continue;
    end;
    menuItem := TMenuItem.Create(FavoritePopupMenu);
    menuItem.Caption := TBoard(FBoardList.MyFolder.Boards[i]).DisplayName;
    menuItem.OnClick := FavoriteMenuItemClick;
    menuItem.Tag     := i;
    FavoritePopupMenu.Items.Add(menuItem);
  end;
 except
     on e: Exception do
     begin
       ShowMessage(e.Message);
     end;
  end;


end;

procedure TMainForm.TopicBrowser_NavigateUrl(Sender: TObject; URL: string);
begin
  OpenUrl(Sender, URL);
end;

procedure TMainForm.OpenBrowser(URL: string);
begin
  URL := AnsiReplaceText(URL, '[%23]', '#');

  if (gConfig.UseDefaultBrowser = false) or (gConfig.BrowserPath = '') then
  begin
    ShellExecute(Handle, 'Open', pchar(URL),'', '', SW_SHOWNORMAL)
  end else
  begin
    ShellExecute(Handle, 'Open', PChar(gConfig.BrowserPath), pchar(URL), '', SW_SHOWNORMAL);
  end;
end;

procedure TMainForm.TopicBrowser_ChangeDownloadState(Sender: TObject);
begin
  // gsbNXgXV
  RepaintListViewTimer.Enabled := true;
  // ^uĕ`
  RepaintTabTimer.Enabled := true;
  ChangeTab();

  if TopicDeleted=true then
    TopicDeleted:=false;

end;

procedure TMainForm.TopicBrowser_Complete(Sender: TObject);
begin
  // gsbNXgXV
  RepaintListViewTimer.Enabled := true;
  // ^uĕ`
  RepaintTabTimer.Enabled := true;
  ChangeTab();
  if Animate1.FileName <> '' then
  begin
    Animate1.Active := false;
  end;
  {var
  b: TTopicBrowser;
  s: string;

  ܂ȂX邩ǂl
  b := TTopicBrowser(Sender);
  if b.Topic.IsFreezed and (b.Topic.MessageCount = 0) then
  begin
    // CloseTabŃgsbN̂
    s := b.Topic.StatusText;
    CloseTab(TopicTabControl.TabIndex);
    MainStatusBar.SimpleText := s;
  end;}
end;

procedure TMainForm.RepaintTabTimerTimer(Sender: TObject);
begin
  RepaintTabTimer.Enabled := false;

  TopicTabControl.DoubleBuffered := true;
  TopicTabControl.Repaint;
  TopicTabControl.DoubleBuffered := false;
end;

procedure TMainForm.RepaintListViewTimerTimer(Sender: TObject);
begin
  RepaintListViewTimer.Enabled := false;

  TopicListView.DoubleBuffered := true;
  TopicListView.Repaint;
  TopicListView.DoubleBuffered := false;
end;

procedure TMainForm.CoolBarRestore;
var
  i: integer;
  idItems, breakItems, widthItems: TStringArray;
  band: TCoolBand;

begin
  SetLength(idItems, 0);
  SetLength(breakItems, 0);
  SetLength(widthItems, 0);

  CoolBar.Bands.BeginUpdate;
  idItems    := Split(gConfig.CoolBarBandId, ',');
  breakItems := Split(gConfig.CoolBarBandBreak, ',');
  widthItems := Split(gConfig.CoolBarBandWidth, ',');
  if (Length(idItems)    >= 3) and
     (Length(breakItems) >= 3) and
     (Length(widthItems) >= 3) then
  begin
    for i := 2 downto 0 do
    begin
      band := TCoolBand(CoolBar.Bands.FindItemID(StrToIntNeo(idItems[i])));
      band.Index := i;
      band.Break := (Trim(UpperCase(breakItems[i])) <> 'FALSE');
      band.Width := StrToIntNeo(widthItems[i]);
    end;
  end;
  CoolBar.Bands.EndUpdate;
end;

procedure TMainForm.SaveBoardButton;
begin

  FBoardButtonList.SaveToFile(AppPath('favboard.idx'));

end;
//
//
//
procedure TMainForm.ReloadOpenedTopic;
var
  b: TTopicBrowser;

begin
  b := GetActiveTab;
  if Assigned(b.Topic) and (tsOpened in b.Topic.Status) then
  begin
//	b.SaveScrollPosition;		// 2008.08.19
    OpenTab(b.Topic, false);
  end;
end;

// gsbN_E[h
procedure TMainForm.ReceiveActiveTabActionExecute(Sender: TObject);
begin
  ReloadOpenedTopic;
end;

// gsbN_E[h~
procedure TMainForm.StopTopicToolButtonClick(Sender: TObject);
var
  b: TTopicBrowser;

begin
  b := GetActiveTab;
  if Assigned(b.Topic) and (tsOpened in b.Topic.Status) then
  begin
//    b.Topic.CancelDownload;
  end;
end;
//
// []{^
//
procedure TMainForm.CloseActiveTabActionExecute(Sender: TObject);
begin
  CloseTabToolButtonClick(CloseTabToolButton);
end;

procedure TMainForm.TabBeforeActionExecute(Sender: TObject);
var
  index : integer;
begin
  index := TopicTabControl.TabIndex;
  if index > 0 then TopicTabControl.TabIndex := index - 1;
  ChangeTab();
end;

procedure TMainForm.TabForwardActionExecute(Sender: TObject);
var
  index : integer;
begin
  index := TopicTabControl.TabIndex;
  if index < TopicTabControl.Tabs.Count - 1 then TopicTabControl.TabIndex := index + 1;
  ChangeTab();
end;

procedure TMainForm.ChangeLimitAllActiveTabExecute(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab = nil then exit;

  ActiveTab.ChangeViewLimit(0);
end;

procedure TMainForm.ChangeStyle1ActionExecute(Sender: TObject);
begin
  StyleSub1ToolButton.Down := not StyleSub1ToolButton.Down;
  StyleChange(StyleSub1ToolButton);
end;

procedure TMainForm.ChangeStyle2ActionExecute(Sender: TObject);
begin
  StyleSub2ToolButton.Down := not StyleSub2ToolButton.Down;
  StyleChange(StyleSub2ToolButton);
end;

procedure TMainForm.ChangeStyle3ActionExecute(Sender: TObject);
begin
  StyleSub3ToolButton.Down := not StyleSub3ToolButton.Down;
  StyleChange(StyleSub3ToolButton);
end;
//
// Xbhqɂ폜
//
procedure TMainForm.RemoveOfflineFolderClick(Sender: TObject);
var
  item: TBoardListViewItem;
  board: TFavoriteBoard;

begin
  item := BoardListView.SelectedItem;
  if not Assigned(item) then
  begin
    exit;
  end;

  if Assigned(item.Board) and (item.Board is TFavoriteBoard) then
  begin
    board := item.Board as TFavoriteBoard;

    // TNƍ폜
    DeleteFile(AppPath(board.DisplayName + '.idx'));
    board.TopicList.Clear;

    FBoardList.MyFolder.Boards.Remove(board);
    RefreshBoardListView;
    BoardListViewClick(BoardListView);
  end;
end;

procedure TMainForm.FavoritePopupMenuPopup(Sender: TObject);
var
  i, boardIndex: integer;
  activeTab: TTopicBrowser;

begin

  activeTab := GetActiveTab();
  for i := 0 to FavoritePopupMenu.Items.Count - 1 do
  begin
    FavoritePopupMenu.Items[i].Checked := false;
    if (activeTab <> nil) and (activeTab.Topic <> nil) then
    begin
      boardIndex := FavoritePopupMenu.Items[i].Tag;
      FavoritePopupMenu.Items[i].Checked :=
        TFavoriteBoard(FBoardList.MyFolder.Boards[boardIndex]).IsHave(activeTab.Topic);
    end;
  end;
end;
//
// XbhqɂɒǉE폜
//
procedure TMainForm.FavoriteMenuItemClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  board: TFavoriteBoard;

begin
  activeTab := GetActiveTab();
  if Assigned(activeTab) and Assigned(activeTab.Topic) then
  begin
    board := TFavoriteBoard(FBoardList.MyFolder.Boards[TMenuItem(Sender).Tag]);
    if board.IsHave(activeTab.Topic) then
    begin
      board.RemoveTopic(activeTab.Topic)
    end else
    begin
      board.AppendTopic(activeTab.Topic);
    end;

    // 2008.06.19
    if board.DisplayName = FSelectedBoard.DisplayName then
    begin
      OpenBoard(board);  // ĕ\
    end;
   activeTab.Topic.SaveIdx;

  end;

end;
//
//
//
procedure TMainForm.TopicTabControlDragOver(Sender, Source: TObject;
                                            X, Y: Integer;
                                            State: TDragState;
                                            var Accept: Boolean);
begin
  if not (Source is TTabControl) then
  begin
    Accept := False;
  end;
end;

procedure TMainForm.TopicTabControlDragDrop(Sender, Source: TObject;
                                            X, Y: Integer);
var 
  index: Integer;
  pt: TPoint;

begin
  if not (Sender is TTabControl) then
  begin
    Exit;
  end;

  GetCursorPos(pt);
  index := GetTabIndexAtPoint(pt);

  if (index < 0) or (index = TopicTabControl.TabIndex) then
  begin
    exit;
  end;
  FBrowserList.Move(TopicTabControl.TabIndex, index); 
  TopicTabControl.TabIndex := index;
  ChangeTab;
end;

procedure TMainForm.BoardListViewDragOver(Sender, Source: TObject;
                                          X, Y: Integer;
                                          State: TDragState;
                                          var Accept: Boolean);
begin
  if not (Source is TTabControl) then
  begin
    Accept := False;
  end;
end;

procedure TMainForm.BoardListViewDragDrop(Sender, Source: TObject;
                                          X, Y: Integer);
var 
  activeTab: TTopicBrowser;
  index, tabIndex: Integer;
  board: TBoard;
  offlineBoard: TFavoriteBoard;
  topic: TTopic;
  item: TListItem;

begin
  activeTab := GetActiveTab();
  if not Assigned(activeTab) or not Assigned(activeTab.Topic) then
  begin
    exit;
  end;

  tabIndex := (Source as TTabControl).TabIndex;
  item := (Sender as TBoardListView).GetItemAt(X, Y);

  if not Assigned(item) then
  begin
    exit;
  end;

  index := item.Index;
  if (index < 1) or (index > FBoardList.MyFolder.Boards.Count) then
  begin
    exit;
  end;

  board := FBoardList.MyFolder.Boards[index - 1];
  if board is TFavoriteBoard and not (board is TAllSubscribedTopics) then
  begin
    offlineBoard := board as TFavoriteBoard;
    topic := TTopicBrowser(FBrowserList[TabIndex]).Topic;
    if not offlineBoard.IsHave(topic) then
    begin
      if offlineBoard.DisplayName = 'Cɓ' then
      begin
        Include(topic.Status, tsFavorite);
      end;
      offlineBoard.AppendTopic(topic);
      if FSelectedBoard = offlineBoard then
      begin
        OpenBoard(offlineBoard);
      end;
    end;
  end;
  TopicTabControl.EndDrag(false);
end;


procedure TMainForm.SetPriorityPlusItemMenuClick(Sender: TObject);
var
  Priority : Integer;
  MenuItem : TMenuItem; 
begin 
  MenuItem := TMenuItem(Sender); 
  Priority := StrToInt(MenuItem.Caption); 
  SetSelectedTopicPriority(Priority); 
end; 


procedure TMainForm.SetPriorityMenuItemClick(Sender: TObject);
var
  i: Integer;
  menuItem: TMenuItem;
  topic: TTopic;

begin
  topic := TopicListView.SelectedTopic;
  if Assigned(topic) then
  begin
    menuItem := TMenuItem(Sender);
    // do check selected priority
    for i := 0 to menuItem.Count - 1 do
    begin
      if topic.Priority = StrToInt(menuItem[i].Caption) then
      begin
        menuItem.Items[i].Checked := True;
      end;
    end;
  end;
end;
//
//
//
procedure TMainForm.TopicListViewPopupMenuPopup(Sender: TObject);
var
  item : TListItem;
  i: Integer;

begin
{$IFDEF Debug}
  TestMenu.Visible:=True;
{$ELSE}
  TestMenu.Visible:=False;
{$ENDIF}

  item := TopicListView.Selected;
  if item <> nil then
  begin
    for i := 0 to TopicListViewPopupMenu.Items.Count - 1 do
    begin
      TopicListViewPopupMenu.Items[i].Enabled := True;
    end;

    // if not yet retrieved
    if not (tsGotLog in TopicListView.SelectedTopic.Status) and
       (FSelectedBoard is TOnlineBoard) then
    begin
      TrashMenuItem.Enabled := False;
    end;
  end else
  begin
    for i := 0 to TopicListViewPopupMenu.Items.Count - 1 do
    begin
      TopicListViewPopupMenu.Items[i].Enabled := False;
    end;
  end;

  if gConfig.AlwaysNewTab then
  begin
    OpenNewTabMenuItem.Caption := '̃^uŊJ'
  end else
  begin
    OpenNewTabMenuItem.Caption := 'V^uŊJ';
  end;
end;
//
//
//
procedure TMainForm.SetSelectedTopicPriority(Priority : Integer);
var
  topic: TTopic;

begin
  topic := TopicListView.SelectedTopic;
  if Assigned(topic) then
  begin
    if topic.Priority <> Priority then
    begin
      topic.Priority := Priority;
      topic.SaveIdx();
      topicListView.Repaint;
    end; 
  end;
end; 
{ /Topic Priority Related }

procedure TMainForm.TopicPagePopupMenuPopup(Sender: TObject);
var
  activeTab: TTopicBrowser;
  i: Integer;

begin
  activeTab := GetActiveTab();
  if (activeTab = nil) or (activeTab.Topic = nil) then
  begin
    for i := 0 to TopicPagePopupMenu.Items.Count - 1 do
    begin
      TopicPagePopupMenu.Items[i].Enabled := False;
    end;
  end else
  begin
    for i := 0 to TopicPagePopupMenu.Items.Count - 1 do
    begin
      TopicPagePopupMenu.Items[i].Enabled := True;
    end;
  end;
end;

// wʒũ^uCfbNX擾
function TMainForm.GetTabIndexAtPoint(Point: TPoint): Integer;
var
  info: TTCHitTestInfo;
begin
  info.pt := TopicTabControl.ScreenToClient(Point);
  info.flags := TCHT_ONITEM;
  result := TabCtrl_HitTest(TopicTabControl.Handle, @Info);
end;


// wʒũ^u擾
function TMainForm.GetTabAtPoint(Point: TPoint): TTopicBrowser;
var 
  index: Integer;

begin
  index := GetTabIndexAtPoint(Point);
  if (index >= 0) and (index < FBrowserList.Count) then
  begin
    result := TTopicBrowser(FBrowserList[index])
  end else
  begin
    result := nil;
  end;
end;
//
// {^ҏWtH[̕\
//
procedure TMainForm.EditBoardButtonMenuItemClick(Sender: TObject);
var
  Point : TPoint;
  EditBoardButtonForm : TEditBoardButtonForm;
begin
  // FBoardButtonList ܂BfsłB
  EditBoardButtonForm := TEditBoardButtonForm.Create(self);
  GetCursorPos(point); 
  EditBoardButtonForm.Left := Point.X - EditBoardButtonForm.Width div 2; 
  EditBoardButtonForm.Top  := Point.Y - EditBoardButtonForm.Height div 3; 
  if EditBoardButtonForm.Top < 0 then
  begin
    EditBoardButtonForm.Top := 0;
  end;
  EditBoardButtonForm.BoardButtonList := FBoardButtonList;
  EditBoardButtonForm.ShowModal;
  if not EditBoardButtonForm.Cancel then 
  begin 
    CreateBoardButton();
    SaveBoardButton(); 
  end; 
  EditBoardButtonForm.Free; 
end;

procedure TMainForm.OpenAllCategoryActionExecute(Sender: TObject);
begin
  FBoardList.OpenAll;
  RefreshBoardListView;
end;

procedure TMainForm.CloseAllCategoryActionExecute(Sender: TObject);
begin
  FBoardList.CloseAll;
  RefreshBoardListView;
end;

procedure TMainForm.InputMemoMenuItemClick(Sender: TObject);
var
  topic: TTopic;
  memo: string;

begin
  topic := TopicListView.SelectedTopic;
  if Assigned(topic) then
  begin
    memo  := InputBox('', topic.Title, topic.Memo);
    if memo <> topic.Memo then
    begin
      Topic.Memo := memo;
      Topic.SaveIdx;
      TopicListView.Repaint;
    end; 
  end;
end;

procedure TMainForm.LogSweeperActionExecute(Sender: TObject);
var
  logSweeperForm: TLogSweeperForm;

begin
  logSweeperForm := TLogSweeperForm.Create(self);
  logSweeperForm.BoardList := FBoardList;
  logSweeperForm.ShowModal;
  logSweeperForm.Free;
end;





procedure TMainForm.FormIdle(Sender: TObject; var Done: Boolean);
//var
//  p: TPoint;
//  control: TControl;
//  activeTab : TTopicBrowser;
//  i: Integer;

begin
//AutoFocus̓}EXI[o[̂Ƃ̋
// Focusړdl͔p~
// if( (AutoFocus!=true) || (FActive==false) ){return;}

//  exit;

//if Init = False then
//begin
    //SetColumnOrderArray();
//  Init:= True;
//end;



//  if not gConfig.AutoFocus or not FActive then
//  begin
//    exit;
//  end;
//
//  if not self.Active then
//  begin
//    exit;
//  end;
//
//  GetCursorPos(p);
//  control := FindDragTarget(p, True);
//
//  if FMouseControl <> control then
//  begin
//    FMouseControl := control;
//    if FMouseControl = BoardListView then
//    begin
//      // ̂̍sȂƃuEUListViewœȂ
//      LeftPanel.SetFocus;
//      BoardListView.SetFocus
//    end else if FMouseControl = TopicListView then
//    begin
//      // ̂̍sȂƃuEUListViewœȂ
//      RightPanel.SetFocus;
//      TopicListView.SetFocus;
//    end else if FMouseControl is TWebBrowser then
//    begin
//      activeTab := GetActiveTab();
//      if activeTab <> nil then
//      begin
//        for i := 0 to ActiveTab.ComponentCount - 1 do
//        begin
//          if (activeTab.Components[i] is TWebBrowser) and
//             Assigned(TWebBrowser(ActiveTab.Components[i]).Document) then
//          begin
//            OleVariant(TWebBrowser(ActiveTab.Components[i]).Document).
//                                                    ParentWindow.Focus;
//          end;
//        end;
//      end;
//    end;
//  end;
end;
//
//
//
procedure TMainForm.FormDeactivate(Sender: TObject);
begin
  FActive := false;
end;
//
//
//
procedure TMainForm.GoTrayActionExecute(Sender: TObject);
begin
  // ^XNgCɑޔ
  TrayIcon.Visible := true;
  self.Visible := false;
end;

procedure TMainForm.TrayIconMouseClick(Sender: TObject;
                                       Button: TMouseButton;
                                       Shift: TShiftState;
                                       X, Y: Integer);
begin
  // ^XNgC߂
  TrayIcon.Visible := false;
  self.Visible := true;
end;
//
// XbhIꂽ߁A\A_E[h̏s
//
procedure TMainForm.OpenSelectedTopic;
var
  topic: TTopic;
  isNewTab: Boolean;

begin
//if (FOpenning=False) or (gConfig.AlwaysNewTab=false) then
//if (FOpenning=False) or (gConfig.AlwaysNewTab=true) then
  if (FOpenning=False) then
  begin
    FOpenning:=true;
    topic := TopicListView.SelectedTopic;
    if Assigned(topic) then
    begin
      isNewTab := (GetAsyncKeyState(VK_SHIFT) < 0) xor gConfig.AlwaysNewTab;
      OpenTab(topic, isNewTab);
    end;
//  FExecute:=False;
    FOpenning:=false;
  end;
end;
//
//
//
procedure TMainForm.BoardListViewSetVisible(const Visible, IsNormalMode: boolean);
begin 
  if Visible then 
  begin 
    LeftPanel.Visible := true; 
    LeftPanel.Width   := gConfig.BoardListViewWidth; 
    RightPanel.Align  := alNone; 
    Splitter1.Visible := true; 
    Splitter1.Align   := alNone; 
    Splitter1.Width   := 3;
    Splitter1.Left    := LeftPanel.Width;
    Splitter1.Align   := alLeft;
    RightPanel.Left   := Splitter1.Left + Splitter1.Width; 
    RightPanel.Align  := alClient; 
  end else 
  begin
    gConfig.BoardListViewWidth := LeftPanel.Width;
    LeftPanel.Visible  := false; 
    Splitter1.Visible  := false; 
  end; 
end; 

procedure TMainForm.TopicListViewSetVisible(const Visible, IsNormalMode : boolean); 
begin
  if Visible then 
  begin 
    TopicListView.Visible := true;
    if IsNormalMode then 
    begin
      TopicListView.Align  := alTop;
      TopicListView.Height := gConfig.TopicListViewHeight; 
    end else 
    begin 
      TopicListView.Align  := alLeft; 
      TopicListView.Width  := gConfig.TopicListViewWidth; 
    end; 
  end else 
  begin 
    // StyleSub2ToolButton ܂ StyleSub3ToolButton ꂽƂA 
    //  BrowserPanel \ĂƂ݂̂ɁA TopicListView ̍/ۑ 
    if (TopicListView.Visible <> Visible) and BrowserPanel.Visible then
    begin
      if IsNormalMode then
        gConfig.TopicListViewHeight := TopicListView.Height
      else
        gConfig.TopicListViewWidth  := TopicListView.Width;
    end;
    TopicListView.Visible := false;
    BrowserPanel.Align    := alClient;
  end;
end;

procedure TMainForm.BrowserPanelSetVisible(const Visible, IsNormalMode : boolean);
begin
  if Visible then
  begin
    BrowserPanel.Visible := true;
    BrowserPanel.Align   := alNone;
    if IsNormalMode then
    begin
      BrowserPanel.Top   := Splitter2.Top + Splitter2.Height;
    end else
    begin
      BrowserPanel.Left  := Splitter2.Left + Splitter2.Width;
    end;
    BrowserPanel.Align   := alClient;
  end else
  begin
    BrowserPanel.Visible := false;
    TopicListView.Align  := alClient;
  end;
end;

procedure TMainForm.Spliter2SetVisible(const Visible, IsNormalMode : boolean);
begin
  if Visible then
  begin
    Splitter2.Visible  := true;
    Splitter2.Align    := alNone;
    if IsNormalMode then
    begin
      Splitter2.Height := 3;
      Splitter2.Top    := TopicListView.Height;
      Splitter2.Align  := alTop;
    end else
    begin
      Splitter2.Width  := 3;
      Splitter2.Left   := TopicListView.Width;
      Splitter2.Align  := alLeft;
    end;
  end else
  begin
    Splitter2.Visible  := false;
  end;
end;

procedure TMainForm.CopyUrlTopicListClick(Sender: TObject);
var
  topic: TTopic;

begin
  if (TopicListView.ItemIndex <> -1) then
  begin
    topic := TopicListView.SelectedTopic;
    Clipboard.AsText := topic.BrowserUrl;
  end;
end;

procedure TMainForm.CopyTitleUrlTopicListClick(Sender: TObject);
var
  topic: TTopic;

begin
  if (TopicListView.ItemIndex <> -1) then
  begin
    topic := TopicListView.SelectedTopic;
    Clipboard.AsText := topic.Title + #13#10 + topic.BrowserUrl;
  end;
end;

procedure TMainForm.OpenByBrowserTopicListClick(Sender: TObject);
var
  topic : TTopic;

begin
  if (TopicListView.ItemIndex <> -1) then
  begin
    topic := TopicListView.SelectedTopic;
    OpenBrowser(topic.BrowserUrl);
  end;
end;


procedure TMainForm.Wiki1Click(Sender: TObject);
begin
  //Q˂Wiki
  OpenBrowser('http://info.2ch.net/wiki/');
end;

procedure TMainForm.N2ch1Click(Sender: TObject);
begin
  //2chIĎ
//  OpenBrowser('http://users72.psychedance.com/');
  //eÎlq
  OpenBrowser('http://sv2ch.baila6.jp/sv2ch01.html');
end;

procedure TMainForm.N18Click(Sender: TObject);
begin
  //T[o׊Ď
  OpenBrowser('http://ch2.ath.cx/load/');
end;

procedure TMainForm.N19Click(Sender: TObject);
begin
  //XbhLO
  OpenBrowser('http://www6.big.or.jp/~beyond/bbsnews/');
end;

procedure TMainForm.Katju88WikiMenuItemClick(Sender: TObject);
begin
  //Wiki
  OpenBrowser('http://katju88fix.sourceforge.jp/');
end;

procedure TMainForm.OpenKatju88SiteDMenuItemClick(Sender: TObject);
begin
  //20
  OpenBrowser('http://www.geocities.jp/katju88jp/');
end;

procedure TMainForm.OpenKatju88SiteAMenuItemClick(Sender: TObject);
begin
  //884
  OpenBrowser('http://sourceforge.jp/projects/katju88fix');
end;

procedure TMainForm.OpenKatju88SiteBMenuItemClick(Sender: TObject);
begin
  //{
//OpenBrowser('http://katju88project.sourceforge.jp/');
  OpenBrowser('http://sourceforge.jp/projects/katju88project/');
end;

procedure TMainForm.OpenKatju88SiteCMenuItemClick(Sender: TObject);
begin
  //Vx
  OpenBrowser('http://sourceforge.jp/projects/katju88kid/');
end;

procedure TMainForm.OpenKatju88_27MenuItemClick(Sender: TObject);
begin
// 027n
  OpenBrowser('http://geocities.yahoo.co.jp/gl/katju88_027x');
end;



procedure TMainForm.Open2chMenuItemClick(Sender: TObject);
begin
  OpenBrowser('http://www.2ch.net/');
end;

procedure TMainForm.Open2chGuideMenuItemClick(Sender: TObject);
begin
  OpenBrowser('http://www.2ch.net/guide/');
end;
//
// 2ch
//
procedure TMainForm.Open2chSearchMenuItemClick(Sender: TObject);
begin
  OpenBrowser('http://find.2ch.net/');
end;
//
//  O폜	XbhꗗEj[ŃO폜
//
{
procedure TMainForm.TrashMenuItemClick(Sender: TObject);
var
  topic: TTopic;
  i: integer;

begin
  topic := TopicListView.SelectedTopic;
  if Assigned(topic) then
  begin
    TopicDeleted:=true;

    if tsOpened in topic.Status then
    begin
      for i := 0 to FBrowserList.Count - 1 do
      begin
        if (FBrowserList[i] as TTopicBrowser).Topic = topic then
        begin
          TopicTabControl.TabIndex := i;
          Application.ProcessMessages;
          break;
        end;
      end;
      TrashToolButtonClick(self);
    end else
    begin
      topic.OnComplete := TopicBrowser_ChangeDownloadState;
      gTaskManager.Request(topic, nil, reqtTrash);
    //RemoveTopicListViewItem(topic);	// 2008.06.24
    end;

//  i:=TopicListView.SelectedTopic.ScrollPosition;
//  i:=TopicListView.SelectedTopic.PhysicalScrollPosition;

//  TopicListView.SelectedTopic.ScrollPosition:=0;
//  TopicListView.SelectedTopic.PhysicalScrollPosition:=-1;

//  TopicListView.InitTopicViewItem;	// 2008.07.10

  end;
end;
}
//
// New Version
//
procedure TMainForm.TrashMenuItemClick(Sender: TObject);
var
  topic: TTopic;
begin
  topic := TopicListView.SelectedTopic;
  if Assigned(topic) then
  begin
    TopicDeleted:=true;
    gTaskManager.Request(topic, nil, reqtTrash);
//  gTaskManager.Request(activeTab.Topic, activeTab, reqtTrash);	// {^̕

{
   if tsOpened in topic.Status then
    begin
      ;
    end else
    begin
      Application.ProcessMessages;		// 2008.08.16
//    TopicListView.Invalidate;
//    TopicListView.Update;
      TopicListView.TopicListRefresh;
    end;
}
  end;
end;
//
// IETCY
//
procedure TMainForm.IETextSizeMenuItemClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  size: Integer;

begin
  activeTab := GetActiveTab;
  if Assigned(activeTab) and (activeTab is TTopicBrowserIE) then
  begin
    if TMenuItem(Sender).Name = 'IETextSizeGiantMenuItem' then
    begin
      size := 4
    end else if TMenuItem(Sender).Name = 'IETextSizeLargeMenuItem' then
    begin
      size := 3
    end else if TMenuItem(Sender).Name = 'IETextSizeMediumMenuItem' then
    begin
      size := 2
    end else if TMenuItem(Sender).Name = 'IETextSizeSmallMenuItem' then
    begin
      size := 1
    end else if TMenuItem(Sender).Name = 'IETextSizeTinyMenuItem' then
    begin
      size := 0
    end else
    begin
      size := 2;
    end;
    TMenuItem(Sender).Checked := True;
    TTopicBrowserIE(activeTab).SetTextSize(size);
  end;
end;
//
// DoeTCY
//
procedure TMainForm.DoeTextSizeMenuItemClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  size: Integer;

begin
  activeTab := GetActiveTab;
  size:=gConfig.Doe_FontSize;
  if Assigned(activeTab) and (activeTab is TTopicBrowserDoe) then
  begin
    if TMenuItem(Sender).Name = 'DoeTextSize16MenuItem' then
    begin
      size := 16;
    end else 
    if TMenuItem(Sender).Name = 'DoeTextSize15MenuItem' then
    begin
      size := 15;
    end else 
    if TMenuItem(Sender).Name = 'DoeTextSize14MenuItem' then
    begin
      size := 14;
    end else 
    if TMenuItem(Sender).Name = 'DoeTextSize13MenuItem' then
    begin
      size := 13;
    end else 
    if TMenuItem(Sender).Name = 'DoeTextSize12MenuItem' then
    begin
      size := 12;
    end else 
    if TMenuItem(Sender).Name = 'DoeTextSize11MenuItem' then
    begin
      size := 11;
    end else 
    if TMenuItem(Sender).Name = 'DoeTextSize10MenuItem' then
    begin
      size := 10;
    end else 
    if TMenuItem(Sender).Name = 'DoeTextSize09MenuItem' then
    begin
      size :=  9;
    end else
    if TMenuItem(Sender).Name = 'DoeTextSize08MenuItem' then
    begin
      size :=  8;
    end;

    if TMenuItem(Sender).Name <> 'DoeTextSizeMenuItem' then
    begin
      TMenuItem(Sender).Checked := True;
      gConfig.Doe_FontSize:=size;
      GetActiveTab.SetFont(gConfig.Doe_FontName,gConfig.Doe_FontSize);
    end;

  end;
end;
//
//
//
procedure TMainForm.GoToToolButtonClick(Sender: TObject);
begin
  if UrlEdit.Text <> '' then
  begin
    OpenUrl(Sender, UrlEdit.Text);
  end;
end;

procedure TMainForm.UrlEditChange(Sender: TObject);
begin
  if UrlEdit.Text <> '' then
  begin
    GoToToolButton.Hint := UrlEdit.Text + ' J'
  end else
  begin
    GoToToolButton.Hint := '';
  end;
end;

procedure TMainForm.AddressToolBarResize(Sender: TObject);
begin
  // ŃTCYĂȂ̂

//UrlEdit.Width := AddressToolBar.Width;
  UrlEdit.Width := AddressToolBar.Width-(GoToToolButton.Left+GoToToolButton.Width);

end;
//
//
//
procedure TMainForm.AddressBarOpenBrowserClick(Sender: TObject);
begin
  if UrlEdit.Text <> '' then
  begin
    OpenBrowser(UrlEdit.Text);
  end;
end;

procedure TMainForm.AddressBarCopyURLClick(Sender: TObject);
begin
  if UrlEdit.Text <> '' then
  begin
    Clipboard.AsText := UrlEdit.Text;
  end;
end;
//
// Xbh^CgRs[
//
procedure TMainForm.AddressBarCopyThreadTitleClick(Sender: TObject);
var
  str: string;
begin
  if TopicNameLabel.Caption <> '' then
  begin
    str := TopicNameLabel.Caption;
//  str := StringReplace(str, '&gt;', '>', [rfReplaceAll]);
//  str := StringReplace(str, '&lt;', '<', [rfReplaceAll]);
//  str := StringReplace(str, '&amp;', '&', [rfReplaceAll]);
//  str := StringReplace(str, '&quot;', '"', [rfReplaceAll]);
//  str := StringReplace(str, '&&', '&', [rfReplaceAll]);
    str := ReTitle(str);

    Clipboard.AsText := str;
  end;
end;
//
//
//
procedure TMainForm.ChangeTopicListViewColumnPadding;
var
  i, newImageHeight, defaultImageHeight: Integer;
  image, mask, tmpImage: TBitMap;

begin

  // C[WXg쐬
  defaultImageHeight := TopicListViewImageList.Height;
  newImageHeight     := defaultImageHeight + gConfig.TopicListViewColumnPadding;

  if Assigned(FImageList) then
  begin
    FImageList.Free;
  end;
  FImageList := TImageList.CreateSize(defaultImageHeight, newImageHeight);

  for i := 0 to TopicListViewImageList.Count - 1 do
  begin
    image    := TBitMap.Create;
    mask     := TBitMap.Create;
    tmpImage := TBitMap.Create;

    TopicListViewImageList.GetBitmap(i, tmpImage);

    image.Width     := defaultImageHeight;
    image.Height    := newImageHeight;
    mask.Width      := image.Width;
    mask.Height     := image.Height;
    tmpImage.Width  := image.Width;
    tmpImage.Height := image.Height;

    image.Canvas.Brush.Color := tmpImage.Canvas.Pixels[0,0];
    image.Canvas.FillRect(Rect(0,0,defaultImageHeight, newImageHeight));
    image.Canvas.Draw(0, gConfig.TopicListViewColumnPadding div 2, TmpImage);

    mask.Canvas.Draw(0, 0, Image);
    mask.Mask(mask.Canvas.Pixels[0,0]);

    FImageList.Add(image, mask);

    image.Free;
    mask.Free;
    tmpImage.Free;
  end;

  if TopicListView.SmallImages <> nil then
  begin
    TopicListView.SmallImages.Free;
  end;

  TopicListView.SmallImages := FImageList;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var
  logSweeper: TLogSweeper;

begin
  try

    if FSelectedBoard is TFavoriteBoard then
    begin
      (FSelectedBoard as TFavoriteBoard).Save;
    end;
    FBoardList.Save;

    if gConfig.DoLogClear then
    begin
      logSweeper := TLogSweeper.Create;
      try
        with logSweeper do
        begin
          BoardList := FBoardList;
          LogLimitSize := gConfig.LogLimitSize;
          FreeOnTerminate := false;
          Resume;
          WaitFor;
        end;
      finally
        logSweeper.Free;
      end;
    end;
  except on e: Exception do
    Showmessage(e.Message);
  end;
end;

//j[NG[hݒ
procedure TMainForm.NG1Click(Sender: TObject);
var
  strMemo: string;
begin
  strMemo := Apppath('ngword.txt');
  ShellExecute(Handle, 'Open', pchar(strMemo),'', '', SW_SHOWNORMAL);
end;

procedure TMainForm.LogSaveModeToolButtonClick(Sender: TObject);
//begin
//  gConfig.DoLogSave := LogSaveModeToolButton.Down;
//  // 2005/04/17
//  //SaveTopicToolButton.Visible := not LogSaveModeToolButton.Down;
//end;
begin
  if gConfig.DoLogSave = True then
  begin
    gConfig.DoLogSave := False;
    LogSaveModeToolButton.Down := False;

    LogSaveToolButton.Visible := true;			// 2008.08.17
    if OpenTopicNumber > 0 then
      LogSaveToolButton.Enabled := true
    else
      LogSaveToolButton.Enabled := false;

    TopicToolBar.Left := TopicToolBar.Left - LogSaveToolButton.Width;
    TopicToolBar.Width := TopicToolBar.Width + LogSaveToolButton.Width;

  end else
  begin
    gConfig.DoLogSave := True;
    LogSaveModeToolButton.Down := True;

    LogSaveToolButton.Visible := false;			// 2008.08.17
    TopicToolBar.Left := TopicToolBar.Left + LogSaveToolButton.Width;
//  TopicToolBar.Width := TopicToolBar.Width - LogSaveToolButton.Width;
  end;
end;



procedure TMainForm.SaveTopicToolButtonClick(Sender: TObject);
var
  activeTab: TTopicBrowser;

begin
  activeTab := GetActiveTab;
  if Assigned(activeTab) and Assigned(activeTab.Topic) then
  begin
    activeTab.Topic.SaveIdx;
    activeTab.Topic.SaveDat;
  end;
end;

//IC/ItC؂ւ{^
procedure TMainForm.OnlineToolButtonClick(Sender: TObject);
//begin
//  if (self.OnlineToolButton.Down) then
//  begin
//     MainStatusBar.SimpleText := 'IC[hɐ؂ւ܂B';
//     gConfig.Offline := false;
//  end else
//  begin
//     MainStatusBar.SimpleText := 'ItC[hɐ؂ւ܂B';
//     gConfig.Offline := true;
//  end;
//
//  ChangeCaption();
//end;
begin
  if gConfig.Offline = True then
  begin
     MainStatusBar.SimpleText := 'IC[hɐ؂ւ܂B';
     gConfig.Offline := False;
     self.OnlineToolButton.Down := True;
  end else
  begin
     MainStatusBar.SimpleText := 'ItC[hɐ؂ւ܂B';
     gConfig.Offline := true;
     self.OnlineToolButton.Down := False;
  end;

  ChangeCaption();
end;



procedure TMainForm.BoardListViewMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  item: TBoardListViewItem;
  boardName: string;

begin
  if Button = mbLeft then
  begin
    exit;
  end;

  // {^
  item := BoardListView.SelectedItem;
  if not Assigned(item) then
  begin
    exit;
  end;
  if Assigned(item.Board) then
  begin
    boardName := TBoard(item.Board).DisplayName
  end else
  begin
    boardName := '' + item.Category.CategoryName;
  end;

  // o^Ă΃`FbN
  if FBoardButtonList.IndexOf(boardName) = -1 then
  begin
    RegisterBoardButtonMenuItem.Checked := false
  end else
  begin
    RegisterBoardButtonMenuItem.Checked := true;
  end;

  // }CtH_ȂAXbhqɍ쐬j[\
  if boardName = '}CtH_' then
  begin
    CreateOfflineFolder.Visible := true
  end else
  begin
    CreateOfflineFolder.Visible := false;
  end;

  // XbhqɂȂ폜j[\
  RemoveOfflineFolder.Visible := false;
  if Assigned(item.Board) and (item.Board is TFavoriteBoard) and
                              not (item.Board.DisplayName = 'Cɓ') and
                              not (item.Board is TAllSubscribedTopics) then
  begin
    RemoveOfflineFolder.Visible := true;
  end;

  // ۂ̔ȊÓuURLRs[vuuEUŊJv\
  CopyBoardUrlMenuButton.Visible     := True;
  OpenBoardByBrowserMenuItem.Visible := True;
  if not (item.Board is TOnlineBoard) then
  begin
    CopyBoardUrlMenuButton.Visible     := False;
    OpenBoardByBrowserMenuItem.Visible := False;
  end;

  // 񃁃j[\ 2008.04.29
  AroundMenuItem.Visible := false;
  if Assigned(item.Board) and (item.Board is TFavoriteBoard) and
                              not (item.Board.DisplayName = 'SǃX') and
                              not (item.Board is TAllSubscribedTopics) then
  begin
    AroundMenuItem.Visible := true;
  end;

  BoardListViewPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
end;

//Xbhځ[
procedure TMainForm.ThreadAboneItemClick(Sender: TObject);
var
  topic: TTopic;
  strAboneTitle: String;
  strNGThreadFile: String;
  Mode: Word;
  FileStream : TFileStream;

begin
  //t@CJAX^Cgǉ݂
  strNGThreadFile := Apppath('ngthread.txt');
  if FileExists(strNGThreadFile) then
    Mode := fmOpenReadWrite or fmShareDenyWrite
  else
    Mode := fmCreate or fmShareDenyWrite;


  if (TopicListView.ItemIndex <> -1) then
  begin
    topic := TopicListView.SelectedTopic;
    strAboneTitle := topic.Title + #13#10;

    FileStream := TFileStream.Create(strNGThreadFile, Mode);
    FileStream.Seek(0, soFromEnd);
    FileStream.WriteBuffer(PChar(strAboneTitle)^, Length(strAboneTitle));

    FileStream.Free;
  end;

end;

//j[NGXbhݒ
procedure TMainForm.NG2Click(Sender: TObject);
var
  strNGThreadFile: String;
begin
  strNGThreadFile := Apppath('ngthread.txt');

  //֘AtꂽAvŊJ
  ShellExecute(Handle, 'Open', pchar(strNGThreadFile),'', '', SW_SHOWNORMAL);
end;
//
//BEOCtH[̕\
//
procedure TMainForm.BELoginMenuItemClick(Sender: TObject);
var
  loginForm: TBELoginForm;
begin
  loginForm := TBELoginForm.Create(self);
  loginForm.ShowModal;
  loginForm.Release;
  loginForm.Free;

  ChangeCaption();
end;

//v\
procedure TMainForm.ToukeiInfoMenuItemClick(Sender: TObject);
var
  toukeiForm: TToukeiInfoForm;

begin
  toukeiForm := TToukeiInfoForm.Create(self);
  toukeiForm.ShowModal;
  toukeiForm.Release;
  toukeiForm.Free;

end;
//
// ^CgLvVύX
//
procedure TMainForm.ChangeCaption();
var
  strCaption: string;
  str: string;

  activeTab: TTopicBrowser;
begin

{   //////// Sʏ ///////
  self.Caption := 'Katju88 Version ' + GetVersionStr;

  //`R|[lg
  if (gConfig.Use_DoeComponent) then
     self.Caption := self.Caption + ' Doe'
  else
     self.Caption := self.Caption + ' IE';

  //
  self.Caption :=  self.Caption + ' [ ' + FSelectedBoard.DisplayName + ' ]';

  //ItC\p
  if (gConfig.Offline) then
     self.Caption := self.Caption + ' sItCt';

  //OCp
  if gConfig.SessionID <> '' then
     self.Caption := self.Caption + ' ';

  //BEOCp
  if (gConfig.BELogin) then
     self.Caption := self.Caption + ' BEOC';

  // X^Cg\ 2008.05.19
  if gConfig.ViewThreadTitle = True then
  begin
     str := TopicNameLabel.Caption;
     str := StringReplace(str, '&gt;', '>', [rfReplaceAll]);
     str := StringReplace(str, '&lt;', '<', [rfReplaceAll]);
     str := StringReplace(str, '&amp;', '&', [rfReplaceAll]);
     str := StringReplace(str, '&quot;', '"', [rfReplaceAll]);
     str := StringReplace(str, '&&', '&', [rfReplaceAll]);

     self.Caption := self.Caption + ' ' + str;
  end;
}

  strCaption := 'Katju88 Version ' + GetVersionStr;

  //`R|[lg
  if (gConfig.Use_DoeComponent) then
     strCaption := strCaption + ' Doe'
  else
     strCaption := strCaption + ' IE';

  //
  strCaption :=  strCaption + ' [ ' + FSelectedBoard.DisplayName + ' ]';

  //ItC\p
  if (gConfig.Offline) then
     strCaption := strCaption + ' sItCt';

  //OCp
  if gConfig.SessionID <> '' then
     strCaption := strCaption + ' ';

  //BEOCp
  if (gConfig.BELogin) then
     strCaption := strCaption + ' BEOC';

  // X^Cg\ 2008.05.19
  if gConfig.ViewThreadTitle = True then
  begin
//  if TopicAllClosed=false then // 2008.07.11
    if OpenTopicNumber > 0 then // 2008.07.11
    begin
//    str := TopicNameLabel.Caption;
      activeTab := GetActiveTab();
//    if activeTab<>Nil then     // 2009.01.19
      if activeTab.Topic<>Nil then     // 2009.01.23
      begin
        str := activeTab.Topic.Title;
        str := ReTitle(str);
        strCaption := strCaption + ' ' + str;
      end;
    end;
  end;

  if self.Caption <> strCaption then
    self.Caption := strCaption;

end;
//
//ځ` 2005/04/13ǉ
//
procedure TMainForm.AboneCancelMenuItemClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  tp: TTopic;

begin
  activeTab := GetActiveTab();
  tp := activeTab.Topic;
  if Assigned(activeTab) and Assigned(tp) then
  begin
    //Xځ`-1ċt]𑗂
    tp.AboneNumber := FSelectMessageNo * -1;
    gTaskManager.Request(tp, activeTab, reqtAbone);
    gTaskManager.Request(tp, activeTab, reqtOpen);
  end;
end;
//
// DoẻENbN
//
procedure TMainForm.DoePopUp(const statusText: string);
begin

  clipText := statusText;

  DoePopupMenuCut.Enabled:=False;

  if statusText='' then
  begin
    DoePopupMenuCopy.Enabled:=False;
  end
  else
  begin
    DoePopupMenuCopy.Enabled:=True;
  end;

  DoePopupMenuPaste.Enabled:=False;
  DoePopupMenuSelectAll.Enabled:=True;
  DoePopupMenuPrint.Enabled:=False;
  DoePopupMenuBack.Enabled:=False;
  DoePopupMenuOver.Enabled:=False;

  DoePopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);

end;
//
// Nbv{[hւ̃Rs[
//
procedure TMainForm.DoePopupMenuCopyClick(Sender: TObject);
begin
   Clipboard.AsText := clipText;
end;

procedure TMainForm.DoePopupMenuCutClick(Sender: TObject);
begin
// ؂
end;

procedure TMainForm.DoePopupMenuPasteClick(Sender: TObject);
begin
// \t
end;

procedure TMainForm.DoePopupMenuSelectAllClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
//i: Integer;
begin
// ׂđI
  activeTab  := GetActiveTab();
  activeTab.SelectAll();

end;

procedure TMainForm.DoePopupMenuPrintClick(Sender: TObject);
begin
// 
end;

procedure TMainForm.DoePopupMenuBackClick(Sender: TObject);
begin
// Oɖ߂
end;

procedure TMainForm.DoePopupMenuOverClick(Sender: TObject);
begin
// ɐi
end;
// 
procedure TMainForm.DoePopupMenuSearchNextClick(Sender: TObject);
begin
  if gConfig.Use_DoeComponent = True then
    DoeSearchForm.SearchNext;
end;
// O
procedure TMainForm.DoePopupMenuSearchPrevClick(Sender: TObject);
begin
  if gConfig.Use_DoeComponent = True then
    DoeSearchForm.SearchPrev;
end;
//
//IDo
//
procedure TMainForm.IDSearchPopupMenuItemClick(Sender: TObject);
begin
   if ID_forSearch = '' then exit;

   //DoeNX̏
   GetActiveTab().IDSearch(ID_forSearch);

end;
//
// DoeSearch
//
procedure TMainForm.DoeSearchToolButtonClick(Sender: TObject);
begin
  DoeSearch;
end;

procedure TMainForm.IDSearchPopupBMenuItemClick(Sender: TObject);
begin
   //IDo|bvAbv

   if ID_forSearch = '' then exit;

   //DoeNX̏
   GetActiveTab().IDSearchPopUp(ID_forSearch);

end;

//Oo^
procedure TMainForm.RegisterOtherBoardButtonClick(Sender: TObject);
  { ֐FExtractUrlPath URLpX𒊏o}
  function ExtractUrlPath(const FileName: string): string;
  var
    I: Integer;
  begin
    I := LastDelimiter('/:', FileName);
    Result := Copy(FileName, 1, I);
  end;

  { ֐FExtractUrlName URLt@C𒊏o}
  function ExtractUrlName(const FileName: string): string;
  var
    I: Integer;
  begin
    I := LastDelimiter('/:', FileName);
    Result := Copy(FileName, I + 1, MaxInt);
  end;

  { ֐FIsUrlDelimiter 񒆂̎wʒu / ǂ}
  function IsUrlDelimiter(const S: string; Index: Integer): Boolean;
  begin
    Result := (Index > 0) and (Index <= Length(S)) and (S[Index] = '/')
      and (ByteType(S, Index) = mbSingleByte);
  end;

  { ֐FExcludeTrailingSlash  t@C̖'/'菜}
  function ExcludeTrailingSlash(const S: string): string;
  begin
    Result := S;
    if IsUrlDelimiter(Result, Length(Result)) then
      SetLength(Result, Length(Result)-1);
  end;
var
  InputName, InputURL, ABordMainURL, ABordSubURL:string;
  OtherBoard: TStringList;
  RegEx: TRegExpr;
begin
  OtherBoard := TStringList.Create;
  RegEx := TRegExpr.Create;
  try

  if FileExists(AppPath('other.brd')) then
  OtherBoard.LoadFromFile(AppPath('other.brd'));

  InputName := InputBox('{[h', '{[h', '');
  InputURL  := InputBox('{[hAhX', '{[hAhX', '');

  InputURL := ExcludeTrailingSlash(InputURL);

  ABordMainURL  := ExcludeTrailingSlash(ExtractUrlPath(InputURL));
  ABordSubURL   := ExtractUrlName(InputURL);

  RegEx.Expression := '(http://)(.+)';

  if (InputName <> '') and (InputURL <> '') then
  begin
    if RegEx.Exec(ABordMainURL) then
    begin
    OtherBoard.Add(RegEx.Match[2] + #9 + ABordSubURL + #9 + InputName);
    end else
    ShowMessage('G[');
  end;

  OtherBoard.SaveToFile(AppPath('other.brd'));

//  {[hXgXV
//  FBoardList.Clear;
//  FBoardList.Init;
//  RefreshBoardListView;


  finally
  OtherBoard.Free;
  RegEx.Free;
  end;
end;

procedure TMainForm.ReGetMenuItemClick(Sender: TObject);
begin
//
end;



procedure TMainForm.FormResize(Sender: TObject);
//var
//mHeight: Integer;
//I: Integer;
begin

// TopPanel.Height:=2+
// CoolBar.Bands[0].Height+2+
// CoolBar.Bands[1].Height+2+
// CoolBar.Bands[2].Height+2;

//TopPanel.Height:=CoolBar.Height;

//for I:=0 to 2 do
//begin
//  mHeight:=CoolBar.Bands[I].Top+CoolBar.Bands[I].Height;
//end;

end;
//
//
//
procedure TMainForm.ApplicationEvents1Message(var Msg: tagMSG; var Handled: Boolean);
var
  Wnd: HWnd;
//Len: integer;
  ClassName: PChar;
  ScrollCode: WORD;

begin
	if gConfig.AutoMouseWheel = True then
	begin
		if Msg.message = WM_MOUSEWHEEL then
		begin
			Wnd:=WindowFromPoint(Msg.pt);
			if Wnd <> Msg.hwnd then
			begin
				GetMem(ClassName,32);
				GetClassName(Wnd,ClassName,31);
				if (ClassName='MS_WINTOPIC') or (ClassName='SysTreeView') or (ClassName='SysListView') then
				begin
					if HIWORD(Msg.wParam) > 32767 then
						ScrollCode:=SB_LINEDOWN
					else
						ScrollCode:=SB_LINEUP;
					PostMessage(Wnd,WM_VSCROLL,MAKEWPARAM(ScrollCode,0),NULL);
					PostMessage(Wnd,WM_VSCROLL,MAKEWPARAM(ScrollCode,0),NULL);
					PostMessage(Wnd,WM_VSCROLL,MAKEWPARAM(ScrollCode,0),NULL);
					PostMessage(Wnd,WM_VSCROLL,MAKEWPARAM(SB_ENDSCROLL,0),NULL);
				end
				else
				begin
					PostMessage(Wnd,WM_MOUSEWHEEL,Msg.wParam,Msg.lParam);
				end;

				FreeMem(ClassName);
				Handled:=True;
			end;
		end;
	end;
end;


//
// J̕сAݒ肷(񂪑ꍇɂΉĂ)
//
procedure TMainForm.SetColumnOrderArray();
var
  items: TStringArray;
  i: integer;
  ID: integer;
  pColumArray: PInteger;
  Count: integer;
  Size: integer;

begin
  Count:=TopicListView.Columns.Count;  // 
  items := Split(gConfig.TopicListViewColumnOrders, ',');
  Size:=Length(items);
  if (Size>0) and (gConfig.TopicListViewColumnOrders[Length(gConfig.TopicListViewColumnOrders)]=',') then
     Dec(Size);			// `Ȃvf-1
  if Size >= 11 then
  try
    GetMem(pColumArray,SizeOf(PInteger)*Count);
    for i:= 0 to Count-1 do
      PIntegerArray(pColumArray)[i]:=i;			// 

    // 𑝂₵́Avf1ȂƂɂȂ
    for i := 0 to Size -1 do
    begin
      PIntegerArray(pColumArray)[i] := StrToIntNeo(items[i]);
    end;

    ListView_SetColumnOrderArray(TopicListView.Handle,Count,pColumArray);
    FreeMem(pColumArray);

  except
   on e: EOutOfMemory do
   begin
     ShowMessage('słBvOI܂B');
     Application.Terminate;
   end;
   on e: Exception do
   begin
     Application.Terminate;
   end;
  end;


  // Widthݒ肷
  TopicListView.Column[Count-1].Width := 60;
  items := Split(gConfig.TopicListViewColumnWidths, ',');
  if Length(items) >= 11 then
  begin
    for i := 0 to Size -1 do
    begin
      ID:=TopicListView.Column[i].ID;
      TopicListView.Column[i].Width := StrToIntNeo(items[ID]);
    end;
  end;

end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TMainForm.TestMenuClick(Sender: TObject);
//	var
//	//ColumArray: Array[0..31] of Integer;
//	  pColumArray: PInteger;
//	begin
//	//
//	//
//	// J̕тݒ肷
//	//
//	GetMem(pColumArray,SizeOf(PInteger)*11);
//	PIntegerArray(pColumArray)[ 0]:= 1;
//	PIntegerArray(pColumArray)[ 1]:= 0;
//	PIntegerArray(pColumArray)[ 2]:= 2;
//	PIntegerArray(pColumArray)[ 3]:= 3;
//	PIntegerArray(pColumArray)[ 4]:= 4;
//	PIntegerArray(pColumArray)[ 5]:= 5;
//	PIntegerArray(pColumArray)[ 6]:= 6;
//	PIntegerArray(pColumArray)[ 7]:= 7;
//	PIntegerArray(pColumArray)[ 8]:= 8;
//	PIntegerArray(pColumArray)[ 9]:= 9;
//	PIntegerArray(pColumArray)[10]:=10;
//	ListView_SetColumnOrderArray(TopicListView.Handle, 11, pColumArray);
//	FreeMem(pColumArray);

var
  activeTab: TTopicBrowser;
begin
    activeTab := GetActiveTab();
    activeTab.SaveScrollPosition;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
function TMainForm.GetInit(): Boolean;
begin
  result := Init;
end;

procedure TMainForm.SetInit(flag: Boolean);
begin
  Init := flag;
end;
//------------------------------------------------------------------
//
// 񌟍
//
//------------------------------------------------------------------
//procedure TMainForm.SearchString;
//var
//  i: Integer;
//  searchText: string;
//  activeTab: TTopicBrowser;
//begin
//  SearchForm.ShowModal;
//  searchText := SearchForm.SearchEdit.Text;
//  if SearchForm.SearchSelect = srFromTopic then
//  begin
//    // Xbh̓e猟
//    activeTab := GetActiveTab();
//    if activeTab <> nil then
//    begin
//      activeTab.SearchText(searchText,true);
//    end;
//  end
//  else if SearchForm.SearchSelect = srFromTopicList then
//  begin
//    // Xbhꗗ猟
//    TopicListView.Search(searchText);
//  end
//  else if SearchForm.SearchSelect = srFromBoardList then
//  begin
//    // ꗗ猟
//    for i := 0 to BoardListView.Items.Count - 1 do
//      if AnsiContainsText(BoardListView.Items[i].Caption, SearchText) then
//      begin
//        BoardListView.Items[i].Selected := true;
//        //BoardListBox.ItemIndex := i;
//        BoardListViewClick(BoardListView);
//        break;
//      end;
//  end;
//end;
//
// Doě
//
procedure TMainForm.DoeSearch();
begin
  if gConfig.Use_DoeComponent = false then exit;

{
  if DoeSearched = True then exit;
  FDoeSearchForm := TDoeSearchForm.Create(self);
  DoeSearched:=True;
  FDoeSearchForm.FormStyle:=fsStayOnTop;
  FDoeSearchForm.SetDoeBrowser(GetActiveTab());
//FDoeSearchForm.ShowModal;
  FDoeSearchForm.Show;
}

  if DoeSearched = True then exit;
  DoeSearched:=True;
  DoeSearchForm.FormStyle:=fsStayOnTop;
  DoeSearchForm.SetDoeBrowser(GetActiveTab());
  DoeSearchForm.Show;


//ȉAÂ@
//{
//DoeSearchForm.ShowModal;
//searchText := DoeSearchForm.SearchEdit.Text;
//searchDown := DoeSearchForm.FMode_SearchDown;
//
// gsbN̓e猟
//activeTab := GetActiveTab();
//if activeTab <> nil then
//begin
//   activeTab.SearchText(searchText,searchDown);
//end;
//}

end;
//
//
//
procedure TMainForm.SearchDoeNextExecute(Sender: TObject);
begin
  if gConfig.Use_DoeComponent = true then
    DoeSearchForm.SearchNext;
end;

procedure TMainForm.SearchDoePrevExecute(Sender: TObject);
begin
  if gConfig.Use_DoeComponent = true then
    DoeSearchForm.SearchPrev;
end;
//
// ʂ[ɋz
//
procedure TMainForm.AdjustWindow(var Msg : TWMWindowPosChanging);
var
  rec : TRect;
  RANGE : Integer;  // zt
begin
  Inherited;

  if gConfig.AdjustWindow = True then
  begin
    RANGE:=gConfig.AdjustWindowRange;
    SystemParametersInfo(SPI_GETWORKAREA, 0, @rec, 0);

    if((Msg.WindowPos.flags and SWP_NOMOVE) = 0 ) then  // ݈ʒuێȂ
    begin
      if( (Msg.WindowPos.x<rec.left+RANGE) and (Msg.WindowPos.x>=rec.left) ) then
        Msg.WindowPos.x:=rec.left;

      if( (Msg.WindowPos.y<rec.top+RANGE) and (Msg.WindowPos.y>=rec.top) ) then
        Msg.WindowPos.y:=rec.top;

      if( (Msg.WindowPos.x>rec.right-Msg.WindowPos.cx-RANGE) and (Msg.WindowPos.x<=rec.right-Msg.WindowPos.cx) ) then
        Msg.WindowPos.x:=rec.right-Msg.WindowPos.cx;

      if( (Msg.WindowPos.y>rec.bottom-Msg.WindowPos.cy-RANGE) and (Msg.WindowPos.y<=rec.bottom-Msg.WindowPos.cy) ) then
        Msg.WindowPos.y:=rec.bottom-Msg.WindowPos.cy;
    end;
  end;


//typedef TWMWindowPosMsg  TWMWindowPosChanging;
//struct TWMWindowPosMsg
//{
//	unsigned Msg;
//	int Unused;
//	tagWINDOWPOS *WindowPos;
//	int Result;
//};
end;

procedure TMainForm.CoolBarChange(Sender: TObject);
begin
//TopPanel.Height:=2+
//CoolBar.Bands[0].Height+2+
//CoolBar.Bands[1].Height+2+
//CoolBar.Bands[2].Height+2;
end;

procedure TMainForm.CoolBarResize(Sender: TObject);
begin
  CoolPanel.Height:=CoolBar.Height;
  AnimatePanel.Height:=CoolBar.Height;
  TopPanel.Height:=CoolBar.Height;
  UrlEdit.Width := AddressToolBar.Width;
end;


//
// Not DoLogSave Oۑ
//
procedure TMainForm.LogSaveToolButtonClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
begin
  activeTab := GetActiveTab();
  if Assigned(activeTab) and Assigned(activeTab.Topic) then
  begin
    activeTab.Topic.SaveLog;
//  TopicListView.TopicListRefresh;		// IʒuNAĂ܂
//  Application.ProcessMessages;		// \͍XVȂ
    TopicListView.Invalidate;
//  TopicListView.Update;
  end;
end;

//procedure TMainForm.SaveScrollPosition;
//var
//  activeTab: TTopicBrowser;
//begin
//	activeTab := GetActiveTab();
//	activeTab.SaveScrollPosition;
//end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TMainForm.ApplicationEvents1Activate(Sender: TObject);
var
  mhwnd:HWND;

begin

  if FWriteForm.Visible=true then
  begin
//  mhwnd:=GetNextWindow(self.Handle,GW_HWNDNEXT);
    mhwnd:=GetNextWindow(self.Handle,GW_HWNDPREV);		// ̃EChE
    if mhwnd<>FWriteForm.Handle then
    begin
      SetWindowPos(self.Handle,HWND_NOTOPMOST,self.Left,self.Top,self.Width,self.Height,SWP_NOMOVE or SWP_NOSIZE or SWP_NOACTIVATE);
      MainStatusBar.SimpleText:='SetWindowPos()';
    end;
  end;

end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TMainForm.ApplicationEvents1Deactivate(Sender: TObject);
begin
//SetWindowPos(self.Handle,HWND_BOTTOM,self.Left,self.Top,self.Width,self.Height,SWP_NOACTIVATE or SWP_NOSIZE);
//if (Assigned(FWriteForm)=True) and (FWriteForm.Visible=True) then
//  SetWindowPos(FWriteForm.Handle,HWND_BOTTOM,FWriteForm.Left,FWriteForm.Top,FWriteForm.Width,FWriteForm.Height,SWP_NOACTIVATE or SWP_NOSIZE);

  FWriteForm.FormDeactivateEx();
end;

end.

