unit untOptionForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, untTool, untColorButton;

type
  TOptionForm = class(TForm)
    TabSheet5: TTabSheet;
    PageControl1: TPageControl;
    TabSheet2: TTabSheet;
    OKButton: TButton;
    CancelButton: TButton;
    TabSheet1: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    OpenDialog1: TOpenDialog;
    TabSheet6: TTabSheet;
    BordListGroupBox: TGroupBox;
    BoardListNoColorCheckBox: TCheckBox;
    BoardListOneCategoryCheckBox: TCheckBox;
    TopicListGroupBox: TGroupBox;
    ListViewFontSizeLabel: TLabel;
    Label8: TLabel;
    ListViewFontSizeEdit: TEdit;
    ListViewColumnPaddingEdit: TEdit;
    GridLineCheckBox: TCheckBox;
    AutoSortCheckBox: TCheckBox;
    TopicListColorCheckBox: TCheckBox;
    TopicListColorGroupBox: TGroupBox;
    FavoriteLabel: TLabel;
    NotGotTopicLabel: TLabel;
    NewMessageLabel: TLabel;
    NoNewMessageLabel: TLabel;
    NewTopicLabel: TLabel;
    TabGroupBox: TGroupBox;
    AlwaysNewTabCheckBox: TCheckBox;
    MultiLineTabCheckBox: TCheckBox;
    AutoMouseWheelCheckBox: TCheckBox;
    ThreadGroupBox: TGroupBox;
    Label2: TLabel;
    HideMailAddressCheckBox: TCheckBox;
    PicturePreviewCheckBox: TCheckBox;
    ViewLimitComboBox: TComboBox;
    GroupBox4: TGroupBox;
    Label12: TLabel;
    UseCompRadioButton1: TRadioButton;
    UseCompRadioButton2: TRadioButton;
    GroupBox1: TGroupBox;
    UseReadProxyCheckBox: TCheckBox;
    ReadProxyEdit: TEdit;
    UseWriteProxyCheckBox: TCheckBox;
    WriteProxyEdit: TEdit;
    Label1: TLabel;
    ConnectTimeEdit: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    UseDefaultBrowserCheckBox: TCheckBox;
    Label4: TLabel;
    BrowserPathEdit: TEdit;
    BrowseBrowserPathButton: TButton;
    Label9: TLabel;
    SkinPathEdit: TEdit;
    SkinPathButton: TButton;
    Label5: TLabel;
    KoteHanEdit: TEdit;
    KoteMailEdit: TEdit;
    Label6: TLabel;
    GroupBox3: TGroupBox;
    Label7: TLabel;
    DoLogClearCheckBox: TCheckBox;
    LogSizeEdit: TEdit;
    CheckBox5: TCheckBox;
    DoeGroupBox: TGroupBox;
    DoeFontNameLabel: TLabel;
    DoeFontSizeLabel: TLabel;
    DoeTextColorLabel: TLabel;
    DoeBGColorLabel: TLabel;
    DoeNameColorLabel: TLabel;
    DoeLinkColorLabel: TLabel;
    DoeFontNameEdit: TEdit;
    DoeFontSizeEdit: TEdit;
    Label15: TLabel;
    BordListURLEdit: TEdit;
    Label16: TLabel;
    LogPathEdit: TEdit;
    LogPathButton: TButton;
    ListViweColorCheckBox: TCheckBox;
    BackColorLabel: TLabel;
    TabSheet7: TTabSheet;
    CheckBoxViewThreadTitle: TCheckBox;
    CheckBoxMyFolderIdx: TCheckBox;
    EditMyFolderIdx: TEdit;
    UpDownMyFolder: TUpDown;
    LabelMyFolder: TLabel;
    CheckBoxKakikomi: TCheckBox;
    CheckBoxAdjustWindow: TCheckBox;
    EditAdjustWindowRange: TEdit;
    UpDownAdjustWindowRange: TUpDown;
    LabelAdjustWindowDot: TLabel;
    LabelAdjustWindowRange: TLabel;
    CheckBoxDoeRightClick: TCheckBox;
    DoeNameLinkColorLabel: TLabel;
    Label17: TLabel;
    DoeScrollLineEdit: TEdit;
    DoeScrollLineUpDown: TUpDown;
    Label18: TLabel;
    DoeLeftMarginEdit: TEdit;
    DoeLeftMarginUpDown: TUpDown;
    DoeRightMarginLabel: TLabel;
    DoeRightMarginEdit: TEdit;
    DoeRightMarginUpDown: TUpDown;
    DoeTopMarginLabel: TLabel;
    DoeTopMarginEdit: TEdit;
    DoeTopMarginUpDown: TUpDown;
    FontDialog1: TFontDialog;
    BoardFontButton: TButton;
    ThreadFontButton: TButton;
    DoeFontButton: TButton;
    DoeColorGroupBox: TGroupBox;
    Label3: TLabel;
    DoeExternalLeadingEdit: TEdit;
    DoeExternalLeadingUpDown: TUpDown;
    CheckBoxMailto: TCheckBox;
    CheckBoxDoeAaReplace: TCheckBox;
    CheckBoxUpdate: TCheckBox;
    CheckBoxReadCheck: TCheckBox;
    CheckBoxCleanFolder: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure UseDefaultBrowserCheckBoxClick(Sender: TObject);
    procedure BrowseBrowserPathButtonClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TopicListColorCheckBoxClick(Sender: TObject);
    procedure DoLogClearCheckBoxClick(Sender: TObject);
    procedure SkinPathButtonClick(Sender: TObject);
    procedure picPrevCheckBoxClick(Sender: TObject);
    procedure LogPathButtonClick(Sender: TObject);
    procedure CheckBoxMyFolderIdxClick(Sender: TObject);
    procedure CheckBoxAdjustWindowClick(Sender: TObject);
    procedure BoardFontButtonClick(Sender: TObject);
    procedure ThreadFontButtonClick(Sender: TObject);
    procedure DoeFontButtonClick(Sender: TObject);
  private
    { Private 錾 }
    BoardFont: TFont;
    ListFont: TFont;

    FNotGotColorButton : TColorButton;
    FFavoriteColorButton : TColorButton;
    FNewMesColorButton : TColorButton;
    FNoNewMesColorButton : TColorButton;
    FNewTopicColorButton : TColorButton;
    FDoeTextColorButton : TColorButton;
    FDoeBGColorButton : TColorButton;
    FDoeNameColorButton : TColorButton;
    FDoeNameLinkColorButton : TColorButton;			// 
    FDoeLinkColorButton : TColorButton;
    FOddColorButton : TColorButton;
    function GetFolderPath(Path: string):string ;

    function FontCompare(Font1: TFont;Font2: TFont): boolean;
  public
    { Public 錾 }
  end;

var
  OptionForm: TOptionForm;

implementation

uses
  untGlobal,
  untBrowseFolder, untConfig,
  StrUtils, untMainForm;

{$R *.dfm}

function TOptionForm.GetFolderPath(Path: string):string ;
var
  bf : TBrowseFolder;
begin
  Result := '';

  bf := TBrowseFolder.Create(self);
  try
  bf.Title := 'tH_IĂ';

  if Path = '' then
    bf.IniDir := ExtractFileDir(Application.ExeName)
  else
    bf.IniDir := Path;

  if bf.Execute then
  Result := bf.DirName;

  finally
  bf.Free;
  end;

end;


procedure TOptionForm.FormCreate(Sender: TObject);
var
  I: integer;
  s: string;
begin
  PageControl1.ActivePageIndex := 0;

  FNotGotColorButton := TColorButton.Create(TopicListColorGroupBox);
  FNotGotColorButton.Left     := NotGotTopicLabel.Left + NotGotTopicLabel.Width + 20;
  FNotGotColorButton.Top      := NotGotTopicLabel.Top - 2;
  FNotGotColorButton.Color    := gConfig.TopicListNotGotColor;
  FNotGotColorButton.TabOrder := 2;
  FNotGotColorButton.TabStop  := True;
  NotGotTopicLabel.FocusControl := FNotGotColorButton;

  FFavoriteColorButton := TColorButton.Create(TopicListColorGroupBox);
  FFavoriteColorButton.Left     := FNotGotColorButton.Left;
  FFavoriteColorButton.Top      := FavoriteLabel.Top - 2;
  FFavoriteColorButton.Color    := gConfig.TopicListFavoriteColor;
  FFavoriteColorButton.TabOrder := 3;
  FFavoriteColorButton.TabStop  := True;
  FavoriteLabel.FocusControl := FFavoriteColorButton;

  FNewMesColorButton := TColorButton.Create(TopicListColorGroupBox);
  FNewMesColorButton.Left     := FNotGotColorButton.Left;
  FNewMesColorButton.Top      := NewMessageLabel.Top - 2;
  FNewMesColorButton.Color    := gConfig.TopicListNewMesColor;
  FNewMesColorButton.TabOrder := 4;
  FNewMesColorButton.TabStop  := True;
  NewMessageLabel.FocusControl := FNewMesColorButton;

  FNoNewMesColorButton := TColorButton.Create(TopicListColorGroupBox);
  FNoNewMesColorButton.Left     := FNotGotColorButton.Left;
  FNoNewMesColorButton.Top      := NoNewMessageLabel.Top - 2;
  FNoNewMesColorButton.Color    := gConfig.TopicListNoNewMesColor;
  FNoNewMesColorButton.TabOrder := 5;
  FNoNewMesColorButton.TabStop  := True;
  NoNewMessageLabel.FocusControl := FNoNewMesColorButton;

  FNewTopicColorButton := TColorButton.Create(TopicListColorGroupBox);
  FNewTopicColorButton.Left     := FNotGotColorButton.Left;
  FNewTopicColorButton.Top      := NewTopicLabel.Top - 2;
  FNewTopicColorButton.Color    := gConfig.TopicListNewTopicColor;
  FNewTopicColorButton.TabOrder := 6;
  FNewTopicColorButton.TabStop  := True;
  NewTopicLabel.FocusControl := FNewTopicColorButton;
  //͋@\ĂȂ̂Ŕ\ɂ
  FNewTopicColorButton.Visible := false;

  TopicListColorCheckBox.Checked := gConfig.TopicListColorUse;
  TopicListColorCheckBoxClick(TopicListColorCheckBox);

  FOddColorButton          := TColorButton.Create(TopicListColorGroupBox);
  FOddColorButton.Left     := FNotGotColorButton.Left;
  FOddColorButton.Top      := BackColorLabel.Top - 2;
  FOddColorButton.Color    := gConfig.TopicListOddColor;
  FOddColorButton.TabOrder := 7;
  FOddColorButton.TabStop  := True;
  ListViweColorCheckBox.Checked := gConfig.TopicListOddColorUse;



  UseReadProxyCheckBox.Checked  := gConfig.ReadProxyUse;
  ReadProxyEdit.Text            := gConfig.ReadProxy;
  UseWriteProxyCheckBox.Checked := gConfig.WriteProxyUse;
  WriteProxyEdit.Text           := gConfig.WriteProxy;
  AlwaysNewTabCheckBox.Checked  := gConfig.AlwaysNewTab;
  MultiLineTabCheckBox.Checked  := gConfig.MultiLineTab;
  BoardListNoColorCheckBox.Checked := gConfig.BoardListNoColor;
  BoardListOneCategoryCheckBox.Checked := gConfig.BoardListOneCategory;
  UseDefaultBrowserCheckBox.Checked    := gConfig.UseDefaultBrowser;
  BrowserPathEdit.Text          := gConfig.BrowserPath;
  KoteHanEdit.Text              := gConfig.KoteHan;
  KoteMailEdit.Text             := gConfig.KoteMail;
//AutoFocusCheckBox.Checked     := gConfig.AutoFocus;
  AutoMouseWheelCheckBox.Checked:= gConfig.AutoMouseWheel;

  LogPathEdit.Text              := gConfig.LogPath;
  SkinPathEdit.Text             := gConfig.SkinPath;
  AutoSortCheckBox.Checked      := gConfig.AutoSort;

  BordListURLEdit.Text          := gConfig.BoardListUrl;

  //ڑҋ@b
  s := IntToStr(gConfig.CONNECT_TIMEOUT);
  i := Length(s);
  s := LeftStr(s,i-3);
  ConnectTimeEdit.text          := s;

  //摜vr[@\
  PicturePreviewCheckBox.Checked := gConfig.PicturePreview;

  //Xꗗ̃Obh
  GridLineCheckBox.Checked := gConfig.TopicListViewGridLines;

  //`R|[lgw
  if (gConfig.Use_DoeComponent) then
  //begin
     UseCompRadioButton1.Checked := true
   else
     UseCompRadioButton2.Checked := true;

  DoeFontNameEdit.Text := gConfig.Doe_FontName;
  DoeFontSizeEdit.Text := intToStr(gConfig.Doe_FontSize);
//DoeFontNameEdit.Visible:=false;
//DoeFontSizeEdit.Visible:=false;
//DoeFontNameLabel.Visible:=false;
//DoeFontSizeLabel.Visible:=false;


  CheckBoxDoeAaReplace.Checked := gConfig.Doe_AaReplace;	// 2009.03.09
  CheckBoxDoeRightClick.Checked := gConfig.Doe_RightClick;	// 2008.06.10

  //Doe eLXgAwiF
  FDoeTextColorButton := TColorButton.Create(DoeGroupBox);
  FDoeTextColorButton.Left     := DoeTextColorLabel.Left + DoeTextColorLabel.Width + 15 + DoeColorGroupBox.Left;
  FDoeTextColorButton.Top      := DoeTextColorLabel.Top - 2 + DoeColorGroupBox.Top;
  FDoeTextColorButton.Color    := gConfig.Doe_TextColor;
  FDoeTextColorButton.TabOrder := 1;
  FDoeTextColorButton.TabStop  := True;

  FDoeBGColorButton := TColorButton.Create(DoeGroupBox);
  FDoeBGColorButton.Left     := FDoeTextColorButton.Left;
  FDoeBGColorButton.Top      := DoeBGColorLabel.Top - 2 + DoeColorGroupBox.Top;
  FDoeBGColorButton.Color    := gConfig.Doe_BGColor;
  FDoeBGColorButton.TabOrder := 2;
  FDoeBGColorButton.TabStop  := True;

  FDoeNameColorButton := TColorButton.Create(DoeGroupBox);
  FDoeNameColorButton.Left     := FDoeTextColorButton.Left;
  FDoeNameColorButton.Top      := DoeNameColorLabel.Top - 2 + DoeColorGroupBox.Top;
  FDoeNameColorButton.Color    := gConfig.Doe_NameColor;
  FDoeNameColorButton.TabOrder := 3;
  FDoeNameColorButton.TabStop  := True;

  FDoeLinkColorButton := TColorButton.Create(DoeGroupBox);
  FDoeLinkColorButton.Left     := FDoeTextColorButton.Left;
  FDoeLinkColorButton.Top      := DoeLinkColorLabel.Top - 2 + DoeColorGroupBox.Top;
  FDoeLinkColorButton.Color    := gConfig.Doe_LinkColor;
  FDoeLinkColorButton.TabOrder := 4;
  FDoeLinkColorButton.TabStop  := True;

  FDoeNameLinkColorButton := TColorButton.Create(DoeGroupBox);
  FDoeNameLinkColorButton.Left     := FDoeTextColorButton.Left;
  FDoeNameLinkColorButton.Top      := DoeNameLinkColorLabel.Top - 2 + DoeColorGroupBox.Top;
  FDoeNameLinkColorButton.Color    := gConfig.Doe_NameLinkColor;
  FDoeNameLinkColorButton.TabOrder := 5;
  FDoeNameLinkColorButton.TabStop  := True;

  DoeScrollLineUpDown.Position  := gConfig.Doe_ScrollLine;
  DoeLeftMarginUpDown.Position  := gConfig.Doe_LeftMargin;
  DoeRightMarginUpDown.Position := gConfig.Doe_RightMargin;
  DoeTopMarginUpDown.Position   := gConfig.Doe_TopMargin;
  DoeExternalLeadingUpDown.Position := gConfig.Doe_ExternalLeading;

  HideMailAddressCheckBox.Checked := gConfig.DispMailAddress;
  DoLogClearCheckBox.Checked := gConfig.DoLogClear;
  LogSizeEdit.Text := IntToStr(gConfig.LogLimitSize);

  if gConfig.ViewLimit = 0 then
    ViewLimitComboBox.ItemIndex := 5
  else
    for I := 0 to ViewLimitComboBox.Items.Count - 1 do
      if ViewLimitComboBox.Items[I] = IntToStr(gConfig.ViewLimit) then
      begin
        ViewLimitComboBox.ItemIndex := I;
      end;

  UseDefaultBrowserCheckBoxClick(UseDefaultBrowserCheckBox);

//ListViewFontSizeEdit.Text      := IntToStr(gConfig.TopicListViewColumnFontSize);
  ListViewFontSizeEdit.Visible:=false;
  ListViewFontSizeLabel.Visible:=false;

  ListViewColumnPaddingEdit.Text := IntToStr(gConfig.TopicListViewColumnPadding);

  DoLogClearCheckBoxClick(self);

  CheckBoxMyFolderIdx.Checked:=gConfig.BackupIdx;		// 2008.05.12
  UpDownMyFolder.Position:=gConfig.BackupIdxNum;
  CheckBoxMyFolderIdxClick(Self);

  CheckBoxViewThreadTitle.Checked:=gConfig.ViewThreadTitle;  // 2008.05.19
  CheckBoxKakikomi.Checked:=gConfig.Kakikomi;                // 2008.05.19

  CheckBoxAdjustWindow.Checked     := gConfig.AdjustWindow;      // 2008.06.06
  UpDownAdjustWindowRange.Position := gConfig.AdjustWindowRange; // 2008.06.06

  CheckBoxMailto.Checked := gConfig.Mailto;      // 2008.07.13
  CheckBoxUpdate.Checked := gConfig.Update;      // 2009.07.19
  CheckBoxReadCheck.Checked := gConfig.ReadCheck;   // 2011.01.10
  CheckBoxCleanFolder.Checked := gConfig.CleanFolder;  // 2011.01.10

   BoardFont:=TFont.Create;
   ListFont :=TFont.Create;
   BoardFont.Assign(MainForm.BoardListView.Font);
   ListFont.Assign(MainForm.TopicListView.Font);
end;
// 
// 
// 
procedure TOptionForm.CancelButtonClick(Sender: TObject);
begin
  // LZȂtHg𕜌
  if FontCompare(BoardFont,MainForm.BoardListView.Font) = false then
  begin
    MainForm.BoardListView.Font.Assign(BoardFont);
  end;

  if FontCompare(ListFont,MainForm.TopicListView.Font) = false then
  begin
    MainForm.TopicListView.Font.Assign(ListFont);
  end;


  Close;
end;

procedure TOptionForm.OKButtonClick(Sender: TObject);
begin
  if DoLogClearCheckBox.Checked then
  begin
    try
      StrToInt(LogSizeEdit.Text);
    except
      ShowMessage('郍OTCYɐ͂Ă');
      exit;
    end;
  end;

  //ڑҋ@b̃`FbN
  if ConnectTimeEdit.Text = '' then
  begin
    ShowMessage('ڑҋ@bݒ肳Ă܂');
    exit;
  end else
  begin
    try
      StrToInt(ConnectTimeEdit.Text);
    except
      ShowMessage('ڑҋ@bɐ͂Ă');
      exit;
    end;

      if (StrToInt(ConnectTimeEdit.Text) > 300) then
      begin
         ShowMessage('ڑҋ@bُłBʏ10`30bxł');
         exit;
      end;
  end;


  with gConfig do
  begin
    TopicListColorUse := TopicListColorCheckBox.Checked;
    TopicListNotGotColor := FNotGotColorButton.Color;
    TopicListFavoriteColor := FFavoriteColorButton.Color;
    TopicListNewMesColor := FNewMesColorButton.Color;
    TopicListNoNewMesColor := FNoNewMesColorButton.Color;
    TopicListNewTopicColor := FNewTopicColorButton.Color;

    TopicListOddColorUse  := ListViweColorCheckBox.Checked;
    TopicListOddColor     := FOddColorButton.Color;

    ReadProxyUse  := UseReadProxyCheckBox.Checked;
    ReadProxy     := ReadProxyEdit.Text;
    WriteProxyUse := UseWriteProxyCheckBox.Checked;
    WriteProxy    := WriteProxyEdit.Text;
    AlwaysNewTab  := AlwaysNewTabCheckBox.Checked;
    MultiLineTab  := MultiLineTabCheckBox.Checked;
    BoardListNoColor := BoardListNoColorCheckBox.Checked;
    BoardListOneCategory := BoardListOneCategoryCheckBox.Checked;
    UseDefaultBrowser := UseDefaultBrowserCheckBox.Checked;
    BrowserPath       := BrowserPathEdit.Text;
    KoteHan           := KoteHanEdit.Text;
    KoteMail          := KoteMailEdit.Text;
//  AutoFocus         := AutoFocusCheckBox.Checked;
    AutoMouseWheel    := AutoMouseWheelCheckBox.Checked;

    LogPath           := LogPathEdit.Text;

    SkinPath          := SkinPathEdit.Text;
    AutoSort          := AutoSortCheckBox.Checked;

    BoardListUrl := BordListURLEdit.Text;

    //~bȂ̂Ő{
    CONNECT_TIMEOUT  := StrToInt(ConnectTimeEdit.Text) * 1000;

    //Xꗗ̃Obh
    TopicListViewGridLines := GridLineCheckBox.Checked;

    //`R|[lgw
    if UseCompRadioButton1.Checked then
       Use_DoeComponent := true
     else
       Use_DoeComponent := false;
    Doe_FontName := DoeFontNameEdit.Text;
    Doe_FontSize := StrToInt(DoeFontSizeEdit.Text);

    Doe_AaReplace := CheckBoxDoeAaReplace.Checked;		// 2009.03.09
    Doe_RightClick := CheckBoxDoeRightClick.Checked;	// 2008.06.10
    Doe_BGColor :=   FDoeBGColorButton.Color;
    Doe_TextColor :=   FDoeTextColorButton.Color;
    Doe_NameColor :=   FDoeNameColorButton.Color;
    Doe_NameLinkColor :=   FDoeNameLinkColorButton.Color;		// 
    Doe_LinkColor :=   FDoeLinkColorButton.Color;

    Doe_ScrollLine  := DoeScrollLineUpDown.Position;
    Doe_LeftMargin  := DoeLeftMarginUpDown.Position;
    Doe_RightMargin := DoeRightMarginUpDown.Position;
    Doe_TopMargin   := DoeTopMarginUpDown.Position;
    Doe_ExternalLeading := DoeExternalLeadingUpDown.Position;

    DispMailAddress := HideMailAddressCheckBox.Checked;
    DoLogClear := DoLogClearCheckBox.Checked;
    LogLimitSize := StrToInt(LogSizeEdit.Text);
  end;

  if ViewLimitComboBox.ItemIndex = 5 then
  begin
    gConfig.ViewLimit := 0
  end else
  begin
    gConfig.ViewLimit := StrToIntNeo(ViewLimitComboBox.Items[ViewLimitComboBox.ItemIndex]);
  end;

  if IsNumeric(ListViewFontSizeEdit.Text) then
  begin
    gConfig.TopicListViewColumnFontSize := StrToInt(ListViewFontSizeEdit.Text);
  end;

  if IsNumeric(ListViewColumnPaddingEdit.Text) then
  begin
    gConfig.TopicListViewColumnPadding := StrToInt(ListViewColumnPaddingEdit.Text);
  end;

  gConfig.BackupIdx := CheckBoxMyFolderIdx.Checked;		// 2008.05.12
  gConfig.BackupIdxNum := UpDownMyFolder.Position;
  gConfig.ViewThreadTitle :=CheckBoxViewThreadTitle.Checked;  // 2008.05.19
  gConfig.Kakikomi :=CheckBoxKakikomi.Checked;                // 2008.05.19

  gConfig.AdjustWindow      := CheckBoxAdjustWindow.Checked;      // 2008.06.06
  gConfig.AdjustWindowRange := UpDownAdjustWindowRange.Position;  // 2008.06.06
  gConfig.Mailto := CheckBoxMailto.Checked;      // 2008.07.13
  gConfig.Update := CheckBoxUpdate.Checked;      // 2009.07.19
  gConfig.ReadCheck := CheckBoxReadCheck.Checked; // 2011.01.10
  gConfig.CleanFolder := CheckBoxCleanFolder.Checked; // 2011.01.10

  gConfig.WriteOption();
  Close;

end;



procedure TOptionForm.UseDefaultBrowserCheckBoxClick(Sender: TObject);
begin
  //


  Label4.Enabled                  := UseDefaultBrowserCheckBox.Checked;
  BrowserPathEdit.Enabled         := UseDefaultBrowserCheckBox.Checked;
  BrowseBrowserPathButton.Enabled := UseDefaultBrowserCheckBox.Checked;

end;

procedure TOptionForm.BrowseBrowserPathButtonClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
    BrowserPathEdit.Text := OpenDialog1.FileName; 
end;

procedure TOptionForm.FormDestroy(Sender: TObject); 
begin 
  FNotGotColorButton.Free;
  FFavoriteColorButton.Free; 
  FNewMesColorButton.Free; 
  FNoNewMesColorButton.Free; 

  BoardFont.Free;
  ListFont.Free;
end;

procedure TOptionForm.TopicListColorCheckBoxClick(Sender: TObject); 
begin 
  if TopicListColorCheckBox.Checked then 
  begin 
    TopicListColorGroupBox.Enabled := True; 
    NotGotTopicLabel.Enabled := True; 
    FavoriteLabel.Enabled := True; 
    NewMessageLabel.Enabled := True;
    NoNewMessageLabel.Enabled := True;
    NewTopicLabel.Enabled := True;
    FNotGotColorButton.Enabled := True;
    FFavoriteColorButton.Enabled := True;
    FNewMesColorButton.Enabled := True;
    FNoNewMesColorButton.Enabled := True;
    FNewTopicColorButton.Enabled := True;
  end else
  begin
    TopicListColorGroupBox.Enabled := False;
    NotGotTopicLabel.Enabled := False;
    FavoriteLabel.Enabled := False;
    NewMessageLabel.Enabled := False;
    NoNewMessageLabel.Enabled := False;
    NewTopicLabel.Enabled := False;
    FNotGotColorButton.Enabled := False;
    FFavoriteColorButton.Enabled := False;
    FNewMesColorButton.Enabled := False;
    FNoNewMesColorButton.Enabled := False;
    FNewTopicColorButton.Enabled := False;
  end;
end;

procedure TOptionForm.DoLogClearCheckBoxClick(Sender: TObject);
begin
  LogSizeEdit.Enabled := DoLogClearCheckBox.Checked;
end;

procedure TOptionForm.SkinPathButtonClick(Sender: TObject);
var
  str : string;
begin
  str := GetFolderPath(SkinPathEdit.Text);

  if str <> '' then
  SkinPathEdit.Text := str;
end;

//摜vr[ 2005/04/03ǉ
procedure TOptionForm.picPrevCheckBoxClick(Sender: TObject);
begin
   gConfig.PicturePreview := self.PicturePreviewCheckBox.Checked;
end;

procedure TOptionForm.LogPathButtonClick(Sender: TObject);
var
  str : string;
begin
  str := GetFolderPath(LogPathEdit.Text);

  if str <> '' then
  LogPathEdit.Text := str;
end;

procedure TOptionForm.CheckBoxMyFolderIdxClick(Sender: TObject);
begin
  if CheckBoxMyFolderIdx.Checked = False then
  begin
    EditMyFolderIdx.Enabled:=False;
    UpDownMyFolder.Enabled:=False;
    LabelMyFolder.Enabled:=False;
  end
  else
  begin
    EditMyFolderIdx.Enabled:=True;
    UpDownMyFolder.Enabled:=True;
    LabelMyFolder.Enabled:=True;
  end;
end;

procedure TOptionForm.CheckBoxAdjustWindowClick(Sender: TObject);
begin
  if CheckBoxAdjustWindow.Checked = False then
  begin
    LabelAdjustWindowRange.Enabled:=False;
    EditAdjustWindowRange.Enabled:=False;
    UpDownAdjustWindowRange.Enabled:=False;
    LabelAdjustWindowDot.Enabled:=False;
  end
  else
  begin
    LabelAdjustWindowRange.Enabled:=True;
    EditAdjustWindowRange.Enabled:=True;
    UpDownAdjustWindowRange.Enabled:=True;
    LabelAdjustWindowDot.Enabled:=True;
  end;
end;
//
//
//
procedure TOptionForm.BoardFontButtonClick(Sender: TObject);
begin

  FontDialog1.Font.Assign(MainForm.BoardListView.Font);
  if FontDialog1.Execute = true then
  begin
    MainForm.BoardListView.Font.Assign(FontDialog1.Font);
  end;

end;
//
//
//
procedure TOptionForm.ThreadFontButtonClick(Sender: TObject);
begin

  FontDialog1.Font.Assign(MainForm.TopicListView.Font);
  if FontDialog1.Execute = true then
  begin
    MainForm.TopicListView.Font.Assign(FontDialog1.Font);
  end;
end;
//
//
//
procedure TOptionForm.DoeFontButtonClick(Sender: TObject);
begin

  FontDialog1.Font.Name:=gConfig.Doe_FontName;
  FontDialog1.Font.Size:=gConfig.Doe_FontSize;
  if FontDialog1.Execute = true then
  begin
    DoeFontNameEdit.Text := FontDialog1.Font.Name;
    DoeFontSizeEdit.Text := intToStr(FontDialog1.Font.Size);
  end;
end;
//
// tHg̔r
//
function TOptionForm.FontCompare(Font1: TFont;Font2: TFont): boolean;
begin

  if (Font1 = nil ) or (Font2 = nil ) then
  begin
    Result:=true;
  end else
  begin
    if (Font1.Name    <> Font2.Name ) or
       (Font1.Size    <> Font2.Size ) or
       (Font1.Charset <> Font2.Charset ) or
       (Font1.Color   <> Font2.Color ) or
       (Font1.Style   <> Font2.Style ) then
    begin
      Result:=false;
    end else
    begin
      Result:=true;
    end;
  end;

end;


end.
