unit untToukeiInfoForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, untGlobal;

type
  TToukeiInfoForm = class(TForm)
    Button1: TButton;
    GroupBox1: TGroupBox;
    Button2: TButton;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ViewInfo();
  private
    { Private 錾 }
    function Div_TotalSec_To_DateTime(intSec: integer; d: integer): string;
    function NiketaNumber(i: integer): string;
  public
    { Public 錾 }
  end;

var
  ToukeiInfoForm: TToukeiInfoForm;

implementation

{$R *.dfm}

uses
  Clipbrd,DateUtils;


procedure TToukeiInfoForm.FormCreate(Sender: TObject);
begin
   ViewInfo();
end;

procedure TToukeiInfoForm.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TToukeiInfoForm.Button2Click(Sender: TObject);
begin
  //Zbg
  if Application.MessageBox('ׂĂ̐lԂɖ߂܂B낵łH','mF',mb_YesNo) = IDNO then exit;

  gConfig.ToukeiInfo_Board_Load := 0;
  gConfig.ToukeiInfo_Thread_Load := 0;
  gConfig.ToukeiInfo_Thread_Make := 0;
  gConfig.ToukeiInfo_Write := 0;
  gConfig.ToukeiInfo_Write_AutoCancel := 0;
  gConfig.ToukeiInfo_TotalTime := 0;
  gConfig.ToukeiInfo_LogStart := Now;
  gConfig.ToukeiInfo_AppStartToday := Now;
  gConfig.ToukeiInfo_AppExeCount := 1;

  ViewInfo();

end;

//\
procedure TToukeiInfoForm.ViewInfo();
var
  strMes: string;
  kadouTime: TDateTime;
  konkaiKadouTime: TDateTime;
  keikaDay: integer;
  kadouDay: integer;
  intSec:  integer;
  strAvgA,strAvgB: string;
  Hour, Min, Sec, MSec: Word;
  strKonkaiKadou: string;
  strSougouKadou: string;
  strZenkaiKadou: string;
begin

  strMes := '@̓Ǎ = ' + IntToStr(gConfig.ToukeiInfo_Board_Load) + ' ' + #13#10;
  strMes := strMes + '@X̓Ǎ = ' + IntToStr(gConfig.ToukeiInfo_Thread_Load) + ' ' + #13#10;
  strMes := strMes + '@X̐VK쐬 = ' + IntToStr(gConfig.ToukeiInfo_Thread_Make) + ' ' + #13#10;
  strMes := strMes + #13#10;
  strMes := strMes + '@ = ' + IntToStr(gConfig.ToukeiInfo_Write) + ' ' + #13#10;
  strMes := strMes + '@ݑҋ@b = ' + IntToStr(gConfig.ToukeiInfo_Write_AutoCancel) + ' ' + #13#10;
  strMes := strMes + #13#10;
  strMes := strMes + '@L^Jn = ' + DateTimeToStr(gConfig.ToukeiInfo_LogStart) + #13#10;
  strMes := strMes + '@N = ' + DateTimeToStr(gConfig.ToukeiInfo_AppStartToday) + #13#10;
  strMes := strMes + '@ݎ = ' + DateTimeToStr(Now) + #13#10;

  //ғԂ̌vZ
  kadouTime := gConfig.ToukeiInfo_TotalTime;
  konkaiKadouTime := now - gConfig.ToukeiInfo_AppStartToday;
  kadouTime := kadouTime + konkaiKadouTime;

  //O܂ł̑ғ

  DecodeTime(gConfig.ToukeiInfo_TotalTime, Hour, Min, Sec, MSec);
  kadouDay := DaysBetween(0,gConfig.ToukeiInfo_TotalTime);

  if (kadouDay > 0) then
     strZenkaiKadou := intToStr(kadouDay) + ' Day ';

  strZenkaiKadou := strZenkaiKadou + NiketaNumber(Hour) + ':' + NiketaNumber(Min) + ':' + NiketaNumber(Sec);

  //ғ
  kadouDay := DaysBetween(Now,gConfig.ToukeiInfo_AppStartToday);
  DecodeTime(konkaiKadouTime, Hour, Min, Sec, MSec);

  if (kadouDay > 0) then
     strKonkaiKadou := intToStr(kadouDay) + ' Day ';

  strKonkaiKadou := strKonkaiKadou + NiketaNumber(Hour) + ':' + NiketaNumber(Min) + ':' + NiketaNumber(Sec);

  //ғ
  kadouDay := Trunc(kadouTime);
  DecodeTime(kadouTime, Hour, Min, Sec, MSec);

  if (kadouDay > 0) then
     strSougouKadou := intToStr(kadouDay) + ' Day ';

  strSougouKadou := strSougouKadou + NiketaNumber(Hour) + ':' + NiketaNumber(Min) + ':' + NiketaNumber(Sec);


  //oߓ
  keikaDay := DaysBetween(Trunc(Now),Trunc(gConfig.ToukeiInfo_LogStart));
  keikaDay := keikaDay + 1;

  //όvZp
  //ғԂbPʂɒ
  intSec := 86400 * kadouDay;
  intSec := intSec + 3600 * Hour;
  intSec := intSec + (60 * Min);
  intSec := intSec + sec;

  //Pωғ
  strAvgA :=  Div_TotalSec_To_DateTime(intSec,keikaDay);

  //P񕽋ωғ
  strAvgB :=  Div_TotalSec_To_DateTime(intSec,gConfig.ToukeiInfo_AppExeCount);

  strMes := strMes + '@L^ = ' + IntToStr(keikaDay) + ' ' + #13#10;
  strMes := strMes + #13#10;

//  strMes := strMes + '@O܂ł̉ғ = ' + strZenkaiKadou + #13#10;
  strMes := strMes + '@ғ = ' + strKonkaiKadou + #13#10;

  strMes := strMes + '@ғ = ' + strSougouKadou + #13#10;

  strMes := strMes + '@Pωғ = ' + strAvgA + #13#10;

  strMes := strMes + #13#10;
  strMes := strMes + '@Katju88 N = ' + IntToStr(gConfig.ToukeiInfo_AppExeCount) + ' ' + #13#10;

  strMes := strMes + '@P񕽋ωғ = ' + strAvgB + #13#10;

  Memo1.Text := strMes;

end;

//Ԃ̊Zp
function TToukeiInfoForm.Div_TotalSec_To_DateTime(intSec: integer; d: integer): string;
var
  intDD,intHH,intMM,intSS:   integer;
  strRet: string;
begin

  //Ŝ
  if (intSec > 0) and (d > 0) then
    intSec := intSec div d;

  if (intSec = 0) then
  begin
     result := '00:00:00';
     exit;
  end;

  //
  intDD := (intSec div 86400);

  //
  intHH := intSec - (86400 * intDD);
  if intHH > 0 then
    intHH := (intHH div 3600);

  //
  intMM := intSec - (86400 * intDD);
  intMM := intMM - (3600 * intHH);
  if intMM > 0 then
    intMM := (intMM div 60);

  //b
  intSS := intSec - (86400 * intDD);
  intSS := intSS - (3600 * intHH);
  intSS := intSS - (60 * intMM);

  if intDD = 0 then
    strRet := NiketaNumber(intHH) +':' + NiketaNumber(intMM) + ':' + NiketaNumber(intSS)
  else
    strRet := intToStr(intDD) + ' Day ' + NiketaNumber(intHH) +':' + NiketaNumber(intMM) + ':' + NiketaNumber(intSS);

  result := strRet;
end;

//񌅂ɂ낦
function TToukeiInfoForm.NiketaNumber(i: integer): string;
begin
  if i < 10 then
    result := '0' + intToStr(i)
  else
    result := intToStr(i);
end;

end.
