unit untUpdate;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Shellapi,urlmon ,Types, IdException,
  StdCtrls, ExtCtrls, IdBaseComponent, IdComponent, IdTCPConnection,
  IdTCPClient, IdHTTP;


type
  TUpdateDlg = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    Label1: TLabel;
    http: TIdHTTP;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
  private
    { Private 錾 }
    Stream: TMemoryStream;
    ts: TStringStream;

    procedure GetURL(URL: string);
    function GetIeVer: string;                // 2009.07.19
    function GetUserAgent: string;
    procedure Countup;
  public
    { Public 錾 }
    procedure CheckUpdate;
  end;

var
  UpdateDlg: TUpdateDlg;

implementation

uses
  untGlobal,untTool;

{$R *.dfm}

procedure TUpdateDlg.FormCreate(Sender: TObject);
begin
//
end;

procedure TUpdateDlg.FormDestroy(Sender: TObject);
begin
//
end;

procedure TUpdateDlg.FormShow(Sender: TObject);
begin
//
end;

procedure TUpdateDlg.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
//
end;

procedure TUpdateDlg.FormActivate(Sender: TObject);
begin
//
end;

procedure TUpdateDlg.OKBtnClick(Sender: TObject);
var
//	hIns:HINSTANCE;
	URL:string;
begin
	URL:='http://geocities.yahoo.co.jp/gl/katju88_027x';
	ShellExecute(Handle,'open',PChar(URL),Nil,Nil,SW_SHOWNORMAL);
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
function TUpdateDlg.GetIeVer: string;
var
  str:string;
  cUAStr:array[1..255] of char;
  nUAStrLen:DWORD;
  iUAStrLen:DWORD;
//ret:HResult;
begin
  nUAStrLen:=255;
  UrlMkGetSessionOption(URLMON_OPTION_USERAGENT,Pchar(@cUAStr[1]),nUAStrLen,iUAStrLen,0);
  str:=cUAStr;

  if Pos('MSIE 4',str)<>0 then
  begin
    Result:='4';
  end
  else if Pos('MSIE 5',str)<>0 then
  begin
    Result:='5';
  end
  else if Pos('MSIE 6',str)<>0 then
  begin
    Result:='6';
  end
  else if Pos('MSIE 7',str)<>0 then
  begin
    if Pos('Trident/4.0',str)<>0 then
    begin
      Result:='8';
    end
    else
    begin
      Result:='7';
    end;
  end
  else if Pos('MSIE 8',str)<>0 then
  begin
    Result:='8';
  end
  else if Pos('MSIE 9',str)<>0 then
  begin
    Result:='9';
  end
  else
  begin
    Result:='X';
  end;
end;
//------------------------------------------------------------------
//
// URLXg[ɓǂݍ
//
//------------------------------------------------------------------
procedure TUpdateDlg.GetURL(URL: string);
var
  str:string;
  proxyHost: string;
  proxyPort: integer;

begin
  // proxy
  if gConfig.ReadProxyUse then
  begin
    gConfig.ParseProxy(gConfig.ReadProxy, proxyHost, proxyPort);
    http.ProxyParams.ProxyServer := proxyHost;
    http.ProxyParams.ProxyPort   := proxyPort;
  end;

  try
//  http.AllowCookies:=True;
    http.ConnectTimeout := gConfig.CONNECT_TIMEOUT;
    http.ReadTimeout:=0;				// (ms)
//  http.HandleRedirects:=True;			// _CNg
    http.RecvBufferSize:=32768;
    http.ProtocolVersion := pv1_1; 		//
    http.Request.Accept:='text/html, */*';
    http.Request.BasicAuthentication:=False;
    http.Request.Username:='';
    http.Request.Password:='';
    http.Request.ContentLength:=0;
    http.Request.ContentRangeEnd:=0;
    http.Request.ContentRangeStart:=0;
    http.Request.Referer:='';
    http.Request.UserAgent:=GetUserAgent;

    http.Get(URL,Stream);
    Stream.Seek(0, soBeginning);

  except
    on e: EIdSocketError do
      str:=e.Message;
    on e: EIdHTTPProtocolException do
      str:=e.Message;
    on e: Exception do
      str:=e.Message;
   end;

{$IFDEF Debug}
//
{$ELSE}
//  
{$ENDIF}
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
function TUpdateDlg.GetUserAgent: string;
var
  UserAgent:string;
begin
  UserAgent:='Katju88';
  if (gConfig.Use_DoeComponent) then
     UserAgent:=UserAgent+'Doe'
  else
     UserAgent:=UserAgent+'IE_';
  UserAgent:=UserAgent+GetIeVer;
  UserAgent:=UserAgent+GetVersionStr;
  Result:=UserAgent+#13#10;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TUpdateDlg.CheckUpdate;
var
  str:string;
  URL:string;
  Version:string;
  newVer:string;
  Count:Integer;
  i:Integer;

begin
  Version:=GetVersionStr;
  newVer:='';
  Stream := TMemoryStream.Create;
  URL:='http://www.geocities.jp/katju88_027x/';

  GetUrl(URL);
  Count:=Stream.Size;
  if Count>=1000 then
  begin
//  Stream.SaveToFile('aaa.html');
    str:=Copy(PChar(Stream.Memory),1,Count);
    i:=Pos('<!--<Version>',str);
    if i<> 0 then
    begin
//<!--<Version>0.2.7.18</Version>-->
      newVer:=Copy(PChar(Stream.Memory),i+13,8);
    end;
  end;
  Stream.Free;
//Countup;

  if StrComp(PChar(newVer),PChar(Version))>0 then
  begin
    self.ShowModal();
  end;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TUpdateDlg.Countup;
var
  URL:string;
  PostData:String;
  
  str:string;
  proxyHost: string;
  proxyPort: integer;
begin
  Stream := TMemoryStream.Create;
  ts:=TStringStream.Create('');

  URL:='http://by.analytics.yahoo.co.jp/p.pl';
  PostData:='a=1000215658331&js=no';
//HttpPost(URL,tm,PostData);


  // proxy
  if gConfig.ReadProxyUse then
  begin
    gConfig.ParseProxy(gConfig.ReadProxy, proxyHost, proxyPort);
    http.ProxyParams.ProxyServer := proxyHost;
    http.ProxyParams.ProxyPort   := proxyPort;
  end;

  try
//  http.AllowCookies:=True;
    http.ConnectTimeout := gConfig.CONNECT_TIMEOUT;
    http.ReadTimeout:=0;				// (ms)
    http.HandleRedirects:=True;			// _CNg
    http.RecvBufferSize:=32768;
    http.ProtocolVersion := pv1_1; 		//
//  http.Request.Accept:='text/html, */*';
    http.Request.Accept:='image/gif, image/jpeg, image/pjpeg, image/pjpeg, application/x-shockwave-flash, application/vnd.ms-excel, application/msword, */*';
    http.Request.BasicAuthentication:=False;
    http.Request.Username:='';
    http.Request.Password:='';
    http.Request.ContentLength:=0;
    http.Request.ContentRangeEnd:=0;
    http.Request.ContentRangeStart:=0;
    http.Request.Referer:='http://www.geocities.jp/katju88_027x/index.html';
    http.Request.UserAgent:=GetUserAgent;
    http.Request.ContentType:='application/x-www-form-urlencoded';
    ts.WriteString(PostData);
    http.Post(URL,ts,Stream);

  except
    on e: EIdSocketError do
      str:=e.Message;
    on e: EIdHTTPProtocolException do
      str:=e.Message;
    on e: Exception do
      str:=e.Message;
   end;


  ts.Free;
  Stream.Free;
end;

end.
