unit untViewImageForm;

interface

uses
  Classes, Windows, Messages, SysUtils, Variants, Graphics, Controls, Forms,Math,StrUtils,
  Dialogs, ExtCtrls, ExtDlgs, untOleImage, StdCtrls,SyncObjs,untDownload,
  IdHttp, IdComponent, IdException, IdBaseComponent, IdTCPConnection,
  IdTCPClient, ComCtrls, Menus, IdCookieManager;

type
  TViewImageForm = class(TForm)
    Image1: TImage;
    OpenPictureDialog1: TOpenPictureDialog;
    Http: TIdHTTP;
    ButtonStop: TButton;
    ProgressBar1: TProgressBar;
    ViewImagePopupMenu: TPopupMenu;
    PopupClose: TMenuItem;
    PopupZoomUp: TMenuItem;
    PopupZoomDown: TMenuItem;
    IdCookieManager1: TIdCookieManager;
    procedure FormDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Image1Click(Sender: TObject);
    procedure Image1DblClick(Sender: TObject);
    procedure HttpRedirect(Sender: TObject; var dest: String;
      var NumRedirect: Integer; var Handled: Boolean;
      var VMethod: TIdHTTPMethod);
    procedure HttpStatus(ASender: TObject; const AStatus: TIdStatus;
      const AStatusText: String);
    procedure HttpConnected(Sender: TObject);
    procedure HttpDisconnected(Sender: TObject);
    procedure HttpWork(Sender: TObject; AWorkMode: TWorkMode;
      const AWorkCount: Integer);
    procedure HttpWorkBegin(Sender: TObject; AWorkMode: TWorkMode;
      const AWorkCountMax: Integer);
    procedure HttpWorkEnd(Sender: TObject; AWorkMode: TWorkMode);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ButtonStopClick(Sender: TObject);
    procedure MainFormPopupMaxClick(Sender: TObject);
    procedure PopupCloseClick(Sender: TObject);
    procedure PopupZoomUpClick(Sender: TObject);
    procedure PopupZoomDownClick(Sender: TObject);
  private
    { Private 錾 }
    DownloadStartEvent: TSimpleEvent;
    DownloadWaitEvent: TSimpleEvent;
    Stream: TMemoryStream;
    mSize: SIZE;
    mStop: Boolean;
    mStep: Double;
    mConnect: Boolean;
    ReceiveCount: Double;		// MoCg
    CountMax: Integer;
    eString: string;
    Complete: Boolean;
    Progress: Boolean;
    GetMsg: string;				// 
    mURL: string;
//  mDblck:  Boolean;

    procedure GetURL(URL: string);
    procedure SetProgress;
    procedure ResetProgress;
    procedure ErrorProgress;
    procedure ImageMax;
//  procedure ImageClose;
	function Domain(URL: string): string;
	function Host(URL: string): string;
  public
    { Public 錾 }
    mPosition: Integer;

    procedure DownLoadEntry();
    procedure SetImageURL(Url: string);
    procedure FitImageURL(URL: string;mPoint: TPoint);
    function ViewSystem(Stream: TMemoryStream): bool;
    function ViewLib(Stream: TMemoryStream;urlStr: string): bool;

  end;

var
  ViewImageForm: TViewImageForm;
//DownloadStartEvent: TSimpleEvent;
//DownloadWaitEvent: TSimpleEvent;
//mURL: string;

implementation

uses
  untGlobal, untMainForm;

{$R *.dfm}
//
// OnCreate
//
procedure TViewImageForm.FormCreate(Sender: TObject);
begin
//mDblck:=False;
  mConnect:=False;
//ProgressBar:=Nil;
//StopButton:=Nil;
//mLabel:=Nil;
  mStop:=False;
  DownloadStartEvent:=TSimpleEvent.Create;
  DownloadWaitEvent:=TSimpleEvent.Create;
  DownloadStartEvent.ResetEvent();		// VOiIt
  DownloadWaitEvent.ResetEvent();		// VOiIt

//Image1.Height:=48;
//Image1.Width:=48;
//ClientHeight:=48;
//ClientWidth:=48;
//Image1.Align:=alClient;

  Stream := TMemoryStream.Create;
//mDownload:=TDownload.Create(False);
end;
//
// OnShow
//
procedure TViewImageForm.FormShow(Sender: TObject);
begin
  //SHOW
end;
//
// OnActivate
//
procedure TViewImageForm.FormActivate(Sender: TObject);
begin
  //ACTIVE
end;
//
// Close
//
procedure TViewImageForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
//if mLabel<>Nil then
//begin
//  mLabel.Free;
//  mLabel:=Nil;
//end;

//Image1.Free;
//Image1.Picture.Bitmap:=Nil;
  SetProgress;

end;
//
// OnDestroy
//
procedure TViewImageForm.FormDestroy(Sender: TObject);
begin
//if ProgressBar<>Nil then ProgressBar.Free;
//if StopButton<>Nil then StopButton.Free;
//if mLabel<>Nil then mLabel.Free;

  if gDownload <>Nil then gDownload.Terminate();
  Stream.Free;
  DownloadStartEvent.Free;
  DownloadWaitEvent.Free;
end;
//
//
//
procedure TViewImageForm.FormDblClick(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then
  begin
    Image1.Picture.LoadFromFile(OpenPictureDialog1.FileName);

//	Image1.Picture.Bitmap.LoadFromStream(Stream);

  end;
end;
//
// URLStreamɓǂݍ
//
procedure TViewImageForm.SetImageURL(URL: string);
var
//i: integer;
  oBitmap: TOleBITMAP;

begin
    GetURL(URL);     // URL Streamɓǂݍ

	oBitmap:=TOleBITMAP.Create();
//  Stream.SaveToFile('zzz.jpg');
//  Stream.Seek(0, soBeginning);
// inherited Image1.Picture.Bitmap.LoadFromStream(Stream);
//Image1.Picture.Graphic.LoadFromFile('zzz.jpg');
//Image1.Picture.LoadFromFile('zzz.jpg');

	oBitmap.LoadFromStream(Stream);
    Image1.Picture.Bitmap:=oBitmap;
	oBitmap.Free;

//TOleBitmap.LoadImageFromStream(Image1.Picture.Bitmap,Stream);

end;
//
// URLStreamɓǂݍ
// Streamrbg}bvɓǂݍ 傫𒲂ׂďcۂ
//
procedure TViewImageForm.FitImageURL(URL: string;mPoint: TPoint);
var
//i: integer;
  Result: TWaitResult;
  urlStr: string;

begin
  mStop:=False;
  SetProgress;		// _E[hoߕ\
//mDblck:=False;
  Top:=mPoint.y-Height;
  Left:=mPoint.x;
  Caption:='摜\';
  Image1.Picture.Bitmap:=Nil;
  Complete:=False;
  Progress:=False;
  Stream.Clear;
//ShowMessage('FitImageURL');
  mURL:=URL;
//mURL:='http://imgsrc.hubblesite.org/hu/db/2008/07/images/a/formats/full_jpg.jpg';
  Application.ProcessMessages;
  DownloadStartEvent.SetEvent();	// _E[hJn
  Application.ProcessMessages;
  DownloadWaitEvent.ResetEvent();
  while True do
  begin
    Result:=DownloadWaitEvent.WaitFor(100);   // ***

//  Result=wrTimeoutɁAMꍇBȂ̂ŁACxg͌ȂŔf
    if Complete=True then
    begin
      urlStr := LowerCase(Url);
      ResetProgress;

      if GetMsg<>'' then
      begin
        ErrorProgress;
        Caption:=GetMsg;
        break;
      end else
      // I
      if AnsiEndsText('.jpg',urlStr) or AnsiEndsText('.jpeg',urlStr) or AnsiEndsText('.gif',urlStr) then
      begin
        if ViewSystem(Stream)=False then
        begin
          ViewLib(Stream,urlStr);
        end;
        break;
      end else
      if AnsiEndsText('.png',urlStr) then
      begin
        ViewLib(Stream,urlStr);
        break;
      end;
    end else
    if Progress=True then
    begin
      ProgressBar1.Position:=mPosition;
      Application.ProcessMessages;
      Progress:=False;
      DownloadWaitEvent.ResetEvent();
    end else
    if mStop=True then
    begin
      // ~
      if mConnect=True then http.DisConnect();
      ErrorProgress;
      mStop:=False;
      break;
    end else
    if Result=wrSignaled then
    begin
      // G[\
      ErrorProgress;
      self.Caption:=eString;
      break;
    end else
    if Result=wrTimeout then    // ^CAEg
    begin
      Application.ProcessMessages;
      if mStop=True then
      begin
        if mConnect=True then http.DisConnect();
        ErrorProgress;
        break;
      end else
      begin
        DownloadWaitEvent.ResetEvent();
      end;
    end else
    if Result=wrAbandoned then    // CxgjȂXbhI
    begin
      if mConnect=True then http.DisConnect();
      break;
    end;
  end;
    Application.ProcessMessages;
end;
//
//
//
//procedure TViewImageForm.DownloadStop();
//begin
//  mStop:=True;
//end;
//
//
//
procedure TViewImageForm.SetProgress;
begin
  Image1.Visible:=False;
  Image1.Enabled:=False;

  Height:=110;
  Width:=274;
  ClientHeight:=75;
  ClientWidth:=266;

  ProgressBar1.Visible:=True;
  ProgressBar1.Enabled:=True;
  ProgressBar1.Top:=8;
  ProgressBar1.Left:=8;
  ProgressBar1.Height:=17;
  ProgressBar1.Width:=249;
  ProgressBar1.Max:=100;
  ProgressBar1.Min:=0;
  ProgressBar1.Position:=0;
//ProgressBar1.Smooth:=True;

  ButtonStop.Visible:=True;
  ButtonStop.Enabled:=True;
  ButtonStop.Top:=38;
  ButtonStop.Left:=96;
  ButtonStop.Height:=25;
  ButtonStop.Width:=75;
  ButtonStop.Caption:='~';
  Application.ProcessMessages;
end;
//
//
//
procedure TViewImageForm.ResetProgress;
begin
  ProgressBar1.Visible:=False;
  ProgressBar1.Enabled:=False;
  ButtonStop.Visible:=False;
  ButtonStop.Enabled:=False;

  Image1.Visible:=True;
  Image1.Enabled:=True;
  ClientHeight:=48;
  ClientWidth:=48;
  Image1.Align:=alClient;
  Application.ProcessMessages;
end;
//
//
//
procedure TViewImageForm.ErrorProgress;
begin
  Height:=110;
  Width:=274;
  ClientHeight:=75;
  ClientWidth:=266;
  ProgressBar1.Visible:=False;
  ProgressBar1.Enabled:=False;
  ButtonStop.Visible:=True;
  ButtonStop.Enabled:=True;
  ButtonStop.Caption:='';
  Application.ProcessMessages;
end;
//
// Xbh[v
//
procedure TViewImageForm.DownLoadEntry();
var
  Result: TWaitResult;
begin
  while True do
  begin
    Result:=DownloadStartEvent.WaitFor(2147483647);		// 0x7fffffff=24
    if Result=wrSignaled then
    begin
      GetURL(mURL);
      DownloadWaitEvent.SetEvent();         // _E[hIʒm
      DownloadStartEvent.ResetEvent();      // Ăёҋ@֑Jڂ
    end else
    if Result=wrAbandoned then      // CxgjȂXbhI
    begin
      break;
    end;
  end;
end;
//
// URLXg[ɓǂݍ
//
procedure TViewImageForm.GetURL(URL: string);
var
//http: TIdHttp;
//src: string;
  proxyHost: string;
  proxyPort: integer;
//i: integer;

begin
  // proxy
  if gConfig.ReadProxyUse then
  begin
    gConfig.ParseProxy(gConfig.ReadProxy, proxyHost, proxyPort);
    http.ProxyParams.ProxyServer := proxyHost;
    http.ProxyParams.ProxyPort   := proxyPort;
  end;

  try
    Http.AllowCookies:=True;
    Http.ConnectTimeout := gConfig.CONNECT_TIMEOUT;
    Http.ReadTimeout:=0;				// (ms)
    Http.HandleRedirects:=True;			// _CNg
    Http.RecvBufferSize:=32768;
    Http.ProtocolVersion := pv1_1; 		//
    Http.Request.Accept:='*/*';
    Http.Request.BasicAuthentication:=False;
    Http.Request.Username:='';
    Http.Request.Password:='';
    Http.Request.ContentLength:=0;
    Http.Request.ContentRangeEnd:=0;
    Http.Request.ContentRangeStart:=0;
    Http.Request.Referer:=Domain(URL);
    Http.Request.Host:=Host(URL);
    Http.Request.UserAgent:='Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)';
    Http.Request.AcceptEncoding:='gzip, deflate';
    eString:='G[';
    Http.Get(URL,Stream);
    Application.ProcessMessages;
    Stream.Seek(0, soBeginning);

  except
    on E: EIdSocketError do
      eString:=E.Message;
    on E: EIdHTTPProtocolException do
      eString:=E.Message;
    on E: Exception do
      eString:=E.Message;
   end;

  if Http.ResponseCode=200 then
  begin
    {$IFDEF Debug}
//    Stream.SaveToFile('aaa.jpg');
    {$ENDIF}
    Stream.Seek(0,soBeginning);
    GetMsg:='';
  end
  else
  begin
    Stream.Clear;
    GetMsg:=Http.ResponseText;
  end;

    Complete:=True;
end;
//
// L[
//
procedure TViewImageForm.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if Key=VK_ESCAPE then
  begin
  //Close;
  Visible:=False;
  SetProgress;
//Image1.Picture.Bitmap:=Nil;
  mStop:=False;
  end;
end;

procedure TViewImageForm.Image1Click(Sender: TObject);
begin
//Close;
end;

procedure TViewImageForm.ImageMax;
begin
  Top:=MainForm.Top;
  Left:=MainForm.Left;
  ClientHeight:=mSize.cy;
  ClientWidth:=mSize.cx;
end;

procedure TViewImageForm.Image1DblClick(Sender: TObject);
begin
//if mDblck=False then
//begin
//  mDblck:=True;
    ImageMax;
//end else
//begin
//  mDblck:=False;
//  Visible:=False;
//  SetProgress;
//end;
end;

procedure TViewImageForm.HttpRedirect(Sender: TObject; var dest: String;
  var NumRedirect: Integer; var Handled: Boolean;
  var VMethod: TIdHTTPMethod);
begin
  if Dest='' then
  begin
    ;
  end;

end;

procedure TViewImageForm.HttpStatus(ASender: TObject;
  const AStatus: TIdStatus; const AStatusText: String);
begin
//
end;
//
//  T[oɐڑ
//
procedure TViewImageForm.HttpConnected(Sender: TObject);
begin
  mConnect:=True;
end;
//
// T[oؒf
//
procedure TViewImageForm.HttpDisconnected(Sender: TObject);
begin
  mConnect:=False;
end;
//
// M
//
procedure TViewImageForm.HttpWork(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCount: Integer);
//var
//Pos: Integer;
begin
//Sender: TObject;
//AWorkMode: TWorkMode;			wmRead/wmWrite
//const AWorkCount: Integer		MꂽɂĉeoCg

  if mStop=False then
  begin
    ReceiveCount:=ReceiveCount+AWorkCount;
    if mStep<>-1 then
    begin
      mPosition:=Ceil(ReceiveCount/mStep);
      Progress:=True;
      DownloadWaitEvent.SetEvent;    // ProgressBar`
    end;
  end else
  begin
    http.DisConnect();
  end;
end;
//
// ǂݏJn
//
procedure TViewImageForm.HttpWorkBegin(Sender: TObject;
  AWorkMode: TWorkMode; const AWorkCountMax: Integer);
begin
//Sender: TObject;
//AWorkMode: TWorkMode;			wmRead/wmWrite
//const AWorkCountMax: Integer	\ő̃oCg

  mStop:=False;
  Complete:=False;
  CountMax:=AWorkCountMax;
  ReceiveCount:=0;

  mPosition:=0;
//if AWorkCountMax<>0 then
  if AWorkCountMax>500 then
  begin
    mStep:=AWorkCountMax/100;
  end else
  begin
    mStep:=-1;
  end;
end;
//
// ǂݏI
//
procedure TViewImageForm.HttpWorkEnd(Sender: TObject;
  AWorkMode: TWorkMode);
begin
//Sender: TObject;
//AWorkMode: TWorkMode			wmRead/wmWrite
  mStop:=False;
//Complete:=True;
end;

procedure TViewImageForm.ButtonStopClick(Sender: TObject);
begin
  if ButtonStop.Caption='' then
  begin
    Visible:=False;
  end else
  begin
    mStop:=True;
    DownloadWaitEvent.SetEvent;    // ~
  end;
end;

procedure TViewImageForm.MainFormPopupMaxClick(Sender: TObject);
begin
  ImageMax;
end;

procedure TViewImageForm.PopupCloseClick(Sender: TObject);
begin
  Visible:=False;
  SetProgress;
end;


function TViewImageForm.Domain(URL: string): string;
var
	n1: integer;
	n2: integer;
	Count: integer;
	s: string;
begin
	Result:='http://www.2ch.net/';
	Count:=Length(URL);
	n1:=AnsiPos('://',URL);
	if n1<>0 then
	begin
		s:=Copy(URL,n1+3,Count-(n1+3-1));
		n2:=AnsiPos('/',s);
		if n2<>0 then
		begin
			Result:=Copy(URL,1,n1+n2+3-1);
		end else
		begin
			Result:=URL;
		end;
	end;
end;
function TViewImageForm.Host(URL: string): string;
var
	n1: integer;
	n2: integer;
	Count: integer;
	s: string;
begin
	Result:='www.2ch.net';
	Count:=Length(URL);
	n1:=AnsiPos('://',URL);
	if n1<>0 then
	begin
		s:=Copy(URL,n1+3,Count-(n1+3-1));
		n2:=AnsiPos('/',s);
		if n2<>0 then
		begin
			Result:=Copy(URL,n1+3,n2-1);
		end else
		begin
			Result:=URL;
		end;
	end;
end;
// 
// OS̋@\gpĉ摜\
// 
function TViewImageForm.ViewSystem(Stream: TMemoryStream): bool;
var
  oBitmap: TOleBITMAP;
  h: Double;
begin
  oBitmap:=TOleBITMAP.Create();
  oBitmap.LoadFromStream(Stream);
  mSize.cx:=oBitmap.Width;
  mSize.cy:=oBitmap.Height;
  if (mSize.cx=0) or (mSize.cy=0) then
  begin
    oBitmap.Free;
    Result:=false;
  end else
  begin
    if mSize.cx>mSize.cy then
    begin
      h:=ClientHeight*(mSize.cy/mSize.cx);
      ClientHeight:=Round(h);
    end else
    if mSize.cx<mSize.cy then
    begin
      h:=ClientWidth*(mSize.cx/mSize.cy);
      ClientWidth:=Round(h);
    end;

    Image1.Stretch:=True;
    Image1.Picture.Bitmap:=oBitmap;
    oBitmap.Free;
    Result:=true;
  end;
end;
//
//
//
function TViewImageForm.ViewLib(Stream: TMemoryStream; urlStr: string): bool;
//var
//  h: Double;
begin

  Result:=true;

  //20130512
  //JpegLoaderCũ\[X݂Ȃ̂
  //͎̕łȂ@ׂăRgAEg
  //摜\⍲֐ŁAigȂ̂őeȂ

{
  with TLinearBitmap.Create do
    try
      Image1.Picture:=nil;
      if AnsiEndsText('.jpg',urlStr) or AnsiEndsText('.jpeg',urlStr) then
      begin
        LoadFromStream(Stream,'JPG');
      end else
//   if AnsiEndsText('.gif',urlStr) then
//     begin
//       LoadFromStream(Stream,'GIF');
//   end else
     if AnsiEndsText('.png',urlStr) then
      begin
        LoadFromStream(Stream,'PNG');
      end;
      AssignTo(Image1.Picture.Bitmap);

	except
	  Result:=false;

      Free;
    end;

//  finally
//    Free;
//  end;

  if(Result=true) then
  begin
    mSize.cx:=Image1.Picture.Bitmap.Width;
    mSize.cy:=Image1.Picture.Bitmap.Height;
    if mSize.cx>mSize.cy then
    begin
      h:=ClientHeight*(mSize.cy/mSize.cx);
      ClientHeight:=Round(h);
    end else
    if mSize.cx<mSize.cy then
    begin
      h:=ClientWidth*(mSize.cx/mSize.cy);
      ClientWidth:=Round(h);
    end;
    Image1.Stretch:=True;
  end;
}

end;

// g
procedure TViewImageForm.PopupZoomUpClick(Sender: TObject);
var
  h: Double;
begin
  h:=(ClientWidth/mSize.cx);
  h:=h*1.05;
  Top:=MainForm.Top;
  Left:=MainForm.Left;
  ClientHeight:=Trunc(mSize.cy*h);
  ClientWidth :=Trunc(mSize.cx*h);
end;
// k
procedure TViewImageForm.PopupZoomDownClick(Sender: TObject);
var
  h: Double;
begin
  h:=(ClientWidth/mSize.cx);
  h:=h*0.95;
  Top:=MainForm.Top;
  Left:=MainForm.Left;
  ClientHeight:=Trunc(mSize.cy*h);
  ClientWidth :=Trunc(mSize.cx*h);
end;

end.



