unit untWriteForm;

interface

uses
  Forms,  StrUtils, Classes, Controls,
  ComCtrls, OleCtrls, StdCtrls, SHDocVw_TLB, ExtCtrls,
  untGlobal, untKakikomi,  untTopic,
  untOnlineBoard, untTopicPostThread, untCrypt,
  untMakeNewThread, untTopicBrowser,
  untRegExpr,
  HogeTextView, untDoeSub, untLocalRule;
type
  TWriteForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    PreviewSheet: TTabSheet;
    Label1: TLabel;
    TitleEdit: TEdit;
    Label2: TLabel;
    NameComboBox: TComboBox;
    Label3: TLabel;
    EmailComboBox: TComboBox;
    BodyMemo: TMemo;
    SageCheckBox: TCheckBox;
    WriteButton: TButton;
    CancelButton: TButton;
    TabSheet3: TTabSheet;
    PreviewBrowser: TWebBrowser;
    HogeTextView1: THogeTextView;
    AutoPostCheckBox: TCheckBox;
    WriteTimerButton: TButton;
    procedure FormDeactivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure WriteButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SageCheckBoxClick(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure PreviewBrowserNavigateComplete2(Sender: TObject;
                                              const pDisp: IDispatch;
                                              var URL: OleVariant);
    procedure TitleEditChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ComboBoxKeyDown(Sender: TObject; var Key: Word;
                              Shift: TShiftState);
    procedure CreateParams(var Params: TCreateParams); override;
    procedure FormResize(Sender: TObject);
    procedure OnWriteTimerButton_Click(Sender: TObject);
  private
    { Private 錾 }
    FOwnerForm: TForm;
    FKakikomi: TKakikomi;
    FFormHeight: Integer;
    FTopic: TTopic;
    FBoard: TOnlineBoard;
    FDefaultMail: string;
    FShowing: Boolean;
    FMakeTopicMode: Boolean;
    FWaitInitializePreview: Boolean;
    FChangeText: Boolean;
    FPostThread: TTopicPostThread;
    //Xėp̐pXbh
    FMakeNewThread: TMakeNewThread;
    //ݑҋ@bLp
    FTaikiDateTime: TDateTime;
    //ҋ@bLẐ߂ɃT[oL
    FTaikiDateTimeServer: String;
    //ēep^C}[
    FAutoPostTimer: TTimer;
    //ŏtO
    FShrink:Boolean;
    procedure OnTimerEvent(Sender: TObject);
    procedure BBS_Complete(Sender: TObject);
    procedure BBS_Error(Sender: TObject;
                        const ErrorCode: TFrameworkErrorType;
                        const ErrorString: string);
    procedure BBS_StatusChange(Sender: TObject);
    procedure LoadList(comboBox: TComboBox; listFile: String);
    procedure SaveList(comboBox: TComboBox; listFile: String);
    procedure ViewInit();
    function ExistNewEntry(comboBox: TComboBox): Boolean;
    function Trip(const Key: string): string;
    procedure WriteKakikomi();    // 2008.05.19

  public
    { Public 錾 }
    //FShrink:Boolean;

    TopicBrowser: TTopicBrowser;
    constructor CreateForm(AOwner: TComponent; AOwnerForm: TForm);
    procedure SetTopic(Topic: TTopic; ResAt: integer = 0);
    procedure SetBoard(Board: TOnlineBoard);
    //CtH[ĂԂ̂Public
    procedure FormActivateEx();
    procedure FormDeactivateEx();

end;

var
  WriteForm: TWriteForm;

implementation

{$R *.dfm}

uses
  SysUtils, Windows, Dialogs, MSHTML_TLB,
  untTool, untMainForm;

constructor TWriteForm.CreateForm(AOwner: TComponent; AOwnerForm: TForm);
begin
  FOwnerForm := AOwnerForm;
  Fshrink:=False;

  Inherited Create(AOwner);
end;

procedure TWriteForm.CreateParams(var Params: TCreateParams);
begin
  inherited;

  Params.WndParent := FOwnerForm.Handle;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TWriteForm.FormDeactivate(Sender: TObject);
begin

  //tH[ANeBɂȂƂ
  //ɖ߂悤ɃTCYLĂ

  if self.Height > 50 then
     FFormHeight := self.Height;

  if FShowing then
  begin
      self.Height:=0;
      FShrink:=True;
  end;

end;

procedure TWriteForm.FormDeactivateEx();
begin
  //tH[ANeBɂȂƂ
  //ɖ߂悤ɃTCYLĂ

  //CtH[Ă΂镔

  if self.Height > 50 then
     FFormHeight := self.Height;

  if FShowing then
  begin
      self.Height:=0;
      FShrink:=True;
  end;

end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TWriteForm.FormActivate(Sender: TObject);
//var
//  mhwnd:HWND;
begin

  //Ӗ̂悤Ȃ̂ŃRgAEg
  //mhwnd:=GetNextWindow(self.Handle,GW_HWNDNEXT);
  //if mhwnd<>MainForm.Handle then
  //begin
    // ERROR
  //end;

  FormActivateEx();
end;

procedure TWriteForm.FormActivateEx();
begin

  //tH[\ɏ݉ʂftHgɂ
   self.PageControl1.ActivePage := TabSheet1;

  //T[oɕςƂɑҋ@bNAĂ
  if (FBoard.Server <> FTaikiDateTimeServer) then FTaikiDateTime := Now();
  //[iTjł͖̓tVAiɂȂ̂
  //uWBBBv
  if (FBoard.BoardName = 'morningcoffee') and (NameComboBox.text = '') then NameComboBox.Text := 'WBBB';

  self.Height := FFormHeight;
  Fshrink:=False;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TWriteForm.FormCreate(Sender: TObject);
begin

  FShowing := false;
  FChangeText := true;
  NameComboBox.Text  := '';
  EmailComboBox.Text := '';

  FFormHeight := gConfig.WriteFormHeight;
  self.Width  := gConfig.WriteFormWidth;
  self.Left   := gConfig.WriteFormLeft;
  self.Top    := gConfig.WriteFormTop;
  self.Height := FFormHeight;

  LoadList(NameComboBox,  gConfig.NameListFile);
  LoadList(EmailComboBox, gConfig.MailListFile);

  self.PageControl1.ActivePage := TabSheet1;

  //[J[\Doeݒ
  // message
  self.HogeTextView1.TextAttrib[0].color := gConfig.Doe_TextColor;
  // name
  self.HogeTextView1.TextAttrib[1].color := gConfig.Doe_NameColor;
  self.HogeTextView1.TextAttrib[3].color := gConfig.Doe_NameColor;
  // HTTP link
  self.HogeTextView1.TextAttrib[2].color := gConfig.Doe_LinkColor;
  self.HogeTextView1.Color := gConfig.Doe_BGColor;
  //]
  self.HogeTextView1.LeftMargin := 15;
  self.HogeTextView1.TopMargin := 15;
  self.HogeTextView1.RightMargin := 20;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TWriteForm.FormDestroy(Sender: TObject);
begin
  SaveList(NameComboBox,  gConfig.NameListFile);
  SaveList(EmailComboBox, gConfig.MailListFile);
  FKakikomi.Free;
end;
//
// ݏ
//
procedure TWriteForm.WriteButtonClick(Sender: TObject);
var
  b: TOnlineBoard;
begin

  WriteButton.Enabled := false;

  if EmailComboBox.Text = 'sage' then
  begin
    gConfig.DefaultSage := true
  end else if EmailComboBox.Text = '' then
  begin
    gConfig.DefaultSage := false;
  end;

  b := FBoard;

  if FMakeTopicMode = false then
  begin
    //X̏

    //AeG[ɑOđΏiT[oɓȂj
     if (FTaikiDateTime > Now()) then
       begin

        //vp
        Inc(gConfig.ToukeiInfo_Write_AutoCancel);

        Showmessage(DateTimeToStr(FTaikiDateTime) +
        '܂őҋ@b' + #13#10 +
        'Ă̂ŏ݂LZ܂B' +
        #13#10#13#10 + 'ݎ ' + DateTimeToStr(Now()));
        WriteButton.Enabled := true;
        exit;
       end;

    //폑

    //vp
    Inc(gConfig.ToukeiInfo_Write);

    FTopic.WroteName  := NameComboBox.Text;
    FTopic.WroteEmail := EmailComboBox.Text;
    FTopic.SaveIdx;
    FPostThread := b.PostArticle(FTopic,
                                 NameComboBox.Text,
                                 EmailComboBox.Text,
                                 BodyMemo.Text) as TTopicPostThread;
    FPostThread.OnComplete     := BBS_Complete;
    FPostThread.OnStatusChange := BBS_StatusChange;
    FPostThread.OnError        := BBS_Error;
    FPostThread.Resume;

    //kakikomi.txto
    WriteKakikomi();

  end;

  if (FMakeTopicMode) then
  try
   begin
    //X

    //vp
    Inc(gConfig.ToukeiInfo_Thread_Make);

    FMakeNewThread := b.MakeTopic(TitleEdit.Text,
                NameComboBox.Text,
                EmailComboBox.Text,
                BodyMemo.Text) as TMakeNewThread;
    FMakeNewThread.OnComplete     := BBS_Complete;
    FMakeNewThread.OnStatusChange := BBS_StatusChange;
    FMakeNewThread.OnError        := BBS_Error;
    FMakeNewThread.Resume;
   end;
  except on e: Exception do
    Showmessage(e.Message);
  end;



  if ExistNewEntry(NameComboBox) then
  begin
    NameComboBox.Items.Add(NameComboBox.Text);
    SaveList(NameComboBox, gConfig.NameListFile);
  end;

  if ExistNewEntry(EmailComboBox) and not SageCheckBox.Checked then
  begin
    EmailComboBox.Items.Add(EmailComboBox.Text);
    SaveList(EmailComboBox, gConfig.MailListFile);
  end;

  //Xă[ĥƂ̓tH[
  if (FMakeTopicMode) then
     self.Close;

end;
//
// ݂̏
//
procedure TWriteForm.SetTopic(Topic: TTopic; ResAt: integer = 0);
begin
  if (self.Visible) then
  begin
    if (ResAt > 0) and (FTopic = Topic) then
    begin
      BodyMemo.Text := BodyMemo.Text +  '>>' + IntToStr(ResAt) + #13#10;
    end;
    self.Show;
    exit;
  end;

  FMakeTopicMode := false;
  FTopic := Topic;
  FBoard := (Topic.OnlineBoard as TOnlineBoard);
  self.Caption := 'u' + FTopic.Title + 'vɃX';

  //OCp
  if gConfig.SessionID <> '' then
     self.Caption := self.Caption + ' ';

  //BEOCp
  if (gConfig.BELogin) then
     self.Caption := self.Caption + ' BEOC';

  TitleEdit.Text := FTopic.Title;
  TitleEdit.Enabled := false;

  if FTopic.WroteName <> '' then
  begin
    NameComboBox.Text := FTopic.WroteName
  end else
  begin
    NameComboBox.Text := gConfig.KoteHan;
  end;

  if (FTopic.WroteEmail <> '') and (FTopic.WroteEmail <> 'sage') then
  begin
    FDefaultMail := FTopic.WroteEmail
  end else
  begin
    FDefaultMail := gConfig.KoteMail;
  end;

  if ResAt = 0 then
  begin
    BodyMemo.Text := ''
  end else
  begin
    BodyMemo.Text := '>>' + IntToStr(ResAt) + #13#10;
  end;
  ViewInit;
end;
//
// XĂ̏
//
procedure TWriteForm.SetBoard(Board: TOnlineBoard);
begin
  if self.Visible = true then
  begin
    self.Show;
    exit;
  end;

  FMakeTopicMode := true;
  FBoard := Board;
  self.Caption := 'u' + FBoard.DisplayName + 'vɐVKXbh';

  //OCp
  if gConfig.SessionID <> '' then
     self.Caption := self.Caption + ' ';

  //BEOCp
  if (gConfig.BELogin) then
     self.Caption := self.Caption + ' BEOC';

  TitleEdit.Text := '';
  TitleEdit.Enabled := true;

  NameComboBox.Text  := gConfig.KoteHan;
  FDefaultMail := gConfig.KoteMail ;

  BodyMemo.Text := '';

  ViewInit;
end;
//
//
//
procedure TWriteForm.ViewInit;
begin
  if (EmailComboBox.Text = '') and gConfig.DefaultSage then
  begin
    EmailComboBox.Text := 'sage';
  end;
  SageCheckBox.Checked := (EmailComboBox.Text = 'sage');
  SageCheckBoxClick(SageCheckBox);
  WriteButton.Enabled := true;

  if (self.Height = 0) then
  begin
       self.Height := FFormHeight;
  end;
  self.Show;
  FShowing := true;
end;
//
//
//
procedure TWriteForm.CancelButtonClick(Sender: TObject);
begin
  //݃LZ
  Close;
end;
//
//
//
procedure TWriteForm.SageCheckBoxClick(Sender: TObject);
begin
  FChangeText := true;
  if SageCheckBox.Checked then
  begin
    EmailComboBox.Text := 'sage';
    EmailComboBox.Enabled := false;
  end else
  begin
    EmailComboBox.Text := FDefaultMail;
    EmailComboBox.Enabled := true;
  end;
end;
//
//
//
procedure TWriteForm.PageControl1Change(Sender: TObject);
  function HtmlPost(const S: string):string;
  begin
    Result := S;
//  Result := AnsiReplaceStr(Result, '<', '&lt;');
//  Result := AnsiReplaceStr(Result, '>', '&gt;');
    Result := ReTitle(Result);

    Result := AnsiReplaceStr(Result, #13#10, '<br>');
    Result := AnsiReplaceStr(Result, #13, '<br>');
    Result := AnsiReplaceStr(Result, #10, '<br>');
  end;

  function NameConv(const S: string):string;
  begin
    Result := HtmlPost(S);
    Result := AnsiReplaceStr(Result, '', '');
    Result := AnsiReplaceStr(Result, '', '');
    if AnsiPos('#', Result) > 0 then
    begin
      Result := Copy(Result, 1, AnsiPos('#', Result) - 1) + '</b>'
        + Trip(Copy(Result,AnsiPos('#', Result) + 1, Length(Result))) + ' <b>';
    end;
    if AnsiPos('', Result) > 0 then
    begin
      Result := Copy(Result, 1, AnsiPos('', Result) - 1) + '</b>'
        + Trip(Copy(Result,AnsiPos('', Result) + 2, Length(Result))) + ' <b>';
    end;
    {
    if not Config.tstAuthorizedAccess then
    begin
      Result := AnsiReplaceStr(Result, '', '');
    end;
    }
    Result := AnsiReplaceStr(Result, '"', '&quot;');
  end;

  function MailConv(const S: string):string;
  begin
    Result := HtmlPost(S);
    if AnsiPos('#', Result) > 0 then
    begin
      Result := Copy(Result, 1, AnsiPos('#', Result) - 1);
    end;
    if AnsiPos('', Result) > 0 then
    begin
      Result := Copy(Result, 1, AnsiPos('', Result) - 1);
    end;
    Result := AnsiReplaceStr(Result, '"', '&quot;');
  end;

  function MessageConv(const S: string):string;
  begin
    Result := HtmlPost(S);
    Result := AnsiReplaceStr(Result, '"', '&quot;');
  end;

var
  preview, postName, postEmail, mailName, body: string;
  i: Integer;
  strLocalRuleURL: string;
  ruleStr        : string;
  rule: TLocalRule;
  dest: TSimpleDat2View;
begin
  if (PageControl1.ActivePage = PreviewSheet) and FChangeText then
  begin
    FChangeText := false;

    FWaitInitializePreview := true;
    PreviewBrowser.Navigate('about:blank');

    // o܂ő҂
    for i := 0 to 1000 do
    begin
      if FWaitInitializePreview = false then
      begin
        break;
      end else
      begin
        Application.ProcessMessages;
      end;
    end;

    if NameComboBox.Text <> '' then
    begin
      postName := NameConv(NameComboBox.Text)
    end else
    begin
      postName := 'vr[̖';
    end;
    postEmail := MailConv(EmailComboBox.Text);
    if postEmail <> '' then
    begin
      mailName := '<a href="mailto:' + postEmail + '"><b>' + postName + '</b></a>'
    end else
    begin
      mailName := '<font color=green><b>' + postName + '</b></font>';
    end;

    Body := MessageConv(BodyMemo.Text);

    Preview  := '<html><head><meta http-equiv="Content-Type" content="text/html; ' +
                'charset=Shift_JIS"></head><body bgcolor=#efefef text=black ' +
                'link=blue alink=red vlink=#660099>' +
                '<font face="lr oSVbN"><dl>' +
                '<dt>1 F' + MailName + ' F00/00/00 00:00<dd>' + Body + '<br></dd><br>';

    OleVariant(PreviewBrowser.Document as IHTMLDocument2).write(Preview);
  end;

  //[J[̕\
  if (PageControl1.ActivePage = TabSheet3)  then
  begin

       //DoeR|ɂ`
       self.HogeTextView1.Clear;

       dest := TSimpleDat2View.Create(self.HogeTextView1);

       strLocalRuleURL := FBoard.BoardUrl + 'head.txt';
       rule := TLocalRule.Create();
       ruleStr := rule.GetHTML(strLocalRuleURL);
       dest.WriteHTML(ruleStr);

  end;
end;
//
//
//
function TWriteForm.Trip(const Key: string): string;
{----------------------------------
$salt = substr($key."H.", 1, 2);//<--ǂ
$salt =~ s/[^\.-z]/\./go;
$salt =~ tr/:;<=>?@[\\]^_`/ABCDEFGabcdef/;
-----------------------------------}
  function MakeSalt(const Key: string): string;
  var
    i: Integer;

  begin
    result := Copy(Copy(Key, 2, 2) + 'H.', 1, 2);

    for i := 1 to Length(Result) do
    begin
      if (Ord(Result[i]) < Ord('.')) or (Ord('z') < Ord(Result[i])) then
      begin
        result[i] := '.';
      end;

      if ((Ord(':') <= Ord(Result[i])) and (Ord(Result[i]) <= Ord('@'))) then
      begin
        result[i] := Char(Ord(Result[i]) - Ord(':') + Ord('A'))
      end else if ((Ord('[') <= Ord(Result[i])) and
                  (Ord(Result[i]) <= Ord('`'))) then
      begin
        result[i] := Char(Ord(Result[i]) - Ord('[') + Ord('a'));
      end;
    end;
  end;

var
  salt: string;

begin
  if Key = '' then
  begin
    result := '#';
  end else
  begin
    salt := MakeSalt(Key);
    result := '' + Copy(crypt(Key), 4, 10);
  end;
end;
//
//
//
procedure TWriteForm.PreviewBrowserNavigateComplete2(Sender: TObject;
                                                     const pDisp: IDispatch;
                                                     var URL: OleVariant);
begin
  FWaitInitializePreview := false;
end;
//
//
//
procedure TWriteForm.TitleEditChange(Sender: TObject);
begin
  FChangeText := true;
end;
//
//
//
procedure TWriteForm.BBS_Complete(Sender: TObject);
begin
  //݊̏

  //Xă[hł͂ȂƂX݂̂Ƃ
  if FMakeTopicMode = false then
  begin
    FTopic.LastWriteDate := DateTimeToStr(Now());
    FTopic.SaveIdx;
    FTopic.State := dsNone;
    if Assigned(TopicBrowser) then
    begin
      TopicBrowser.Reload;
    end;
  //ҋ@bNA(ݎɐݒj
  FTaikiDateTime := Now();
  //T[oLiʂ̃T[oւ̃ANZXpj
  FTaikiDateTimeServer := FBoard.Server;

  end;
  //kakimi.txto͗}
  //FKakikomi.Write(FTopic.LastWriteDate, FTopic.Title, FTopic.BrowserUrl, FTopic.WroteName, FTopic.WroteEmail, BodyMemo.Text);

  //^C}[NA
  if Assigned(FAutoPostTimer) then
  begin
     FAutoPostTimer.Enabled  := false;
  end;

  //XāAX݊tH[
  Close;
end;
//
//
//
procedure TWriteForm.BBS_Error(Sender: TObject;
                               const ErrorCode: TFrameworkErrorType;
                               const ErrorString: string);
var
  strErrMes: string;
  regEx: TRegExpr;
  strDate: string;
  dblTime: double;
  myDate: TDateTime;
  intTaikiSec: integer;
begin
  //ҋ@b
  intTaikiSec := 0;

  //^C}[NA
  if Assigned(FAutoPostTimer) then
     FAutoPostTimer.Enabled  := false;

  strErrMes := ErrorString;

  //20130511 

  //G[bZ[W̒
  //ݑҋ@b
  if (Pos(' sec',strErrMes) <> 0) or
     (Pos(' b',strErrMes) <> 0) then
  begin
    regEx := TRegExpr.Create;

    try

    //regEx.Expression := ' ([0-9]+) sec ȂƏ܂';
    regEx.Expression := '([0-9]+) sec';
    if (regEx.Exec(strErrMes)) then
        intTaikiSec := StrToInt(regEx.Match[1]);

    regEx.Expression := '([0-9]+) b';
    if (regEx.Exec(strErrMes)) then
        intTaikiSec := StrToInt(regEx.Match[1]);

    myDate := Now();
    //ԌvẐ߂̊Z
    dblTime := intTaikiSec;
    dblTime := dblTime / 60 / 60 / 24;
    myDate := myDate + dblTime;
    //鎞L
    FTaikiDateTime := myDate;
    //ҋ@bLiēepj
    intTaikiSec := intTaikiSec + 1; //Pb]T
    //bZ[W
    strDate := IntToStr(intTaikiSec) + 'bKłBɏ̂ ' + DateTimeToStr(myDate);
    FTopic.StatusText := strDate;

    //vp
    Inc(gConfig.ToukeiInfo_Write_AutoCancel);

    except
         on e: Exception do
         begin
         ShowMessage(e.Message);
         FTopic.StatusText := 'ҋ@b̓[`G[ vbugfix';
         end;
    end;
    regEx.Free;

  end else
  begin
    FTopic.StatusText := '݃G[';
    ShowMessage(strErrMes);
  end;

  //ҋ@bK̂ƂAēe
  if (AutoPostCheckBox.Checked) and (intTaikiSec > 0) then
  begin
     if Assigned(FAutoPostTimer) then FAutoPostTimer.Free;
     FAutoPostTimer := TTimer.Create(self);
     FAutoPostTimer.Interval := intTaikiSec * 1000;
     FAutoPostTimer.Enabled  := true;
     FAutoPostTimer.OnTimer  := OnTimerEvent;
     FTopic.StatusText := FTopic.StatusText + '@yēeIz';
  end;

  WriteButton.Enabled := true;
  FTopic.State := dsNone;
  BBS_StatusChange(self);

end;
//
//
//
procedure TWriteForm.BBS_StatusChange(Sender: TObject);
begin
  self.Caption := FTopic.StatusText;
end;
//
//
//
procedure TWriteForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FShowing := false;
  if self.Height > 5 then
  begin
    gConfig.WriteFormHeight:= Height;
    gConfig.WriteFormWidth := Width;
    gConfig.WriteFormLeft  := Left;
    gConfig.WriteFormTop   := Top;
  end;
end;
//
// ɃXgɂ邩ǂ
//
function TWriteForm.ExistNewEntry(comboBox: TComboBox): Boolean;
begin
  if (comboBox.Text <> '') and (comboBox.Items.IndexOf(comboBox.Text) = -1) then
  begin
    result := True
  end else
  begin
    result := False;
  end;
end;
//
//
//
procedure TWriteForm.LoadList(comboBox: TComboBox; listFile: String);
begin
  if FileExists(gConfig.NameListFile) and AnsiEndsText('.txt', listFile) then
  begin
    comboBox.items.LoadFromFile(listFile);
  end;
end;
//
//
//
procedure TWriteForm.SaveList(comboBox: TComboBox; listFile: String);
var
  i: Integer;
  stringList: TStringList;

begin
  // ςȃt@CgȂ悤Ɋgq .txt 
  if AnsiEndsText('.txt', listFile) then
  begin
    stringList := TStringList.Create;
    for i := 0 to comboBox.Items.Count - 1 do
    begin
      // 󔒍s͏
      if comboBox.Items[i] <> '' then
      begin
       stringList.Add(comboBox.Items[i]);
      end;
    end;
    stringList.SaveToFile(listFile);
    stringList.Free;
  end;
end;
//
// [Delete] L[ŃGg폜
//
procedure TWriteForm.ComboBoxKeyDown(Sender: TObject;
                                     var Key: Word;
                                     Shift: TShiftState);
var
  comboBox  : TComboBox;
  itemIndex : Integer;

begin
  if (Sender is TComboBox) and (Key = VK_DELETE) then
  begin
    comboBox  := TComboBox(Sender);
    itemIndex := comboBox.ItemIndex;
    comboBox.Items.Delete(itemIndex);
  end;
end;
//
//TCY
//
procedure TWriteForm.FormResize(Sender: TObject);
var
  w: Integer;
begin
  if (self.PageControl1.ActivePage = TabSheet3) then
  begin
      self.HogeTextView1.Width := self.Width - 50;
      self.HogeTextView1.Height := self.Height - 80;
  end;

  //{^Ĕzû߂̌vZ
  w := WriteButton.Width + AutoPostCheckBox.Width + CancelButton.Width + WriteTimerButton.Width;

  AutoPostCheckBox.Left:=(TabSheet1.Width-w) div 2;
  WriteButton.Left := AutoPostCheckBox.Left + AutoPostCheckBox.Width+6;
  CancelButton.Left := WriteButton.Left + WriteButton.Width+6;
  WriteTimerButton.Left:=CancelButton.Left + CancelButton.Width+6;

  //ȑO̐ݒ
  //WriteButton.Left:=(TabSheet1.Width-WriteButton.Width-CancelButton.Width-6) div 2;
  //CancelButton.Left:=WriteButton.Left+WriteButton.Width+6;

end;
//
// "kakikomi.txt"o
//
procedure TWriteForm.WriteKakikomi();
var
  f: TextFile;
  str: string;
const
  KAKIKOMI: string = 'kakikomi.txt';

begin
  if gConfig.Kakikomi = True then
  begin
    AssignFile(f,AppPath(KAKIKOMI));
    if FileExists(AppPath(KAKIKOMI)) = True then
    begin
     Append(f);
    end
    else
    begin
     Rewrite(f);
    end;

    Writeln(f,'--------------------------------------------');
    str:='Date   : ' + DateTimeToStr(Now());
    Writeln(f,str);

    str:='Subject: ' + TitleEdit.Text;
    Writeln(f,str);

    str:='URL    : ' + MainForm.UrlEdit.Text;
    Writeln(f,str);

    str:='From   : ' + NameComboBox.Text;
    Writeln(f,str);
    str:='Mail   : ' + EmailComboBox.Text;
    Writeln(f,str);

    Writeln(f,'');

    Writeln(f,BodyMemo.Lines.Text);

    Writeln(f,'');

    Flush(f);
    CloseFile(f);
  end;
end;


procedure TWriteForm.OnWriteTimerButton_Click(Sender: TObject);
begin
   //΂炭ҋ@ŏ

   //{^disabled
   WriteTimerButton.Enabled := false;
   Application.ProcessMessages;

   //ҋ@
   Sleep(30000);

   WriteTimerButton.Enabled := true;
   Application.ProcessMessages;

   //
   WriteButtonClick(Sender);

end;

procedure TWriteForm.OnTimerEvent(Sender: TObject);
begin
   WriteButtonClick(self);
end;


end.

