unit unt2chUrlParser;

{ 2ch url ̓jbg }

interface

type

  T2chUrlParser = class
  private
    FIs2chUrl: boolean;
    FServer:    string;
    FBoardName: string;
    FTopicId:   string;
  public
    StartNo: integer;
    EndNo:   integer;
    procedure Parse(const URI: string);
    property Is2chUrl: boolean read FIs2chUrl;
    property Server:    string read FServer;
    property BoardName: string read FBoardName;
    property TopicId:   string read FTopicId;
  end;

implementation

uses
  untRegExpr, Classes, SysUtils, StrUtils,
  untTool, untGlobal;

procedure T2chUrlParser.Parse(const URI: string);
const
  reg2chServer = '(2ch\.net|bbspink\.com)';
  regMachiServer = '(machi\.to|machibbs\.com)';
  regSitarabaServer = '(jbbs\.livedoor\.jp)';
  regOpen2chServer = 'open2ch\.net';
var
  regEx, regExOpt: TRegExpr;
  match: boolean;
  bt: TBBSType;

begin
  FIs2chUrl := false;

  //]vȏLZ邽
  if (URI = '') then exit;
  if (URI = 'y[W\܂') then exit;

  //wikiuEUŊJ
  if (Pos('2ch.net/wiki/pukiwiki.php',URI) <> 0) then
  begin
      exit;
  end;

  //BẽvtB[QƂ̓uEUŊJ
  if (Pos('be.2ch.net/test/p.php',URI) <> 0) then
  begin
    exit;
  end;

  //̃^Cvf
  bt := GetBBSType(URI);
  //ȃP[X̓uEUŊJ
  if (bt = bt2ch) and (Pos('2ch.net/', URI) = 0) and (Pos('bbspink.com/', URI) = 0) then
  begin
    exit;
  end;

  regEx := TRegExpr.Create;
  try
  case bt of
    bt2ch:
    begin
      // http://server.2ch.net/test/read.cgi/bbs/dat/opt
      regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/test/read\.cgi/(\w+)/(\w+)/*(.*)';
      match := regEx.Exec(URI);
      if not match then
      begin
        // http://server.2ch.net/bbs/dat/nnn.dat
        regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/(\w+)/dat/(\w+)\.dat';
        match := regEx.Exec(URI);
        if not match then
        begin
          // http://server.2ch.net/bbs/kako/nnn/dat.html
          regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/(\w+)/kako/(\w+)/dat\.html';
          match := regEx.Exec(URI);
          if not match then
          begin
            // http://server.2ch.net/sub/test/read.cgi?bbs=bbs&key=dat
            regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/sub/test/read\.cgi\?bbs=(\w+)&key=(\w+)';
            match := regEx.Exec(URI);
            if not match then
            begin
              // http://server.2ch.net/bbs/kako/nnn/nnnn/dat.html
              regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/(\w+)/kako/\w+/\w+/(\w+)\.html';
              match := regEx.Exec(URI);
              if not match then
              begin
                // http://server.2ch.net/bbs/kako/nnn/dat.html
                regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/(\w+)/kako/\w+/(\w+)\.html';
                match := regEx.Exec(URI);
                // gїpAhX
                if not match then
                begin
                  // http://server.2ch.net/test/r.i/bbs/dat/i
                  regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/test/r\.i/(\w+)/(\w+)/(.*)';
                  match := regEx.Exec(URI);
                  if not match then
                  begin
                    // http://c.2ch.net/test/-/bbs/dat/i
                    regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/test/-/(\w+)/(\w+)/(.*)';
                    match := regEx.Exec(URI);
                  end;
                end;
              end;
            end;
          end;
        end;
      end;
      if match then
      begin
        FServer := regEx.Match[1] + regEx.Match[2];
        FBoardName := regEx.Match[3];
        FTopicId := regEx.Match[4];
        FIs2chUrl := true;
        if regEx.SubExprMatchCount > 4 then
        begin
          regExOpt := TRegExpr.Create;
          try
          regExOpt.Expression := '^(\d{1,3})-?(\d{1,3})?';
          if regExOpt.Exec(regEx.Match[5]) then
          begin
            StartNo := StrToInt(regExOpt.Match[1]);
            if regExOpt.SubExprMatchCount > 1 then
            begin
              EndNo := StrToInt(regExOpt.Match[2]);
            end else
            begin
              EndNo := 0;
            end;
          end;
          finally
          regExOpt.Free;
          end;
        end;
      end else
      begin
        // 
        // http://server.2ch.net/test/read.cgi/bbs/?opt
        regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/test/read\.cgi/(\w+)/.*';
        match := regEx.Exec(URI);
        if not match then
        begin
          // http://server.2ch.net/bbs/
          regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/(\w+)/';
          match := regEx.Exec(URI);
        end;
        if match then
        begin
          FServer := regEx.Match[1] + regEx.Match[2];
          FBoardName := regEx.Match[3];
          FIs2chUrl := true;
        end;
      end;
    end;
    btJBBS:
    begin
      // ܂BBS
      // http://server.mach.to/bbs/read.cgi?bbs=bbs&key=dat
      regEx.Expression := 'http://(\w+\.)' + regMachiServer + '/bbs/read\.(cgi|pl)\?BBS=(\w+)&KEY=(\w+)&?.*';
      match := regEx.Exec(URI);
      if match then
      begin
        FServer := regEx.Match[1] + regEx.Match[2];
        FBoardName := regEx.Match[4];
        FTopicId := regEx.Match[5];
        FIs2chUrl := true;
      end else
      begin
        regEx.Expression := 'http://' + regSitarabaServer + '/(\w+)/([0-9]+)/';
        match := regEx.Exec(URI);
        if match then
        begin
          FServer := regEx.Match[1] + '/' + regEx.Match[2];
          FBoardName := regEx.Match[3];
          FIs2chUrl := true;
        end;

        regEx.Expression := 'http://(\w+\.)' + regMachiServer + '/(\w+)/';
        match := regEx.Exec(URI);
        if match then
        begin
          FServer := regEx.Match[1] +  regEx.Match[2];
          FBoardName := regEx.Match[3];
          FIs2chUrl := true;
        end;

      end;
    end;
    btOpen2ch:
    begin
      // Open2ch
      // http://server.open2ch.net/test/read.cgi/bbs/dat/opt
      regEx.Expression := 'http://(\w+\.)' + regOpen2chServer + '/test/read\.cgi/(\w+)/(\w+)/*(.*)';
      match := regEx.Exec(URI);

      if not match then
      begin
        // http://server.open2ch.net/bbs/dat/nnn.dat
        regEx.Expression := 'http://(\w+\.)' + regOpen2chServer + '/(\w+)/dat/(\w+)\.dat';
        match := regEx.Exec(URI);
      end;

      if not match then
      begin
         // http://server.open2ch.net/sub/test/read.cgi?bbs=bbs&key=dat
         regEx.Expression := 'http://(\w+\.)' + regOpen2chServer + '/sub/test/read\.cgi\?bbs=(\w+)&key=(\w+)';
         match := regEx.Exec(URI);
      end;

      if match then
      begin
        FServer := regEx.Match[1] + regEx.Match[2];
        FBoardName := regEx.Match[3];
        FTopicId := regEx.Match[4];
        FIs2chUrl := true;
      end;

    end;
  end;
  finally
  regEx.Free;
  end;
end;

end.
