unit untBoard;

interface

uses
  Classes, 
  untTopic, untGlobal;

type
  TBoardState = (stIdling, stDownLoading, stArrivalChecking,stTimeOut);
  TBoard = class
  private
    FState: TBoardState;
  protected
    procedure WriteState(const s: TBoardState); virtual;
    procedure SyncOnReceived;
    procedure SyncOnComplete;
    procedure SyncOnError;
    property State: TBoardState read FState write WriteState;
    function ReadIsDownloading: boolean;
  public
    StatusText:  string;
		DisplayName: string;
    BoardList: TObject;
    Category:  TObject;
    TopicList: TList;
    OnReceived: TNotifyEvent;
    OnComplete: TNotifyEvent;
    OnError:    TNotifyEvent;
    ReceivedIndex: integer;
    constructor Create;
    destructor Destroy; override;
    property IsDownloading: boolean read ReadIsDownloading;
    procedure SendTopicList; virtual;
    procedure FreeAllTopic; virtual; abstract;
  end;

implementation

uses
  untBoardList;

procedure TBoard.SyncOnReceived;
begin
  OnReceived(self);
end;

procedure TBoard.SyncOnComplete;
begin
  OnComplete(self);
end;

procedure TBoard.SyncOnError;
begin
  OnError(self);
end;

procedure TBoard.WriteState(const s: TBoardState);

  procedure StateError;
  begin
    if Assigned(OnError) then
    begin
      StatusText := 'Xbhꗗ擾ɃG[';
      gSynchronizer.DoSynchronize(SyncOnError);
    end;
  end;

begin

  //^CAEg̏
  if (s = stTimeOut) then
  begin
    if Assigned(OnError) then
    begin
      StatusText := ' ڑ^CAEgłBT[odȂĂA͐ڑҋ@bȂ܂B';
      gSynchronizer.DoSynchronize(SyncOnError);
    end;
   exit;
  end;

  if (s = stDownloading) or (s = stArrivalChecking) then
  begin
    if FState = stIdling then
    begin
      FState := s;
    end else
    begin
      StateError;
    end;
  end else
  begin
    FState := s;
  end;
end;

function TBoard.ReadIsDownloading: boolean;
begin
  if State = stDownloading then
  begin
    result := true;
  end else
  begin
    result := false;
  end;
end;


procedure TBoard.SendTopicList;
begin
  State := stDownLoading;
  ReceivedIndex := 0;  
end;

constructor TBoard.Create;
begin
  TopicList := TList.Create;
end;

destructor TBoard.Destroy;
begin
  TopicList.Free;

  inherited;
end;

end.
