unit untBoard2ch;

interface

uses
  untOnlineBoard, IdComponent, untTopic, untTopicBrowser,
  untTool;

type
  TBoard2ch = class(TOnlineBoard)
  private
    FLastModified: string;
    FServerMoved: boolean;
  protected
    procedure HttpReceived(Sender: TObject); override;
  public
    procedure SendTopicList; override;
    function HasTopicListChange: boolean;
  end;

implementation

uses
  untTopic2ch, untGlobal, untBoard, untHttp, untConfig;

function TBoard2ch.HasTopicListChange: boolean;
begin
  if FLastModified = '' then
  begin
    result := true;
    exit;
  end;
  State := stArrivalChecking;
  FHttp := TAsyncHttp.Create;

  FHttp.UserAgent := gConfig.UserAgent + '/' + GetVersionStr;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  FHttp.OnStatus := HttpStatusChange;
  FHttp.URL := SubjectURL;
  gConfig.InitReadProxy(FHttp);
  FHttp.Head;
  result := false;
  if FHttp.LastModified <> FLastModified then
  begin
    result := true;
  end;
  FHttp.Free;
  State := stIdling;
end;

procedure TBoard2ch.SendTopicList;
var
  intSubPos: integer;
  strURL: string;
begin
  inherited;

  //ItC\p
  if (gConfig.Offline = false) then
  begin

  FHttp.UseGzip := true;
  FHttp.OnReceived := HttpReceived;

  //T[oړ]op
  //V[uCxg΂̃tOfalseɂȂ
  FServerMoved := true;

  try
    FHttp.Get;
  except
    ;
  end;

    //^CAEgResponseCode-1
    if (FHttp.ResponseCode = -1) then
    begin
      State := stTimeOut;
      exit;
    end;

  //̈ړ]Iɒ߂̏

  if (FServerMoved) or (FHttp.ResponseCode = 302) then
  begin
   strURL := FHttp.URL;
   intSubPos := Pos('/subject.txt',strURL);
   FHttp.URL := copy(strURL,0,intSubPos);
   FHttp.LastModified := '';

   //܂ړ]m邽߂Get
   try
     FHttp.Get;
   except
     ;
   end;

   //x͈ړ]Subject𓾂邽߂Get
   FHttp.URL := SubjectURL;

   try
     Fhttp.Get;
   except
    ;
   end;

   //FLastModified := '';
   State := stIdling;
  end;
   FLastModified := FHttp.LastModified;
  end;

  inherited SendTopicListComplete;

end;

procedure TBoard2ch.HttpReceived(Sender: TObject);
var
  line: string;
  strItenMessage: string;
begin

  //̃X݂Ƃ͈ړ]ƌȂ

  //ړ]̂ƂAPcXbh̃^Cg
  strItenMessage := 'y24hŔ[izBIG  BIG ȁAT[o[pӂ܂ y2get֎~z (1)';

  if (FHttp.ReceivedLines.Count = 1) then
  begin
     line := FHttp.ReceivedLines[0];
      if Pos(strItenMessage,line) <> 0 then
      begin
        //PdatMƂNA
        FHttp.ReceivedLines.Clear;
        exit;
      end;
  end;

  //XbhꗗMł̂ŃT[oړ]͂ĂȂƌȂ
  FServerMoved := false;

  inherited HttpReceivedProc('^(.+?)\.dat<>(.*)\s?\((.+?)\)$');
end;

end.
