unit untBoardList;

interface

uses
  Classes, IdComponent, Contnrs,
  untOnlineBoard, untHttp, untMyFolder, untLostBoard;

type
  TBoardList = class
  private
    FCategoryCache: TObjectList;
  protected
    FServer: string;
    procedure SetCategoryColor;
    function ReadMyFolder: TMyFolder;
    function ReadLostBoard: TLostBoard;
  public
    Categorys: TList;
    constructor Create;
    destructor  Destroy; override;
    property MyFolder: TMyFolder read ReadMyFolder;
    property LostBoard: TLostBoard read ReadLostBoard;
    function GetBoard(const Server, BoardName: string): TOnlineBoard;
    function GetRealNameForTopicPath(AliasName: string): string;
    procedure GC;
    procedure Init;
    procedure Save;
    procedure UpdateBoard(const BoardListHtml: string);
    procedure CloseAll;
    procedure OpenAll;
  end;

implementation

uses
  SysUtils, Graphics, Windows, untRegExpr, StrUtils,
  untTool,  untGlobal, untBoardCategory,
  untFavoriteBoard, untBoard, unt2chUrlParser;

{ TBoardList }

//  \bh 


procedure TBoardList.OpenAll;
var
  i: integer;

begin
  for i := 0 to Categorys.Count - 1 do
  begin
    TBoardCategory(Categorys[i]).Opened := true;
  end;
end;

procedure TBoardList.CloseAll;
var
  i: integer;

begin
  for i := 0 to Categorys.Count - 1 do
  begin
    TBoardCategory(Categorys[i]).Opened := false;
  end;
end;

procedure TBoardList.GC;
var
  i, j: integer;
  c: TBoardCategory;

begin
  for i := 1 to FCategoryCache.Count - 1 do
  begin
    c := (FCategoryCache[i] as TBoardCategory);
    for j := 0 to c.Boards.Count - 1 do
    begin
      TOnlineBoard(c.Boards[j]).GC;
    end;
  end;
end;

function TBoardList.ReadMyFolder: TMyFolder;
var
  myfo: TMyFolder;
begin

   try
       myfo := (FCategoryCache[0] as TMyFolder);
   except on e: Exception do
       myfo := nil;
   end;

   result := myfo;
end;

function TBoardList.ReadLostBoard: TLostBoard;
begin
  result := (FCategoryCache[1] as TLostBoard);
end;

procedure TBoardList.Init;
var
  boardFile: TStringList;
  boardItems: TStringArray;
  i, rs:  integer;
  c: TBoardCategory;
  myFolder: TMyFolder;
  lostBoard: TLostBoard;
  sr: TSearchRec;
  favBoard: TBoard;

  otherboardFile: TStringList;
begin
  SetLength(boardItems, 0);
  c := nil;

  // {[ht@Cǂݍ
  boardFile := TStringList.Create;
  otherboardFile := TStringList.Create;

  try

  if FileExists(AppPath('2channel.brd')) then
  begin
    boardFile.LoadFromFile(AppPath('2channel.brd'));
  end;

  for i := 0 to boardFile.Count - 1 do
  begin
    boardItems := Split(boardFile[i], #9, 4);
    if (boardItems[0] <> '') then
    begin
      // JeStB[h
      c := TBoardCategory.Create(self);
      c.CategoryName := boardItems[0];
      FCategoryCache.Add(c);
      Categorys.Add(c);

      if (boardItems[1] <> '0') and not gConfig.BoardListOneCategory then
      begin
        c.Opened := true;
      end;
    end else
    begin
      // tB[h
      c.AddBoard(boardItems[1], boardItems[2], boardItems[3]);
    end;
  end;

  //20140308 
  //other.brdt@Cǂݍ
  if (boardFile.Count > 0) and FileExists(AppPath('other.brd')) then
  begin
    otherboardFile.LoadFromFile(AppPath('other.brd'));

    for i := 0 to otherboardFile.Count - 1 do
    begin
      otherboardFile[i] := #9 + otherboardFile[i];
    end;

    otherboardFile.Insert(0, 'O' + #9 + '1');

  end;
  for i := 0 to otherboardFile.Count - 1 do
  begin
    boardItems := Split(otherboardFile[i], #9, 4);
    if (boardItems[0] <> '') then
    begin
      // JeStB[h
      c := TBoardCategory.Create(self);
      c.CategoryName := boardItems[0];
      FCategoryCache.Add(c);
      Categorys.Add(c);

      if (boardItems[1] <> '0') and not gConfig.BoardListOneCategory then
      begin
        c.Opened := true;
      end;
    end else
    begin
      // tB[h
      c.AddBoard(boardItems[1], boardItems[2], boardItems[3]);
    end;
  end;


  finally
    boardFile.Free;
    otherboardFile.Free;
  end;

  // }CtH_{[hXg̐擪0Ԃɒu
  myFolder := TMyFolder.Create(self);
  myFolder.CategoryName := '}CtH_';
  myFolder.Opened := true;
  Categorys.Insert(0, myFolder);
  FCategoryCache.Insert(0, myFolder);

  // Cɓǂݍ
  favBoard := myFolder.AddBoard(AppPath('favorite.idx'), '}CtH_', 'Cɓ');
  myFolder.FavoriteBoard := favBoard as TFavoriteBoard;

  // Xbhqɂǂݍ
  rs := FindFirst(AppPath('*.idx'), faAnyFile, sr);
  try
    while rs = 0 do
    begin
      if (LowerCase(sr.Name) <> 'favorite.idx') and
         (LowerCase(sr.Name) <> 'favboard.idx') then
      begin
        myFolder.AddBoard(AppPath(sr.Name), '}CtH_', ChangeFileExt(sr.Name, ''));
      end;
      rs := FindNext(sr);
    end;
  finally
    SysUtils.FindClose(sr);
  end;
  myFolder.AddBoard('', '}CtH_', 'SX');

  lostBoard := TLostBoard.Create(self);
  lostBoard.CategoryName := 'q';
  FCategoryCache.Insert(1, lostBoard);
  // q͕\Ȃ
  //Categorys.Insert(1, LostBoard);

  SetCategoryColor;
end;

{ --------------------------------------------------------
  pr  : RXgN^
  l  : Ȃ
  ------------------------------------------------------ }
constructor TBoardList.Create;
begin
  inherited;

  Categorys := TList.Create;
  FCategoryCache := TObjectList.Create;
end;

{ --------------------------------------------------------
  pr  : fXgN^
  l  : Ȃ
  ------------------------------------------------------ }
destructor TBoardList.Destroy;
begin
  Categorys.Free;
  FCategoryCache.Clear;
  FCategoryCache.Free;

  inherited;
end;

function TBoardList.GetRealNameForTopicPath(AliasName: string): string;
begin
  result := AliasName;
end;

function TBoardList.GetBoard(const Server, BoardName: string): TOnlineBoard;
var
  i: integer;
  c: TBoardCategory;
  b: TOnlineBoard;

begin
  result := nil;
  for i := 1 to Categorys.Count - 1 do
  begin
    c := TBoardCategory(Categorys[i]);
    b := c.GetBoard(Server, BoardName);
    if Assigned(b) then
    begin
      result := b;
      break;
    end;
  end;
  if not Assigned(result) then
  begin
    result := LostBoard.AddBoard(Server, BoardName, 'q');
  end;
end;

// {[hXV
procedure TBoardList.UpdateBoard(const BoardListHtml: string);
var
  regEx, regExLink: TRegExpr;
  match, linkMatch: boolean;
  url, server, boardName, displayName, categoryName: string;
  i, j: integer;
  offlineBoard: TFavoriteBoard;
  onlineBoard:  TOnlineBoard;
  c: TBoardCategory;
  categoryList: TObjectList;
  parser: T2chUrlParser;
  strList: TStringArray;
  s: TStringList;

  otherboardFile: TStringList;
  boardItems: TStringArray;
begin

  regEx     := TRegExpr.Create;
  regExLink := TRegExpr.Create;
  categoryList := TObjectList.Create;
  parser := T2chUrlParser.Create;
  RegEx.ModifierI := true;
  regEx.Expression := '<B>(.+?)</B>';
  strList := Split(BoardListHtml, #$A);

  SetLength(boardItems, 0);
try
  for i := Low(strList) to High(strList) do
  begin
    match := regEx.Exec(strList[i]);

    //JeS𓾂
    if match then
    begin
      categoryName := regEx.Match[1];

      //
      //20140310 ̃TCgǉ
      if (categoryName = 'ʊ') or
         (categoryName = 'c[') or
         (categoryName = '`bg') or
         (categoryName = '̃TCg') then
        categoryName := '';

    end
    //ڍ׏𓾂
    else if (categoryName <> '') then
    begin
      regExLink.Expression := '<A HREF=(http://.+?)( TARGET=_blank)?>([^<>]+?)</A>';
      linkMatch := regExLink.Exec(strList[i]);
      if linkMatch then
      begin
        s := TStringList.Create;
        s.Add(categoryName);

        url := regExLink.Match[1];
        parser.Parse(url);
        if parser.Is2chUrl then
        begin
          s.Add(parser.Server);
          s.Add(parser.BoardName);
          s.Add(regExLink.Match[3]);
          s.Add(url);
        end;
        categoryList.Add(s);
      end;
    end;
  end;
  regExLink.Free;
  parser.Free;

  regEx.ModifierI := true;
  regEx.Expression := 'http://.+/';

  Categorys.Clear;
  //20140310 }CtH_擪ɒǉ
  Categorys.Add(MyFolder);

  c := nil;

  for i := 0 to categoryList.Count - 1 do
  begin
    // łɂJeS[
    s := (categoryList[i] as TStringList);
    if categoryName <> s[0] then
    begin
      categoryName := s[0];
      c := nil;
      for j := 1 to FCategoryCache.Count - 1 do
      begin
        if TBoardCategory(FCategoryCache[j]).CategoryName = categoryName then
        begin
          c := TBoardCategory(FCategoryCache[j]);
          break;
        end;
      end;
      if c = nil then
      begin
        c := TBoardCategory.Create(self);
        c.CategoryName := categoryName;
        c.Opened := true;
        FCategoryCache.Add(c);
      end;
      c.Boards.Clear;
      Categorys.Add(c);
    end;

    if Assigned(c) then
    begin
      if s.Count = 1 then
      begin
        continue;
      end;
      server      := s[1];
      boardName   := s[2];
      displayName := s[3];
      url         := s[4];

      onlineBoard := c.GetBoard(server, boardName);
      if Assigned(onlineBoard) then
      begin
        // ̎IύX
        if onlineBoard.Server <> server then
        begin
          // GCAX̒ǉ
          gFolderAlias.AddAlias(boardName, displayName, onlineBoard.Server);
          gFolderAlias.AddAlias(boardName, displayName, server);

          // qɂۑ
          for j := 0 to MyFolder.Boards.Count - 1 do
          begin
            if TBoard(MyFolder.Boards[j]) is TFavoriteBoard then
            begin
              offlineBoard := TFavoriteBoard(MyFolder.Boards[j]);
              offlineBoard.Save;
            end;
          end;
        end;
        onlineBoard.Server := server;
        onlineboard.DisplayName := displayName;
        if regEx.Exec(url) then
        begin
          url := url + 'subject.txt'
        end;
        onlineBoard.SubjectURL := url;
        c.Boards.Add(onlineBoard);
      end else
      begin
        // Ȃǉ
        c.AddBoard(server, boardName, displayName);
      end;
    end;
  end;


  //20140310 O̓{[hꗗɂ邩ǂ͊֌WȂǉ
  //T[oURL̕ύXɂ͑ΉłȂ other.brd̒`̂܂
  otherboardFile := TStringList.Create;

  //f[^t@CȂ
  if FileExists(AppPath('other.brd')) then
  begin

     //Oǉ
     c := nil;
     c := TBoardCategory.Create(self);
     c.CategoryName := 'O';
     c.Opened := true;

     otherboardFile.LoadFromFile(AppPath('other.brd'));

     for i := 0 to otherboardFile.Count - 1 do
     begin
       boardItems := Split(otherboardFile[i], #9, 3);
       c.AddBoard(boardItems[0], boardItems[1], boardItems[2]);
     end;

     Categorys.Add(c);
  end;

 except
     on e: Exception do
     begin
       //G[N^XNLZ
        gTaskmanager.Cancel;
     end;
 end;

  regEx.Free;

  categoryList.Clear;
  categoryList.Free;

  //20140310 ł̓}CtH_ǉȂ
  //Categorys.Insert(0, MyFolder);

  // q͕\Ȃ
  //Categorys.Insert(1, LostBoard);

  SetCategoryColor;

  // ۑ
  Save;
  gFolderAlias.Save;
end;

// {[hXgۑ
procedure TBoardList.Save;
var
  boardFile: TStringList;
  i, j: integer;
  category: TBoardCategory;
  opened: string;
  board: TOnlineBoard;

begin
  boardFile := TStringList.Create;

  //OX^[g
  //for i := 1 to Categorys.Count - 1 do
  for i := 0 to Categorys.Count - 1 do
  begin
    category := TBoardCategory(Categorys[i]);

    //20141310 }CtH_2chboard.brdɕۑȂ
    if (category.CategoryName = '}CtH_') then continue;
    
    //20141308 O2chboard.brdɕۑȂ
    if (category.CategoryName = 'O') then continue;

    opened := '0';
    if (category.Opened) then opened := '1';
    boardFile.Add(category.CategoryName + #9 + opened);

    for j := 0 to category.Boards.Count - 1 do
    begin
      board := TOnlineBoard(category.Boards[j]);
      boardFile.Add(#9 + board.Server +
                    #9 + board.BoardName +
                    #9 + board.DisplayName);
    end;
  end;

  boardFile.SaveToFile(AppPath('2channel.brd'));
  boardFile.Free;
end;

procedure TBoardList.SetCategoryColor;
var
  i: integer;
  category: TBoardCategory;
  colorCycle: integer;
  color: TColor;

begin
  ColorCycle := 0;

  for i := 0 to Categorys.Count - 1 do
  begin
    category := TBoardCategory(Categorys[i]);

    // F
    Inc(ColorCycle);
    if ColorCycle > 33 then
    begin
      ColorCycle := 1;
    end;

    case ColorCycle of
      1:  Color := Rgb( 255, 255, 255 );
      2:  Color := Rgb( 152,  90,  98 );
      3:  Color := Rgb( 221, 255, 221 );
      4:  Color := Rgb( 255, 215, 255 );
      5:  Color := Rgb(  81, 157, 176 );
      6:  Color := Rgb( 215, 215, 255 );
      7:  Color := Rgb(   0, 128, 128 );
      8:  Color := Rgb( 255,   0,   0 );
      9:  Color := Rgb( 186, 160,  71 );
      10: Color := Rgb( 255, 134, 134 );
      11: Color := Rgb( 194, 177, 186 );
      12: Color := Rgb( 139,  63, 120 );
      13: Color := Rgb( 169, 186,  50 );
      14: Color := Rgb( 160, 150, 222 );
      15: Color := Rgb( 211, 196, 141 );
      16: Color := Rgb( 255,   0, 255 );
      17: Color := Rgb( 255, 255,   0 );
      18: Color := Rgb( 143, 140, 145 );
      19: Color := Rgb( 255, 162, 255 );
      20: Color := Rgb(   0,   0, 255 );
      21: Color := Rgb( 208,  34, 196 );
      22: Color := Rgb( 179, 255, 179 );
      23: Color := Rgb(  55, 230, 217 );
      24: Color := Rgb( 149, 149, 255 );
      25: Color := Rgb(  91,  48, 194 );
      26: Color := Rgb( 200, 241, 255 );
      27: Color := Rgb(   0, 255,   0 );
      28: Color := Rgb( 40,  202, 255 );
      29: Color := Rgb( 255, 255, 210 );
      30: Color := Rgb( 255, 208, 208 );
      31: Color := Rgb(   0, 140, 187 );
      32: Color := Rgb( 234, 138, 172 );
      else Color := Rgb(   0,   0,   0 );
    end;
    category.Color := Color;
  end;
end;


end.
