unit untCrypt;

interface

uses
  Classes, untTool,
  untCryptAuto, untBase64;

function Crypt(PlainText : string) : string;
function Decrypt(Crypted : string) : string;

implementation

function Crypt(PlainText : string) : string;
var
  Crypt : THogeCryptAuto;
  inputStream, outputStream: TStringStream;
begin

  if PlainText <> '' then
  begin
    inputStream  := TStringStream.Create(PlainText);
    outputStream := TStringStream.Create('');
    Crypt := THogeCryptAuto.Create;

    Crypt.Encrypt(inputStream, GetPCName, outputStream);
    result := HogeBase64Encode(outputStream.DataString);
  end else
    result := '';

end;

function Decrypt(Crypted : string) : string;
var
  Crypt : THogeCryptAuto;
  inputStream, outputStream: TStringStream;
begin

  if Crypted <> '' then
  begin
    inputStream  := TStringStream.Create(HogeBase64Decode(Crypted));
    outputStream := TStringStream.Create('');
    Crypt := THogeCryptAuto.Create;

    Crypt.Decrypt(inputStream, GetPCName, outputStream);
    result := outputStream.DataString;
  end else
    result := '';

end;


end.
