unit untFavoriteBoard;

interface

uses
  Classes,
  untBoard, untTopic;

type
  TFavoriteBoard = class(TBoard)
  private
    FIdxPath: string;
    FLoadedLog: Boolean;
    procedure BackupToFile(PathName: string);
  protected
    procedure LoadIdx;
    procedure SaveToLog;
  public
    OnStateChange: TNotifyEvent;
    constructor Create(const idxPath: string);
    procedure SendTopicList; override;
    procedure AppendTopic(Topic: TTopic); virtual;
    procedure RemoveTopic(Topic: TTopic); virtual;
    procedure Save; virtual;
    procedure Patrol(Sender: TObject);
    function  IsHave(Topic: TTopic) : boolean;
    procedure Sort(Compare: TListSortCompare);
    procedure FreeAllTopic; override;
  end;

implementation

uses
  untRegExpr, SysUtils,
  untOnlineBoard, untBoardList, untBoardCategory, untMainForm,
  untGlobal, untTaskManager;

procedure TFavoriteBoard.FreeAllTopic;
begin
  // gsbN̉̓IC{[hs
end;

constructor TFavoriteBoard.Create(const idxPath: string);
begin
  inherited Create;

  FIdxPath := idxPath;
end;

procedure TFavoriteBoard.SendTopicList;
begin
  inherited;

  FLoadedLog := false;
  TopicList.Clear;
  LoadIdx;
  if Assigned(OnReceived) then
  begin
    gSynchronizer.DoSynchronize(SyncOnReceived);
  end;
  if Assigned(OnComplete) then
  begin
    gSynchronizer.DoSynchronize(SyncOnComplete);
  end;
  State := stIdling;
end;
//
// XbhqɂɃXǉ
//
procedure TFavoriteBoard.AppendTopic(Topic: TTopic);
begin
//LoadIdx;

  TopicList.Insert(0, Topic);
  Include(Topic.Status, tsInBox);
  Topic.SaveIdx;
  SaveToLog;
end;

procedure TFavoriteBoard.RemoveTopic(Topic: TTopic);
begin
//LoadIdx;

  TopicList.Remove(Topic);
  SaveToLog;
end;
//
// 
//
procedure TFavoriteBoard.Patrol(Sender: TObject);
var
  i: Integer;
  topic: TTopic;

begin
// MainForm.Around:=True;  // 񒆃tOI

  for i := 0 to TopicList.Count - 1 do
  begin
    topic := TTopic(TopicList[i]);
//  if topic.NewMessageCount <= 0 then   // 2008.06.20
    begin
      topic.DoNotify := true;
      topic.OnStateChange := OnStateChange;
      topic.OnReceived := nil;
      topic.OnComplete := OnComplete;
      gTaskManager.Request(Topic, nil, reqtDownload);
    end;
  end;

//MainForm.Around:=False;
end;
//
//
//
procedure TFavoriteBoard.LoadIdx;
var
  stlLog: TStringList;
  topic: TTopic;
  i: Integer;
  regex: TRegExpr;
  server, boardName, topicId: string;
  board: TOnlineBoard;

begin
  regex := TRegExpr.Create;
  try
    regex.Expression := '^(.+?)\\(.+?)\\(.+?)\.idx';

    if FLoadedLog = false then
    begin
      if FileExists(FIdxPath) then
      begin
        stlLog := TStringList.Create;
        stlLog.LoadFromFile(FIdxPath);

        // gsbN̓ǂݍ
        for i := 0 to stlLog.Count - 1 do
        begin
          if (stlLog[i] <> '') and (Regex.Exec(stlLog[i])) then
          begin
            server    := Regex.Match[1];
            boardName := Regex.Match[2];
            topicId   := Regex.Match[3];

            board := (BoardList as TBoardList).GetBoard(server, boardName);
            topic := board.GetTopic(topicId);
            Include(topic.Status, tsInBox);

            if(board.DisplayName='q') then			// 2009.04.23 q̓G[
            begin
              Include(topic.Status,tsError);
            end;

            topic.Index := i + 1;
            topic.OnlineBoard := board;
            TopicList.Add(topic);
          end;
        end;
        stlLog.Free;
      end;
      FLoadedLog := true;
    end;
  finally
    regex.Free;
  end;
end;

procedure TFavoriteBoard.Save;
begin
  if TopicList.Count = 0 then
  begin
    exit;
  end;
  SaveToLog;
end;

procedure TFavoriteBoard.SaveToLog;
var
  i: Integer;
  topic: TTopic;
  stlSave: TStringList;
  board: TOnlineBoard;

begin
  stlSave := TStringList.Create;
  try
    for i := 0 to TopicList.Count - 1 do
    begin
      topic := TTopic(TopicList[i]);
      board := topic.OnlineBoard as TOnlineBoard;
      stlSave.Add(board.Server + '\' + board.BoardName + '\' + topic.TopicId + '.idx');
    end;
    BackupToFile(FIdxPath);			// 2008.05.12
    stlSave.SaveToFile(FIdxPath);
  finally
    stlSave.Free;
  end;
end;
//
// 
//
function TFavoriteBoard.IsHave(Topic: TTopic): boolean;
begin
  LoadIdx;	// 2008.06.24

  if TopicList.IndexOf(Topic) > -1 then
  begin
    result := true
  end else
  begin
    result := false;
  end;
end;

procedure TFavoriteBoard.Sort(Compare: TListSortCompare);
begin
  TopicList.Sort(Compare);
end;
// 
// ėpobNAbv
// 
procedure TFavoriteBoard.BackupToFile(PathName: string);
var
	i: Integer;
	str: string;
	OldPathName: string;
	NewPathName: string;
	Ext: string;
	num: Integer;

begin
	if gConfig.BackupIdx = True then
	begin
		Ext     :=LowerCase(ExtractFileExt(PathName));	// gq(.idx)
		if Ext='.idx' then
		begin
			num:=gConfig.BackupIdxNum-1;
			for i:=num downto 1 do
			begin
				str:=IntToStr(i-1);
				OldPathName:=PathName;
				OldPathName[Length(OldPathName)]:=str[1];
				if (FileExists(OldPathName)=True) then
				begin
					str:=IntToStr(i+0);
					NewPathName:=PathName;
					NewPathName[Length(NewPathName)]:=str[1];
					if (FileExists(NewPathName)=True) then
					begin
						DeleteFile(NewPathName);
					end;
					RenameFile(OldPathName,NewPathName);
				end;
			end;
	
			NewPathName:=PathName;
			NewPathName[Length(NewPathName)]:='0';
			OldPathName:=PathName;
			RenameFile(OldPathName,NewPathName);
		end;
	end;
end;
//
//
//

end.
