unit untHintWindow;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TToolTip = class(THintWindow)
  private
    { Private 錾 }
    FHintText : string;
  public
    { Public 錾 }
    property    HintText : string read FHintText;
    procedure   SetHint(HintText : string);
    procedure   UnVisible();
    constructor Create(AOwner: TComponent); override;
  end;

var
  ToolTip: TToolTip;

implementation


constructor TToolTip.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  self.Color := clWhite;
end;

procedure TToolTip.SetHint(HintText: string);
var
  Rect     : TRect;
  MousePos : TPoint;
begin

  Rect := self.CalcHintRect(600, HintText, nil);
  GetCursorPos(MousePos);
  Rect.Right  := MousePos.X + Rect.Right;
  Rect.Left   := MousePos.X;
  Rect.Top    := MousePos.Y - Rect.Bottom - 3;
  Rect.Bottom := MousePos.Y - 3; 

  FHintText := HintText;
  self.ActivateHint(Rect, HintText);

end;

procedure TToolTip.UnVisible;
begin
  FHintText := '';
  self.ReleaseHandle;
end;

initialization

  ToolTip := TToolTip.Create(nil);

finalization

  ToolTip.Free;


end.
 