unit untMakeNewThread;

 //XĐpXbh

interface

uses
  SysUtils, Classes, Contnrs, SyncObjs,
  untRegExpr, IdHttp, IdComponent,
  untStreamTool, untGlobal, untHttp,
  Dialogs, untDzURL, untTool,IdCookieManager,
  untBoard, untOnlineBoard, untMakeNewThreadB;

type
  TMakeNewThread = class(TThread)
  private
    FBoard: TOnlineBoard;
    FTitle:       string;
    FMakeNew:     TMakeNew;
    FPostName:    string;
    FPostEmail:   string;
    FPostBody:    string;
    FErrorString: string;
    FErrorCode: TFrameworkErrorType;
  protected
    FPostHttp: TIdHttp;
    procedure SyncOnStatus;
    procedure SyncOnComplete;
    procedure RaiseBBSError;
    procedure BBS_Complete(Sender : TObject);
    procedure BBS_Error(Sender: TObject;
                        const ErrorCode: TFrameworkErrorType;
                        const ErrorString: string);
    procedure BBS_StatusChange(Sender: TObject);
  public
    OnComplete: TNotifyEvent;
    OnStatusChange: TNotifyEvent;
    OnError: TFrameworkError;
    procedure   Execute; override;
    constructor Create(OnlineBoard: TOnlineBoard;
                       const Title,
                             PostName,
                             PostEmail,
                             PostBody: string);
  end;

implementation

{ TMakeNewThread }

constructor TMakeNewThread.Create(OnlineBoard: TOnlineBoard;
                                       const Title,
                                          PostName,
                                          PostEmail,
                                          PostBody: string);
begin
  inherited Create(true);

  FBoard    := OnlineBoard;
  FPostName  := PostName;
  FPostEmail := PostEmail;
  FPostBody  := PostBody;
  FTitle     := Title;

  //XPOSTp
  FMakeNew := TMakeNew.Create(OnlineBoard);

end;

procedure TMakeNewThread.Execute;
begin

  // 
  try
    FMakeNew.Post(FTitle, FPostName, FPostEmail, FPostBody);
  except on e: Exception do
    Showmessage(e.Message);
  end;
  Terminate;
end;

procedure TMakeNewThread.BBS_Complete(Sender: TObject);
begin
  if Assigned(OnComplete) then
  begin
    Synchronize(SyncOnComplete);
  end;
end;

procedure TMakeNewThread.SyncOnComplete;
begin
  OnComplete(self);
end;

procedure TMakeNewThread.SyncOnStatus;
begin
  OnStatusChange(self);
end;

procedure TMakeNewThread.BBS_StatusChange(Sender: TObject);
begin
  if Assigned(OnStatusChange) then
  begin
    Synchronize(SyncOnStatus);
  end;
end;

procedure TMakeNewThread.BBS_Error(Sender: TObject;
                                     const ErrorCode: TFrameworkErrorType;
                                     const ErrorString: string);
begin
  FErrorString := ErrorString;
  FErrorCode   := ErrorCode;
  Synchronize(RaiseBBSError);
end;

procedure TMakeNewThread.RaiseBBSError;
begin
  if Assigned(OnError) then
  begin
    OnError(self, FErrorCode, FErrorString);
  end;
end;


end.
