unit untMakeNewThreadB;

   //XĐpuntMakeNewThreadĂ΂qNXB
   //Post΂̂
   //̂͏Ă

interface

uses
  IdComponent, untGlobal, Forms,
  untTopic, untOnlineBoard,
  SysUtils, Classes, Contnrs, SyncObjs,
  untRegExpr,
  untStreamTool, untHttp, IdHttp,
  IniFiles, IdCookie;


type
  TTopicStatusSet = set of (tsError, tsFreezed, tsGotLog, tsRetryed,
                            tsFavorite, tsInBox, tsPosting, tsOpened);

  TTopicState = (dsNone, dsStarting, dsDatLoaded, dsComplete);

  TMakeNew = class
  private
    FErrorCode: TFrameworkErrorType;
    FState: TTopicState;
  protected
    FHttp: TAsyncHttp;
    FPostHttp: TIdHttp;
    procedure HttpComplete;
    procedure HttpStatusChange(axSender: TObject;
                               const axStatus: TIdStatus;
                               const asStatusText: string);

    procedure ChangeStatusText(const NewText: string);
    procedure WriteState(const s: TTopicState);
    procedure SyncOnComplete;
    procedure SyncOnReceived;
    procedure SyncOnStateChange;
    procedure RaiseError(const ErrorCode: TFrameworkErrorType); overload;
    procedure RaiseError(ErrorCode: TFrameworkErrorType;
                         ErrorString: string); overload;

	procedure GetInput(response:string;lst:TStringList);
	function GetMethodValue(sip:string):string;
	function GetValue(name:string;sip:string):string;

  public
    CompleteEvent: TSimpleEvent;
    OnlineBoard: TOnlineBoard;
    ArticleList: TStringList;
    Status: TTopicStatusSet;
    DoNotify: boolean;
    GZip:     boolean;
    NoIndex:  boolean;
    TopicId:       string;
    Title:         string;
    WroteName:     string;
    WroteEmail:    string;
    LocalDir:      string;
    Memo:          string;
    WriteError:    string;
    StatusText:    string;
    LastModified:  string;
    LastReadDate:  string;
    LastWriteDate: string;
    DatUrl:        string;
    DisplayMsgCount: integer;
    MessageCount:    integer;
    Index:           integer;
    GotMessageCount: integer;
    NewMessageCount: integer;
    ScrollPosition:  integer;
    Priority:        integer;
    DatSize:         integer;
    FileSize:        integer;
    AboneNumber:     integer;
    FileDate: TDateTime;
    OnComplete: TNotifyEvent;
    OnReceived: TNotifyEvent;
    OnError: TFrameworkError;
    OnStateChange: TNotifyEvent;
    property State: TTopicState read FState write WriteState;
    property ErrorCode: TFrameworkErrorType read FErrorCode;
    constructor Create(b: TObject);
    destructor  Destroy; override;
    procedure Post(PostTitle, PostName, PostEmail, Body: string);

  end;

implementation

uses
  untTool,  IdCookieManager, jconvert,
  untDzURL,
  untConfig,
  untMainForm;

constructor TMakeNew.Create(b: TObject);
begin

  OnlineBoard := b as TOnlineBoard;

  CompleteEvent := TSimpleEvent.Create;

end;


destructor TMakeNew.Destroy;
begin
  CompleteEvent.Free;

  inherited;
end;


//VK̃X
procedure TMakeNew.Post(PostTitle, PostName, PostEmail, Body: string);
var
  postData: TStringList;
  intTime: integer;
  response, errorMsg, writeData: string;

  strCookie: string;
  strRef: string;
  intCode: integer;

  proxyhost: string;
  proxyport: integer;

  strSvr: string;
  strSr: string;
  intPos: integer;
  intLen: integer;

  strCGIURL: string;

// E@Ή
  str: string;
  SetCookie: string;

  i: integer;
  Count: integer;
  lst: TStringList;
begin

// E@Ή
    SetCookie:=LoadCookie();	  //ۑĂCookieǂݏo

    //Xe[^Xo[\p̐ݒ
    Include(Status,tsPosting);

    //T[o̎ނ̔fp
    strSvr := (OnlineBoard as TOnlineBoard).Server;
    intPos := Pos('jbbs.livedoor.jp',strSvr);

    if intPos <> 0 then
    begin
    //Ηp̐ݒ

    intLen := Length(strSvr);
    strSr := copy(strSvr,intPos + 17,intLen - intPos + 17);

    strRef := 'http://jbbs.livedoor.jp/' +
                          strSr + '/' +
                          (OnlineBoard as TOnlineBoard).BoardName +
                          '/';

    end else
    begin
    // 2chƂ܂p
    strRef := 'http://' +
              (OnlineBoard as TOnlineBoard).Server + '/' +
//            (OnlineBoard as TOnlineBoard).BoardName  + '/index2.html';
              'test/bbs.cgi?guid=ON';				// 2011.04.27
    end;

    strCookie := 'Cookie: NAME=' + UrlEncode(PostName) +
                 '; MAIL=' + UrlEncode(PostEmail) +';';
    strCookie := strCookie + ' ' + SetCookie;		// E@Ή

    if (OnlineBoard as TOnlineBoard).Server = 'be.2ch.net' then
    begin

      //Oݒ肵ȂƓe錻ۂ
      if PostName = '' then
        PostName := '񁗂ςB';

      //BEւPOSTSJISEUCɕϊȂƂȂ
      PostTitle := sjis2euc(PostTitle);
      PostName := sjis2euc(PostName);
      PostEmail := sjis2euc(PostEmail);
      Body := sjis2euc(Body);
    end;

   //BEOC`FbNꂽԂȂΕKBEOC
   //T[o֑
   if (gConfig.BELogin) then
        strCookie := strCookie + ' MDMD=' + gConfig.BEMDMD + '; DMDM=' + gConfig.BEDMDM + ';';

    FPostHttp := TIdHttp.Create(nil);

//  FPostHttp.ProtocolVersion := pv1_1;
    FPostHttp.AllowCookies := False;

    FPostHttp.OnStatus := HttpStatusChange;

    FPostHttp.Request.UserAgent := gConfig.UserAgent + '/' + GetVersionStr;

    FPostHttp.Request.CustomHeaders.Add('X-2ch-UA: ' + APP_2chUA);

    // 2011.04.27
    FPostHttp.Request.Accept := 'image/gif, image/jpeg, image/pjpeg, image/pjpeg, application/x-shockwave-flash, application/vnd.ms-excel, application/msword, */*';
    FPostHttp.Request.AcceptLanguage := 'ja';
    FPostHttp.Request.Connection := 'Keep-Alive';
    FPostHttp.Request.CacheControl := 'no-cache';

  //vLVݒ
  if (gConfig.WriteProxyUse) then
  begin
     gConfig.ParseProxy(gConfig.WriteProxy, proxyhost, proxyport);
     FPostHttp.ProxyParams.ProxyServer := proxyhost;
     FPostHttp.ProxyParams.ProxyPort   := proxyport;
  end
  //20130526 vLVgȂꍇ̐ݒǉ
  else
  begin
     FPostHttp.ProxyParams.ProxyServer := '';
     FPostHttp.ProxyParams.ProxyPort   := 0;
  end;


// Cookie
  with FPostHttp do
  begin
    Request.Referer := strRef;
    HTTPOptions := [];
    ConnectTimeout := gConfig.CONNECT_TIMEOUT ;
//  CookieManager := TIdCookieManager.Create(nil);

/////////////////////////////////////
    Count:=Request.RawHeaders.Count;
    for i:=0 to Count-1 do
    begin
        str:=Request.RawHeaders.Names[i];
        if(Pos('Cookie',str) <> 0) then
        begin
           ;
        end;
    end;

    // Cookie
    str := Request.RawHeaders.Values['Cookie'];
    if(str='') then
    begin
        Request.CustomHeaders.Add(strCookie);
    end else
    begin
        Request.CustomHeaders.Values['Cookie'] := strCookie;
    end;

  end;

  //ݎԐݒɍs
  intTime := Round((Now() - EncodeDate(1970, 1, 1)) * 86400 - 32400);

  //T[oƂɑ镶ς
  if (Pos('machi.to',strSvr) <> 0) then
  //܂
  begin
    writeData := 'submit='  + UrlEncode('VK') + '&' +
               'SUBJECT=' + UrlEncode(PostTitle) + '&' +
               'NAME='    + UrlEncode(PostName) + '&' +
               'MAIL='    + UrlEncode(PostEmail) + '&' +
               'MESSAGE=' + UrlEncode(Body)+ '&' +
               'BBS='     + (OnlineBoard as TOnlineBoard).BoardName + '&' +
               'TIME='    + IntToStr(intTime);
    strCGIURL := 'http://' + (OnlineBoard as TOnlineBoard).Server +
                                 '/bbs/write.cgi';
  end else if (Pos('jbbs.livedoor.jp',strSvr) <> 0) then
  //
  begin
   writeData := 'submit='  + UrlEncode(sjis2euc('VK')) + '&' +
               'SUBJECT='    + UrlEncode(sjis2euc(PostTitle)) + '&' +
               'NAME='    + UrlEncode(sjis2euc(PostName)) + '&' +
               'MAIL='    + UrlEncode(sjis2euc(PostEmail)) + '&' +
               'MESSAGE=' + UrlEncode(sjis2euc(Body))+ '&' +
               'BBS='     + (OnlineBoard as TOnlineBoard).BoardName + '&' +
               'DIR='     + strSr + '&' +
               'TIME='    + IntToStr(intTime);
    strCGIURL := 'http://jbbs.livedoor.jp/bbs/write.cgi/' + strSr +
                          (OnlineBoard as TOnlineBoard).BoardName +
                          '/new/';
  end else
  //ȊO@*.2ch.net , *.bbspink.com Ȃ
  begin
//writeData := 'submit='  + UrlEncode('VK') + '&' +
  writeData := 'submit='  + UrlEncode('VKXbh쐬') + '&' +			// 2011.04.27
               'subject=' + UrlEncode(PostTitle) + '&' +
               'FROM='    + UrlEncode(PostName) + '&' +
               'mail='    + UrlEncode(PostEmail) + '&' +
               'MESSAGE=' + UrlEncode(Body) + '&' +
               'bbs='     + (OnlineBoard as TOnlineBoard).BoardName + '&' +
               'time='    + IntToStr(intTime-2);

   strCGIURL := 'http://' + (OnlineBoard as TOnlineBoard).Server +
                                 '/test/bbs.cgi?guid=ON';
  end;


  if gConfig.Sessionid <> '' then
  begin
    writeData := writeData + '&sid=' + UrlEncode(gConfig.Sessionid);
  end;

  postData := TStringList.Create;
  postData.Add(writeData);

  //302ԂƂ邯ǖĂ
  try
     response := FPostHttp.Post(strCGIURL,postData);
     SetCookie:=FPostHttp.Response.RawHeaders.Values['Set-Cookie']; // Cookie󂯎
     SaveCookie(SetCookie);
  except
     ;
  end;

  //T[oSJISȊOŕԓĂƂEUCɕϊ
  intCode := InCodeCheck(response);
  if intCode <> SJIS_IN then
  begin
     response := euc2sjis(response);
  end;


  // refreshołΏݐAłȂΎs
  // u݊mFvʂłx

  if (Pos('<title>dqqnqI</title>',response) <> 0) then
  begin
      ErrorMsg := CopyMiddle(response, '<b>', '</b>');
  end else
  if (Pos('refresh', response) = 0) or
     (Pos('<title> ݊mF </title>',response) <> 0) then
  begin
/////////////////////////////////////
//  str:=FPostHttp.Response.RawHeaders.Text;
//	Count:=FPostHttp.Response.RawHeaders.Count;
//  for i:=0 to Count-1 do
//  begin
//    str:=FPostHttp.Response.RawHeaders.Names[i];
//    value:=FPostHttp.Response.RawHeaders.Values[str];
//  end;

    FPostHttp.Request.CustomHeaders.Add(strCookie);			// 2011.04.27
//
//		str := FPostHttp.Request.RawHeaders.Values['Cookie'];	// Cookie
//		if(str='') then
//		begin
//		    FPostHttp.Request.CustomHeaders.Add(strCookie);
//		end else
//		begin
//	//	    FPostHttp.Request.CustomHeaders.Values['Cookie'] := strCookie;
//		    FPostHttp.Request.RawHeaders.Values['Cookie'] := strCookie;
//		end;
//
// RequestCookielƂ͊֌WȂACookieɏo͂Ă܂ƂۂB
// 1xڂPostł͖Ȃ̂ŁA2xڈȍ~̖ƎvB
// CookielĂA܂fȂB
// Add
// CookieQso͂Ă܂ƂۂɑĂ̑΍ƂďLꂽ
// Indył̖̏?Ȃ̂AK1sڂCookietĂ܂B
// 2so͂ĂAXĂɂ͐̂ŁA2so͂܂܂ɂB
//

    if (Pos('2ch.net',strSvr) <> 0) then
    begin
//    writeData := 'submit='  + UrlEncode('mFď') + '&' +			// 2011.04.27
//    writeData := 'submit='  + UrlEncode('LSĂď') + '&' +	        // 2011.10.27
//                 'subject=' + UrlEncode(PostTitle) + '&' +
//                 'FROM='    + UrlEncode(PostName) + '&' +
//                 'mail='    + UrlEncode(PostEmail) + '&' +
//                 'MESSAGE=' + UrlEncode(Body) + '&' +
//                 'bbs='     + (OnlineBoard as TOnlineBoard).BoardName + '&' +
//                 'time='    + IntToStr(intTime-2);

//    writeData := 'subject=' + UrlEncode(PostTitle) + '&' +
//                 'FROM='    + UrlEncode(PostName) + '&' +
//                 'mail='    + UrlEncode(PostEmail) + '&' +
//                 'MESSAGE=' + UrlEncode(Body) + '&' +
//                 'bbs='     + (OnlineBoard as TOnlineBoard).BoardName + '&' +
//                 'time='    + IntToStr(intTime-2) + '&' +
//                 'kibi=dango' + '&' +		// 2011.10.27
//                 'submit='  + UrlEncode('LSĂď');        // 2011.10.27
//

      lst := TStringList.Create;
      GetInput(response,lst);		// 2011.10.27 ߑłł͂Ȃresponse琶悤ɂ
      writeData :='';
      Count:=lst.Count;
      for i:=0 to Count-1 do
      begin
         if i<>0 then writeData := writeData + '&';
         if((lst.Names[i]='MESSAGE')or(lst.Names[i]='message')) then
         begin
           writeData := writeData + 'MESSAGE=' + UrlEncode(Body);
         end else
         begin
           writeData := writeData + lst.Strings[i];
         end;
      end;
      lst.Free;

      postData.Clear();
      postData.Add(writeData);
    end;

    //302ԂƂ邯ǖĂ
    try
      response := FPostHttp.Post(strCGIURL,postData);
      SetCookie:=FPostHttp.Response.RawHeaders.Values['Set-Cookie']; // Cookie󂯎
      SaveCookie(SetCookie);
    except
      ;
    end;

    //T[o̕ԓ̃GR[h
    intCode := InCodeCheck(response);
    if intCode <> SJIS_IN then
     begin
         response := euc2sjis(response);
     end;

    if Pos('refresh', response) = 0 then
    begin
      // G[
      ErrorMsg := CopyMiddle(response, '<b>', '</b>');
      if ErrorMsg = '' then
      begin
        ErrorMsg := CopyMiddle(response, '<!-- 2ch_X:error -->', '<br>');
      end;
      if ErrorMsg = '' then
      begin
       if Pos('OCG[',response) <> 0 then
          ErrorMsg := 'OCG[łB'
        else
          ErrorMsg := 'G[܂';
       end;
    end;
  end;

  postData.Free;

  if ErrorMsg <> '' then
  begin
    OnlineBoard.RaiseErrorPost(ErrorMsg);
  end else
  begin
    //ݐ`邽߂StatusBarɏo
    OnlineBoard.RaiseErrorPost('@VKX쐬܂B');

    if Assigned(OnComplete) then
    begin
      OnComplete(self);
    end;
  end;
  FPostHttp.Free;

end;


procedure TMakeNew.HttpComplete;
begin

  //XĂIƂ̏
  FHttp.Free;

  State := dsComplete;
end;


procedure TMakeNew.HttpStatusChange(axSender: TObject;
                                  const axStatus: TIdStatus;
                                  const asStatusText: string);
begin

  case axStatus of
    hsConnecting:
    begin
      ChangeStatusText((OnlineBoard as TOnlineBoard).Server + 'ɐڑ');
    end;
    hsConnected:
    begin
      Application.ProcessMessages;
      ChangeStatusText((OnlineBoard as TOnlineBoard).Server + 'ɐڑ܂');
    end;
  end;
end;


procedure TMakeNew.ChangeStatusText(const NewText: string);
begin
  StatusText := NewText;
  if Assigned(OnStateChange) and DoNotify then
  begin
    gSynchronizer.DoSynchronize(SyncOnStateChange);
  end;
end;


procedure TMakeNew.SyncOnReceived;
begin
  OnReceived(self);
end;

procedure TMakeNew.SyncOnStateChange;
begin
  OnStateChange(self);
end;

procedure TMakeNew.SyncOnComplete;
begin
  OnComplete(self);
end;


procedure TMakeNew.WriteState(const s: TTopicState);
begin
  FState := s;
  case s of
    dsStarting:
    begin
      StatusText := '';
      Exclude(Status, tsFreezed);
    end;
  end;
end;

procedure TMakeNew.RaiseError(const ErrorCode: TFrameworkErrorType);
begin
  FErrorCode := ErrorCode;
  Include(Status, tsError);
  case ErrorCode of
    etAbone:
    begin
      StatusText := '폜ځ[ŃOl܂悤ł';
    end;
    etParse:
    begin
      StatusText := '̓G[';
    end;
    etDatFreezed:
    begin
      StatusText := 'DAT܂';
      Include(Status, tsFreezed);
    end;
    etBrokenGZip:
    begin
      StatusText := 'gzipG[';
    end;
    etSocketError:
    begin
      StatusText := 'ڑɎs܂';
    end;
  end;
end;

procedure TMakeNew.RaiseError(ErrorCode: TFrameworkErrorType;
                            ErrorString: string);
begin
  if Assigned(OnError) then
  begin
    OnError(self, ErrorCode, ErrorString);
  end;
end;





procedure TMakeNew.GetInput(response:string;lst:TStringList);
var
  s: string;
  sip: string;		// input string

  i: integer;
  j: integer;
  n: integer;
begin
	i:=AnsiPos('<form',response);
	j:=AnsiPos('</form>',response);
	if((i<>0)and(j<>0)) then
	begin
		s:=Copy(response,i,j-i+7);
		for n:=0 to 16 do
		begin
			i:=AnsiPos('<input ',s);
			if i<>0 then
			begin
				s:=Copy(s,i,Length(s)-i+1);
				j:=AnsiPos('>',s);
				sip:=Copy(s,1,j);			// <input
				s:=Copy(s,j+1,Length(s)-j+1);
			//	if n<>0 then result:=result+'&';
			//	result:=result+GetMethodValue(sip);
				lst.Add(GetMethodValue(sip));
			end else
			begin
				break;
			end;
			
		end;
	end;
end;

function TMakeNew.GetMethodValue(sip:string):string;
var
  method : string;
  value : string;
begin
	result:='';
	method:=GetValue('name=',sip);
	value:=GetValue('value=',sip);
	result:=method+'='+UrlEncode(value);
end;


function TMakeNew.GetValue(name:string;sip:string):string;
var
  lname : string;
  lsip : string;
//		<input type=hidden name="kibi" value="dango"><br>
  i: integer;
  j: integer;
  n: integer;
begin
	lname:=LowerCase(name);
	lsip:=LowerCase(sip);
	i:=AnsiPos(lname,lsip);
	if i<>0  then
	begin
		result:='';
		n:=Length(name);
		if(sip[i+n]='"') then i:=i+1;
		for j:=i+n to length(sip) do
		begin
			if((sip[j]<>'"')and(sip[j]<>' ')and(sip[j]<>'>')) then
			begin
				result:=result+sip[j];
			end else
			begin
				break;
			end;
		end;
	end;
end;

end.
