unit untMyFolder;

interface

uses
  untBoardCategory, untAllSubscribedTopics,
  untFavoriteBoard, untBoard;

type
  TMyFolder = class(TBoardCategory)
  protected
  public
    AllSubscribedTopics: TAllSubscribedTopics;
    FavoriteBoard: TFavoriteBoard;
    function AddBoard(const FavidxPath, Category, DisplayName: string): TBoard;
  end;

implementation

function TMyFolder.AddBoard(const FavidxPath, Category, DisplayName: string): TBoard;
var
  b: TBoard;

begin
  if DisplayName = 'SX' then
  begin
    b := TAllSubscribedTopics.Create;
    FBoardCache.Add(b);
    Boards.Add(b);
    AllSubscribedTopics := b as TAllSubscribedTopics;
  end else
  begin
    b := TFavoriteBoard.Create(FavidxPath);
    if Boards.Count = 0 then
    begin
      FBoardCache.Add(b);
      Boards.Add(b);
    end else
    begin
      FBoardCache.Insert(1, b);
      Boards.Insert(1, b);
    end;
  end;
  b.Category    := self;
  b.BoardList   := FBoardList;
  b.DisplayName := DisplayName;
  result := b;
end;

end.
