unit untOnlineBoard;

interface

uses
  Classes, IdComponent, Contnrs,
  untBoard, untHttp, untTopic, jconvert,
  IdHttp, IdCookieManager,untDzURL;

type
  TOnlineBoard = class(TBoard)
  private
    FTopicErase: TList;
  protected

    FHttp: TAsyncHttp;
    FTopicCache: TObjectList;
    FServer: string;
    function GetBoardUrl: string;
    procedure LoadIdx(strPath: string; strServer: string; strBoard: string);
    procedure ListFiles
          (dirName: String;{fBNgtpX}
           attr: Word;
          {t@C̑,SĂȂfaAnyfile(attr͊܂܂Ȃ)}
           addnoattr: boolean;{True:Ȃt@C}{C}
           clrFlag: boolean;{True:VK@false: }
           theList: TStringList;{ꗗi[TStringList}
           gosubdir: boolean;{True:TufBNg}
           addYen: boolean);{True:fBNgȂ_}
    procedure SyncOnStatus;
    procedure HttpReceivedProc(const regPattern: string);
    procedure RaiseError(ErrorString: string);
    procedure SetServer(const serverName: string);
    procedure HttpReceived(Sender: TObject); virtual; abstract;
    procedure HttpStatusChange(axSender: TObject;
                               const axStatus: TIdStatus;
                               const asStatusText: string); virtual;
    procedure SendTopicListComplete; virtual;
  public
    BoardName:  string;
    WriteError: string;
    SubjectURL: string;
    ModTime: Integer;
    OnStateChange: TNotifyEvent;
    property BoardUrl: string read GetBoardUrl;
    property Server:   string read FServer write SetServer;
    constructor Create;
    destructor Destroy; override;
    procedure FreeAllTopic; override;
    procedure FreeTopic(Topic: TTopic);
    procedure GC; virtual;
    procedure SendTopicList; override;
    procedure CancelDownload;
    procedure RaiseErrorPost(ErrorString: string);
    function MakeTopic(const Title,
                              PostName,
                              PostEmail,
                              PostBody: string): TThread; virtual;
    function PostArticle(Topic: TTopic; const PostName,
                                              PostEmail,
                                              PostBody: string): TThread; virtual;
    function GetTopic(const TopicId: string): TTopic; virtual;
    procedure UpdateTopic(const TopicId: string); virtual;		// 2009.07.15
  end;

implementation

uses
  SysUtils, untRegExpr,
  untTool, untTopicBrowser, untConfig, untTopicPostThread,untMakeNewThread,
  untTopic2ch, untTopicJBBS, untBoard2ch, untBoardJBBS, untGlobal,
  untBoardList;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TOnlineBoard.SyncOnStatus;
begin
  OnStateChange(self);
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TOnlineBoard.CancelDownload;
begin
  if State <> stIdling then
  begin
    //FHttpŃLZĂȂH
    //FHttp.Terminae;
  end;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
function TOnlineBoard.PostArticle(Topic: TTopic; const PostName, PostEmail, PostBody: string): TThread;
var
  postThread: TTopicPostThread;

begin
  // epXbh𗧂グ
  postThread := TTopicPostThread.Create(self,
                                        Topic,
                                        '',
                                        PostName,
                                        PostEmail,
                                        PostBody);
  postThread.Priority := tpLower;
  postThread.FreeOnTerminate := true;
  result := postThread;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
function TOnlineBoard.MakeTopic(const Title,
                                       PostName,
                                       PostEmail,
                                       PostBody: string): TThread;
var
  makeNewThread: TMakeNewThread;

begin
  //XĐpXbh

  makeNewThread := TMakeNewThread.Create(self,
                                        Title,
                                        PostName,
                                        PostEmail,
                                        PostBody);

  makeNewThread.Priority := tpLower;
  makeNewThread.Resume;
  result := makeNewThread;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TOnlineBoard.GC;
var
  i: integer;
  findIndex: integer;

begin
  // ݔ
  for i := 0 to FTopicErase.Count - 1 do
  begin
    findIndex := FTopicCache.IndexOf(FTopicErase[i]);
    // Ƃ͍폜
    if findIndex <> -1 then
    begin
      FTopicCache.Delete(findIndex);
    end;
  end;
  FTopicErase.Clear;
end;
//------------------------------------------------------------------
//
// 
//
//------------------------------------------------------------------
procedure TOnlineBoard.FreeTopic(Topic: TTopic);
var
  i: integer;

begin
  // JĂgsbN͉Ă͂
  if tsOpened in Topic.Status then
  begin
    exit;
  end;
  // Xbhqɂ̃gsbN͉Ă͂
  if tsInBox in Topic.Status then
  begin
    // bZ[W͉Ă悢
    Topic.FreeMessage;
    exit;
  end;
  i := FTopicCache.IndexOf(Topic);
  if (i > -1) then
  begin
    FTopicErase.Add(Topic);
  end;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
//G[bZ[Wp
procedure TOnlineBoard.RaiseErrorPost(ErrorString: string);
begin

    StatusText := ErrorString;
    gSynchronizer.DoSynchronize(SyncOnError);

end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TOnlineBoard.FreeAllTopic;
var
  i: integer;

begin
  for i := 0 to FTopicCache.Count - 1 do
  begin
    FreeTopic((FtopicCache[i] as TTopic));
  end;
  GC;
end;
//------------------------------------------------------------------
//
// 擾BCacheĂȂ΁A擾Cacheɒǉ
//
//------------------------------------------------------------------
function TOnlineBoard.GetTopic(const TopicId: string): TTopic;
var
  newTopic: TTopic;
  bbsType: TBBSType;
  i: integer;

begin
  result := nil;
  for i := 0 to FTopicCache.Count - 1 do
  begin
    if TopicId = TTopic(FTopicCache[i]).TopicId then
    begin
      // LbVǂݎ
      result := TTopic(FTopicCache[i]);
      //result.NewMessageCount := -1;
      break;
    end;
  end;
  if not Assigned(result) then
  begin
    // VgsbN
    bbsType := GetBBSType(self.Server);
    //20140308 Open2chΉ̂߂ɒ

    //2chftHgɂ
    newTopic := TTopic2ch.Create(self, TopicId);

    if (bbsType = btJBBS) then
    begin
      newTopic.Free;
      newTopic := TTopicJBBS.Create(self, TopicId);
    end;

    newTopic.LoadIdx;
    FTopicCache.Add(newTopic);
    result := newTopic;
 end;

end;
//------------------------------------------------------------------
//
// CacheĂTopicXV
//
//------------------------------------------------------------------
procedure TOnlineBoard.UpdateTopic(const TopicId: string);
var
//newTopic: TTopic;
  i: integer;
begin
  for i := 0 to FTopicCache.Count - 1 do
  begin
    if TopicId = TTopic(FTopicCache[i]).TopicId then
    begin
      TTopic(FTopicCache[i]).LoadIdx;
      break;
    end;
  end;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
constructor TOnlineBoard.Create;
begin
  inherited;
  FTopicErase := TList.Create;
  FTopicCache := TObjectList.Create;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TOnlineBoard.SetServer(const serverName: string);
begin
  FServer := serverName;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
function TOnlineBoard.GetBoardUrl: string;
begin
  result := 'http://' + FServer + '/' + BoardName + '/';
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TOnlineBoard.SendTopicList;
var
  strPath: string;
begin
  inherited;

  if (gConfig.Offline) then
  begin

    //Ot@C̎w
    strPath := AppPath('log\' + Server + '\' + BoardName + '\');
//    strPath := gConfig.LogPath + '\' + Server + '\' + BoardName + '\';
    LoadIdx(strPath,Server,BoardName);

    try
    if Assigned(OnReceived) then
    begin
      gSynchronizer.DoSynchronize(SyncOnReceived);
    end;
    if Assigned(OnComplete) then
    begin
      gSynchronizer.DoSynchronize(SyncOnComplete);
    end;

    except
      on e: Exception do
      begin
        RaiseError(e.Message);
      end;
    end;

    State := stIdling;

   exit;
  end;

  FHttp := TAsyncHttp.Create;
  FHttp.UserAgent := gConfig.UserAgent + '/' + GetVersionStr;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  FHttp.OnStatus := HttpStatusChange;
  FHttp.URL := SubjectURL;
  gConfig.InitReadProxy(FHttp);
  TopicList.Clear;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TOnlineBoard.RaiseError(ErrorString: string);
begin
  if Assigned(OnError) then
  begin
    StatusText := ErrorString;
    gSynchronizer.DoSynchronize(SyncOnError);
  end;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TOnlineBoard.HttpReceivedProc(const regPattern: string);
var
  line, topicId, topicTitle: string;
  regEx: TRegExpr;
  topic: TTopic;
  i, topicMsgCount: integer;
  intCode: integer;
  bbsType: TBBSType;
begin
  regEx := TRegExpr.Create;
  try
    bbsType := GetBBSType(self.Server);
    if bbsType = btJBBS then
    FHttp.ReceivedLines.Delete(FHttp.ReceivedLines.Count - 1);

    regEx.Expression := regPattern;

    for i := 0 to FHttp.ReceivedLines.Count - 1 do
    begin
      line := FHttp.ReceivedLines[i];

      //eucŕԂĂ\̂SJISɃGR[h
      intCode := InCodeCheck(line);
      if intCode <> SJIS_IN then
      begin
         line := euc2sjis(line);
      end;
 
      if regEx.Exec(line) then
      begin
        topicId       := regex.Match[1];
        topicTitle    := regex.Match[2];
        topicMsgCount := StrToIntNeo(Regex.Match[3]);

        // ꕶϊ
//      topicTitle := StringReplace(topicTitle, '&gt;', '>', [rfReplaceAll]);
//      topicTitle := StringReplace(topicTitle, '&lt;', '<', [rfReplaceAll]);
//      topicTitle := StringReplace(topicTitle, '&amp;', '&', [rfReplaceAll]);
//      topicTitle := StringReplace(topicTitle, '&quot;', '"', [rfReplaceAll]);
        topicTitle := ReTitle(topicTitle);

        topicTitle := TrimRight(topicTitle);

        // gsbN̐
        topic := GetTopic(topicId);
        topic.Index        := i + ReceivedIndex + 1;
        topic.Title        := topicTitle;
        topic.MessageCount := topicMsgCount;
        topic.NoIndex      := false;
        topic.OnlineBoard  := self;
        TopicList.Add(topic);
      end else
      begin
        //RaiseError('̓G[');

        //̈ړ]o
        //T[ou
        if Pos('window.location.href=',line) <> 0 then
        begin
          regEX.Expression := '\"http://(.*?)/.*?\"';
          regEX.Exec;
          Server       := regex.Match[1];
          SetServer(Server);
          regEX.Expression := '\"(http://.*?/.*?)\"';
          regEX.Exec;
          SubjectURL := regex.Match[1] + 'subject.txt';
          break;
        end;
      end;
    end;
   finally
    regEx.Free;
  end;
  // Cxgs
  if Assigned(OnReceived) then
  begin
    gSynchronizer.DoSynchronize(SyncOnReceived);
  end;
  ReceivedIndex := TopicList.Count;
  FHttp.ReceivedLines.Clear;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TOnlineBoard.HttpStatusChange(axSender: TObject;
                                        const axStatus: TIdStatus;
                                        const asStatusText: string);
  procedure ChangeStatusText(const NewText: string);
  begin
    StatusText := NewText;
    if Assigned(OnStateChange) then
    begin
      gSynchronizer.DoSynchronize(SyncOnStatus);
    end;
  end;

begin
  case axStatus of
    hsConnecting:
    begin
      ChangeStatusText(Server + 'ɐڑ');
    end;
    hsConnected:
    begin
      ChangeStatusText(Server + 'ɐڑ܂');
    end;
    hsDisconnected:
    begin
      ChangeStatusText('');
    end;
  end;
end;

destructor TOnlineBoard.Destroy;
begin
  FTopicErase.Free;
  FTopicCache.Clear;
  FTopicCache.Free;

  inherited;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TOnlineBoard.SendTopicListComplete;
begin

  //ItC\p

  if (gConfig.Offline = false) then
  begin

  if FHttp.ErrorCode = heNoError then
  begin
    //XbhM

    //̈ړ]ƃbZ[W؂ւ
    if (State = stIdling) then
    begin
      StatusText := '@ړ]̂ŃT[oURLC܂B@' + IntToStr(TopicList.Count) + '̃XbhM܂B';
    end else
    begin
      StatusText := '@' + IntToStr(TopicList.Count) + '̃XbhM܂B';
    end;
  end else if FHttp.ErrorCode = heMoved then
  begin
    StatusText := '@ړ]܂B';
  end else
  begin
    StatusText := '@ڑG[';
  end;
  FHttp.Free;

  end;

  if Assigned(OnComplete) then
  begin
    gSynchronizer.DoSynchronize(SyncOnComplete);
  end;
  State := stIdling;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TOnlineBoard.LoadIdx(strPath: string; strServer: string; strBoard: string);
var
  stlLog: TStringList;
  topic: TTopic;
  i: Integer;
  regex: TRegExpr;
  topicId: string;
begin
  regex := TRegExpr.Create;

  //G[΍
  if DirectoryExists(strPath) = false then exit;

  try

    stlLog := TStringList.Create;
    ListFiles(strPath,faAnyFile,true,true,stlLog,false,false);

      regex.Expression := '([0-9]+?)\.i';

        TopicList.Clear;

        // gsbN̓ǂݍ
        for i := 0 to stlLog.Count - 1 do
        begin
          if (stlLog[i] <> '') and (regex.Exec(stlLog[i])) then
          begin
            //server    := Regex.Match[1];
            //boardName := Regex.Match[2];
            //regex.Exec(strLog[i]);
            topicId   := regex.Match[1];

            //board := (BoardList as TBoardList).GetBoard(Server, BoardName);
            topic := GetTopic(topicId);
            Include(topic.Status, tsInBox);
            topic.Index := i + 1;
            topic.OnlineBoard := self;

            TopicList.Add(topic);
          end;
        end;
        stlLog.Free;
  finally
    regex.Free;
  end;
end;
//------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------
procedure TOnlineBoard.ListFiles
          (dirName: String;{fBNgtpX}
           attr: Word;
          {t@C̑,SĂȂfaAnyfile(attr͊܂܂Ȃ)}
           addnoattr:boolean;{True:Ȃt@C}{C}
           clrFlag: boolean;{True:VK@false: }
           theList: TStringList;{ꗗi[TStringList}
           gosubdir:boolean;{True:TufBNg}
           addYen:boolean);{True:fBNgȂ_}
{sample
           ListFiles ('c:_windows', faAnyFile,True,True,
                        newStringList,True,True);}
var
     //RC,p : Integer;
     RC: Integer;
     SearchRec : TSearchRec;
     ss: String;
begin
     if copy(dirname,length(dirname),1)<>'\' then dirname:=dirname+'\';
     {L_Lʂ͎蔲A}`oCglčsׂ}
     if clrFlag Then TheList.Clear ;
     RC := FindFirst(dirName+ '*.i', faAnyfile, SearchRec);
     try
          while RC = 0 do
          begin
               if (SearchRec.Name <> '..') and (SearchRec.Name <> '.')
               then
               begin
                    ss := dirName + SearchRec.Name;
                    if (SearchRec.Attr And faDirectory > 0) then
                    begin
                         if addyen then
                          begin
                             if copy(ss,length(ss),1)<>'\' then
                                                      ss:=ss+'\';
                         end;
                    end;
                    if (SearchRec.Attr And attr > 0) or
                       ((SearchRec.Attr=0) and addnoattr)
                    then
                    begin
                         theList.Add(SearchRec.Name);
                    end;
                    if gosubdir and (SearchRec.Attr And faDirectory > 0)
                    then
                    begin
                         ListFiles(ss, attr,addnoattr,false,
                                    TheList,true,True);
                    end;
               end;
          RC := FindNext(SearchRec);
          end;
     finally
          FindClose(SearchRec);
     end;
end;

end.
