unit untStreamTool;

interface

uses
  Classes;

type

  TStreamReader = class
  private
    FStream: TStream;
  public
    constructor Create(Target: TStream);
    destructor  Destroy; override;
    function ReadLine(out BufferString : AnsiString): Boolean;
    function Read(var Buff : Char): Boolean;
    function ReadToEnd: string;
  end;

  TWriteEvent = procedure(const Buffer; Count: int64) of object;

  TMemoryStreamEx = class(TCustomMemoryStream)
  private
    FPosition: Integer;
    FOnWrite: TWriteEvent;
    procedure SetOnWrite(const Value: TWriteEvent);
  public
    property OnWrite: TWriteEvent read FOnWrite write SetOnWrite;
    function Write(const Buffer; Count: integer): integer; override;
  end;

implementation

{ TStreamReader }

constructor TStreamReader.Create(Target: TStream);
begin
  FStream := Target;
end;

destructor TStreamReader.Destroy;
begin
  inherited;
end;

function TStreamReader.Read(var Buff: Char): Boolean;
var
  ret: boolean;
begin

  //P(1byte)ǂ

  ret := false;

  if (FStream.Read(Buff, 1) = 1) then ret := true;

  result := ret;
end;

//20130522 BufferStringStringł͂ȂAnsiStringɕύX
//String=ShortString255Ă܂
//RpCIvVŁugvI
//String=AnsiStringɂȂ
//
//varouẗႢ var͎QƓnln out͏o͐œnȂ
function TStreamReader.ReadLine(out BufferString: AnsiString): Boolean;
var
  //buffer, lastBuffer: Char;
  //intSize, length: Integer;
  //startPos: int64;
  //p: PChar;
  //s: AnsiString;
  //nextpos: int64;
  buffer: Char;
  ret: boolean;
begin

  //20130526
  //̊֐łȂĂ݂
  //ꉞő͖ʂȂ͂

  BufferString := '';
  //length := 0;
  ret := false;

  while (true) do
  begin
    //Pǂ
    if (FStream.Read(buffer, 1) = 0) then break;

    //sR[h  #13#10

    if (buffer = #13) then continue;

    if (buffer = #10) then break;

    //o͂镶
    BufferString := BufferString + buffer;

    //ǂ񂾕𐔂Ƃ@͕svȂ̂ŃRgAEg
    //Inc(length);

  end; //--- end while

  //strue Ȃfalse
  if (buffer = #10) then ret := true;

  result := ret;


  //ȉAÂ

{
  lastBuffer := #0;
  ret := false;

  // s܂œǂݍ
  startpos := FStream.Position;
  length   := 0;
  while true do
  begin
    intSize := FStream.Read(buffer, 1);
    if intSize = 0 then
    begin
      if length <> 0 then
      begin
        break;
      end else
      begin
        result       := false;
        BufferString := '';
        exit;
      end;
    end;
    if buffer = #10 then
    begin
      if lastBuffer = #13 then
      begin
        lastBuffer := #0;
      end;
      break;
    end else
    begin
      if lastBuffer <> #0 then
      begin
        Inc(length);
      end;
      lastBuffer := buffer;
    end;
  end;

  if (lastBuffer <> #0) then
      Inc(length);

  nextpos := FStream.Position;

  GetMem(p, length);
  FStream.Seek(startpos, soFromBeginning);
  FStream.Read(p^, length);
  SetString(s, p, length);
  FreeMem(p);
  BufferString := s;

  FStream.Seek(nextpos, soFromBeginning);

  if (buffer = #10) then
     ret := true;

  result := ret;
}

end;

function TStreamReader.ReadToEnd: string;
var
  buffer  : Array[1..255] of Char;
  intSize : Integer;
  str     : string;
begin

  while true do
  begin
    intSize := FStream.Read(Buffer, SizeOf(Buffer));
    if intSize = 0 then break;

    str := str + Copy(Buffer, 1, intSize);
  end;

  result := str;
end;

procedure TMemoryStreamEx.SetOnWrite(const Value: TWriteEvent);
begin
  FOnWrite := Value;
  FPosition := 0;
end;

function TMemoryStreamEx.Write(const Buffer; Count: integer): integer;
begin
  if Assigned(FOnWrite) then
  begin
    FOnWrite(Buffer, Count);
  end;
  result := Count;
end;

end.
