unit untTopic;

interface

uses
  SysUtils, Classes, Contnrs, SyncObjs,
  untRegExpr, IdComponent, Forms, StrUtils, Dialogs,
  untStreamTool, untGlobal, untHttp, IdHttp, DateUtils;

type
  TTopicMessage = class
  private
    function GetForPopup: string;
    function GetForPopup_Simple: string;
  public
    Index: Integer;
    Body:      string;
    PostName:  string;
		PostEmail: string;
    RestStr:   string;
    IsNewMessage: Boolean;
    property ForPopup: string read GetForPopup;
    property ForPopup_Simple: string read GetForPopup_Simple;
  end;

  TTopicStatusSet = set of (tsError, tsFreezed, tsGotLog, tsRetryed,
                            tsFavorite, tsInBox, tsPosting, tsOpened);

  TTopicState = (dsNone, dsStarting, dsDatLoaded, dsComplete);

  TTopic = class
  private
    FMsg: TTopicMessage;
    FLogLoaded: boolean;
    FNoBrowser: boolean;
    FMessageList: TList;
    FErrorCode: TFrameworkErrorType;
    FState: TTopicState;
  protected
    //GetPostŕʁX
    FHttp: TAsyncHttp;
    FPostHttp: TIdHttp;
    function GetTopicURL: string; virtual; abstract;
    function GetBrowserUrl: string; virtual; abstract;
    function ParseDat(const line: string; var aTitle: string): TTopicMessage;
    procedure RaiseError(const ErrorCode: TFrameworkErrorType); overload;
    procedure RaiseError(ErrorCode: TFrameworkErrorType;
                         ErrorString: string); overload;
    procedure HttpComplete; virtual;
    procedure HttpReceived(Sender: TObject); virtual;
    procedure HttpStatusChange(axSender: TObject;
                               const axStatus: TIdStatus;
                               const asStatusText: string);

    procedure SendTopic; virtual;
    procedure ChangeStatusText(const NewText: string);
    procedure WriteToDat(const newDat: string);
    procedure WriteState(const s: TTopicState);
    procedure SyncOnComplete;
    procedure SyncOnReceived;
    procedure SyncOnStateChange;
    procedure AddNewMessage;
  public
    CompleteEvent: TSimpleEvent;
    OnlineBoard: TObject;
    ArticleList: TStringList;
    Status: TTopicStatusSet;
    DoNotify: boolean;
    GZip:     boolean;
    NoIndex:  boolean;
    Server:        string;
    BoardName:     string;
    TopicId:       string;
    Title:         string;
    WroteName:     string;
    WroteEmail:    string;
    LocalDir:      string;
    Memo:          string;
    WriteError:    string;
    StatusText:    string;
    LastModified:  string;
    LastReadDate:  string;
    LastWriteDate: string;
    DatUrl:        string;
    NewMarkCount:    integer;
    DisplayMsgCount: integer;
    MessageCount:    integer;
    Index:           integer;
    GotMessageCount: integer;
    GotMessageCount2:integer;				// 2008.08.18
    NewMessageCount: integer;
    NewMessageCount2:integer;
    ScrollPosition:  integer;
    PhysicalScrollPosition:  integer;		// 2008.07.04
    PhysicalScrollPositionIE:integer;		// 2008.08.16
    Priority:        integer;
    DatSize:         integer;
    FileSize:        integer;
    AboneNumber:     integer;
    FileDate: TDateTime;
    OnComplete: TNotifyEvent;
    OnReceived: TNotifyEvent;
    OnError: TFrameworkError;
    OnStateChange: TNotifyEvent;
    property State: TTopicState read FState write WriteState;
    property ErrorCode: TFrameworkErrorType read FErrorCode;
    property MessageList: TList read FMessageList;
    property BrowserUrl: string read GetBrowserUrl;
    constructor Create(b: TObject; ti: string);
    destructor  Destroy; override;
//  procedure Download;
    procedure Download(b: boolean);
    procedure CancelDownload;
    procedure Post(PostName, PostEmail, Body: string); virtual;
    procedure LoadIdx;
    procedure LoadDat;
    procedure SaveIdx;
    procedure SaveDat;
    procedure SaveLog;			// 2008.08.18
    procedure EraseIdx;
    procedure EraseDat;
    procedure EraseLog;
    procedure CheckWriteFolder;
    procedure FreeMessage;
    procedure Abone;
    procedure CheckLog(str: string);			// 2009.07.13
  end;

implementation

uses
  untOnlineBoard, untConfig, untTool, untBoard, untBoardList;

procedure TTopic.SyncOnReceived;
begin
  OnReceived(self);
end;

procedure TTopic.SyncOnStateChange;
begin
  OnStateChange(self);
end;

procedure TTopic.SyncOnComplete;
begin
  OnComplete(self);
end;

procedure TTopic.Abone;
var
  msg: TTopicMessage;
  intNum: integer;
  regEx: TRegExpr;

begin
  if AboneNumber = 0 then
  begin
    exit;
  end;

  regEx := TRegExpr.Create;
  regEx.Expression := '<K88_ABONE>';

  intNum := AboneNumber;

  if (intNum < 0) then
  begin
  //ځ`
    intNum := intNum * -1;
    msg := TTopicMessage(MessageList[intNum - 1]);

    //regExɃknƃG[ɂȂ̂Œ
    if (msg.PostEmail) <> '' then
      if regEx.exec(msg.PostEmail) then
         msg.PostEmail := CopyAfter(msg.PostEmail,12);

  end else
  begin
  //ځ`
    msg := TTopicMessage(MessageList[intNum - 1]);

    if (msg.PostEmail) = '' then
        msg.PostEmail := '<K88_ABONE>'
    else if not regEx.exec(msg.PostEmail) then
        msg.PostEmail := '<K88_ABONE>' + msg.PostEmail;
  end;

  regEx.Free;

  //Oۑ
  SaveDat;

end;

procedure TTopic.CancelDownload;
begin

  //----@ǂݍ݂̃LZ܂Ȃ
  //FHttp.Destroy;

  Include(Status,tsError);
  //State := dsNone;

//     gSynchronizer.DoSynchronize(SyncOnComplete);
//     State := dsComplete;
//     CompleteEvent.SetEvent;
//     State := dsNone;
  //   Application.ProcessMessages;

  //----


  // 
  //DoNotify := false;
  {if State <> dsNone then
  begin
    OnStateChange := nil;
    OnReceived := nil;
    OnComplete := nil;
    FHttp.Terminate;
  end;}
end;

procedure TTopic.WriteState(const s: TTopicState);
begin
  FState := s;
  case s of
    dsStarting:
    begin
      StatusText := '';
      //ExcludeStatus񂩂w肳ꂽL[
      //Status͐ڑ̏ԂĂ
      //ł̓G[NAĂ
      Exclude(Status, tsFreezed);
      Exclude(Status, tsError);
    end;
  end;
end;
//
// X_E[h
//
//procedure TTopic.Download;
procedure TTopic.Download(b: boolean);
//var
//  board: TOnlineBoard;
//  server, boardName, topicId: string;

begin

	try

  CompleteEvent.ResetEvent;
  State := dsStarting;
  NewMessageCount2 := 0;

  CheckWriteFolder;
  FNoBrowser := not Assigned(OnReceived);

  LoadDat;  // Oǂݍ NewMessageCountOɃ[h

  if b = false then   // ʏ폈(ȊO)
  begin
    if NewMessageCount > -1 then
    NewMessageCount := 0
    else
    NewMessageCount := -1;
  end;

  DisplayMsgCount := 0;

//LoadDat;  // Oǂݍ




  if Assigned(OnReceived) and DoNotify then
  begin
    gSynchronizer.DoSynchronize(SyncOnReceived);
  end;

  if (gConfig.Offline) then
  begin
     gSynchronizer.DoSynchronize(SyncOnComplete);
     State := dsComplete;
     CompleteEvent.SetEvent;
     State := dsNone;
     Application.ProcessMessages;

     exit;
  end;

  SendTopic;

  except
    on e: Exception do
    begin
//    ShowMessage(e.Message);
    end;
  end;


end;
//
// 
//
procedure TTopic.SendTopic;
begin
  FHttp := TAsyncHttp.Create;
  FHttp.UserAgent := gConfig.UserAgent + '/' + GetVersionStr;

  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  gConfig.InitReadProxy(FHttp);
  FHttp.OnStatus := HttpStatusChange;
  FHttp.LastModified := LastModified;

end;
//
//
//
procedure TTopic.RaiseError(const ErrorCode: TFrameworkErrorType);
begin
  FErrorCode := ErrorCode;
  Include(Status, tsError);
  case ErrorCode of
    etAbone:
    begin
      StatusText := ' 폜ځ[ŃOl܂悤łB';
    end;
    etParse:
    begin
      StatusText := ' ̓G[B';
    end;
    etDatFreezed:
    begin
      StatusText := ' ̃XDAT܂B';
      Include(Status, tsFreezed);
    end;
    etBrokenGZip:
    begin
      StatusText := ' gzipG[B';
    end;
    etSocketError:
    begin
      StatusText := ' ڑɎs܂B';
    end;
    //^CAEg̃bZ[WiX擾j
    etTimeOut:
    begin
      StatusText := ' ڑ^CAEgłBT[odȂĂA͐ڑҋ@bȂ܂B';
    end;
  end;
end;

procedure TTopic.RaiseError(ErrorCode: TFrameworkErrorType;
                            ErrorString: string);
begin
  if Assigned(OnError) then
  begin
    OnError(self, ErrorCode, ErrorString);
  end;
end;
//----------------------------------------------------------------------------------------
//
// VM
//
//  NewMessageCount ::܂łɎMĖǂ̍v
//  NewMessageCount2::Mv
//----------------------------------------------------------------------------------------
procedure TTopic.HttpReceived(Sender: TObject);
var
  aTitle: string;
  i: integer;
  newDat: string;
  str: string;
begin
//NewMessageCount2:=0;
  FMessageList.Capacity := FMessageList.Count + ArticleList.Count;

  newDat := '';
  for i := 0 to ArticleList.Count - 1 do
  begin
    FMsg := ParseDat(ArticleList[i], aTitle);
    FMsg.IsNewMessage := true;
    gSynchronizer.DoSynchronize(AddNewMessage);
    newDat := newDat + ArticleList[i] + #13#10;
    if (FMsg.Index = 1) and (aTitle <> '') then
    begin
      Title := aTitle;
    end;
  end;

// O̓dǂݍ݂`FbN		2011.01.10
  if(gConfig.ReadCheck=TRUE) and (ArticleList.Count>0) then
  begin
      str:=ArticleList[0];
      if str<>'' then
        CheckLog(str);
  end;

  if NewMessageCount > 0 then
  begin
    NewMessageCount := NewMessageCount + ArticleList.Count;
  end else
  begin
    NewMessageCount := ArticleList.Count;
  end;

  if NewMessageCount2 > 0 then
  begin
    NewMessageCount2 := NewMessageCount2 + ArticleList.Count;
  end else
  begin
    NewMessageCount2 := ArticleList.Count;
  end;

  ArticleList.Clear;
  if gConfig.DoLogSave or (tsInBox in Status) or (tsGotLog in Status) then
  begin
    //󔒃f[^܂Ȃ悤ɗ}
    if newDat <> '' then
       WriteToDat(newDat);
  end;
  if Assigned(OnReceived) and DoNotify then
  begin
    gSynchronizer.DoSynchronize(SyncOnReceived);
  end;
end;
//----------------------------------------------------------------------------------------
//
//
//----------------------------------------------------------------------------------------
destructor TTopic.Destroy;
begin
  try
  FreeMessage;
  FMessageList.Free;
  ArticleList.Free;
  CompleteEvent.Free;

  inherited;

  except
    on e: Exception do
    begin
//    ShowMessage(e.Message);
    end;
  end;
end;
//
// M
//
procedure TTopic.HttpComplete;
var
  strMes: string;
begin
  //ŏIXV
  LastModified := FHttp.LastModified;
  //
  FHttp.Free;

  //X̌vZ

  //20140309 [ɂȂ錻ۂ̂Œ
  //X{V
  MessageCount := GotMessageCount + NewMessageCount;

  //X
  GotMessageCount := MessageCount;

  //t
  LastReadDate := DateTimeToStr(Now());


{
  //Oۑ
  if (gConfig.DoLogSave) then
  begin

      if NewMessageCount2 > 0 then
      begin
         GotMessageCount := GotMessageCount + NewMessageCount2;
         LastReadDate := DateTimeToStr(Now());
      end
      else
         NewMessageCount2 := 0;

      if GotMessageCount <> 0 then
         MessageCount := GotMessageCount;

  end else
  //OۑȂƂ
  begin
    GotMessageCount2 := GotMessageCount + NewMessageCount2;		// Oۑ[hoff̊ǂL
//  GotMessageCount:=0;			// 2008.08.17
    LastReadDate:='';

    MessageCount := GotMessageCount2;
  end;
}

  if not (tsError in Status) then
  begin
//  if NewMessageCount <= 0 then
    if NewMessageCount2 <= 0 then
    begin
      StatusText := '@VȂ'
    end else
    begin

       //X̎擾ƁA݂ŃbZ[W𕪂

       //20140309 ̃bZ[W
       strMes := '@VX ' + IntToStr(NewMessageCount2) + ' M';

       if (tsPosting in Status) then
           strMes := strMes + 'A܂'
       else
           strMes := strMes + '܂';

{
//     strMes := '@' + IntToStr(NewMessageCount) + '̃XM';
       strMes := '@' + IntToStr(NewMessageCount2) + '̃XM';
       if (tsPosting in Status) then
       begin
           strMes := strMes + 'A܂B';
       end else
           strMes := strMes + '܂B';
}

       StatusText := strMes;

    end;
  end else
  begin
    if tsRetryed in Status then
    begin
      StatusText := 'ēǂݍ݂܂B'
    end;
  end;

  if gConfig.DoLogSave or (tsInBox in Status) or (tsGotLog in Status) then
  begin

    //20140309 Kۑ datƐ邽
    SaveIdx;

{
    //ڑG[NAVȂ̂Ƃ̓O݂}
//  if NewMessageCount > 0 then
    if NewMessageCount2 > 0 then
       SaveIdx;
}
  end;

  State := dsComplete;
  if Assigned(OnComplete) and DoNotify then
  begin
    gSynchronizer.DoSynchronize(SyncOnComplete);
  end;
  CompleteEvent.SetEvent;
  State := dsNone;
  Application.ProcessMessages;
end;
//
//
//
procedure TTopic.ChangeStatusText(const NewText: string);
begin
  StatusText := NewText;
  if Assigned(OnStateChange) and DoNotify then
  begin
    gSynchronizer.DoSynchronize(SyncOnStateChange);
  end;
end;

procedure TTopic.HttpStatusChange(axSender: TObject;
                                  const axStatus: TIdStatus;
                                  const asStatusText: string);
begin
  case axStatus of
    hsConnecting:
    begin
      ChangeStatusText((OnlineBoard as TOnlineBoard).Server + 'ɐڑ');
    end;
    hsConnected:
    begin
      Application.ProcessMessages;
      ChangeStatusText((OnlineBoard as TOnlineBoard).Server + 'ɐڑ܂');
    end;
  end;
end;
//
// 
//
procedure TTopic.SaveDat;
var
  i: integer;
  msg: TTopicMessage;
  newDat: string;

begin
//  DeleteFile(LocalDir + TopicId + '.d');			2008.07.07
//  DeleteFile(LocalDir + TopicId + K88_DAT_EXT);

	// t@CobNAbv
	if FileExists(LocalDir + TopicId + '.bak') = True then
		DeleteFile(LocalDir + TopicId + '.bak');
	RenameFile(LocalDir + TopicId + '.d',LocalDir + TopicId + '.bak');

  newDat := '';
  for i := 0 to MessageList.Count - 1 do
  begin
    msg := TTopicMessage(MessageList[i]);
    newDat := newDat + msg.PostName + '<>' +
                       msg.PostEmail + '<>' +
                       msg.RestStr + '<>' +
                       msg.Body + #13#10;
  end;
  WriteToDat(newDat);

	// mF
	if FileExists(LocalDir + TopicId + '.d') = false then
	begin
		// t@C
		ShowMessage('TTopic.SaveDat::t@C');
		// 
		RenameFile(LocalDir + TopicId + '.bak',LocalDir + TopicId + '.d');
	end else
	begin
		// I
		DeleteFile(LocalDir + TopicId + '.bak');
	end;

end;
//
// VOo
//
procedure TTopic.WriteToDat(const newDat: string);
var
  logpath: string;
  datFile: TextFile;

begin
  Include(Status, tsGotLog);

  // DATt@C̏o
  logpath := LocalDir + TopicId + '.d';
//  logpath := LocalDir + TopicId + K88_DAT_EXT;
  AssignFile(datFile, logpath);
  if not FileExists(logpath) then
  begin
    ReWrite(datFile);
  end;

  Append(datFile);
  Write(datFile, newDat);
  Flush(datFile);
  CloseFile(datFile);
end;
//---------------------------------------------------------
//
// `FbN
// MX̐擪sAOt@Cɑ݂Ă邩(dǂݍ)`FbN
//
//---------------------------------------------------------
procedure TTopic.CheckLog(str: string);
var
	i: Integer;
//	f: TextFile;
	PathName: string;
	lst: TStringList;
	Count: Integer;
	items: TStringArray;
	sstr: string;
	dstr: string;
//	date1,date2:TDateTime;
//	year,month,day,hour,min,sec: Integer;
begin
	try
		begin
			PathName := LocalDir + TopicId + '.d';
			if FileExists(PathName) then
			begin
			//	date1:=0;
			//	date2:=0;
				lst := TStringList.Create;
				lst.LoadFromFile(PathName);			// Oǂݍ
//----------------------------------
				items := Split(str, '<>');
				if Length(items) > 3 then
				begin
					sstr:=items[2];					// DataTime+ID
				//	items:=Split(str,' ID:');
				//	dstr:=items[0];
				//	// 12345678901234567890123456789
				//	// 2009/07/11(y) 13:57:49
				//	// ' eF 2009/07/14() 08:21:40'
				//	year	:=StrToInt(Copy(dstr, 1,4));
				//	month	:=StrToInt(Copy(dstr, 6,2));
				//	day		:=StrToInt(Copy(dstr, 9,2));
				//	hour	:=StrToInt(Copy(dstr,16,2));
				//	min		:=StrToInt(Copy(dstr,19,2));
				//	sec		:=StrToInt(Copy(dstr,22,2));
				//	date1:=EncodeDateTime(year,month,day,hour,min,sec,0);
				//	dstr:=DateTimeToStr(date1);
				end;
//----------------------------------
				Count:=lst.Count;
				for i:=0 to Count-1 do
				begin
//----------------------------------
					dstr:=lst.Strings[i];
					items := Split(dstr, '<>');
					if Length(items) > 3 then
					begin
						dstr:=items[2];
					//	items:=Split(str,' ID:');
					//	dstr:=items[0];
					//	// 12345678901234567890123456789
					//	// 2009/07/11(y) 13:57:49
					//	year	:=StrToInt(Copy(dstr, 1,4));
					//	month	:=StrToInt(Copy(dstr, 6,2));
					//	day		:=StrToInt(Copy(dstr, 9,2));
					//	hour	:=StrToInt(Copy(dstr,16,2));
					//	min		:=StrToInt(Copy(dstr,19,2));
					//	sec		:=StrToInt(Copy(dstr,22,2));
					//	date2:=EncodeDateTime(year,month,day,hour,min,sec,0);
					//	dstr:=DateTimeToStr(date1);
					end;
				//	if date1<date2 then
				//	begin
				//		ShowMessage('date1<date2');
				//	end;
//----------------------------------
					if dstr=sstr then
					begin
						Application.MessageBox('O̓dǂݍ݂\܂.O폜ēǂݒĂ.','G[', 0);
					end
					else
					if StrPos(PChar(dstr),PChar(str)) <> nil then
					begin
						Application.MessageBox('O̓dǂݍ݂\܂.O폜ēǂݒĂ.','G[', 0);
					end;
				end;
				lst.Free;
			end;
		end;
		except on e: Exception do
			Showmessage(e.Message);
	end;
end;
//
// Oǂݍ
//
procedure TTopic.LoadDat;
var
  i, j: Integer;
  lines: TStringList;
  items: TStringArray;
  aTitle, logpath: string;

begin
  if FLogLoaded then
  begin
    exit;
  end;
  FLogLoaded := true;
  SetLength(items, 0);
  lines := TStringList.Create;
  logpath := LocalDir + TopicId + '.d';
//  logpath := LocalDir + TopicId + K88_DAT_EXT;

  if FileExists(logpath) then
  begin
    // [Jǂݍ
    lines.LoadFromFile(logpath);
    for i := 0 to lines.Count - 1 do
    begin
      FMsg := ParseDat(lines[i], aTitle);

      /// ݂̖ǂp
      if i >= lines.Count-NewMessageCount then      // 2008.06.25
      begin
        FMsg.IsNewMessage := true;
      end;

      AddNewMessage;
      if (i = 0) and (aTitle <> '') then
      begin
        self.Title := aTitle;
      end;
    end;
  end else
  begin
    // Of[^AÂ``
    // ÔȂ炻炩ǂݍ
    logpath := LocalDir + TopicId + '.dat';
//    logpath := LocalDir + TopicId + KATJU_DAT_EXT;
    if FileExists(logpath) then
    begin
      lines.LoadFromFile(logpath);
      for i := 0 to lines.Count - 1 do
      begin
        items := Split(lines[i], ',');
        for j := 0 to 3 do
        begin
          items[j] := StringReplace(items[j], 'M', ',', [rfReplaceAll]);
        end;

        FMsg := TTopicMessage.Create;
        FMsg.PostName  := Copy(items[0], 4, Length(items[0])-7);
        FMsg.PostEmail := items[1];
        FMsg.RestStr   := items[2];
        FMsg.Body      := items[3];
        AddNewMessage;
        WriteToDat(items[0] + '<>' +
                   items[1] + '<>' +
                   items[2] + '<>' +
                   items[3] + #13#10);
      end;
    end;
  end;
  lines.Free;
  State := dsDatLoaded;
  if MessageList.Count > 0 then
  begin
  	GotMessagecount := MessageList.Count;
  end;
end;
//
//
//
function TTopic.ParseDat(const line: string; var aTitle: string): TTopicMessage;
var
  items: TStringArray;
  msg: TTopicMessage;

begin
  msg := TTopicMessage.Create;
  items := Split(line, '<>');
  if Length(items) > 3 then
  begin
    msg.PostName  := items[0];
    msg.PostEmail := items[1];
    msg.RestStr   := items[2];
    msg.Body      := items[3];
  end;

  aTitle := '';
  if Length(items) > 4 then
  begin
    aTitle := items[4];
  end;

  result := msg
//msg.Free;				// 2009.07.14
end;
//
//
//
procedure TTopic.Post(PostName, PostEmail, Body: string);
var
  proxyhost: string;
  proxyport: integer;

begin
  //X̏ݕ

  //ʐMԂɏݒ̃tO𗧂Ă
  Include(Status, tsPosting);

  FPostHttp := TIdHttp.Create(nil);
  FPostHttp.OnStatus := HttpStatusChange;

  FPostHttp.Request.UserAgent := gConfig.UserAgent + '/' + GetVersionStr;

  FPostHttp.Request.CustomHeaders.Add('X-2ch-UA: ' + APP_2chUA);

  // proxy
  if (gConfig.WriteProxyUse) then
  begin
    gConfig.ParseProxy(gConfig.WriteProxy, proxyhost, proxyport);
    FPostHttp.ProxyParams.ProxyServer := proxyhost;
    FPostHttp.ProxyParams.ProxyPort   := proxyport;
  end
  //20130526 vLVgȂꍇ̐ݒǉ
  else
  begin
     FPostHttp.ProxyParams.ProxyServer := '';
     FPostHttp.ProxyParams.ProxyPort   := 0;
  end;

end;
//
//
//
constructor TTopic.Create(b: TObject; ti: string);
begin
  ArticleList := TStringList.Create;

  OnlineBoard := b as TOnlineBoard;

  TopicId := ti;
  FLogLoaded := false;

  GotMessageCount := 0;
  NewMessageCount := -1;
  NewMessageCount2:= 0;

  NewMarkCount := -1;

  FMessageList := TList.Create;

  CompleteEvent := TSimpleEvent.Create;

  if not gFolderAlias.GetFolderPath((OnlineBoard as TOnlineBoard).Server,
                                    (OnlineBoard as TOnlineBoard).BoardName,
                                    TopicId + '.i',
                                    LocalDir) then
  begin
      gFolderAlias.GetFolderPath((OnlineBoard as TOnlineBoard).Server,
                               (OnlineBoard as TOnlineBoard).BoardName,
                               TopicId + '.idx',
                               LocalDir)
  end;
 
end;
//
//
//
procedure TTopic.LoadIdx;
var
  idxPath: string;
  idxLines: TStringList;
  idxItems: TStringArray;
  state: Integer;
  isGotLog, isFreezed, isFavorite, isInBox: boolean;

begin
  SetLength(idxitems, 0);

  // IDX t@CΓǂݍ
  NoIndex := true;
  if DirectoryExists(LocalDir) then
  begin
    idxPath := localdir + TopicId + '.i';
//    idxPath := localdir + TopicId + K88_IDX_EXT;
    if not FileExists(idxPath) then
    begin
      idxPath := localDir + TopicId + '.idx';
//      idxPath := localDir + TopicId + KATJU_IDX_EXT;
      if not FileExists(idxPath) then
      begin
        exit;
      end;
    end;

    idxLines := TStringList.Create();
    idxLines.LoadFromFile(idxPath);
    if idxLines.Count > 0 then
    begin
      idxItems := Split(idxLines[0], #9);
      if Length(idxItems) >= 18 then
      begin
        NoIndex := false;

        state := StrToIntNeo(idxItems[1]);
        isFreezed  := Boolean(state and 16);
        isGotLog   := Boolean(state and 32);
        isFavorite := Boolean(state and 64);

        if isFreezed then
        begin
          Include(Status, tsFreezed);
        end else
        begin
          Exclude(Status, tsFreezed);
        end;
        if isGotLog then
        begin
          Include(Status, tsGotLog);
        end else
        begin
          Exclude(Status, tsGotLog);
        end;
        if isFavorite then
        begin
          Include(Status, tsFavorite);
        end else
        begin
          Exclude(Status, tsFavorite);
        end;

        Priority        := StrToInt(idxItems[2]);
        Title           :=          idxItems[3];
        // 4`6͌ݎgĂȂ
        MessageCount    := StrToInt(idxItems[7]);
        GotMessageCount := StrToInt(idxItems[8]);
        NewMessageCount := StrToInt(idxItems[9]);             // 2008.06.20 
        LastReadDate    :=          idxItems[10];
        LastWriteDate   :=          idxItems[11];
        // FBoardName := idxItems[12]; ͌ݎgĂȂ
        DatSize         := StrToInt(idxItems[13]);
        WroteName       :=          idxItems[14];
        WroteEmail      :=          idxItems[15];
        ScrollPosition  := StrToInt(idxItems[16]);
        Memo            :=          idxItems[17];
        DatUrl          :=          idxItems[18];
PhysicalScrollPosition  := StrToIntDef(idxItems[19],-1);		// 2008.07.04
PhysicalScrollPositionIE:= StrToIntDef(idxItems[20],-1);		// 2008.08.16

      end;

      // only 88 item
      if Length(idxItems) > 21 then
      begin
        LastModified := idxItems[21];
      end;

      // ver0.23 add
      if Length(idxItems) > 22 then
      begin
        state := StrToIntNeo(idxItems[22]);
        isInBox := Boolean(state and 16);
        Gzip    := Boolean(state and 32);
        if isInBox then
        begin
          Include(Status, tsInBox);
        end else
        begin
          Exclude(Status, tsInBox);
        end;
      end;
    end;
    idxLines.Free;
  end;
end;
//
// Idxt@C̋L^
//
procedure TTopic.SaveIdx;
var
  line, idxPath: string;
  state, state2: Integer;

begin
  if (tsFreezed in Status) and (MessageCount = 0) then
  begin
    exit;
  end;

  CheckWriteFolder;

  NoIndex := false;

  state := 0;
  if tsFreezed in Status then
  begin
    state := state or 16;
  end;
  if tsGotLog in Status then
  begin
    state := state or 32;
  end;
	if tsFavorite in Status then
  begin
    state := state or 64;
  end;

  state2 := 0;
  if tsInBox in Status then
  begin
    state2 := state2 or 16;
  end;
  if GZip then
  begin
    state2 := state2 or 32;
  end;

  line := '88' + #9 +
          IntToStr(state) + #9 +
					IntToStr(Priority) + #9 +
					Title + #9 +
          #9 +
					#9 +
				  #9 +
					IntToStr(MessageCount) + #9 +
					IntToStr(GotMessageCount) + #9 +
          IntToStr(NewMessageCount) + #9 +
					LastReadDate  + #9 +
					LastWriteDate + #9 +
					#9 +
					IntToStr(Datsize) + #9 +
					WroteName + #9 +
					WroteEmail + #9 +
					IntToStr(ScrollPosition) + #9 +
					Memo + #9 +
          DatUrl + #9 +
					IntToStr(PhysicalScrollPosition  ) + #9 +			// [19] 2008.07.04
					IntToStr(PhysicalScrollPositionIE) + #9 +			// [20] 2008.08.16
          LastModified + #9 +
          IntToStr(state2) + #9;

  // ۑ
  idxPath := LocalDir + TopicId + '.i';
//  idxPath := LocalDir + TopicId + K88_IDX_EXT;
  WriteFile(idxPath, line);
end;

procedure TTopic.FreeMessage;
var
  i: Integer;

begin
	try

  for i := 0 to FMessageList.Count - 1 do
  begin
    TTopicMessage(FMessageList[i]).Free;
  end;
  FMessageList.Clear;

  FLogLoaded := false;

  except
    on e: Exception do
    begin
//      ShowMessage(e.Message);
    end;
  end;

end;
//
// 
//
procedure TTopic.EraseDat;
begin
  GotMessageCount := 0;
  NewMessageCount := -1;
  Datsize      := 0;
  LastModified := '';

	//ShowMessage('TTopic.EraseDat;.dt@C');

  DeleteFile(LocalDir + TopicId + '.d');
//  DeleteFile(LocalDir + TopicId + K88_DAT_EXT);
end;
//
//
//
procedure TTopic.EraseIdx;
begin
  DeleteFile(LocalDir + TopicId + '.i');
//  DeleteFile(LocalDir + TopicId + K88_IDX_EXT);
end;
//
// O̍폜
//
procedure TTopic.EraseLog;
var
  b: TOnlineBoard;
begin
  //CancelDownload;

  // 폜
  EraseDat;
  EraseIdx;

  FreeMessage;

  Priority        := 0;
  LastReadDate    := '';
  LastWriteDate   := '';
  Memo            := '';
  ScrollPosition  := 0;				// 2008.07.10
  PhysicalScrollPosition  := -1;	// 2008.07.10
  PhysicalScrollPositionIE:= -1;	// 2008.08.16
//Title           := '';			// 2008.07.11
  Exclude(Status, tsGotLog);

  StatusText := 'u' + Title + 'ṽO폜܂';
  if tsFavorite in Status then
  begin
    // Cɓ肩͂
    Exclude(Status, tsFavorite);

    b := OnlineBoard as TOnlineBoard;
    (b.BoardList as TBoardList).MyFolder.FavoriteBoard.RemoveTopic(self);
  end;

  if Assigned(OnComplete) then
  begin
    gSynchronizer.DoSynchronize(SyncOnComplete);
  end;

  Application.ProcessMessages;		// 2008.08.16
//TopicListView.Invalidate;
//TopicListView.Update;

end;
//
//
//
procedure TTopic.CheckWriteFolder;
begin
  // tH_Ȃ΍
  if DirectoryExists(LocalDir) = false then
  begin
    CreateFullDir(LocalDir);
  end;
end;

procedure TTopic.AddNewMessage;
begin
  FMsg.Index := FMessageList.Count + 1;
  FMessageList.Add(FMsg);
end;

{ TTopicMessage }

// |bvAbvp̃bZ[W
function TTopicMessage.GetForPopup: string;
var
  pureText: string;
  regEx: TRegExpr;

begin
  pureText := IntToStr(Index) + ' ' +
              'OF' + PostName + ' ';
  if gConfig.DispMailAddress and (PostEmail <> '') then
  begin
    pureText := pureText + '[' + PostEmail + ']';
  end;
  pureText := pureText + 'eF' + RestStr  + #10 + Body;

  // HTML^O
	puretext := StringReplace(pureText, '<br>', #10, [rfReplaceAll]);
  regEx := TRegExpr.Create;
  regEx.Expression := '<.*?>';
  pureText := regEx.Replace(pureText, '');
  regEx.Free;

  // ꕶϊ
//pureText := StringReplace(pureText, '&gt;', '>', [rfReplaceAll]);
//pureText := StringReplace(pureText, '&lt;', '<', [rfReplaceAll]);
//pureText := StringReplace(pureText, '&amp;', '&', [rfReplaceAll]);		// 2008.05.05
//pureText := StringReplace(pureText, '&quot;', '"', [rfReplaceAll]);		// 2008.05.05
//pureText := ReTitle(pureText);

//if gConfig.Doe_AaReplace = True then
    pureText := ReplaceAA(pureText);

  result := pureText;
end;

// |bvAbvp̃bZ[W ȈՔ 2005/04/19
function TTopicMessage.GetForPopup_Simple: string;
var
  pureText: string;
  regEx: TRegExpr;
  intNumLen: integer;
  i: integer;
  strSpace: string;
begin

  //Xԍ̌
  intNumLen := Length(IntToStr(Index));
  strSpace := '';
  for i := 0 to intNumLen do
  begin
    strSpace := strSpace + ' ';
  end;

  pureText := IntToStr(Index) + '@' + Body;

  // HTML^O
  puretext := StringReplace(pureText, '<br>', #10 + strSpace + '@', [rfReplaceAll]);
  regEx := TRegExpr.Create;
  regEx.Expression := '<.*?>';
  pureText := regEx.Replace(pureText, '');
  regEx.Free;

  // ꕶϊ
//pureText := StringReplace(pureText, '&gt;', '>', [rfReplaceAll]);
//pureText := StringReplace(pureText, '&lt;', '<', [rfReplaceAll]);
  pureText := ReTitle(pureText);

  //؂
  //pureText := pureText + #10 + '';

  result := pureText;
end;
//
// Oۑ[hoffɁAOۑ
//
procedure TTopic.SaveLog;
begin
  GotMessageCount:=GotMessageCount2;
  LastReadDate := DateTimeToStr(Now());
  SaveIdx;
  SaveDat;
end;

end.
