unit untTopic2ch;

interface

uses
  IdComponent, untGlobal, Forms, IniFiles,
  untTopic, untOnlineBoard;

type
  TTopic2ch = class(TTopic)
  private
    FLogin:       boolean;
    FNoFirstLine: boolean;
    FReadTimeOut: TDateTime;

    function GetFormData(var sBody: string;response: string):string;
	function GetSubString(pTop: string; pEnd: string ;var  str: string):string;
	procedure GetInput(sInput: string;var Name: string;var Value :string);
	function GetSentens(sInput: string;str: string):string;
	function PosEx(sub:string; str:string; n:integer):integer;

  protected
    procedure Retry;
    procedure SendTopic; override;
    procedure HttpReceived(Sender: TObject); override;
    function GetTopicURL: string; override;
    function GetBrowserURL: string; override;
  public
    procedure Post(PostName, PostEmail, Body: string); override;
  end;

implementation

uses
  untTool, Classes, IdCookieManager, jconvert,
  untDzURL, SysUtils, untRegExpr,
  untHttp,  untConfig,
  untMainForm,
  IdCookie;

procedure TTopic2ch.Retry;
begin

  //XǍݏgC

  StatusText := 'ēǂݍݒ';
  FreeMessage;

{
  //gCsɏĂ܂烍O͏Ȃ
  //EraseDat;
}

  //20140308 open2chł̓W[ȂB
  //̂܂܂ł̓W[JԂ̂ŃOKv
  //mɃgCŎsƃO͏邯ǂőÓȂ͂
  //ODatSize0ɃZbg
  //DatSizeɂăW[邩ǂ肵Ă
  EraseDat;

  //XǍ
  Download(false);

end;

function TTopic2ch.GetTopicURL: string;
var
  b: TOnlineBoard;

begin
  b := (OnlineBoard as TOnlineBoard);
  if FLogin then
  begin
    result := 'http://' + b.Server + '/test/offlaw.cgi/' +
                          b.BoardName + '/' + TopicId +
                          '/?raw=.' + IntToStr(DatSize) +
                          '&sid=' + UrlEncode(gConfig.SessionId);
  end else if tsFreezed in Status then
  begin
    if Length(TopicId) > 9 then
    begin
      result := 'http://' + b.Server + '/' +
                            b.BoardName + '/kako/' +
                            Copy(TopicId, 1, 4) + '/' +
                            Copy(TopicId, 1, 5) + '/' + TopicId + '.dat.gz'
    end else
    begin
      result := 'http://' + b.Server + '/' +
                            b.BoardName + '/kako/' +
                            Copy(TopicId, 1, 3) + '/' + TopicId + '.dat.gz';
    end;
  end else
  begin
    if DatUrl = '' then
    begin
      result := 'http://' + b.Server + '/' +
                            b.BoardName + '/dat/' + TopicId + '.dat';
    end else
    begin
      result := DatUrl;
    end;
  end;
end;

function TTopic2ch.GetBrowserUrl: string;
begin
  if DatUrl = '' then
  begin
    result := 'http://' + (OnlineBoard as TOnlineBoard).Server + '/test/read.cgi/'  +
                          (OnlineBoard as TOnlineBoard).BoardName  + '/' + TopicId + '/';
  end else
  begin
    result := DatUrl;
  end;
end;
//
//
//
procedure TTopic2ch.SendTopic;
var
  contentSize, i: integer;
begin
  inherited;

  FNoFirstLine := true;
  FLogin := false;

  if DatSize > 0 then
  begin
    FHttp.StartRange := DatSize - 1
  end else
  begin
    FHttp.StartRange := 0;
  end;

  FHttp.UseGzip := true;
  FHttp.OnReceived := HttpReceived;


//ڑG[ŃgC邽߂̃[v

  for i := 0 to 1 do
  begin

    //ǂݍ݃^CAEgݒ肵ĂāA
    //͂ivɑ̂}
    FReadTimeOut := Now();
    //^CAEgݒ肪PbȏȂ Pb=1000~b
    if (gConfig.CONNECT_TIMEOUT > 999) then
       FReadTimeOut := FReadTimeOut + (gConfig.CONNECT_TIMEOUT /1000 / 60 / 60 / 24);

    try
      FHttp.URL := GetTopicURL;
      FHttp.Get;
    except
      ;
    end;


    //VȂ̂Ƃ
    if (FHttp.ResponseCode = 304) then Break;

    //^CAEg
    if (FHttp.ResponseCode = -1) then
    begin
        RaiseError(etTimeOut);
        break;
    end;

    //gC
    //W[sAځ[A̓G[Agzipj
    if (FHttp.ResponseCode = 416) or
       (ErrorCode = etAbone) or
       (ErrorCode = etParse) or
       (ErrorCode = etBrokenGZip) then
    begin
      if not (tsRetryed in Status) then
      begin
        Include(Status, tsRetryed);
        Retry;
        exit;
      end;
    end;


    //G[ȂƂ
    if FHttp.ErrorCode = heNoError then
    begin
       contentSize := FHttp.ContentLength;
        if contentSize > 0 then
        begin
          if DatSize = 0 then
            DatSize := contentSize
          else
            DatSize := DatSize + contentSize - 1;
        end;

        //20140308 gCƂ̏ǉ
        if (tsRetryed in Status) then
        begin
           //VXĐݒ肷
           //ƌŊXZbg
           NewMessageCount2 := NewMessageCount;
           //gCtO
           Exclude(Status, tsRetryed);
        end;

        //G[Ȃ̂Ń[v𔲂
        break;
    end;


    case  FHttp.ErrorCode of
      heBrokenGZip:
        RaiseError(etBrokenGZip);

      heSocketError:
        RaiseError(etSocketError);

      //302G[
      heMoved:
      begin

        //Ȃ̏ꍇ
        if (gConfig.UserId = '') then
        begin
            //DATG[
            RaiseError(etDatFreezed);
            //xĂ_Ȃ̂ł
            Break;
        end;

        //̏ꍇ
        //̂for[vɖ߂
        //OCēǂݍ݂
        if (gConfig.UserID <> '') then
            FLogin := true;

      end; //--- end heMoved

     end; //--- end case

  end; //--- end for


  //OCĂDat̏ꍇAG[\
  if (FLogin = true) and (gConfig.SessionId = '') then
  begin
      FLogin := false;
      RaiseError(etDatFreezed);
  end;


  inherited HttpComplete;

end;
//
// ݏ
//
procedure TTopic2ch.Post(PostName, PostEmail, Body: string);
var
  postData: TStringList;
  intTime: integer;
  response, errorMsg, writeData, compData: string;
  i,intCode: integer;
  strCGIURL: string;
  iCookies: TIdCookies;
  iCookie: TIdCookieRFC2109;
  regExp: TRegExpr;
  strPON,strHAP: AnsiString; //IAnsiStringɂ256ȏ㎝
  blPON,blHAP: boolean; //20130802 NbL[ptO
  label CHECK1;
begin
  inherited;

    i := 0;
    intTime := 0;
    response := '';
    errorMsg := '';
    writeData := '';
    compData := '';
    intCode := 0;
    strCGIURL := '';

    //X̏

    //[F؃T[opݒ
    if (OnlineBoard as TOnlineBoard).Server = 'be.2ch.net' then
    begin

      //Oݒ肵ȂƓe錻ۂ
      if PostName = '' then
         PostName := '񁗂ςB';

      //BEւPOSTSJISEUCɕϊȂƂȂ
      PostName := sjis2euc(PostName);
      PostEmail := sjis2euc(PostEmail);
      Body := sjis2euc(Body);
    end;


  with FPostHttp do
  begin
    Request.Referer := 'http://' +
                          (OnlineBoard as TOnlineBoard).Server + '/' +
                          (OnlineBoard as TOnlineBoard).BoardName  + '/index2.html';
    HTTPOptions := [];
    //BEOC`FbNꂽԂȂΕKBET[o֑
    if (gConfig.BELogin) then
        Request.CustomHeaders.Add('Cookie: MDMD=' + gConfig.BEMDMD + '; DMDM=' + gConfig.BEDMDM + ';');
    //timeout
    ConnectTimeout := gConfig.CONNECT_TIMEOUT;
  end;

  //ݓe
  writeData := 'submit='  + UrlEncode('') + '&' +
               'FROM='    + UrlEncode(PostName) + '&' +
               'mail='    + UrlEncode(PostEmail) + '&' +
               'MESSAGE=' + UrlEncode(Body) + '&' +
               'bbs='     + (OnlineBoard as TOnlineBoard).BoardName + '&' +
               'key='     + TopicId +
               '&' + gConfig.WriteCookie;


  if (gConfig.Sessionid <> '') then
     writeData := writeData + '&sid=' + UrlEncode(gConfig.Sessionid);

  //20140309 timěvZ@ύX
  intTime := gConfig.GetUnixTime_Now;
  compdata := writeData + '&' + 'time=' + IntToStr(intTime);
  postData := TStringList.Create;
  postData.Add(compData);

  strCGIURL := 'http://' + (OnlineBoard as TOnlineBoard).Server + '/test/bbs.cgi?guid=ON';

  //NbL[蒼
  FPostHttp.CookieManager := TIdCookieManager.Create(nil);
  FPostHttp.Request.CustomHeaders.Clear;

  //݂̃NbL[Zbg
  FPostHttp.CookieManager.CookieCollection.AddSrcCookie(gConfig.WriteCookie2);
  FPostHttp.CookieManager.CookieCollection.AddSrcCookie(gConfig.WriteCookie3);

  try
     response := FPostHttp.Post(strCGIURL,postData);
  except
     RaiseError(etSocketError);
  end;

  //20130511 HɓeԂȂƂ
  if (response = '') then goto CHECK1;

  //BE@2chPostƁAʂEUCŕԂĂ̂
  //SJISփGR[h
  intCode := InCodeCheck(response);
  if (intCode <> SJIS_IN) then
     response := euc2sjis(response);

  //20130526 G[bZ[W܂Ƃ߂Čo
  if (Pos('<!-- 2ch_X:error -->',response) > 0) then
  if (Pos('<title>dqqnqI</title>',response) > 0) then
  //if (Pos('sec ȂƏ܂B',response) > 0) then
  //if (Pos('<b>dqqnqFCs܂',response) > 0) then
  begin
      ErrorMsg := CopyMiddle(response, '<!-- 2ch_X:error -->', '<br>');
      goto CHECK1;
  end;

  // refreshołΏݐAłȂΎs
  // u݊mFvʂłx
  if (Pos('refresh', response) = 0) or
     (Pos('<title> ݊mF </title>',response) <> 0) then
  begin

      //ZbVIDāAx

      //ҋ@قǂ͔
      //Sleep(8000);

      postData.Free;
      postData := TStringList.Create;

      //T[ỏtime̐ݒ擾
      compData := writeData;
      regExp := TRegExpr.Create;
      regExp.Expression := '<input type=hidden name=time value=([0-9]+)>';
      if (regExp.Exec(response)) then
      begin
         compData := compData + '&' + 'time=' + regExp.Match[1];
         postData.Add(compData);
      end;
      regExp.Free;

      //ł̓NbL[NAĂ͂Ȃ
      //FPostHttp.Request.CustomHeaders.Clear;

      //NbL[ݒ肷
      iCookies := FPostHttp.CookieManager.CookieCollection;
      if (iCookies.Count > 0) then
      begin

        //20130802 Qdo^Ȃ悤ɃtOŏ
        blPON := false;
        blHAP := false;

        for i:=0 to iCookies.Count-1 do
        begin

          iCookie := iCookies.Items[i];

          //20120704 ܂ɕςȃNbL[͂Ƃ̂
          //𖳎Kv
          if (iCookie.CookieName = '') then continue;

          //20130802 do^`FbN ȂƃNbL[Ȃ
          if (iCookie.CookieName = 'PON') then
          begin
             if (blPON) then continue;
             blPON := true;
          end;

          if (iCookie.CookieName = 'HAP') then
          begin
             if (blHAP) then continue;
             blHAP := true;
          end;

          //NbL[o^
          FPostHttp.Request.CustomHeaders.Add('Cookie: ' + iCookie.CookieText);
        end;
      end;

      //ݗpBNbL[̐ݒ
      regExp := TRegExpr.Create;
      regExp.Expression := '<input type=hidden name="([a-z]+)" value="([a-z]+)">';
      if (regExp.Exec(response)) then
      if (gConfig.WriteCookie <> regExp.Match[1] + '=' + regExp.Match[2]) then
      begin
          gConfig.WriteCookie := regExp.Match[1] + '=' + regExp.Match[2];
          postData.Add('&' + gConfig.WriteCookie);

          //bZ[W\
          ErrorMsg := 'WriteCookieXV܂B';
          ErrorMsg := ErrorMsg + #13#10#13#10 + 'ݏ͐ɍs͂Ȃ̂';
          ErrorMsg := ErrorMsg + #13#10 + 'xOɁAXmFĂB';
          ErrorMsg := ErrorMsg + #13#10#13#10 + 'ȂAWriteCookie̍XV͂PNɂPxx';
          ErrorMsg := ErrorMsg + #13#10 + 'ႢpxŋN͂łB̏pȂ';
          ErrorMsg := ErrorMsg + #13#10 + 'G[̂ꂪ܂B';

      end;
      regExp.Free;

      //20140307 ݊mF̂Ƃҋ@悤ɂ
      Application.ProcessMessages;
      Sleep(2000);

      try
        response := FPostHttp.Post(strCGIURL,postData);
      except
        RaiseError(etSocketError);
      end;

      //T[o̕ԓ̃GR[h
      intCode := InCodeCheck(response);
      if (intCode <> SJIS_IN) then
         response := euc2sjis(response);

      //E@쐬Ƃ
      if (Pos('悤FM̔E@', response) > 0) then
      begin

         //EҋK̃NbL[
         strPON := '';
         strHAP := '';
         regExp := TRegExpr.Create;
         iCookies := FPostHttp.CookieManager.CookieCollection;

         for i:=0 to iCookies.Count-1 do
         begin
              iCookie := iCookies.Items[i];

              regExp.Expression := '(PON=[0-9a-zA-Z.]+)';
              if (regExp.Exec(iCookie.CookieText)) then
                  strPON := regExp.Match[1];

              regExp.Expression := '(HAP=[0-9a-zA-Z]+)';
              if (regExp.Exec(iCookie.CookieText)) then
                  strHAP := regExp.Match[1];

         end;

         regExp.Free;

         gConfig.WriteCookie2 := strPON;
         gConfig.WriteCookie3 := strHAP;


      end;//---end if E@


      if (Pos('refresh', response) = 0) then
      begin
        // G[
        ErrorMsg := CopyMiddle(response, '<b>', '</b>');

        if (ErrorMsg = '') then
            ErrorMsg := CopyMiddle(response, '<!-- 2ch_X:error -->', '<br>');

        if (ErrorMsg = '') then
        begin
          if (Pos('OCG[',response) > 0) then
              ErrorMsg := 'OCG[łB'
          else
               ErrorMsg := 'G[܂';
        end;

        //E@LV0ɂȂƂNbL[
        if (Pos('ꂽł', response) > 0) then
        begin
            //EҋK̃NbL[NA
            gConfig.WriteCookie2 := '';
            gConfig.WriteCookie3 := '';
        end;

      end; //--- end if

  end;//--- end if refresh

CHECK1:

  postData.Free;

  //G[bZ[W
  if (ErrorMsg <> '') then
     RaiseError(etPostArticle, ErrorMsg);

  //Ɋ
  if (ErrorMsg = '') then
  if Assigned(OnComplete) then
     OnComplete(self);

end;
//
//
//
procedure TTopic2ch.HttpReceived(Sender: TObject);
var
  line: string;
  regExp: TRegExpr;
  i: Integer;
  intCode: integer;
begin
  regExp := TRegExpr.Create;
  try
    ArticleList.BeginUpdate;
    regExp.Expression := '^(.*?)<>(.*?)<>(.*?)<>(.*?)<>(.*?)';
    for i := 0 to FHttp.ReceivedLines.Count - 1 do
    begin

      //^CAEgȂ珈𔲂
      //ŔivIɉ͂𑱂邱Ƃ}
      if (FReadTimeOut < Now()) then
      begin
         FHttp.ReceivedLines.Clear;
         //G[\
         RaiseError(etTimeOut);
         break;
      end;

      line := FHttp.ReceivedLines[i];

      intCode := InCodeCheck(line);
      if (intCode <> SJIS_IN) then
          line := euc2sjis(line);

      // Ol܂`FbN
      if FNoFirstLine then
      begin
        FNoFirstLine := false;
        if DatSize > 0 then
        begin
          if line = '' then
          begin
            continue;
          end else
          begin
            RaiseError(etAbone);
            exit;
          end;
        end
      end;

      // sǉ
      if RegExp.Exec(line) then
      begin
        ArticleList.Add(line);
      end else
      begin
        if (i <> 0) and (gConfig.SessionId = '') then
        begin
        RaiseError(etParse);
        ArticleList.Add('<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                        '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                        '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                        '<FONT COLOR="Gray">[Ă܂]</FONT><>');
        end;
      end;
    end;
    ArticleList.EndUpdate;
    FHttp.ReceivedLines.Clear;
  finally
    Regexp.Free;
  end;
  inherited;
end;
//
// 
//
function TTopic2ch.GetFormData(var sBody: string;response: string):string;
var
	Name: string;
	Value: string;
	sForm: string;
	sInput: string;

//  pTop: integer;
begin
	Result:='';
	sForm:=GetSubString('<form','</form>',response);		// ͈͂̕擾
	while sForm<>'' do
	begin
		sInput:=GetSubString('<input','>',sForm);		// Delete(sForm,Index, Count);
		if sInput<>'' then
		begin
			GetInput(sInput,Name,Value);				// 
			if (Name='MESSAGE') or (Name='message') then
				Value:=sBody;
			if Result<>'' then
				Result:=Result+'&';
			Result:=Result+Name+'='+UrlEncode(Value);
		end else
		begin
			break;
		end;
	end;
end;
// 
// 擾
// 擾𕶎񂩂폜
// 
function TTopic2ch.GetSubString(pTop: string; pEnd: string ;var  str: string):string;
var
	Size: integer;
	p0: integer;
	p1: integer;

begin
	Result:='';
	p0 := Pos(pTop,str);
//	p1 := Pos(pEnd,str);
	p1 := PosEx(pEnd,str,p0+1);
	if (p0<>0) and (p1<>0) and (p0<p1) then
	begin
		Size:=p1-p0+Length(pEnd);
		Result:=Copy(str,p0,Size);
		Delete(str,p0,Size);
	end;
end;
//
// <input name=nnn value="xxx">
//
procedure TTopic2ch.GetInput(sInput: string;var Name: string;var Value :string);
begin
	Name:=GetSentens(sInput,'name=');
	Value:=GetSentens(sInput,'value=');
end;
//
// nnn="xxx"|nnn=xxx `̕擾
//
function TTopic2ch.GetSentens(sInput: string;str: string):string;
var
	s: string;
	p: integer;
	ch: Char;
	wq: boolean;

begin
	Result:='';
	wq:=false;
	s:=LowerCase(str);
	p:=Pos(s,sInput);
	if p=0 then
	begin
		s:=UpperCase(str);
		p:=Pos(s,sInput);
	end;
	if p<>0 then
	begin
		p:=p+Length(str);
		ch:=sInput[p];
		if ch='"' then
		begin
			Inc(p);
			wq:=true;
		end;
		while sInput[p] <> '>' do
		begin
			ch:=sInput[p];
			if wq=true then
			begin
				if ch='"' then break;
			end else
			begin
				if ch='>' then break;
				if ch=' ' then break;
			end;
			Result:=Result+ch;
			inc(p);
		end;
	end;
end;
// JnʒuwŕT
// PosEx(,Buffer,Jnʒu(1`)
//
function TTopic2ch.PosEx(sub:string; str:string; n:integer):integer;
var
        Size: integer;
begin

        Result:=0;
        Size:=Length(str);
        if n<=Size then
        begin
                Delete(str,1,n-1);
                Result:=Pos(sub,str);
                if Result<>0 then
                        Result:=Result+n-1;
        end;
end;





end.
