unit untTopicBrowser;

interface

uses
  Classes, ExtCtrls, SyncObjs,
  untTopic,Graphics;

type
  TNavigateUrlEvent = procedure(sender: TObject; URL: string) of object;

  TTopicBrowser = class(TPanel)
  protected
    FLoading:     boolean;
    FAutoReload:  boolean;
    FDownloading: boolean;
//  FOpenExecute: boolean;		// 2008.08.19
    FViewLimit: integer;
    FReloadTimer: TTimer;
    function  ChangePopup(const statustext: string): boolean;
    procedure SetAutoReload(const Value: Boolean);
    procedure RaiseNavigateUrlEvent(Url: string);
    procedure ChangeImageIndex;
    procedure AutoReloadTimer(Sender: TObject);
    procedure SyncInit;
    procedure SyncSetTitle;
    procedure Topic_MessageReceived(Sender: TObject);  virtual; abstract;
    procedure Topic_ChangeDownloadState(Sender: TObject); virtual;
    procedure Topic_Complete(Sender: TObject); virtual;
    procedure DoePopup(const statustext: string);

  public
    RangeNoList: TStringList;
    Topic: TTopic;
    Caption: string;
    StartNo:    integer;
    ImageIndex: integer;
    OnNavigateUrl: TNavigateUrlEvent;
    OnMessageReceived:     TNotifyEvent;
    OnComplete:            TNotifyEvent;
    OnChangeDownloadState: TNotifyEvent;
    CompleteEvent: TSimpleEvent;
    property AutoReload: Boolean read FAutoReload write SetAutoReload;
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    procedure JumpMessage(const msgNo: integer); virtual; abstract;
    procedure SaveScrollPosition; virtual; abstract;
    procedure RestoreScrollPosition; virtual; abstract;
    procedure OpenTopic(tp: TTopic); virtual;
    procedure CloseTopic; virtual;
    procedure Reload; virtual;
    procedure SearchText(const str: string; mode: boolean); virtual; abstract;
    procedure ChangeViewLimit(NewLimit: integer); virtual; abstract;
    procedure TrashTopic;
    procedure SetFont(fname: string; fsize: integer); virtual; abstract;
//  procedure SetHTMLColor(mes: integer; nam: integer; lnk: integer; bg: integer); virtual; abstract;
    procedure SetHTMLColor(mes: integer; nam: integer; namelink: integer; lnk: integer; bg: integer); virtual; abstract;
    procedure IDSearch(id: string); virtual; abstract;
    procedure SetWallpaper(g: TGraphic); virtual; abstract;
    procedure IDSearchPopUp(id: string); virtual; abstract;
    procedure SelectAll();  virtual; abstract;

  end;

implementation

uses
  ComCtrls, Controls, windows, untRegExpr, StrUtils, SysUtils, Forms, Math,
  untOnlineBoard, untGlobal, untTool, untHintWindow, untTaskManager,
  untMainForm, unt2chURLParser,
  untPicturePreviewForm,   // 2005.04.03
  untViewImageForm,        // 2008.04.29
  untDownload;             // 2008.06.10


type
  TPopupManager = class(TObject)
  private
    class function GetMessages(Msgs: TList;
                               const First,
                                     Last: Integer): string;
    //IDo|bvAbvp
    class function GetMessages_By_ID(Msgs: TList;
                               const id: string): string;
    class function ParseMailto(const URI: string): string;
  public
    class procedure ParseJump(const URI: string;
                                var First,
                                    Last: Integer);
    class function GetPopupMessages(Topic: TTopic; const URI: string): string;
  end;
//
//  O폜(S~{^)
//
procedure TTopicBrowser.TrashTopic;
begin
  if Assigned(Topic) then
  begin
//  Topic.OnComplete := MainForm.TopicBrowser_TrashComplete;	// 2008.08.16	
    Topic.EraseLog;
  end;
end;
//
// URLōNbNł̏
//
procedure TTopicBrowser.RaiseNavigateUrlEvent(Url: string);
var
  p: Integer;
  urlStr: string;
  msgNo: integer;
  mPoint: TPoint ;

begin
  if Url = '' then exit;

    urlStr := LowerCase(Url);

  //摜vr[̕\
  if gConfig.PicturePreview then
  begin
    if AnsiEndsText('.jpg',urlStr) or AnsiEndsText('.gif',urlStr) or AnsiEndsText('.png',urlStr) or AnsiEndsText('.jpeg',urlStr) then
    begin

      if gViewImage=Nil then
        gViewImage := TViewImageForm.Create(self);
      if gDownload=Nil then
      begin
        gDownload := TDownload.Create(False);
        gDownload.FreeOnTerminate:=True;
      end;

      GetCursorPos(mPoint);	// \ʒu̓}EXJ[\ʒu
//    gViewImage.Top:=mPoint.y-gViewImage.Height;
//    gViewImage.Left:=mPoint.x;
      gViewImage.FormStyle:=fsStayOnTop;
      gViewImage.Show;
      gViewImage.FitImageURL(Url,mPoint);   // Download and View
      exit;
    end;
  end;

  if AnsiStartsText('jump://goto/', urlStr) then
  begin
    p := Pos('-', Url);
    if p <> 0 then
    begin
      urlStr := Copy(Url, 0, p - 1)
    end else
    begin
      urlStr := Url;
    end;
    msgNo := StrToIntNeo(CopyAfter(UrlStr, 13));
    JumpMessage(msgNo);
  end else
  begin
    if Assigned(OnNavigateUrl) then
    begin
      OnNavigateUrl(self, Url);
    end;
  end;
end;

constructor TTopicBrowser.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  self.BevelInner := bvNone;
  self.BevelOuter := bvNone;

  FLoading := false;
//FOpenExecute:=false;
  ImageIndex := -1;
  FReloadTimer := TTimer.Create(self);
  FReloadTimer.Enabled  := false;
  FReloadTimer.Interval := 60000;
  FReloadTimer.OnTimer  := AutoReloadTimer;

  RangeNoList := TStringList.Create;
  CompleteEvent := TSimpleEvent.Create;
  gViewImage:=Nil;
  gDownload:=Nil;
end;

destructor TTopicBrowser.Destroy;
begin
  FReloadTimer.Free;
//CompleteEvent.Free;
  RangeNoList.Free;
//if gDownload<>Nil then gDownload.Free;
  if gViewImage<>Nil then 
  begin
    gViewImage.Free;
    gViewImage:=Nil;
  end;

  inherited;
  CompleteEvent.Free;
end;

procedure TTopicBrowser.AutoReloadTimer(Sender: TObject);
begin
  // I[g[h
  Reload;
end;

procedure TTopicBrowser.Reload;
begin
  if Assigned(Topic) then
  begin
    //Topic.CancelDownload;
    Topic.OnStateChange := Topic_ChangeDownloadState;
    Topic.OnReceived    := Topic_MessageReceived;
    Topic.OnComplete    := Topic_Complete;

    gTaskManager.Request(Topic, self, reqtDownload);
  end;
end;
//
//
//
procedure TTopicBrowser.OpenTopic(tp: TTopic);
begin
//if FOpenExecute=true then
//   exit;

  try
//  FOpenExecute:=true;

  //vp
  Inc(gConfig.ToukeiInfo_Thread_Load);

  CompleteEvent.ResetEvent;

  if Assigned(Topic) then
  begin
    CloseTopic;
  end;

  if Assigned(tp) then
  begin
    FViewLimit := gConfig.ViewLimit;

    Topic := tp;
    gSynchronizer.DoSynchronize(SyncSetTitle);

    Topic.DoNotify := true;
    Topic.OnStateChange := Topic_ChangeDownloadState;
    Topic.OnReceived    := Topic_MessageReceived;
    Topic.OnComplete    := Topic_Complete;
    Include(Topic.Status, tsOpened);
//  Topic.Download;
    Topic.Download(false);
  end else
  begin
    gSynchronizer.DoSynchronize(SyncInit);
    CompleteEvent.SetEvent;
  end;

  except
    on e: Exception do
    begin
//      ShowMessage(e.Message);
    end;
  end;


end;
//
//
//
procedure TTopicBrowser.CloseTopic;
begin
	try


  if Assigned(Topic) then
  begin
    //Topic.CancelDownload;
//  SaveScrollPosition;				// 2009.07.17
//	MainForm.SaveScrollPosition;


    if gConfig.DoLogSave or (tsInBox in Topic.Status) or (tsGotLog in Topic.Status) then
    begin
      // Oۑ[h
      Topic.SaveIdx;
      if not (tsGotLog in Topic.Status) then
      begin
        // [hؑփ{^ꂽƂ
        // O܂ۑĂȂ̂łŕۑ
        Topic.SaveDat;
      end;
    end else
    begin
      // OۑȂ[h    
      Topic.GotMessageCount := 0;
      Topic.NewMessageCount := -1;
      Topic.Datsize         := 0;
      Topic.LastModified    := '';
    end;
    Exclude(Topic.Status, tsOpened);            //
    Topic.FreeMessage;				//
    SetAutoReload(false);			//
  end;
  RangeNoList.Clear;
  StartNo := 0;

  Topic := nil;
  gSynchronizer.DoSynchronize(SyncInit);


  except
    on e: Exception do
    begin
//      ShowMessage(e.Message);
    end;
  end;


end;
//
//
//
procedure TTopicBrowser.SyncInit;
begin
  Caption  := '';
  ImageIndex := -1;
end;

procedure TTopicBrowser.SyncSetTitle;
begin
  Caption  := Topic.Title;
end;
//------------------------------------------------------------------
// 
// 
// 
//------------------------------------------------------------------
procedure TTopicBrowser.Topic_Complete(Sender: TObject);
begin
  if Assigned(Topic) then	// 2008.08.16
  begin
    ChangeImageIndex;
    if Topic.NewMessageCount > 0 then
    begin
      SetAutoReload(false);
    end;

    if Assigned(OnComplete) then
    begin
      OnComplete(self);
    end;
    CompleteEvent.SetEvent;

//  FOpenExecute:=false;
//	RestoreScrollPosition;
    MainForm.FOpenning:=false;
  end;
end;
//
// ԕω
//
procedure TTopicBrowser.ChangeImageIndex;
begin
  if Assigned(Topic) then	// 2008.08.16
  begin
    case Topic.State of
      dsNone:
      begin
        if FAutoReload then
        begin
          ImageIndex := 1;
        end else
        begin
          ImageIndex := -1;
        end;
      end;
      dsComplete:
      begin
        if Topic.NewMessageCount > 0 then
        begin
          ImageIndex := 0
        end else
        begin
          if FAutoReload then
          begin
            ImageIndex := 1
          end else
          begin
            ImageIndex := -1;
            if tsError in Topic.Status then
            begin
              ImageIndex := 2;
            end;
            if tsFreezed in Topic.Status then
            begin
              ImageIndex := 3;
            end;
          end;
        end;
  
        if FDownloading = true then
        begin
          FDownloading := false;
  
          // vOANeBułȂ
          // ^Cgo[_ł
          if (Topic.NewMessageCount > 0) and
             not Application.Active then
          begin
            FlashWindow(Application.Handle, True);
          end;
        end;
      end;
      dsStarting:
        ImageIndex := 4;
      {dsProcessing:
        ImageIndex := 5;}
    end;
  end else
  begin
    ImageIndex := -1;		// 2008.08.16
  end;

  Application.ProcessMessages;
end;
//
//
//
procedure TTopicBrowser.Topic_ChangeDownloadState(Sender: TObject);
begin
  ChangeImageIndex;
  if Assigned(OnChangeDownloadState) then
  begin
    OnChangeDownloadState(self);
  end;
end;

// I[g[hݒ
procedure TTopicBrowser.SetAutoReload(const Value: Boolean);
begin
  FAutoReload := Value;
  FReloadTimer.Enabled := Value;
  Topic_ChangeDownloadState(Topic);
end;
//
//
//
function TTopicBrowser.ChangePopup(const statusText: string): boolean;
var
  msgText: string;
  blExit: boolean;
begin

  //|bvAbveLXg\Ȃꍇ̔f
  blExit := false;
  if statusText = '' then blExit := true;
  if AnsiStartsText('TCg',statusText) then blExit := true;
  if AnsiStartsText('y[W',statusText) then blExit := true;

  if blExit then
  begin
    ToolTip.UnVisible;
    result := false;
    exit;
  end;

  //摜vr[𑥂|bvAbv̕\
  if gConfig.PicturePreview then
  begin
    if AnsiEndsText('.jpg',statusText) or AnsiEndsText('.gif',statusText) or AnsiEndsText('.png',statusText) or AnsiEndsText('.jpeg',statusText) then
    begin

     ToolTip.SetHint('NbNŉ摜vr[\');
     result := true;
     exit;
    end;
  end;

{
  //[̃|bvAbv\
  if AnsiStartsText('mailto:',statusText) then
  begin
     ToolTip.SetHint(statusText);
     result := true;
     exit;
  end;
}

  //X̃|bvAbv\
  msgText := TPopupManager.GetPopupMessages(Topic, statustext);
  if msgText <> '' then
  begin
    ToolTip.SetHint(msgText);
    ToolTip.Color := RGB(255,255,225);   //2008.04.29 Fw 255 255 225 FF FF E1
    result := true;
  end else
  begin
    ToolTip.UnVisible;
    result := false;
  end;

end;


//DoeR|ŉENbNƂ
procedure TTopicBrowser.DoePopup(const statusText: string);
begin
    MainForm.DoePopup(statusText);
end;


{ TPopupManager }

class function TPopupManager.GetMessages(Msgs: TList; const First, Last: Integer): string;
var
  i: Integer;
  firstPos, lastPos: Integer;
  msg: string;

begin
  // eg. >>0
  if (First < 1) and (Last < 0) then
  begin
    Result := '';
    Exit;
  end;

  firstPos := Max(First - 1, 0);

  lastPos := Min(Last, Msgs.Count);
  Dec(LastPos);

  // eg. >>100000 or >>10-9
  if (firstPos >= msgs.Count) or ((lastPos >= 0) and (firstPos > lastPos)) then
  begin
    Result := '';
    Exit;
  end;

  if lastPos > 0 then
  begin
    for i := firstPos to lastPos do
    begin
      if I > firstPos + 20 then
      begin
        msg := msg + '(ȗ܂)';
        break;
      end else
      begin
        msg := msg + TTopicMessage(Msgs[i]).ForPopup + #10#10
      end;
    end
  end else
  begin
    msg := TTopicMessage(Msgs[FirstPos]).ForPopup;
  end;

  Result := msg;
end;

// IDo|bvAbvp
class function TPopupManager.GetMessages_By_ID(Msgs: TList; const id: string): string;
var
  i: Integer;
  strRet: string;
  msg: TTopicMessage;
  strLine: string;
  intLen: integer;
begin

  if (id = '') then
  begin
    result := '';
    exit;
  end;

  strRet := '';
  strLine := '';
  for i := 0 to msgs.Count -1 do
  begin
     msg := TTopicMessage(Msgs[i]);
     if (Pos(id,msg.RestStr) > 0) then
     begin
       strRet := strRet + msg.ForPopup_Simple + #13#10;
       strRet := strRet + strLine + #13#10;
     end;

  end;

  //Ō̃C
  intLen := Length(strRet) -1;

  //ꉞgbv
  try
     strRet := Copy(strRet,1,intLen - Length(strLine));
  except
     ;
  end;

  result := strRet;
end;

class function  TPopupManager.ParseMailto(const URI : string): string;
begin
  Result := CopyAfter(URI, 8);
end;


// \n+(-\n+)? only
//
//
//
class procedure  TPopupManager.ParseJump(const URI : string; var First, Last: Integer);
var
  Text : string;
  p : Integer;
  len : Integer;
begin
  Text := CopyAfter(URI, 13);

  p := Pos('-', Text);
  if p <> 0 then
  begin
    len:=p-1;
    if len<5 then
      First := StrToInt(Copy(Text, 0, p - 1))
    else
      First := StrToInt(Copy(Text, 0, 3));

    len:=Length(Text);
    if len<5 then
      Last  := StrToInt(Copy(Text, p + 1, Length(Text)))
    else
      Last  := StrToInt(Copy(Text, p + 1, 4));
  end else
  begin
    First := StrToInt(Text);
    Last  := -1;
  end;
end;



class function TPopupManager.GetPopupMessages(Topic: TTopic; const URI: string): string;
var
  first, last: integer;
  parser: T2chURLParser;
  id: string;
begin
  parser := T2chURLParser.Create;
  if Copy(URI, 1, 7) = 'mailto:' then
  begin
    Result := ParseMailto(URI);
  end else if Copy(URI, 1, 12) = 'jump://goto/' then
  begin
    ParseJump(URI, first, last);
    Result := GetMessages(Topic.MessageList, first, last);
  end else if Copy(URI, 1, 10) = 'menu://id/' then
  begin
    id := CopyAfter(URI,11);
    if id = 'ID:???' then
      Result := 'IDsł'
    else
      Result := GetMessages_By_ID(Topic.MessageList, id);
  end else
  begin
    parser.Parse(URI);
    if parser.Is2chUrl then
    begin

    end else
    begin

    end;
    Result := '';
  end;
  parser.Free;
end;

end.
